/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.wizards;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.pa.model.CSVDataExtract;
import com.ibm.cics.pa.model.CSVDataRestrictionFilter;
import com.ibm.cics.pa.model.ChartingFile;
import com.ibm.cics.pa.model.DataKeyElement;
import com.ibm.cics.pa.model.GenericDataProvider;
import com.ibm.cics.pa.model.IUniqueRecord;
import com.ibm.cics.pa.model.TreeElement;
import com.ibm.cics.pa.model.definitions.PersistedChartDefinition;
import com.ibm.cics.pa.ui.ChartManager;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.QueryCache;
import com.ibm.cics.pa.ui.wizards.SampleNewCSVPage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class SampleCSV
extends Wizard
implements INewWizard {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger("com.ibm.cics.pa.ui");
    private SampleNewCSVPage page;
    private ISelection selection;

    public SampleCSV() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.getString("SampleNewCSVPage.sampleNew"));
    }

    public void addPages() {
        this.page = new SampleNewCSVPage(this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        final String containerName = this.page.getContainerName();
        final String fileName = this.page.getFileName();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    SampleCSV.this.doFinish(containerName, fileName, monitor);
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, true, op);
        }
        catch (InterruptedException e) {
            logger.logp(Level.SEVERE, SampleCSV.class.getName(), "performFinish", "Interruption exception", e);
            return false;
        }
        catch (InvocationTargetException e) {
            logger.logp(Level.SEVERE, SampleCSV.class.getName(), "performFinish", "Invocation Target Exception", e);
            return false;
        }
        return true;
    }

    void doFinish(String containerName, String fileName, final IProgressMonitor monitor) {
        Debug.enter((Logger)logger, (String)SampleCSV.class.getName(), (String)"doFinish");
        monitor.beginTask(String.valueOf(Messages.getString("SampleCSV.creating")) + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            logger.logp(Level.SEVERE, SampleCSV.class.getName(), "doFinish", String.valueOf(containerName) + " does not exist");
        }
        IContainer container = (IContainer)resource;
        IFile file = container.getFile((IPath)new Path(fileName));
        try {
            InputStream stream = this.openContentStream();
            if (file.exists()) {
                file.setContents(stream, true, true, monitor);
            } else {
                file.create(stream, true, monitor);
            }
            stream.close();
            GenericDataProvider dataProvider = ChartingFile.getReference(file);
            dataProvider.getData();
            TreeElement extract1 = dataProvider.getRootTreeElement();
            extract1 = (TreeElement)extract1.getChildren()[0];
            TreeElement extract = (TreeElement)extract1.getChildren()[extract1.getChildren().length - 1];
            extract = (TreeElement)extract.getChildren()[extract.getChildren().length - 1];
            CSVDataRestrictionFilter filter = CSVDataRestrictionFilter.getFilterFor(new StructuredSelection(new Object[]{extract}));
            final PersistedChartDefinition defn = PersistedChartDefinition.getDefinition(QueryCache.getInstance().getAppropriatePresentation("HST_Threadsafe", "680"));
            final GenericDataProvider provider2 = CSVDataExtract.getFor(dataProvider, filter);
            final IUniqueRecord record = dataProvider.getRootTreeElement().getSpecificChild(DataKeyElement.createDataKey(dataProvider, dataProvider.getData()[dataProvider.getData(monitor).length - 4]));
            final PersistedChartDefinition defn1 = PersistedChartDefinition.getDefinition(QueryCache.getInstance().getAppropriatePresentation("HST_RMI_pie", "680"));
            final GenericDataProvider providerPie = ChartingFile.adaptForSpecific(record.getSourceProvider(), record, defn1);
            monitor.worked(1);
            monitor.setTaskName(Messages.getString("SampleCSV.opening"));
            this.getShell().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    String idChart = ChartManager.getInstance().createChart(defn, provider2, null, null, null);
                    String pieId = ChartManager.getInstance().createChart(defn1, providerPie, (String)record.getLabel(), record, monitor);
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    try {
                        page.showView("com.ibm.cics.pa.ui.charteditor", idChart, 1);
                        page.showView("com.ibm.cics.pa.ui.pie_editor", pieId, 1);
                    }
                    catch (PartInitException partInitException) {
                        // empty catch block
                    }
                }
            });
        }
        catch (IOException e) {
            logger.logp(Level.SEVERE, SampleCSV.class.getName(), "performFinish", "I/O exception", e);
        }
        catch (CoreException e) {
            logger.logp(Level.SEVERE, SampleCSV.class.getName(), "performFinish", "Core exception", e);
        }
        monitor.worked(1);
        Debug.enter((Logger)logger, (String)SampleCSV.class.getName(), (String)"doFinish");
    }

    private InputStream openContentStream() {
        return ((Object)((Object)this)).getClass().getResourceAsStream("/sample/sample.csv");
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

