/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.wizards;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.dbfunc.command.Engine;
import com.ibm.cics.dbfunc.command.EngineShell;
import com.ibm.cics.dbfunc.command.RowProcessor;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.eclipse.common.Activator;
import com.ibm.cics.pa.model.IUniqueRecord;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.PAContextTracker;
import com.ibm.cics.pa.ui.remote.PAConnectionTracker;
import com.ibm.cics.pa.ui.views.internal.FilteredEntitiesComposite;
import com.ibm.cics.pa.ui.wizards.ProfileWizardDatePage;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class ProfileWizardEntityPage
extends WizardPage {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2010, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final Debug debug = new Debug(ProfileWizardEntityPage.class);
    private String tableused;
    protected FilteredEntitiesComposite base1;
    protected FilteredEntitiesComposite variant1;
    protected FilteredEntitiesComposite base2;
    protected FilteredEntitiesComposite variant2;
    protected Engine engine;
    private Job job;
    protected Button checkApplid;
    protected List<Object> allApplids;
    protected List<Object> allTransactions;
    protected int loaded = 0;
    protected ISelection startApplid;
    protected ISelection startTransaction;
    protected Button checkTran;

    protected ProfileWizardEntityPage(IWorkbenchPartSite site, String pageName) {
        super(pageName);
        debug.enter("ProfileWizardEntityPage", (Object)pageName);
        this.setPageComplete(false);
        this.tableused = PAContextTracker.getInstance().getPerformanceTableReference();
        this.populateForApplid(this.tableused, null, null);
        debug.exit("ProfileWizardEntityPage");
    }

    public void createControl(Composite parent) {
        debug.enter("createControl");
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        this.initializeDialogUnits((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.cics.pa.ui.profilewizardentitypage");
        composite.setLayout((Layout)new GridLayout(4, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.createContent(composite);
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setPageComplete(this.validatePage());
        this.setControl((Control)composite);
        this.loaded |= 4;
        this.signal();
        debug.exit("createControl");
    }

    private void createContent(Composite composite) {
        debug.enter("createContent");
        Label dumbLabel = new Label(composite, 0);
        dumbLabel.setLayoutData((Object)new GridData(16384, 128, false, false));
        dumbLabel = new Label(composite, 0);
        dumbLabel.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        dumbLabel.setText(Messages.getString("Profiler_Base"));
        dumbLabel = new Label(composite, 0);
        dumbLabel.setLayoutData((Object)new GridData(16384, 128, false, false));
        dumbLabel = new Label(composite, 0);
        dumbLabel.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        dumbLabel.setText(Messages.getString("Profiler_Variant"));
        Group group = new Group(composite, 0);
        group.setLayoutData((Object)new GridData(16384, 128, false, false));
        group.setLayout((Layout)new GridLayout(1, false));
        group.setText(Messages.getString("Profiler_Primary"));
        group.setLayoutData((Object)new GridData());
        this.checkApplid = new Button((Composite)group, 16);
        this.checkApplid.setText(ColumnDefinition.APPLID.getLabel(null));
        this.checkApplid.setSelection(true);
        this.checkApplid.setToolTipText(MessageFormat.format(Messages.getString("Profiler_Primary_Selection"), ColumnDefinition.APPLID.getLabel(null)));
        this.checkTran = new Button((Composite)group, 16);
        this.checkTran.setText(ColumnDefinition.TRAN.getLabel(null));
        this.checkTran.setToolTipText(MessageFormat.format(Messages.getString("Profiler_Primary_Selection"), ColumnDefinition.TRAN.getLabel(null)));
        this.base1 = FilteredEntitiesComposite.createFilteredEntityComposite(composite, this, "Base1");
        this.base1.setLayoutData(new GridData(4, 128, true, false));
        Button link1 = new Button(composite, 8);
        link1.setImage(Activator.IMGD_LINK_TO_SELECTION.createImage());
        link1.setLayoutData((Object)new GridData());
        link1.setToolTipText(Messages.getString("Profiler_Choose_same"));
        this.variant1 = FilteredEntitiesComposite.createFilteredEntityComposite(composite, this, "Variant1");
        this.variant1.setLayoutData(new GridData(4, 128, true, false));
        group = new Group(composite, 0);
        group.setLayoutData((Object)new GridData(16384, 128, false, false));
        group.setLayout((Layout)new GridLayout(1, false));
        group.setText(Messages.getString("Profiler_Secondary"));
        group.setLayoutData((Object)new GridData());
        final Label secondlabel = new Label((Composite)group, 0);
        secondlabel.setLayoutData((Object)new GridData(16384, 128, false, false));
        secondlabel.setText(this.checkTran.getText());
        this.base2 = FilteredEntitiesComposite.createFilteredEntityComposite(composite, this, "Base2");
        this.base2.setLayoutData(new GridData(4, 128, true, false));
        Button link2 = new Button(composite, 8);
        link2.setImage(Activator.IMGD_LINK_TO_SELECTION.createImage());
        link2.setLayoutData((Object)new GridData());
        link2.setToolTipText(Messages.getString("Profiler_Choose_same"));
        this.variant2 = FilteredEntitiesComposite.createFilteredEntityComposite(composite, this, "Variant2");
        this.variant2.setLayoutData(new GridData(4, 128, true, false));
        this.checkApplid.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                secondlabel.setText(!ProfileWizardEntityPage.this.checkApplid.getSelection() ? ProfileWizardEntityPage.this.checkApplid.getText() : ProfileWizardEntityPage.this.checkTran.getText());
                ProfileWizardEntityPage.this.signal();
            }
        });
        link1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProfileWizardEntityPage.this.variant1.init(ProfileWizardEntityPage.this.base1.getContent(), ProfileWizardEntityPage.this.base1.getSelection(), ProfileWizardEntityPage.this.checkApplid.getSelection() ? ProfileWizardEntityPage.this.checkApplid.getText() : ProfileWizardEntityPage.this.checkTran.getText());
                ProfileWizardEntityPage.this.variant1.setSelection(ProfileWizardEntityPage.this.base1.getSelection());
            }
        });
        link2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProfileWizardEntityPage.this.variant2.init(ProfileWizardEntityPage.this.base2.getContent(), ProfileWizardEntityPage.this.base2.getSelection(), ProfileWizardEntityPage.this.checkApplid.getSelection() ? ProfileWizardEntityPage.this.checkApplid.getText() : ProfileWizardEntityPage.this.checkTran.getText());
                ProfileWizardEntityPage.this.variant2.setSelection(ProfileWizardEntityPage.this.base2.getSelection());
            }
        });
        debug.exit("createContent");
    }

    private boolean validatePage() {
        return !this.base1.getSelection().isEmpty() && !this.base2.getSelection().isEmpty() && !this.variant1.getSelection().isEmpty() && !this.variant2.getSelection().isEmpty();
    }

    public String populateForApplid(String table, String applid, FilteredEntitiesComposite variant) {
        debug.enter("populateForApplid", (Object)applid, (Object)variant);
        String jobString = "T";
        Selection selectionObj = PresentationFactory.getInstance().createSelectForTable(new String[]{table}, new String[]{":schema"});
        selectionObj.getSelect().addSelectionColumn(ColumnDefinition.TRAN.getDBColumnRef(), table, ColumnReference.DataType.String, ColumnReference.Function.DISTINCT);
        if (StringUtil.hasContent((String)applid)) {
            selectionObj.appendCondition(ColumnDefinition.APPLID.getDBColumnRef(), table, ColumnDefinition.APPLID.getType(), Comparator.LI, new Object[]{String.valueOf('%') + applid + '%'}, QueryElement.Predicate.AND, false);
            jobString = String.valueOf(jobString) + ' ' + table + ' ' + applid;
        }
        debug.exit("populateForApplid");
        return this.runDBQuery(variant, jobString, selectionObj);
    }

    protected String populateForTransaction(String table, String transaction, FilteredEntitiesComposite variant) {
        debug.enter("populateForTransaction", (Object)transaction, (Object)variant);
        String jobString = "A";
        Selection selectionObj = PresentationFactory.getInstance().createSelectForTable(new String[]{table}, new String[]{":schema"});
        selectionObj.getSelect().addSelectionColumn(ColumnDefinition.APPLID.getDBColumnRef(), table, ColumnReference.DataType.String, ColumnReference.Function.DISTINCT);
        if (StringUtil.hasContent((String)transaction)) {
            selectionObj.appendCondition(ColumnDefinition.TRAN.getDBColumnRef(), table, ColumnDefinition.TRAN.getType(), Comparator.LI, new Object[]{String.valueOf('%') + transaction + '%'}, QueryElement.Predicate.AND, false);
            jobString = String.valueOf(jobString) + ' ' + table + ' ' + transaction;
        }
        debug.exit("populateForTransaction");
        return this.runDBQuery(variant, jobString, selectionObj);
    }

    private String runDBQuery(final FilteredEntitiesComposite composite, final String jobString, final Selection selectionObj) {
        debug.enter("runDBQuery", (Object)jobString);
        String response = Messages.getString("SheetProxy.Initializing");
        if (PAConnectionTracker.getInstance().isConnected()) {
            this.job = new Job(jobString){

                protected IStatus run(IProgressMonitor monitor) {
                    ProfileWizardEntityPage.this.engine = new Engine("com.ibm.cics.pa.connection", new RowProcessor(){

                        public Map<String, Object> getParameterMap() {
                            return new HashMap<String, Object>();
                        }

                        public SelectionObject getSelectionObject() {
                            return selectionObj;
                        }

                        public Object processRow(ResultSet resultSet) {
                            try {
                                return resultSet.getString(1).trim();
                            }
                            catch (SQLException e) {
                                debug.error("runApplidQuery ", (Throwable)e);
                                return null;
                            }
                        }
                    });
                    ProfileWizardEntityPage.this.engine.setPageSize(90000);
                    ProfileWizardEntityPage.this.engine.addListener(new EngineShell.EngineListener(){
                        private List<Object> res = new ArrayList<Object>();

                        public void dataAvailable(Collection<Object> items) {
                            this.getRes().addAll(items);
                        }

                        public void notifyResultCount(int count) {
                        }

                        public void statusUpdate(EngineShell.EngineStatus es) {
                            switch (es) {
                                case Cancelled: 
                                case Error: {
                                    (this).ProfileWizardEntityPage.this.engine.removeListener((EngineShell.EngineListener)this);
                                    break;
                                }
                                case Complete: {
                                    (this).ProfileWizardEntityPage.this.engine.removeListener((EngineShell.EngineListener)this);
                                    Display.getDefault().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (composite != null) {
                                                if (((this).this).ProfileWizardEntityPage.this.startApplid == null && ((this).this).ProfileWizardEntityPage.this.startTransaction != null) {
                                                    Display.getDefault().asyncExec(new Runnable(){

                                                        @Override
                                                        public void run() {
                                                            composite.init(this.getRes(), (((this).this).this).ProfileWizardEntityPage.this.startTransaction, jobString.equals("A") ? (((this).this).this).ProfileWizardEntityPage.this.checkApplid.getText() : (((this).this).this).ProfileWizardEntityPage.this.checkTran.getText());
                                                            (((this).this).this).ProfileWizardEntityPage.this.startTransaction = null;
                                                        }
                                                    });
                                                } else if (((this).this).ProfileWizardEntityPage.this.startApplid != null && ((this).this).ProfileWizardEntityPage.this.startTransaction == null) {
                                                    Display.getDefault().asyncExec(new Runnable(){

                                                        @Override
                                                        public void run() {
                                                            composite.init(this.getRes(), (((this).this).this).ProfileWizardEntityPage.this.startApplid, jobString.equals("A") ? (((this).this).this).ProfileWizardEntityPage.this.checkApplid.getText() : (((this).this).this).ProfileWizardEntityPage.this.checkTran.getText());
                                                            (((this).this).this).ProfileWizardEntityPage.this.startApplid = null;
                                                        }
                                                    });
                                                } else {
                                                    composite.init(this.getRes(), null, jobString.equals("A") ? ((this).this).ProfileWizardEntityPage.this.checkApplid.getText() : ((this).this).ProfileWizardEntityPage.this.checkTran.getText());
                                                }
                                            } else if (jobString.equals("A")) {
                                                ((this).this).ProfileWizardEntityPage.this.allApplids = this.getRes();
                                                ((this).this).ProfileWizardEntityPage.this.loaded |= 1;
                                                ProfileWizardEntityPage.this.signal();
                                            } else if (jobString.equals("T")) {
                                                ((this).this).ProfileWizardEntityPage.this.allTransactions = this.getRes();
                                                ((this).this).ProfileWizardEntityPage.this.loaded |= 2;
                                                ProfileWizardEntityPage.this.signal();
                                            }
                                        }
                                    });
                                    break;
                                }
                            }
                        }

                        public List<Object> getRes() {
                            return this.res;
                        }
                    });
                    ProfileWizardEntityPage.this.engine.setNotifyOnCount(false);
                    ProfileWizardEntityPage.this.engine.start();
                    return Status.OK_STATUS;
                }
            };
            this.job.setPriority(20);
            IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite().getAdapter(IWorkbenchSiteProgressService.class);
            siteService.schedule(this.job, 0L, true);
        } else {
            response = Messages.getString("Resource.status.disconnected");
        }
        debug.exit("runDBQuery", (Object)response);
        return response;
    }

    public synchronized void selectionChanged(FilteredEntitiesComposite filteredEntitiesComposite, String selection) {
        debug.enter("selectionChanged", (Object)selection);
        if (filteredEntitiesComposite == this.base1) {
            if (this.checkApplid.getSelection()) {
                this.populateForApplid(this.tableused, selection, this.base2);
            } else {
                this.populateForTransaction(this.tableused, selection, this.base2);
            }
        } else if (filteredEntitiesComposite == this.variant1) {
            if (this.checkApplid.getSelection()) {
                this.populateForApplid(this.tableused, selection, this.variant2);
            } else {
                this.populateForTransaction(this.tableused, selection, this.variant2);
            }
        }
        this.setPageComplete(!this.base1.getSelection().isEmpty() && !this.base2.getSelection().isEmpty() && !this.variant1.getSelection().isEmpty() && !this.variant2.getSelection().isEmpty());
        debug.exit("selectionChanged");
    }

    void signal() {
        debug.enter("signal", (Object)this.loaded);
        if (this.loaded == 7) {
            if (this.checkApplid.getSelection()) {
                this.base1.init(this.allApplids, this.startApplid != null ? this.startApplid : null, this.checkApplid.getSelection() ? this.checkApplid.getText() : this.checkTran.getText());
                this.startApplid = null;
                this.variant1.init(this.allApplids, null, this.checkApplid.getSelection() ? this.checkApplid.getText() : this.checkTran.getText());
            } else {
                this.base1.init(this.allTransactions, this.startTransaction != null ? this.startTransaction : null, this.checkApplid.getSelection() ? this.checkApplid.getText() : this.checkTran.getText());
                this.startTransaction = null;
                this.variant1.init(this.allTransactions, null, !this.checkApplid.getSelection() ? this.checkApplid.getText() : this.checkTran.getText());
            }
        } else if ((this.loaded & 2) == 2) {
            this.populateForTransaction(this.tableused, null, null);
        }
        debug.exit("signal");
    }

    public String getBase1() {
        return this.base1.getSelectedValue();
    }

    public String getVariant1() {
        return this.variant1.getSelectedValue();
    }

    public String getBase2() {
        return this.base2.getSelectedValue();
    }

    public String getVariant2() {
        return this.variant2.getSelectedValue();
    }

    public IWizardPage getNextPage() {
        IWizardPage page = this.getWizard().getNextPage((IWizardPage)this);
        ((ProfileWizardDatePage)page).retrieveChildren((String)((StructuredSelection)this.base1.getSelection()).getFirstElement(), (String)((StructuredSelection)this.base2.getSelection()).getFirstElement(), (String)((StructuredSelection)this.variant1.getSelection()).getFirstElement(), (String)((StructuredSelection)this.variant2.getSelection()).getFirstElement());
        return page;
    }

    public void setInitialSelection(ISelection currentSelection) {
        Object element;
        if (currentSelection != null && !currentSelection.isEmpty() && (element = ((StructuredSelection)currentSelection).getFirstElement()) instanceof IUniqueRecord) {
            Map<ColumnDefinition, Object> e0 = ((IUniqueRecord)element).getCompleteMapping(false);
            this.startApplid = new StructuredSelection(e0.get(ColumnDefinition.APPLID));
            this.startTransaction = new StructuredSelection(e0.get(ColumnDefinition.TRAN));
        }
    }
}

