/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.views.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.pa.model.Pie;
import com.ibm.cics.pa.model.definitions.ColumnContainment;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.editors.PieEditorItem;
import com.ibm.cics.pa.ui.views.internal.PieViewVariance;
import java.util.Map;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;

public class TransientDataPieViewVariance
extends PieViewVariance {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(TransientDataPieViewVariance.class);
    private static final String[] headersAvg = new String[]{Messages.getString("ChartDefinition.MULTIROW_TRANSIENT_DATA_ANALYSIS"), Messages.getString("PiePage.Timeavg"), Messages.getString("ExplodingPieChart.count"), Messages.getString("PiePage.percent.Suspend")};
    private static final String[] headers = new String[]{Messages.getString("ChartDefinition.MULTIROW_TRANSIENT_DATA_ANALYSIS"), Messages.getString("PiePage.Time.word"), Messages.getString("PiePage.Count.word"), Messages.getString("PiePage.percent.Suspend")};

    public TransientDataPieViewVariance(Pie model) {
        super(model);
    }

    @Override
    public void populateTreeViewer(TreeViewer viewer, Map<ColumnDefinition, Object> mapping, boolean includeFlag, boolean restrictFlag) {
        debug.enter("populateTreeViewer");
        super.populateTreeViewer(viewer, mapping, includeFlag, restrictFlag);
        ((GridData)viewer.getTree().getLayoutData()).heightHint = -1;
        ColumnContainment[] containments = new ColumnContainment[]{ColumnContainment.SUSPEND_TIME_AVG2};
        viewer.setInput((Object)PieEditorItem.createRootForContainments(this.model.getChartReference(), mapping, containments, Messages.getString("PiePage.TransientIO"), includeFlag, restrictFlag));
        viewer.getTree().setVisible(true);
        viewer.expandAll();
        debug.exit("populateTreeViewer");
    }

    @Override
    protected String[] getHeaders() {
        if (this.model.isPListRecord()) {
            return headers;
        }
        return headersAvg;
    }
}

