/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.views.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import com.ibm.cics.pa.ui.wizards.ProfileWizardEntityPage;
import java.text.MessageFormat;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class FilteredEntitiesComposite
extends Composite {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(FilteredEntitiesComposite.class);
    private ViewerFilter filter;
    Text filterField;
    TableViewer viewer;
    ProfileWizardEntityPage page;
    private String label;

    private FilteredEntitiesComposite(Composite outerparent, ProfileWizardEntityPage parent, String label) {
        super(outerparent, 0);
        debug.enter("FilteredEntitiesComposite", (Object)label);
        this.page = parent;
        this.setLayout((Layout)new GridLayout(1, true));
        this.label = label;
        this.filterField = new Text((Composite)this, 2436);
        this.filterField.setLayoutData((Object)new GridData(4, 128, true, false));
        this.filterField.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                FilteredEntitiesComposite.this.viewer.refresh();
            }
        });
        this.filterField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                FilteredEntitiesComposite.this.viewer.refresh();
            }
        });
        this.viewer = new TableViewer((Composite)this, 2822);
        Table table = this.viewer.getTable();
        table.setLayoutData((Object)new GridData(4, 128, true, false));
        table.setHeaderVisible(false);
        table.setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setInput(null);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.heightHint = 80;
        this.viewer.getControl().setLayoutData((Object)gridData);
        this.filter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                String searchString = FilteredEntitiesComposite.this.filterField.getText();
                if (searchString == null || searchString.length() == 0) {
                    return true;
                }
                if (searchString.indexOf(42) > -1) {
                    return Pattern.matches(DataTypeUtilities.wildcardToRegexp(searchString), (String)element);
                }
                return ((String)element).contains(searchString);
            }
        };
        this.viewer.addFilter(this.filter);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FilteredEntitiesComposite.this.page.selectionChanged(FilteredEntitiesComposite.this, event.getSelection().isEmpty() ? null : (String)((StructuredSelection)event.getSelection()).getFirstElement());
            }
        });
        this.filterField.setMessage(Messages.getString("Profiler_Filter_text"));
        debug.exit("FilteredEntitiesComposite");
    }

    public static FilteredEntitiesComposite createFilteredEntityComposite(Composite oparent, ProfileWizardEntityPage page, String label) {
        return new FilteredEntitiesComposite(oparent, page, label);
    }

    public void setEnabled(boolean enabled) {
        debug.enter("setEnabled", (Object)enabled);
        this.filterField.setEnabled(enabled);
        this.viewer.getTable().setEnabled(enabled);
        super.setEnabled(enabled);
        debug.exit("setEnabled");
    }

    public void init(List<Object> list, final ISelection iSelection, String part_label) {
        debug.enter("init");
        if (!this.viewer.getTable().isDisposed()) {
            this.viewer.setInput(list);
            this.viewer.refresh();
            this.filterField.setToolTipText(MessageFormat.format(Messages.getString("Profiler_Tooltip_Filter_List"), part_label));
            this.viewer.getTable().setToolTipText(MessageFormat.format(Messages.getString("Profiler_Tooltip_Content_List"), part_label));
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    FilteredEntitiesComposite.this.viewer.setSelection(iSelection);
                }
            });
        }
        debug.exit("init");
    }

    public List<Object> getContent() {
        debug.enter("getContent");
        debug.exit("getContent");
        return (List)this.viewer.getInput();
    }

    public ISelection getSelection() {
        debug.enter("getSelection");
        debug.exit("getSelection", (Object)this.viewer.getSelection());
        return this.viewer.getSelection();
    }

    public void setSelection(ISelection selection) {
        debug.enter("setSelection", (Object)selection);
        this.viewer.setSelection(selection);
        debug.exit("setSelection");
    }

    public String getSelectedValue() {
        debug.enter("getSelectedValue");
        String defaultResult = "";
        if (!this.getSelection().isEmpty()) {
            defaultResult = (String)((StructuredSelection)this.getSelection()).getFirstElement();
        }
        debug.exit("getSelectedValue", (Object)defaultResult);
        return defaultResult;
    }

    public String toString() {
        return this.label;
    }
}

