/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.views.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.pa.model.Column;
import com.ibm.cics.pa.model.PlotModel;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.PluginConstants;
import com.ibm.cics.pa.ui.figures.SingleIntervalFigure;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import com.ibm.cics.pa.ui.views.PlotView;
import com.ibm.cics.pa.ui.views.internal.PlotViewVariance;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class DSAPlotViewVariance
extends PlotViewVariance {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(DSAPlotViewVariance.class);
    private static ColumnDefinition[] rows = new ColumnDefinition[]{ColumnDefinition.DSA_SIZE_CUR, ColumnDefinition.DSA_SIZE_USED, ColumnDefinition.DSA_SIZE_USED_PERCENT, ColumnDefinition.DSA_SIZE_PEAK_USED, ColumnDefinition.DSA_SIZE_PEAK, ColumnDefinition.CUSHION_SIZE, ColumnDefinition.FREE_STORAGE, ColumnDefinition.FREE_STORAGE_PEAK, ColumnDefinition.FREE_STORAGE_LOW, ColumnDefinition.FREE_AREA_LARGEST, ColumnDefinition.FREE_AREA_LARGEST_PERCENT, ColumnDefinition.FREE_AREA_FREE, ColumnDefinition.UNKNOWN, ColumnDefinition.CURRENT_EXTENTS, ColumnDefinition.EXTENTS_ADDED, ColumnDefinition.EXTENTS_RELEASED, ColumnDefinition.UNKNOWN, ColumnDefinition.SUBPOOLS_CUR, ColumnDefinition.ADD_SUBPOOL_REQ, ColumnDefinition.DEL_SUBPOOL_REQ, ColumnDefinition.UNKNOWN, ColumnDefinition.GETMAINS_NO_STOR, ColumnDefinition.GETMAINS_SUSPENDED, ColumnDefinition.SUSPENDED_CUR, ColumnDefinition.SUSPENDED_PEAK, ColumnDefinition.SUSPENDED_PURGED, ColumnDefinition.UNKNOWN, ColumnDefinition.CUSHION_RELEASES, ColumnDefinition.SOS_COUNT, ColumnDefinition.SOS_TIME_TOTAL, ColumnDefinition.SOS_TIME_AVERAGE, ColumnDefinition.UNKNOWN, ColumnDefinition.STORAGE_VIOLATIONS, ColumnDefinition.ACCESS};
    protected static final List<ColumnDefinition> MBDEFNS = Arrays.asList(ColumnDefinition.FREE_STORAGE, ColumnDefinition.FREE_STORAGE_PEAK, ColumnDefinition.FREE_STORAGE_LOW, ColumnDefinition.FREE_AREA_LARGEST, ColumnDefinition.CUR_GDSA_ALLOCATED, ColumnDefinition.PEAK_GDSA_ALLOCATE);
    private ColumnDefinition[] headings = PluginConstants.GDSA;
    private Map<ColumnDefinition, Map<ColumnDefinition, Control>> controls = new HashMap<ColumnDefinition, Map<ColumnDefinition, Control>>();

    public DSAPlotViewVariance(PlotModel plotModel) {
        super(plotModel);
    }

    @Override
    public Composite createDetailSection(PlotView viewPart, Composite parent, Composite sectionClient) {
        debug.enter("createDetailSection");
        if (this.model.getSubColumnValueLabel() != null && this.model.hasSubElements() && this.model.getElements().length > 0) {
            switch (this.model.getDSAType()) {
                case DSA: {
                    this.headings = PluginConstants.DSA;
                    viewPart.setPartName(Messages.getString("ChartDefinition.DSA_TRACE_LONG"));
                    break;
                }
                case EDSA: {
                    this.headings = PluginConstants.EDSA;
                    viewPart.setPartName(Messages.getString("ChartDefinition.EDSA_TRACE_LONG"));
                    break;
                }
                default: {
                    this.headings = PluginConstants.GDSA;
                    viewPart.setPartName(Messages.getString("ChartDefinition.GDSA_TRACE_LONG"));
                }
            }
        }
        this.viewPart = viewPart;
        this.parent = parent;
        this.detailSection = sectionClient;
        this.scrolledComposite = new ScrolledComposite(sectionClient, 512);
        this.scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setAlwaysShowScrollBars(true);
        this.detailColumnComposite = new Composite((Composite)this.scrolledComposite, 0);
        this.scrolledComposite.getVerticalBar().setIncrement(10);
        this.scrolledComposite.getVerticalBar().setPageIncrement(100);
        this.detailColumnComposite.setLayout((Layout)this.leanLayout(new GridLayout(2, false)));
        this.detailColumnComposite.setBackground(sectionClient.getBackground());
        this.scrolledComposite.setContent((Control)this.detailColumnComposite);
        this.scrolledComposite.setShowFocusedControl(true);
        this.dsaStyleHeadings(sectionClient.getBackground());
        if (this.model.getSubColumnValueLabel() != null && this.model.hasSubElements() && this.model.getElements().length > 0) {
            Control lt;
            Group contentBox = new Group(this.detailColumnComposite, 0);
            contentBox.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
            contentBox.setLayout((Layout)this.leanLayout(new GridLayout(1 + this.headings.length, false)));
            contentBox.setBackground(this.detailSection.getBackground());
            Label l = new Label((Composite)contentBox, 0);
            l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            l.setText("");
            l.setBackground(this.detailSection.getBackground());
            ColumnDefinition[] columnDefinitionArray = this.headings;
            int n = this.headings.length;
            int n2 = 0;
            while (n2 < n) {
                ColumnDefinition headlabel = columnDefinitionArray[n2];
                lt = this.createPoolsHyperLink(headlabel, contentBox);
                ((Hyperlink)lt).setText(headlabel.getLabel(null));
                GridData gdHyper = new GridData(4, 4, true, false, 1, 1);
                gdHyper.horizontalAlignment = 131072;
                lt.setLayoutData((Object)gdHyper);
                lt.setForeground(Column.getFor(headlabel).getColor());
                lt.setBackground(this.detailSection.getBackground());
                viewPart.addPaintedLabel(lt, headlabel);
                this.controls.put(headlabel, new HashMap());
                ++n2;
            }
            columnDefinitionArray = rows;
            n = rows.length;
            n2 = 0;
            while (n2 < n) {
                ColumnDefinition definition = columnDefinitionArray[n2];
                if (ColumnDefinition.UNKNOWN == definition) {
                    l = new Label((Composite)contentBox, 0);
                    l.setLayoutData((Object)new GridData(4, 4, true, false, 1 + this.headings.length, 1));
                    l.setText("");
                    l.setBackground(this.detailSection.getBackground());
                } else {
                    l = new Label((Composite)contentBox, 16384);
                    l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                    l.setText(definition.getLabel(null));
                    l.setForeground(ColorConstants.black);
                    l.setBackground(this.detailSection.getBackground());
                    ColumnDefinition[] columnDefinitionArray2 = this.headings;
                    int n3 = this.headings.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ColumnDefinition headlabel = columnDefinitionArray2[n4];
                        GridData gdHyper = new GridData(4, 4, true, false, 1, 1);
                        gdHyper.horizontalAlignment = 131072;
                        if (definition == ColumnDefinition.SUBPOOLS_CUR) {
                            lt = this.createPoolsHyperLink(headlabel, contentBox);
                            lt.setForeground(headlabel.getLabel(null).endsWith(ColumnDefinition.UDSA.getLabel(null)) ? Column.getFor(headlabel).getColor() : ColorConstants.blue);
                        } else {
                            lt = new Label((Composite)contentBox, 131072);
                            lt.setToolTipText(String.valueOf(headlabel.getLabel(null)) + ' ' + definition.getLabel(null));
                        }
                        lt.setBackground(this.detailSection.getBackground());
                        lt.setLayoutData((Object)gdHyper);
                        this.controls.get(headlabel).put(definition, lt);
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        viewPart.addStandardAdditional(sectionClient, this.detailColumnComposite);
        debug.exit("createDetailSection");
        return this.detailColumnComposite;
    }

    @Override
    public void updateDetailSection(SingleIntervalFigure figure) {
        debug.enter("updateDetailSection");
        super.updateDetailSection(figure);
        if (figure != null) {
            int i = 0;
            while (i < this.headings.length) {
                Object[] values = figure.getElement().getSubMap1().get(this.headings[i].getLabel(null));
                if (values != null) {
                    Map<ColumnDefinition, Control> currentControlMap = this.controls.get(this.headings[i]);
                    int j = 0;
                    while (j < this.model.getSubColumnValueLabel().size()) {
                        String text = DataTypeUtilities.getAsString(values[j]);
                        ColumnDefinition definition = this.model.getSubColumnValueLabel().get(j);
                        if (this.model.getDSAType() == PlotModel.DSAType.GDSA && MBDEFNS.contains(definition) && StringUtil.hasContent((String)text)) {
                            text = String.valueOf(text) + Messages.getString("Megabytes");
                        }
                        if (currentControlMap.containsKey(definition)) {
                            if (currentControlMap.get(definition) instanceof Label) {
                                ((Label)currentControlMap.get(definition)).setText(text);
                            } else if (currentControlMap.get(definition) instanceof Hyperlink) {
                                ((Hyperlink)currentControlMap.get(definition)).setText(text);
                                boolean enabled = text.length() > 0 && !text.equals("0");
                                ((Hyperlink)currentControlMap.get(definition)).setEnabled(enabled);
                                ((Hyperlink)currentControlMap.get(definition)).setUnderlined(enabled);
                                ((Hyperlink)currentControlMap.get(definition)).setForeground(enabled ? Column.getFor(this.headings[i]).getColor() : ColorConstants.black);
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        debug.exit("updateDetailSection");
    }

    @Override
    protected GridLayout leanLayout(GridLayout noMargin) {
        noMargin.marginBottom = 0;
        noMargin.marginTop = 0;
        noMargin.marginLeft = 0;
        noMargin.marginRight = 0;
        noMargin.marginWidth = 5;
        noMargin.marginHeight = 0;
        noMargin.verticalSpacing = 5;
        noMargin.horizontalSpacing = 10;
        return noMargin;
    }
}

