/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.views;

import com.ibm.cics.eclipse.common.ui.Messages;
import com.ibm.cics.eclipse.common.ui.TextInput;
import com.ibm.cics.eclipse.common.ui.fieldassist.HistoryDropDown;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;

public class ViewFilterContribution
extends WorkbenchWindowControlContribution {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    Text text;
    private String id = "com.ibm.cics.eclipse.common.findregionhistory";
    private FilteredResourcesView listener = null;
    private IPartService service;
    private IPartListener partListener;
    private Label lab;
    IWorkbenchPart currentPart;
    private HistoryDropDown historyDropDown;

    public ViewFilterContribution() {
        super("com.ibm.cics.eclipse.common.findregionhistory");
    }

    void setEnabled(boolean hasAdapter) {
        this.listener = null;
        if (this.text == null || this.text.isDisposed()) {
            return;
        }
        if (hasAdapter) {
            this.listener = (FilteredResourcesView)this.currentPart;
            ((FilteredResourcesView)this.currentPart).setFocusableControl((Control)this.text);
        }
    }

    protected Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        int laySize = 2;
        GridLayout layout = new GridLayout(laySize, false);
        layout.marginHeight = 1;
        composite.setLayout((Layout)layout);
        this.lab = new Label(composite, 0);
        this.lab.setText(Messages.getString((String)"FindControl.find.label"));
        this.lab.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.lab.setToolTipText(Messages.getString((String)"FindControl.tooltip.label"));
        this.text = new Text(composite, 2048);
        TextInput.setAccessibleLabel((Text)this.text, (Label)this.lab);
        GridData data = new GridData(1, 128, true, true);
        data.minimumWidth = 75;
        data.minimumHeight = 15;
        this.text.setLayoutData((Object)data);
        this.text.setToolTipText(Messages.getString((String)"FindControl.tooltip.label"));
        this.text.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ViewFilterContribution.this.handleWidgetDefaultSelected(ViewFilterContribution.this.text.getText());
            }
        });
        this.historyDropDown = HistoryDropDown.attachContentAssist((Text)this.text, (String)this.id);
        this.intialiseListeners();
        return composite;
    }

    private void intialiseListeners() {
        IPartService partService;
        IWorkbenchWindow currentWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        this.service = partService = (IPartService)currentWindow.getService(IPartService.class);
        Assert.isNotNull((Object)partService);
        this.partListener = new IPartListener(){

            public void partActivated(IWorkbenchPart part) {
                ViewFilterContribution.this.currentPart = part;
                ViewFilterContribution.this.setEnabled(Platform.getAdapterManager().hasAdapter((Object)part, FilteredResourcesView.class.getName()));
            }

            public void partBroughtToTop(IWorkbenchPart p) {
            }

            public void partClosed(IWorkbenchPart p) {
            }

            public void partDeactivated(IWorkbenchPart p) {
            }

            public void partOpened(IWorkbenchPart p) {
            }
        };
        partService.addPartListener(this.partListener);
    }

    void handleWidgetDefaultSelected(String text) {
        this.historyDropDown.addValue(text);
        this.listener.findSelectionText(text);
    }

    public int computeWidth(Control client) {
        return client.computeSize((int)-1, (int)-1, (boolean)true).x;
    }

    public void dispose() {
        this.text = null;
        this.listener = null;
        if (this.partListener != null) {
            this.service.removePartListener(this.partListener);
        }
        super.dispose();
    }

    public void takeFocus() {
        this.text.setFocus();
    }

    public static interface FilteredResourcesView {
        public void findSelectionText(String var1);

        public void setFocusableControl(Control var1);
    }
}

