/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.views;

public class ScaleUtil {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2009, 2023 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final float[][] range1 = new float[][]{{0.0f, 0.2f, 0.4f, 0.6f, 0.8f, 1.0f}, {0.0f, 0.5f, 1.0f, 1.5f, 2.0f}, {0.0f, 0.5f, 1.0f, 1.5f, 2.0f, 2.5f, 3.0f}, {0.0f, 1.0f, 2.0f, 3.0f, 4.0f}, {0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f}, {0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f}, {0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f}, {0.0f, 2.0f, 4.0f, 6.0f, 8.0f}, {0.0f, 1.5f, 3.0f, 4.5f, 6.0f, 7.5f, 9.0f}, {0.0f, 2.0f, 4.0f, 6.0f, 8.0f, 10.0f}};
    private static final float[] range2 = new float[]{0.0f, 0.25f, 0.5f, 0.75f, 1.0f, 1.25f, 1.5f};

    public static float[] getRange(double input) {
        if (input == 0.0) {
            return new float[]{0.0f};
        }
        float[] result = new float[]{0.0f};
        double multiplier = 1.0;
        double value = input;
        if (value < 1.0) {
            while (value < 1.0) {
                value = input * (multiplier *= 10.0);
            }
        } else if (value > 10.0) {
            while (value > 10.0) {
                value = input * (multiplier /= 10.0);
            }
        }
        if (value > 1.0 && value < 1.5) {
            result = (float[])range2.clone();
        } else {
            value += 0.45;
            try {
                result = (float[])range1[Math.round(Math.round(value)) - 1].clone();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        int i = 0;
        while (i < result.length) {
            int n = i++;
            result[n] = (float)((double)result[n] / multiplier);
        }
        return result;
    }

    public static void main(String[] args) {
        double[] tests = new double[]{1.3E-7, 0.0023, 0.00167, 0.876, 12.7, 678.0, 123456.0};
        int i = 0;
        while (i < tests.length) {
            float[] results = ScaleUtil.getRange(tests[i]);
            System.out.print("Input " + tests[i] + " rounds to ");
            int j = 0;
            while (j < results.length) {
                System.out.print(" " + new Float(results[j]).toString() + ", ");
                ++j;
            }
            System.out.println("");
            ++i;
        }
    }
}

