/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.views;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Presentation;
import com.ibm.cics.pa.model.IUniqueRecord;
import com.ibm.cics.pa.model.ManifestRecord;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.ReportStyle;
import com.ibm.cics.pa.model.definitions.TableCategorisationEnum;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.PAContextTracker;
import com.ibm.cics.pa.ui.QueryCache;
import com.ibm.cics.pa.ui.dialogs.PATreeColumnViewerLabelProvider;
import com.ibm.cics.pa.ui.handlers.PAContextListener;
import com.ibm.cics.pa.ui.remote.PAConnectionListener;
import com.ibm.cics.pa.ui.remote.PAConnectionTracker;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import com.ibm.cics.pa.ui.views.SheetView;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;

public class ReportList
extends ViewPart
implements PAContextListener,
PAConnectionListener {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2010, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    TreeViewer treeViewer;
    private Group categorizationGroup;
    private Group limitgroup;
    private Group resourceGroup;
    IUniqueRecord lastRecord;
    ISelection externalSelection = new StructuredSelection();
    boolean connected = false;
    private ISelectionListener generalListener;
    static final Logger logger = Logger.getLogger(ReportList.class.getPackage().getName());
    public static final String prefCat = "CategoryLimited.";
    public static final String prefType = "TypeLimited.";
    public static final String prefCol = "ColumnLimited.";

    public void createPartControl(Composite parent) {
        Debug.enter((Logger)logger, (String)ReportList.class.getName(), (String)"createPartControl");
        this.setContentDescription(Messages.getString("Resource.status.disconnected"));
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        this.createInquiriesGroup(parent);
        this.hookListeners();
        this.reassess();
        MenuManager menuManager = new MenuManager("popup");
        menuManager.setRemoveAllWhenShown(true);
        Menu popUpMenu = menuManager.createContextMenu((Control)this.treeViewer.getTree());
        this.treeViewer.getTree().setMenu(popUpMenu);
        this.getViewSite().registerContextMenu(menuManager, (ISelectionProvider)this.treeViewer);
        PAContextTracker.getInstance().addPAContextListenerListener(this);
        PAConnectionTracker.getInstance().addPAConnectionTrackerListener(this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getHelpContextId());
        if (PAConnectionTracker.getInstance().isPost32()) {
            this.connected(PAConnectionListener.Era.POST);
            this.tableSelected(PAConnectionTracker.getInstance().getAlertManifest());
        }
        Debug.exit((Logger)logger, (String)ReportList.class.getName(), (String)"createPartControl");
    }

    private String getHelpContextId() {
        return "com.ibm.cics.pa.ui.reportview";
    }

    private void hookListeners() {
        this.generalListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (part instanceof SheetView) {
                    ReportList.this.externalSelection = ((SheetView)part).getSelection();
                    if (!ReportList.this.externalSelection.isEmpty()) {
                        IUniqueRecord record;
                        ReportList.this.lastRecord = record = (IUniqueRecord)((SheetView)part).getSelection().getFirstElement();
                        if (!ReportList.this.treeViewer.getSelection().isEmpty()) {
                            Object selected = ((StructuredSelection)ReportList.this.treeViewer.getSelection()).getFirstElement();
                            boolean cfr_ignored_0 = selected instanceof Presentation;
                        }
                    }
                }
            }
        };
        this.getSite().getPage().addPostSelectionListener(this.generalListener);
    }

    public void setFocus() {
        if (!this.connected) {
            this.connected = PAConnectionTracker.getInstance().isPost32();
            if (this.connected) {
                this.tableSelected(PAContextTracker.getInstance().getCurrentManifest());
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.getSite().getPage().removePostSelectionListener(this.generalListener);
        PAConnectionTracker.getInstance().removePAContextListener(this);
        PAConnectionTracker.getInstance().removePAConnectionTrackerListener(this);
    }

    private void createInquiriesGroup(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 2048);
        this.treeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                ReportList.this.treeViewer.refresh(true);
            }

            public Object[] getChildren(Object parentElement) {
                ArrayList<Object> children;
                block16: {
                    block19: {
                        block18: {
                            block17: {
                                children = new ArrayList<Object>();
                                if (!ReportList.this.connected) break block16;
                                if (parentElement != TableCategorisationEnum.ReportRoot) break block17;
                                Object[] objectArray = TableCategorisationEnum.ReportRoot.getChildren();
                                int n = objectArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Object child = objectArray[n2];
                                    if (child instanceof TableCategorisationEnum && Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), ReportList.prefCat + ((TableCategorisationEnum)((Object)child)).getId(), true, null)) {
                                        children.add(child);
                                    }
                                    ++n2;
                                }
                                break block16;
                            }
                            if (parentElement != TableCategorisationEnum.Regions) break block18;
                            Object[] objectArray = TableCategorisationEnum.Regions.getChildren();
                            int n = objectArray.length;
                            int n3 = 0;
                            while (n3 < n) {
                                Object child = objectArray[n3];
                                if (child instanceof TableCategorisationEnum && Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), ReportList.prefCat + ((TableCategorisationEnum)((Object)child)).getId(), true, null)) {
                                    children.add(child);
                                }
                                ++n3;
                            }
                            objectArray = QueryCache.getInstance().getAllPresentations();
                            n = objectArray.length;
                            n3 = 0;
                            while (n3 < n) {
                                Object presentation = objectArray[n3];
                                if (TableCategorisationEnum.getForId(presentation.getCategorization()) == TableCategorisationEnum.Regions) {
                                    ManifestRecord record;
                                    ColumnDefinition defn = DataTypeUtilities.firstSignificantColumn(presentation.getInputColumns().keySet().toArray(new ColumnReference[presentation.getInputColumns().keySet().size()]));
                                    if (Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), ReportList.prefType + (Object)((Object)ReportStyle.deriveFromImplType(presentation.getImplType())), true, null) && (defn == null || Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), ReportList.prefCol + defn.getDBColumnRef(), true, null)) && (record = ManifestRecord.getAlias((String)presentation.getSelection().getSelect().getTable().getLabels().keySet().toArray()[0])) != null) {
                                        children.add(presentation);
                                    }
                                }
                                ++n3;
                            }
                            break block16;
                        }
                        if (parentElement != TableCategorisationEnum.Server) break block19;
                        Object[] objectArray = TableCategorisationEnum.Server.getChildren();
                        int n = objectArray.length;
                        int n4 = 0;
                        while (n4 < n) {
                            Object child = objectArray[n4];
                            if (child instanceof TableCategorisationEnum && child instanceof TableCategorisationEnum && Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), ReportList.prefCat + ((TableCategorisationEnum)((Object)child)).getId(), true, null)) {
                                children.add(child);
                            }
                            ++n4;
                        }
                        if (!ReportList.this.connected) break block16;
                        objectArray = QueryCache.getInstance().getAllPresentations();
                        n = objectArray.length;
                        n4 = 0;
                        while (n4 < n) {
                            Object presentation = objectArray[n4];
                            if (TableCategorisationEnum.getForId(presentation.getCategorization()) == TableCategorisationEnum.Server && Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), ReportList.prefType + (Object)((Object)ReportStyle.deriveFromImplType(presentation.getImplType())), true, null)) {
                                ManifestRecord record;
                                ColumnDefinition defn = DataTypeUtilities.firstSignificantColumn(presentation.getInputColumns().keySet().toArray(new ColumnReference[presentation.getInputColumns().keySet().size()]));
                                if (Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), ReportList.prefType + (Object)((Object)ReportStyle.deriveFromImplType(presentation.getImplType())), true, null) && (defn == null || Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), ReportList.prefCol + defn.getDBColumnRef(), true, null)) && (record = ManifestRecord.getAlias((String)presentation.getSelection().getSelect().getTable().getLabels().keySet().toArray()[0])) != null) {
                                    children.add(presentation);
                                }
                            }
                            ++n4;
                        }
                        break block16;
                    }
                    if (parentElement instanceof TableCategorisationEnum && ReportList.this.connected) {
                        Presentation[] presentationArray = QueryCache.getInstance().getAllPresentations();
                        int n = presentationArray.length;
                        int n5 = 0;
                        while (n5 < n) {
                            Presentation presentation = presentationArray[n5];
                            if (TableCategorisationEnum.getForId(presentation.getCategorization()) == parentElement) {
                                ManifestRecord record;
                                ColumnDefinition defn = DataTypeUtilities.firstSignificantColumn(presentation.getInputColumns().keySet().toArray(new ColumnReference[presentation.getInputColumns().keySet().size()]));
                                if (Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), ReportList.prefType + (Object)((Object)ReportStyle.deriveFromImplType(presentation.getImplType())), true, null) && (defn == null || Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), ReportList.prefCol + defn.getDBColumnRef(), true, null)) && (record = ManifestRecord.getAlias((String)presentation.getSelection().getSelect().getTable().getLabels().keySet().toArray()[0])) != null) {
                                    children.add(presentation);
                                }
                            }
                            ++n5;
                        }
                    }
                }
                return children.toArray();
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return this.getChildren(element).length > 0;
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement == null) {
                    return new Object[0];
                }
                return this.getChildren(inputElement);
            }
        });
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new PATreeColumnViewerLabelProvider(true), new ILabelDecorator(){

            public Image decorateImage(Image image, Object element) {
                return null;
            }

            public String decorateText(String text, Object element) {
                return null;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        }));
        this.treeViewer.getTree().addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
                TreeItem item = ReportList.this.treeViewer.getTree().getItem(new Point(e.x, e.y));
                if (item != null && item.getData() != null && item.getData() instanceof Presentation) {
                    String menu = ((Presentation)item.getData()).getMenu();
                    if (Messages.hasString(menu)) {
                        menu = Messages.getString(menu);
                    }
                    if (!((Presentation)item.getData()).getCode().startsWith("/") && !Messages.getString("Menu." + ((Presentation)item.getData()).getCode()).startsWith("!")) {
                        menu = Messages.getString("Menu." + ((Presentation)item.getData()).getCode());
                    }
                    if (ReportList.this.getExternalSelection() != null) {
                        HashMap<ColumnDefinition, Object> parameterMap = new HashMap<ColumnDefinition, Object>();
                        Map requiredDefinitions = ((Presentation)item.getData()).getInputColumns();
                        for (ColumnReference column : requiredDefinitions.keySet()) {
                            ColumnDefinition defn = ColumnDefinition.getByDBColumnRef(column.getColumnName());
                            IUniqueRecord record = (IUniqueRecord)((StructuredSelection)ReportList.this.getExternalSelection()).getFirstElement();
                            parameterMap.put(defn, record != null ? record.getCompleteMapping(true).get(defn) : null);
                        }
                        boolean complete = true;
                        for (Object value : parameterMap.values()) {
                            boolean bl;
                            if (complete) {
                                if (value != null) {
                                    bl = true;
                                    continue;
                                }
                                bl = false;
                                continue;
                            }
                            bl = complete = false;
                        }
                        if (complete) {
                            for (ColumnDefinition defn : parameterMap.keySet()) {
                                if (defn == ColumnDefinition.START_DATE || defn == ColumnDefinition.START_TIME || defn == ColumnDefinition.APPLID || defn == ColumnDefinition.MVSID || defn == ColumnDefinition.VRM || defn == ColumnDefinition.INTERVAL_TYPE || defn == ColumnDefinition.INTERVAL_NUMBER) continue;
                                menu = String.valueOf(menu) + MessageFormat.format(Messages.getString("ReportList.runwith"), defn.getLabel(null), parameterMap.get(defn));
                            }
                        }
                    }
                    ReportList.this.treeViewer.getTree().setToolTipText(menu);
                }
            }

            public void mouseExit(MouseEvent e) {
            }

            public void mouseEnter(MouseEvent e) {
            }
        });
        this.treeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        this.treeViewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                IHandlerService handlerService = (IHandlerService)ReportList.this.getSite().getService(IHandlerService.class);
                try {
                    handlerService.executeCommand("com.ibm.cics.pa.ui.commands.run_report1", null);
                }
                catch (NotEnabledException nex) {
                    Debug.warning((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"createInquiriesGroup", (Object)((Object)nex));
                }
                catch (Exception ex) {
                    Debug.error((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"createInquiriesGroup", (Throwable)ex);
                }
            }
        });
    }

    public void setCategorisationSectionVisibility(boolean b) {
        this.categorizationGroup.setVisible(b);
        this.categorizationGroup.getParent().layout();
        Activator.getDefault().getPluginInstancePreferences().putBoolean("CATEGORISATION_GROUP", b);
    }

    public void setLimitSectionVisibility(boolean b) {
        this.limitgroup.setVisible(b);
        this.limitgroup.getParent().layout();
        Activator.getDefault().getPluginInstancePreferences().putBoolean("LIMIT_REPORT_GROUP", b);
    }

    public void setResourceTypeSectionVisibility(boolean b) {
        this.resourceGroup.setVisible(b);
        this.resourceGroup.getParent().layout();
        Activator.getDefault().getPluginInstancePreferences().putBoolean("INPUT_PARAMETER_GROUP", b);
    }

    public void reassess() {
        if (this.treeViewer.getContentProvider() != null) {
            this.treeViewer.setInput((Object)TableCategorisationEnum.ReportRoot);
            this.treeViewer.expandAll();
            this.treeViewer.getTree().getParent().layout();
        }
    }

    public Presentation getPresentation() {
        Object element;
        if (!this.treeViewer.getSelection().isEmpty() && (element = ((StructuredSelection)this.treeViewer.getSelection()).getFirstElement()) instanceof Presentation) {
            return (Presentation)element;
        }
        return null;
    }

    public IUniqueRecord getRecord() {
        return this.lastRecord;
    }

    public ISelection getExternalSelection() {
        return this.externalSelection;
    }

    @Override
    public void disconnected() {
        this.connected = false;
        if (!this.treeViewer.getTree().isDisposed()) {
            this.treeViewer.refresh();
        }
        this.setContentDescription(Messages.getString("Resource.status.disconnected"));
    }

    @Override
    public void disconnecting() {
    }

    @Override
    public void connected(final PAConnectionListener.Era post32) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (PAConnectionTracker.getInstance().isConnected()) {
                    ReportList.this.setContentDescription(MessageFormat.format(Messages.getString("Connected"), PAConnectionTracker.getInstance().getConnectable().getConnection().getConfiguration().getName()));
                }
                ReportList.this.connected = post32 == PAConnectionListener.Era.POST;
            }
        });
    }

    @Override
    public void tableSelected(ManifestRecord manifest) {
        this.reassess();
        if (this.connected) {
            this.setContentDescription("");
        }
    }

    public String getPartProperty(String key) {
        if (IConnectionCategory.class.getName().equals(key)) {
            return "com.ibm.cics.pa.connection";
        }
        return super.getPartProperty(key);
    }
}

