/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.views;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.eclipse.common.ViewHelper;
import com.ibm.cics.pa.model.AlertElement;
import com.ibm.cics.pa.model.Chart;
import com.ibm.cics.pa.model.IUniqueRecord;
import com.ibm.cics.pa.model.Pie;
import com.ibm.cics.pa.model.TransactionPerformanceListModel;
import com.ibm.cics.pa.model.WaitAnalysis;
import com.ibm.cics.pa.model.definitions.ColumnContainment;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.figures.WaitAnalysisFigure;
import com.ibm.cics.pa.ui.remote.PAConnectionListener;
import com.ibm.cics.pa.ui.remote.PAConnectionTracker;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import com.ibm.cics.pa.ui.utilities.ViewLinkingDBFunctions;
import com.ibm.cics.pa.ui.views.internal.PerformanceListRecordViewVariance;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ColumnLayout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;

public class PerformanceListRecordFormsView
extends ViewPart
implements ISelectionProvider,
PAConnectionListener {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final Debug debug = new Debug(PerformanceListRecordFormsView.class);
    private FormToolkit toolkit;
    private Collection<ISelectionChangedListener> listeners = new HashSet<ISelectionChangedListener>();
    IUniqueRecord record;
    TransactionPerformanceListModel model;
    protected Integer selectedIndex;
    private TabFolder topTabFolder;
    private static String FONT_NAME = Display.getCurrent().getSystemFont().getFontData()[0].getName();
    private static int FONT_SIZE = Display.getCurrent().getSystemFont().getFontData()[0].getHeight();
    static Font STANDARD_BOLD = new Font((Device)Display.getDefault(), FONT_NAME, FONT_SIZE, 1);
    FocusListener focusListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
            PerformanceListRecordFormsView.this.setSelection((ISelection)new StructuredSelection((Object)PerformanceListRecordFormsView.this.model.getRecord()));
        }

        public void focusLost(FocusEvent e) {
        }
    };
    ScrolledForm form;
    private AlertElement nextAlert;

    public void init(IViewSite site) throws PartInitException {
        debug.enter("init");
        super.init(site);
        this.model = (TransactionPerformanceListModel)Chart.getReference(site.getSecondaryId());
        if (this.model == null && site.getSecondaryId() != null || !this.model.isReliable()) {
            this.closeMeAgain(this);
        }
        this.record = this.model.getRecord();
        debug.exit("init", (Object)this.model);
    }

    public void createPartControl(Composite parent) {
        debug.enter("createPartControl");
        if (this.model.isReliable()) {
            this.setPartName(this.model.getTitle());
            this.setTitleToolTip(this.model.getToolTipText());
            if (this.model.getAlert() == null) {
                this.setTitleImage(Activator.getDefault().getImage(Activator.IMGD_TRAN));
            }
            ManagedForm managedForm = new ManagedForm(parent);
            this.toolkit = managedForm.getToolkit();
            this.form = managedForm.getForm();
            GridLayout formLayout = new GridLayout();
            formLayout.horizontalSpacing = 0;
            formLayout.verticalSpacing = 0;
            formLayout.marginHeight = 0;
            formLayout.marginWidth = 0;
            this.form.getBody().setLayout((Layout)new FillLayout());
            GridData headSectionLayoutData = new GridData();
            headSectionLayoutData.horizontalAlignment = 4;
            Composite bodySash = this.getCompositeClientGridData(this.form.getBody());
            GridLayout bodySashlayout = this.leanLayout(new GridLayout(2, false));
            bodySash.setLayout((Layout)bodySashlayout);
            Composite detailComposite1 = this.getCompositeClientGridData(bodySash);
            GridData detailData = new GridData(4, 4, false, true);
            detailComposite1.setLayoutData((Object)detailData);
            Composite trtComposite = this.getTwistieSectionClient(detailComposite1, Messages.getString("PerformanceListRecordFormsView.Transaction.response.time"), 258);
            final WaitAnalysis waModel = this.createTRTSection(trtComposite);
            trtComposite.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    if (waModel != null) {
                        e.result = waModel.getAccessibleMessage();
                    }
                }
            });
            this.topTabFolder = new TabFolder(detailComposite1, 128);
            GridData tfData = new GridData(4, 4, true, false);
            tfData.widthHint = 1025;
            this.topTabFolder.setLayoutData((Object)tfData);
            this.toolkit.adapt((Composite)this.topTabFolder);
            this.createPieSection(this.topTabFolder);
            TabFolder bottomTabFolder = new TabFolder(detailComposite1, 128);
            GridData bfData = new GridData(4, 4, true, false);
            bfData.widthHint = 1025;
            bottomTabFolder.setLayoutData((Object)bfData);
            this.toolkit.adapt((Composite)bottomTabFolder);
            this.createGeneralSection(bottomTabFolder);
            Composite bodyClient = this.toolkit.createComposite(bodySash);
            bodyClient.setLayout((Layout)this.leanLayout(new GridLayout()));
            GridData bcData = new GridData(4, 4, true, true);
            bodyClient.setLayoutData((Object)bcData);
            Composite todComposite = this.getSectionClient(bodyClient, Messages.getString("PerformanceListRecordFormsView.Transaction.origin.data"), 322, false);
            todComposite.setToolTipText(Messages.getString("PerformanceListRecordFormsView.tod_data.tooltip"));
            this.createTODSection(todComposite);
            Composite hopComposite = this.getSectionClient(bodyClient, Messages.getString("PerformanceListRecordFormsView.Previous.hop.data"), 322, true);
            hopComposite.setToolTipText(Messages.getString("PerformanceListRecordFormsView.hop_data.tooltip"));
            this.createHopSection(hopComposite);
            this.form.computeSize(-1, -1, true);
            this.addToolbar(this.getViewSite().getActionBars().getToolBarManager());
            PAConnectionTracker.getInstance().addPAConnectionTrackerListener(this);
            this.getSite().setSelectionProvider((ISelectionProvider)this);
            this.setSelection((ISelection)new StructuredSelection((Object)this.model.getRecord()));
            this.setContentDescription(this.model.getRecord().getDataKey().getColumnDescriptiveFullReference());
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getHelpContextId());
        }
        debug.exit("createPartControl");
    }

    private void addToolbar(IToolBarManager toolBarManager) {
        Action summaryAction = new Action(null, 8){

            public void run() {
                ViewLinkingDBFunctions.openSpreadsheet((IViewPart)PerformanceListRecordFormsView.this, PerformanceListRecordFormsView.this.record, null);
            }
        };
        summaryAction.setToolTipText(Messages.getString("View.Summary"));
        summaryAction.setImageDescriptor(Activator.getDefault().getImageDescriptor("pie"));
        summaryAction.setEnabled(true);
        toolBarManager.add((IAction)summaryAction);
    }

    private WaitAnalysis createTRTSection(Composite composite1) {
        composite1.setLayout((Layout)new GridLayout(2, false));
        composite1.setLayoutData((Object)new GridData(1, 1, true, false));
        return this.createWaitAnalysisSection(composite1, 0, this.model.getPrimaryPie());
    }

    private void createTODSection(Composite composit) {
        Table table = this.toolkit.createTable(composit, 0);
        table.setRedraw(false);
        table.setHeaderVisible(false);
        table.setLinesVisible(true);
        TableViewer tableViewer = this.basicTableViewer(table);
        table.setLayoutData((Object)new GridData(4, 1, true, false));
        TableColumn tcLabel = new TableColumn(table, 16384);
        TableColumn tcData = new TableColumn(table, 16384);
        this.setTableViewerLabelData(new TableViewerColumn(tableViewer, tcData), 0);
        this.setTableViewerLabel(new TableViewerColumn(tableViewer, tcLabel), 0);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)tableViewer, (int)2);
        tableViewer.setInput((Object)new ColumnDefinition[]{ColumnDefinition.OTRAN, ColumnDefinition.OUSERID, ColumnDefinition.OTASKNO, ColumnDefinition.OAPPLID, ColumnDefinition.OSTART, ColumnDefinition.OSLATNCY_TIME, ColumnDefinition.OORIGIN, ColumnDefinition.OFCTYTYP, ColumnDefinition.OFCTY, ColumnDefinition.OTCPSRVC, ColumnDefinition.OPORT, ColumnDefinition.OCLI6ADR, ColumnDefinition.OCLIPORT});
        table.addFocusListener(this.focusListener);
        tcLabel.setWidth(200);
        tcLabel.setResizable(true);
        tcData.setWidth(150);
        tcData.setResizable(true);
        table.layout();
        table.setRedraw(true);
    }

    private void createHopSection(Composite composite) {
        Table table = this.toolkit.createTable(composite, 0);
        table.setRedraw(false);
        table.setHeaderVisible(false);
        table.setLinesVisible(true);
        TableViewer tableViewer = this.basicTableViewer(table);
        table.setLayoutData((Object)new GridData(4, 1, true, true));
        TableColumn tcLabel = new TableColumn(table, 16384);
        TableColumn tcData = new TableColumn(table, 16384);
        tcLabel.setWidth(200);
        tcData.setWidth(150);
        this.setTableViewerLabelData(new TableViewerColumn(tableViewer, tcData), 0);
        this.setTableViewerLabel(new TableViewerColumn(tableViewer, tcLabel), 0);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)tableViewer, (int)2);
        tableViewer.setInput((Object)new ColumnDefinition[]{ColumnDefinition.PHTRAN, ColumnDefinition.PHTASKNO, ColumnDefinition.PHAPPLID, ColumnDefinition.PHSTART, ColumnDefinition.PHCOUNT, ColumnDefinition.PHLATNCY_TIME});
        table.addFocusListener(this.focusListener);
        table.setRedraw(true);
    }

    private void createGeneralSection(TabFolder tabFolder) {
        if (this.model.getAlert() != null) {
            this.createAlertDetail(tabFolder);
        }
        this.createTransactionInformation(tabFolder);
        this.createFacilityInformation(tabFolder);
        this.createWebserviceInformation(tabFolder);
        this.createApplicationContext(tabFolder);
        tabFolder.addFocusListener(this.focusListener);
    }

    private Composite createTransactionInformation(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Messages.getString("PerformanceListRecordFormsView.Transaction.information"));
        tabItem.setToolTipText(Messages.getString("PerformanceListRecordFormsView.transaction.tooltip"));
        Composite composite = this.toolkit.createComposite((Composite)tabFolder, 0);
        composite.setLayout((Layout)this.leanLayout(new GridLayout(1, false)));
        composite.setLayoutData((Object)new GridData(1, 4, false, true));
        tabItem.setControl((Control)composite);
        this.createRunningTable(composite, new Object[][]{{ColumnDefinition.TRAN, ColumnDefinition.USERID, ColumnDefinition.PROGRAM, ColumnDefinition.NETNAME}, {ColumnDefinition.TRANPRTY, "", ColumnDefinition.RSYSID, ColumnDefinition.UOWID}, {ColumnDefinition.TCLASSNM, ColumnDefinition.TCLDELAY_TIME, "", ColumnDefinition.UOWSEQ}, {ColumnDefinition.STYPE, ColumnDefinition.EICTOTCT, ColumnDefinition.MAXTASKS, ColumnDefinition.RMUOWID}, {ColumnDefinition.ORIGIN, ColumnDefinition.TRACKORG, ColumnDefinition.TRACKVAL, ColumnDefinition.SYNCPT}, {ColumnDefinition.CLIP6ADR, ColumnDefinition.CLIPPORT, ColumnDefinition.SRVCLASS, ColumnDefinition.LOGWRITE}, {ColumnDefinition.RTYPE, ColumnDefinition.RECCOUNT, ColumnDefinition.RPTCLASS, ""}}, new int[]{160, 150, 140, 110});
        return composite;
    }

    private void createRunningTable(Composite composite, Object[][] rows, int[] widths) {
        Table table = this.toolkit.createTable(composite, 65536);
        table.setLayoutData((Object)new GridData(4, 1, true, false));
        table.setRedraw(false);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableViewer tableViewer = this.basicTableViewer(table);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)tableViewer, (int)2);
        table.addFocusListener(this.focusListener);
        table.setRedraw(true);
        int j = 0;
        while (j < rows[0].length) {
            TableColumn tcLabel = new TableColumn(table, 16384);
            tcLabel.setText(Messages.getString("Attribute"));
            TableColumn tcData = new TableColumn(table, 16384);
            tcLabel.setWidth(widths[j]);
            tcLabel.setResizable(true);
            tcData.setWidth(widths[j] - 50);
            tcData.setText(Messages.getString("Value"));
            tcData.setResizable(true);
            this.setTableViewerLabelData(new TableViewerColumn(tableViewer, tcData), j);
            this.setTableViewerLabel(new TableViewerColumn(tableViewer, tcLabel), j);
            ++j;
        }
        tableViewer.setInput((Object)rows);
    }

    private Composite createApplicationContext(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Messages.getString("PerformanceListRecordFormsView.Application.context"));
        tabItem.setToolTipText(Messages.getString("PerformanceListRecordFormsView.application.tooltip"));
        Composite composite = this.toolkit.createComposite((Composite)tabFolder, 0);
        composite.setLayout((Layout)this.leanLayout(new GridLayout()));
        composite.setLayoutData((Object)new GridData(1, 1, true, true));
        tabItem.setControl((Control)composite);
        this.createRunningTable(composite, new Object[][]{{ColumnDefinition.ACPLATNM, ColumnDefinition.MPPRTXCD}, {ColumnDefinition.ACAPPLNM, ""}, {ColumnDefinition.ACMAJVER, ColumnDefinition.ACAPPLVR}, {ColumnDefinition.ACMINVER, ""}, {ColumnDefinition.ACMICVER, ""}, {ColumnDefinition.ACOPERNM, ""}}, new int[]{180, 150});
        return composite;
    }

    private Composite createAlertDetail(TabFolder tabFolder) {
        Image image = Activator.getDefault().getImage("information");
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setToolTipText(Messages.getString("PerformanceListRecordFormsView.alertdetail.tooltip"));
        tabItem.setText(Messages.getString("PerformanceListRecordFormsView.Alert.detail"));
        if (((String)this.model.getCompleteValues().get(ColumnDefinition.SEVERITY)).trim().equals("Critical")) {
            image = Activator.getDefault().getImage("critical");
        } else if (((String)this.model.getCompleteValues().get(ColumnDefinition.SEVERITY)).trim().equals("Warning")) {
            image = Activator.getDefault().getImage("warning");
        }
        tabItem.setImage(image);
        Composite composite = this.toolkit.createComposite((Composite)tabFolder, 0);
        composite.setLayout((Layout)this.leanLayout(new GridLayout()));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        tabItem.setControl((Control)composite);
        this.createRunningTable(composite, new Object[][]{{ColumnDefinition.ALT_FIELD_NAME, ColumnDefinition.ALT_FIELD_VALUE, ColumnDefinition.THRESHOLD}, {ColumnDefinition.RES_NAME1, ColumnDefinition.RES_VALUE1, ColumnDefinition.ALT_DEF_NAME}, {ColumnDefinition.RES_NAME2, ColumnDefinition.RES_VALUE2, ""}, {ColumnDefinition.RES_NAME3, ColumnDefinition.RES_VALUE3, ""}}, new int[]{160, 160, 140});
        return composite;
    }

    private Composite createFacilityInformation(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Messages.getString("PerformanceListRecordFormsView.Facility.information"));
        tabItem.setToolTipText(Messages.getString("PerformanceListRecordFormsView.facility.tooltip"));
        Composite composite = this.toolkit.createComposite((Composite)tabFolder, 0);
        composite.setLayout((Layout)this.leanLayout(new GridLayout(1, false)));
        composite.setLayoutData((Object)new GridData(4, 4, false, false));
        tabItem.setControl((Control)composite);
        this.createRunningTable(composite, new Object[][]{{ColumnDefinition.FCTYTYPE, ColumnDefinition.FCTY, ColumnDefinition.NETID, ""}, {ColumnDefinition.TERM, ColumnDefinition.LUNAME, ColumnDefinition.RLUNAME, ""}, {ColumnDefinition.TERMCNNM, "", "", ""}, {ColumnDefinition.SESSTYPE, ColumnDefinition.ACCMETH, ColumnDefinition.NATURE, ""}, {ColumnDefinition.CLIP6ADR, ColumnDefinition.CLIPPORT, "", ColumnDefinition.TCALLOC}, {ColumnDefinition.TCPSRVCE, ColumnDefinition.PORT, ColumnDefinition.ISIPICNM, ColumnDefinition.ISALLOC}}, new int[]{150, 150, 150, 150});
        return composite;
    }

    private Composite createWebserviceInformation(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Messages.getString("PerformanceListRecordFormsView.Webservice.information"));
        tabItem.setToolTipText(Messages.getString("PerformanceListRecordFormsView.webservice.tooltip"));
        Composite composite = this.toolkit.createComposite((Composite)tabFolder, 0);
        composite.setLayout((Layout)this.leanLayout(new GridLayout(1, false)));
        composite.setLayoutData((Object)new GridData(4, 4, false, false));
        tabItem.setControl((Control)composite);
        this.createRunningTable(composite, new Object[][]{{ColumnDefinition.TCPSRVCE, ColumnDefinition.PORT, ColumnDefinition.CLIP6ADR, ColumnDefinition.CLIPPORT}, {ColumnDefinition.WBURIMNM, "", "", ""}, {ColumnDefinition.WBPIPLNM, ColumnDefinition.DHTOTAL, "", ColumnDefinition.SOCIPHER}, {ColumnDefinition.WBSVCENM, ColumnDefinition.WBIWBSCT, "", ColumnDefinition.SOBYDECT}, {ColumnDefinition.WBPROGNM, ColumnDefinition.WBTOTAL, "", ColumnDefinition.SOBYENCT}, {ColumnDefinition.WBATMSNM, ColumnDefinition.SOTOTAL, "", ""}}, new int[]{150, 150, 150, 150});
        return composite;
    }

    private void createPieSection(TabFolder topTabFolder) {
        this.model.establishVariance().populatePieSection((IViewPart)this, topTabFolder, this.toolkit, this.focusListener);
    }

    private String getHelpContextId() {
        return "com.ibm.cics.pa.ui.performance_record";
    }

    public void dispose() {
        if (this.toolkit != null) {
            this.toolkit.dispose();
        }
        super.dispose();
    }

    private void closeMeAgain(final ViewPart view) {
        Job job = new Job(Messages.getString("TimelineHandler.4")){

            protected IStatus run(IProgressMonitor monitor) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PerformanceListRecordFormsView.this.getViewSite().getPage().hideView((IViewPart)view);
                        ViewHelper.setDeferredStatusInformationMessage((String)Messages.getString("PAX0103I.Results.NoData"));
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.schedule();
    }

    @Override
    public void disconnected() {
        Job job = new Job(Messages.getString("Resource.status.disconnected")){

            protected IStatus run(IProgressMonitor monitor) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PerformanceListRecordFormsView.this.getViewSite().getPage().hideView((IViewPart)PerformanceListRecordFormsView.this);
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.schedule();
    }

    @Override
    public void connected(PAConnectionListener.Era era) {
    }

    @Override
    public void disconnecting() {
    }

    public ISelection getSelection() {
        return new StructuredSelection(this.nextAlert != null ? this.nextAlert : this.record);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        final SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        Iterator<ISelectionChangedListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ISelectionChangedListener listener;
            final ISelectionChangedListener finalListener = listener = iterator.next();
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    debug.error(this.getClass().getName(), "setSelection", exception);
                }

                public void run() throws Exception {
                    finalListener.selectionChanged(event);
                }
            });
        }
    }

    public void setFocus() {
        this.form.setFocus();
    }

    public void adjustTreeSelection(ColumnContainment columnContainment) {
        ((PerformanceListRecordViewVariance.IndividualTab)this.topTabFolder.getSelection()[0].getControl()).adjustTreeSelection(columnContainment);
    }

    public void adjustTreeSelection(ColumnDefinition columnDefinition) {
        ((PerformanceListRecordViewVariance.IndividualTab)this.topTabFolder.getSelection()[0].getControl()).adjustTreeSelection(columnDefinition);
    }

    private Composite getSectionClient(Composite composite, String text, int extra_style, boolean grabVertical) {
        Section section = this.toolkit.createSection(composite, extra_style);
        if (StringUtil.hasContent((String)text)) {
            section.setText(text);
        }
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                PerformanceListRecordFormsView.this.form.reflow(false);
            }
        });
        ColumnLayout layout2 = new ColumnLayout();
        layout2.maxNumColumns = 1;
        layout2.horizontalSpacing = 0;
        layout2.verticalSpacing = 0;
        Composite innerComposite = this.toolkit.createComposite((Composite)section, 0);
        section.setClient((Control)innerComposite);
        section.setLayout((Layout)layout2);
        section.setLayoutData((Object)new GridData(4, 1, true, grabVertical));
        innerComposite.setLayout((Layout)this.leanLayout(new GridLayout()));
        return innerComposite;
    }

    private Composite getTwistieSectionClient(Composite composite, String text, int extra_style) {
        Section section = this.toolkit.createSection(composite, extra_style);
        if (StringUtil.hasContent((String)text)) {
            section.setText(text);
        }
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                PerformanceListRecordFormsView.this.form.reflow(false);
            }
        });
        Composite innerComposite = this.toolkit.createComposite((Composite)section, 0);
        section.setClient((Control)innerComposite);
        section.setLayout((Layout)this.leanLayout(new GridLayout()));
        section.setLayoutData((Object)new GridData(1, 1, false, false));
        innerComposite.setLayout((Layout)this.leanLayout(new GridLayout()));
        innerComposite.setLayoutData((Object)new GridData(1, 1, false, true));
        return innerComposite;
    }

    private Composite getCompositeClientGridData(Composite composite) {
        GridLayout formLayout = new GridLayout();
        formLayout.horizontalSpacing = 0;
        formLayout.verticalSpacing = 0;
        formLayout.marginHeight = 0;
        formLayout.marginWidth = 0;
        Composite innerComposite = this.toolkit.createComposite(composite, 0);
        innerComposite.setLayout((Layout)formLayout);
        return innerComposite;
    }

    public String getPartProperty(String key) {
        if (IConnectionCategory.class.getName().equals(key)) {
            return "com.ibm.cics.pa.connection";
        }
        return super.getPartProperty(key);
    }

    private TableViewer basicTableViewer(Table table) {
        TableViewer tableViewer = new TableViewer(table);
        tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }
        });
        return tableViewer;
    }

    private void setTableViewerLabel(TableViewerColumn tableViewerColumn, final int rows) {
        tableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getToolTipText(Object defns) {
                if (defns instanceof Object[] && ((Object[])defns)[rows] instanceof ColumnDefinition) {
                    return ((Object[])defns)[rows] == null ? "" : ((ColumnDefinition)((Object[])defns)[rows]).getTooltip(null);
                }
                if (defns instanceof ColumnDefinition) {
                    return ((ColumnDefinition)defns).getTooltip(null);
                }
                return "";
            }

            public String getText(Object defns) {
                if (defns instanceof Object[] && ((Object[])defns)[rows] instanceof ColumnDefinition) {
                    return ((Object[])defns)[rows] == null ? "" : ((ColumnDefinition)((Object[])defns)[rows]).getLabel(null);
                }
                if (defns instanceof ColumnDefinition) {
                    return ((ColumnDefinition)defns).getLabel(null);
                }
                return "";
            }
        });
    }

    private void setTableViewerLabelData(final TableViewerColumn tableViewerColumn, final int rows) {
        tableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getToolTipText(Object defns) {
                if (defns instanceof Object[] && ((Object[])defns)[rows] instanceof ColumnDefinition) {
                    return ((Object[])defns)[rows] == null ? "" : String.valueOf(((ColumnDefinition)((Object[])defns)[rows]).getTooltip(null)) + ": " + DataTypeUtilities.getAsString(PerformanceListRecordFormsView.this.model.getCompleteValues().get(((Object[])defns)[rows]));
                }
                if (defns instanceof ColumnDefinition) {
                    return String.valueOf(((ColumnDefinition)defns).getTooltip(null)) + ": " + DataTypeUtilities.getAsString(PerformanceListRecordFormsView.this.model.getCompleteValues().get(defns));
                }
                return "";
            }

            public String getText(Object defns) {
                if (defns instanceof Object[] && ((Object[])defns)[rows] instanceof ColumnDefinition) {
                    return ((Object[])defns)[rows] == null ? "" : DataTypeUtilities.getAsString(PerformanceListRecordFormsView.this.model.getCompleteValues().get(((Object[])defns)[rows]));
                }
                if (defns instanceof ColumnDefinition) {
                    return DataTypeUtilities.getAsString(PerformanceListRecordFormsView.this.model.getCompleteValues().get(defns));
                }
                return "";
            }

            public Font getFont(Object defns) {
                if (defns instanceof Object[] && ((Object[])defns)[rows] instanceof ColumnDefinition) {
                    return STANDARD_BOLD;
                }
                return null;
            }

            public void update(ViewerCell cell) {
                super.update(cell);
                TableItem item = (TableItem)cell.getItem();
                if (cell.getElement() instanceof Object[] && ((Object[])cell.getElement())[rows] instanceof ColumnDefinition && ((ColumnDefinition)((Object[])cell.getElement())[rows] == ColumnDefinition.TCLASSNM || (ColumnDefinition)((Object[])cell.getElement())[rows] == ColumnDefinition.TRAN)) {
                    final ColumnDefinition definition = (ColumnDefinition)((Object[])cell.getElement())[rows];
                    Hyperlink link = new Hyperlink((Composite)((TableViewer)tableViewerColumn.getViewer()).getTable(), 0);
                    link.setUnderlined(true);
                    link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                        public void linkActivated(HyperlinkEvent e) {
                            PerformanceListRecordFormsView.this.activateLink(definition);
                        }
                    });
                    String text = DataTypeUtilities.getAsString(PerformanceListRecordFormsView.this.model.getCompleteValues().get(((Object[])cell.getElement())[rows]));
                    link.setForeground(ColorConstants.blue);
                    link.setToolTipText((ColumnDefinition)((Object[])cell.getElement())[rows] == ColumnDefinition.TCLASSNM ? MessageFormat.format(Messages.getString("PlotView.open.tranclass"), text) : MessageFormat.format(Messages.getString("PlotView.open.transaction"), text));
                    link.setText(text);
                    link.setFont(STANDARD_BOLD);
                    cell.setText("");
                    link.setEnabled(true);
                    TableEditor editor = new TableEditor(item.getParent());
                    editor.grabHorizontal = true;
                    editor.grabVertical = true;
                    editor.setEditor((Control)link, item, cell.getColumnIndex());
                    editor.layout();
                }
            }
        });
    }

    private GridLayout leanLayout(GridLayout noMargin) {
        noMargin.marginBottom = 0;
        noMargin.marginTop = 0;
        noMargin.marginLeft = 0;
        noMargin.marginRight = 0;
        noMargin.marginWidth = 0;
        noMargin.marginHeight = 0;
        noMargin.verticalSpacing = 0;
        noMargin.horizontalSpacing = 0;
        return noMargin;
    }

    private WaitAnalysis createWaitAnalysisSection(Composite parent, int expanded, Pie startModel) {
        WaitAnalysis model = new WaitAnalysis(startModel);
        if (model.isReliable()) {
            ScrollingGraphicalViewer graphicalViewerLine = new ScrollingGraphicalViewer();
            FigureCanvas viewerHeader = (FigureCanvas)graphicalViewerLine.createControl(parent);
            viewerHeader.getViewport().setPreferredSize(new Dimension(1000, 125));
            LightweightSystem lws = new LightweightSystem((Canvas)viewerHeader);
            this.toolkit.adapt((Composite)viewerHeader);
            WaitAnalysisFigure waitFigure = new WaitAnalysisFigure((GraphicalViewer)graphicalViewerLine, model);
            waitFigure.setModel(model);
            viewerHeader.getViewport().setContents((IFigure)waitFigure);
            lws.setContents((IFigure)waitFigure);
        } else {
            ViewHelper.setStatusInformationMessage((IWorkbenchPart)this, (String)Messages.getString("PlotView.insufficient.data"));
        }
        return model;
    }

    void activateLink(ColumnDefinition columnDefinition) {
        String tableAlias = null;
        ColumnDefinition columnDefinition2 = null;
        Object value = this.model.getCompleteValues().get(columnDefinition);
        if (columnDefinition == ColumnDefinition.TCLASSNM) {
            tableAlias = "HST012A";
            columnDefinition2 = ColumnDefinition.TCLASS_NAME;
        } else if (columnDefinition == ColumnDefinition.TRAN) {
            tableAlias = "HST011A";
            columnDefinition2 = ColumnDefinition.TRAN_ID;
        }
        if (StringUtil.hasContent((String)tableAlias)) {
            ViewLinkingDBFunctions.openSpreadsheet((IViewPart)this, this.record, tableAlias, columnDefinition2, value);
        }
    }

    public void setNextAlert(AlertElement nextAlert) {
        debug.enter("activateHyperLink", (Object)nextAlert);
        if (nextAlert != null) {
            this.nextAlert = nextAlert;
            ICommandService commandService = (ICommandService)this.getSite().getService(ICommandService.class);
            Command command = commandService.getCommand("com.ibm.cics.pa.ui.intervaltracker");
            if (command.isEnabled()) {
                try {
                    IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
                    handlerService.executeCommand("com.ibm.cics.pa.ui.intervaltracker", null);
                }
                catch (NotDefinedException e) {
                    debug.error("activateLink", "Could not find open command: com.ibm.cics.pa.ui.intervaltracker", (Throwable)e);
                }
                catch (ExecutionException e) {
                    debug.error("activateLink", "Failed to execute comand: com.ibm.cics.pa.ui.intervaltracker", (Throwable)e);
                }
                catch (NotEnabledException e) {
                    debug.error("activateLink", "Command not enabled: com.ibm.cics.pa.ui.intervaltracker", (Throwable)e);
                }
                catch (NotHandledException e) {
                    debug.error("activateLink", "Command not handled: com.ibm.cics.pa.ui.intervaltracker", (Throwable)e);
                }
            }
            this.nextAlert = null;
        }
        debug.exit("activateHyperLink");
    }

    public AlertElement getNextAlert() {
        return this.nextAlert;
    }
}

