/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.views;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.pa.model.ManifestRecord;
import com.ibm.cics.pa.model.definitions.TableCategorisationEnum;
import com.ibm.cics.pa.ui.dialogs.PATreeColumnViewerLabelProvider;
import com.ibm.cics.pa.ui.dialogs.TableSelectorContentProvider;
import com.ibm.cics.pa.ui.remote.PAConnectionListener;
import com.ibm.cics.pa.ui.remote.PAConnectionTracker;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class Navigator
implements PAConnectionListener {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(Navigator.class);
    TreeViewer navigatorTreeViewer;

    private String getHelpContextId() {
        return "com.ibm.cics.pa.ui.tables_dialog";
    }

    public void createPartControl(Composite parent) {
        debug.enter("createPartControl");
        TableSelectorContentProvider contentProvider = new TableSelectorContentProvider((Object)TableCategorisationEnum.Root){

            @Override
            public boolean hasChildren(Object element) {
                return !(element instanceof String) && !(element instanceof ManifestRecord);
            }
        };
        PATreeColumnViewerLabelProvider labelProvider = new PATreeColumnViewerLabelProvider(true);
        parent.setLayout((Layout)new GridLayout(1, true));
        FilteredTree tree = new FilteredTree(parent, 2820, new PatternFilter(){

            protected boolean isParentMatch(Viewer viewer, Object element) {
                Object[] children = ((ITreeContentProvider)((AbstractTreeViewer)viewer).getContentProvider()).getChildren(element);
                if (element instanceof ManifestRecord || element instanceof TableCategorisationEnum) {
                    return this.filter(viewer, element, children).length > 0;
                }
                return false;
            }
        }, true);
        this.navigatorTreeViewer = tree.getViewer();
        this.navigatorTreeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.navigatorTreeViewer.setContentProvider((IContentProvider)contentProvider);
        this.navigatorTreeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.navigatorTreeViewer.getTree().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        PAConnectionTracker.getInstance().addPAConnectionTrackerListener(this);
        ManifestRecord.registerNavigator(this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.getHelpContextId());
        debug.exit("createPartControl");
    }

    public void refresh(final ManifestRecord manifestRecord) {
        debug.enter("refresh");
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Navigator.this.navigatorTreeViewer.refresh((Object)manifestRecord);
            }
        });
        debug.exit("refresh");
    }

    public void setFocus() {
    }

    @Override
    public void disconnected() {
        this.navigatorTreeViewer.setInput(null);
    }

    @Override
    public void disconnecting() {
    }

    @Override
    public void connected(PAConnectionListener.Era era) {
        if (era == PAConnectionListener.Era.POST) {
            this.navigatorTreeViewer.setInput((Object)TableCategorisationEnum.Root);
            this.navigatorTreeViewer.expandToLevel(2);
        }
    }
}

