/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.views;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.dbfunc.command.EngineShell;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.Direction;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.ui.ScrollLimitManager;
import com.ibm.cics.eclipse.common.ViewHelper;
import com.ibm.cics.pa.model.AlertElement;
import com.ibm.cics.pa.model.ManifestRecord;
import com.ibm.cics.pa.model.NullRangeDateCaveat;
import com.ibm.cics.pa.model.definitions.CategorisationHelper;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.remote.AlertsCommand;
import com.ibm.cics.pa.ui.remote.PAConnectionTracker;
import com.ibm.cics.pa.ui.utilities.FilterElement;
import com.ibm.cics.pa.ui.views.AlertsView;
import com.ibm.cics.pa.ui.views.Overview;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class Alerts
extends AlertsView {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final Logger logger = Logger.getLogger("com.ibm.cics.pa.ui");
    private IPerspectiveListener perspectiveListener;
    private static final String TG = "com.ibm.ctg.ui.perspectives.cicstg";
    private static final String TS = "com.ibm.cics.core.ui.sm.perspective";
    private static final ColumnDefinition[] FIELDS = new ColumnDefinition[]{ColumnDefinition.ALERT, ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.RESOURCE_NAME, ColumnDefinition.RESOURCE_VALUE, ColumnDefinition.ACTUAL, ColumnDefinition.THRESHOLD, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_NUMBER, ColumnDefinition.INTERVAL_DURATION};

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.viewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (!Alerts.this.viewer.getSelection().isEmpty()) {
                    try {
                        IHandlerService handlerService = (IHandlerService)Alerts.this.getSite().getService(IHandlerService.class);
                        AlertElement element = (AlertElement)((StructuredSelection)Alerts.this.viewer.getSelection()).getFirstElement();
                        ManifestRecord record = ManifestRecord.getAlias(element.getTableAlias());
                        if (record != null && record.isPresent()) {
                            String manifest = record.getAlias();
                            for (String alias : CategorisationHelper.getPossibleIntervalTables()) {
                                if (!manifest.startsWith(alias)) continue;
                                handlerService.executeCommand("com.ibm.cics.pa.ui.intervaltracker", null);
                                return;
                            }
                        }
                        handlerService.executeCommand("com.ibm.cics.pa.ui.commands.spreadsheet", null);
                    }
                    catch (Exception ex) {
                        Debug.error((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"createPartControl", (Throwable)ex);
                    }
                }
            }
        });
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().addPerspectiveListener(this.getPerspectiveListener());
    }

    @Override
    public void tableSelected(ManifestRecord manifest) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"tableSelected");
        this.initialised = true;
        if (this.command != null && this.command.status() == -1) {
            this.command.cancel();
            ViewHelper.setStatusInformationMessage((IWorkbenchPart)this, (String)Messages.getString("RemoteEditorInput.SearchHalted1"));
            Debug.event((Logger)logger, (String)this.getClass().getName(), (String)"Overview Listener selectionChanged", (Object)"Cancelled already waiting command");
        } else if (this.command != null && this.command.status() == 0) {
            this.command.cancel();
            ViewHelper.setStatusInformationMessage((IWorkbenchPart)this, (String)Messages.getString("RemoteEditorInput.SearchHalted2"));
            Debug.event((Logger)logger, (String)this.getClass().getName(), (String)"A command already in progress");
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                Debug.error((Logger)logger, (String)this.getClass().getName(), (String)"tableSelected", (Throwable)e);
            }
        }
        if (this.connected) {
            if (manifest != null) {
                this.currentManifest = manifest;
            }
            String newDescription = "";
            this.setContentDescription("");
            if (this.currentManifest != null && this.currentManifest.isPresent()) {
                this.scrollLimitManager = this.getScrollLimitManager();
                if (this.scrollLimitManager != null) {
                    this.scrollLimitManager.dispose();
                }
                this.initialiseBuckets();
                HashMap<String, Object> parameterMap = new HashMap<String, Object>();
                this.selection = PresentationFactory.getInstance().createSelectAllForTable(this.currentManifest.getName(), ":schema");
                ArrayList<String> whereByClause = new ArrayList<String>();
                if (Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.pa.ui.alert.critical", true, null)) {
                    whereByClause.add("Critical");
                }
                if (Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.pa.ui.alert.warning", true, null)) {
                    whereByClause.add("Warning");
                }
                if (Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.pa.ui.alert.information", true, null)) {
                    whereByClause.add("Info");
                }
                if (!whereByClause.isEmpty() && whereByClause.size() < 3) {
                    this.selection.appendCondition(ColumnDefinition.SEVERITY.getDBColumnRef(), this.currentManifest.getName(), ColumnDefinition.SEVERITY.getType(), Comparator.IN, whereByClause.toArray(), QueryElement.Predicate.AND, false);
                }
                if (this.filters != null && !this.filters.isEmpty()) {
                    Object aClause = null;
                    for (FilterElement element : this.filters) {
                        newDescription = String.valueOf(newDescription) + element.toString();
                        newDescription = String.valueOf(newDescription) + ',';
                        ColumnDefinition column = (ColumnDefinition)element.getColumn();
                        String attribute = element.getOperator();
                        boolean isNot = false;
                        Comparator comparator = Comparator.EQ;
                        if (!attribute.trim().equals("=")) {
                            if (attribute.trim().equals("!=")) {
                                comparator = Comparator.EQ;
                                isNot = true;
                            } else if (attribute.trim().equals(">")) {
                                comparator = Comparator.GT;
                            } else if (attribute.trim().equals(">=")) {
                                comparator = Comparator.GE;
                            } else if (attribute.trim().equals("<")) {
                                comparator = Comparator.LT;
                            } else if (attribute.trim().equals("<=")) {
                                comparator = Comparator.LE;
                            }
                        }
                        String value = element.getValue();
                        if (element.getAlternativeValue() != null) {
                            value = element.getAlternativeValue().getDBColumnRef();
                        }
                        if (value.indexOf(42) > -1) {
                            value.replace('*', '%');
                        }
                        if (value.indexOf(37) > -1) {
                            comparator = Comparator.LI;
                        }
                        aClause = aClause == null ? PresentationFactory.getInstance().createSimpleCondition(column.getDBColumnRef(), this.currentManifest.getName(), column.getType(), comparator, new Object[]{value}, isNot) : aClause.appendCondition(column.getDBColumnRef(), this.currentManifest.getName(), column.getType(), comparator, new Object[]{value}, QueryElement.Predicate.AND, isNot);
                    }
                    parameterMap.put("TemporaryConstraintAnd", aClause);
                }
                if (this.sortColumnDefinition != null) {
                    this.selection.addOrderByCondition(this.sortColumnDefinition.getDBColumnRef(), this.currentManifest.getName(), this.sortDirection == 128 ? Direction.ASC : Direction.DESC);
                } else {
                    this.selection.addOrderByCondition(ColumnDefinition.START_DATE.getDBColumnRef(), this.currentManifest.getName(), Direction.DESC);
                    this.selection.addOrderByCondition(ColumnDefinition.START_TIME.getDBColumnRef(), this.currentManifest.getName(), Direction.DESC);
                    this.selection.addOrderByCondition(ColumnDefinition.APPLID.getDBColumnRef(), this.currentManifest.getName(), Direction.DESC);
                }
                if (this.currentDateToken != null && !(this.currentDateToken instanceof NullRangeDateCaveat)) {
                    this.selection.appendCondition(this.currentDateToken.getConstraint(null, false), QueryElement.Predicate.AND);
                    newDescription = String.valueOf(newDescription) + this.currentDateToken.getLabel() + this.relativeDateText();
                }
                if (this.isLinkedToSelection && !this.linkToSelection.isEmpty()) {
                    this.selection.appendCondition(ColumnDefinition.APPLID.getDBColumnRef(), this.currentManifest.getName(), ColumnDefinition.APPLID.getType(), Comparator.IN, this.linkToSelection.toArray(), QueryElement.Predicate.AND, false);
                    StringBuffer desc = new StringBuffer(this.getContentDescription());
                    Object[] elements = this.linkToSelection.toArray();
                    int i = 0;
                    while (i < elements.length) {
                        if (i == 0) {
                            desc.append(ColumnDefinition.APPLID.getLabel(null));
                        } else {
                            desc.append(',');
                        }
                        desc.append(' ');
                        desc.append((String)elements[i]);
                        if (i == elements.length - 1) {
                            desc.append('.');
                        }
                        ++i;
                    }
                    newDescription = String.valueOf(newDescription) + ' ' + desc.toString();
                }
                this.setContentDescription(newDescription);
                this.command = new AlertsCommand(this, this.selection, this.defns, parameterMap);
                this.command.setAsync(false);
                this.command.addListener(new EngineShell.EngineListener(){
                    private int rows_returned = 0;

                    public void dataAvailable(Collection<Object> items) {
                        this.setRows_returned(this.getRows_returned() + items.size());
                        Alerts.this.updateResults(Alerts.this.viewer, items);
                    }

                    public void notifyResultCount(int count) {
                    }

                    public void statusUpdate(EngineShell.EngineStatus es) {
                        switch (es) {
                            case Cancelled: 
                            case Error: {
                                Alerts.this.command.removeListener(this);
                                Display.getDefault().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        ScrollLimitManager scrollLimitManager = Alerts.this.getScrollLimitManager();
                                        if (scrollLimitManager != null) {
                                            scrollLimitManager.dispose();
                                        }
                                    }
                                });
                                break;
                            }
                            case Complete: {
                                Alerts.this.command.removeListener(this);
                                try {
                                    Thread.sleep(250L);
                                }
                                catch (InterruptedException e) {
                                    Debug.error((Logger)logger, (String)this.getClass().getName(), (String)"tableSelected", (Throwable)e);
                                }
                                Display.getDefault().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        (this).Alerts.this.scrollLimitManager = Alerts.this.getScrollLimitManager();
                                        if ((this).Alerts.this.scrollLimitManager != null) {
                                            (this).Alerts.this.scrollLimitManager.dispose();
                                        }
                                        if ((this).Alerts.this.filterControl != null) {
                                            (this).Alerts.this.filterControl.revalidate();
                                        }
                                        if (!("Critical".isEmpty() && "Warning".isEmpty() && "Info".isEmpty())) {
                                            ViewHelper.setStatusInformationMessage((IWorkbenchPart)Alerts.this, (String)MessageFormat.format(Messages.getString("CSVDataExtract.Rows"), this.getRows_returned()));
                                        } else {
                                            Alerts.this.setContentDescription(String.valueOf(Alerts.this.getContentDescription()) + ' ' + Messages.getString("PAX0103I.Results.NoData"));
                                            ViewHelper.setStatusInformationMessage((IWorkbenchPart)Alerts.this, (String)"");
                                        }
                                    }
                                });
                                break;
                            }
                            case Paused: {
                                Display.getDefault().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        ScrollLimitManager scrollLimitManager;
                                        if ((this).Alerts.this.filterControl != null) {
                                            (this).Alerts.this.filterControl.revalidate();
                                        }
                                        if ((scrollLimitManager = Alerts.this.getScrollLimitManager()) != null && (this).Alerts.this.command != null && (this).Alerts.this.command.status() == 3) {
                                            scrollLimitManager.setCursor(null);
                                            scrollLimitManager.scrollLimitReached((Command)(this).Alerts.this.command);
                                            scrollLimitManager.setTaskName(MessageFormat.format(Messages.getString("SheetView.collecting"), Messages.getString("Alerts")));
                                        }
                                    }
                                });
                                break;
                            }
                        }
                    }

                    public int getRows_returned() {
                        return this.rows_returned;
                    }

                    public void setRows_returned(int rows_returned) {
                        this.rows_returned = rows_returned;
                    }
                });
                Job job = new Job(MessageFormat.format(Messages.getString("AlertsView.collecting"), this.getContentDescription())){

                    protected IStatus run(IProgressMonitor monitor) {
                        if (PAConnectionTracker.getInstance().isConnected()) {
                            Alerts.this.command.start();
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setPriority(30);
                IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
                siteService.schedule(job);
            } else {
                ViewHelper.setStatusInformationMessage((IWorkbenchPart)this, (String)MessageFormat.format(Messages.getString("PAX0109I.Results.NoData.view"), this.getPartName()));
            }
        }
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"tableSelected");
    }

    @Override
    protected String getHelpContextId() {
        return "com.ibm.cics.pa.ui.alertsview";
    }

    @Override
    public ColumnDefinition[] getFields() {
        return FIELDS;
    }

    @Override
    public String getPersistenceLabel() {
        return "HST0SAA";
    }

    @Override
    public void initialise() {
        Job job = new Job(Messages.getString("ExplorerViewContentProvider.initialization")){

            protected IStatus run(IProgressMonitor monitor) {
                final ManifestRecord manifest = PAConnectionTracker.getInstance().getAlertManifest();
                if (manifest != null) {
                    while (!manifest.isPresent()) {
                        try {
                            Thread.yield();
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            Debug.error((Logger)logger, (String)Alerts.class.getName(), (String)"initialise", (Throwable)e);
                        }
                    }
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            Alerts.this.tableSelected(manifest);
                            Overview overview = (Overview)Alerts.this.getSite().getPage().findView("com.ibm.cics.pa.ui.overview");
                            if (overview != null) {
                                Alerts.this.selectionChanged((IWorkbenchPart)overview, overview.getSelection());
                            }
                        }
                    });
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(30);
        IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        siteService.schedule(job);
    }

    @Override
    public void resetColumns() {
        int[] order = new int[this.getFields().length];
        int i = 0;
        while (i < this.getFields().length) {
            order[i] = i;
            ++i;
        }
        this.viewer.getTree().setColumnOrder(order);
        i = 0;
        while (i < this.getFields().length) {
            if (this.getFields()[i] == ColumnDefinition.ALERT) {
                this.viewer.getTree().getColumn(i).setWidth(300);
            } else if (this.getFields()[i].getType() == ColumnReference.DataType.String) {
                this.viewer.getTree().getColumn(i).setWidth(75);
                this.viewer.getTree().getColumn(i).setAlignment(0x1000000);
            } else {
                this.viewer.getTree().getColumn(i).setWidth(65);
                this.viewer.getTree().getColumn(i).setAlignment(131072);
            }
            ++i;
        }
        this.viewer.refresh();
    }

    @Override
    protected void fillActionBar(IActionBars actionBars) {
        super.fillActionBar(actionBars);
        actionBars.getMenuManager().addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                String[] stringArray = new String[]{"com.ibm.cics.pa.ui.alert.table.tg", "com.ibm.cics.pa.ui.alert.table.ts"};
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String contributor = stringArray[n2];
                    IContributionItem item = manager.find(contributor);
                    if (item != null && Alerts.this.isLinkedToSelection == item.isVisible()) {
                        item.setVisible(!Alerts.this.isLinkedToSelection);
                        item.update();
                        manager.update(true);
                    }
                    ++n2;
                }
            }
        });
    }

    @Override
    protected void fillViewMenuDropdown(IMenuManager manager) {
        super.fillViewMenuDropdown(manager);
        String[] stringArray = new String[]{"com.ibm.cics.pa.ui.alert.table.tg", "com.ibm.cics.pa.ui.alert.table.ts"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String contributor = stringArray[n2];
            IContributionItem item = manager.find(contributor);
            if (item != null && this.isLinkedToSelection == item.isVisible()) {
                item.setVisible(!this.isLinkedToSelection);
                item.update();
                manager.update(true);
            }
            ++n2;
        }
    }

    private IPerspectiveListener getPerspectiveListener() {
        if (this.perspectiveListener == null) {
            this.perspectiveListener = new IPerspectiveListener(){

                public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
                }

                public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                    Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"perspectiveActivated");
                    if (perspective.getId().equals(Alerts.TG) && Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.pa.ui.alert.table.ts", true, null)) {
                        Debug.event((Logger)logger, (String)this.getClass().getName(), (String)"perspectiveActivated TG");
                        Activator.getDefault().getPluginInstancePreferences().putBoolean("com.ibm.cics.pa.ui.alert.table.tg", true);
                        Activator.getDefault().getPluginInstancePreferences().putBoolean("com.ibm.cics.pa.ui.alert.table.ts", false);
                        ManifestRecord manifest = ManifestRecord.getAlias("HSTG0SAA");
                        Alerts.this.tableSelected(manifest);
                    } else if (perspective.getId().equals(Alerts.TS) && Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.pa.ui.alert.table.tg", true, null)) {
                        Debug.event((Logger)logger, (String)this.getClass().getName(), (String)"perspectiveActivated TS");
                        Activator.getDefault().getPluginInstancePreferences().putBoolean("com.ibm.cics.pa.ui.alert.table.tg", false);
                        Activator.getDefault().getPluginInstancePreferences().putBoolean("com.ibm.cics.pa.ui.alert.table.ts", true);
                        ManifestRecord manifest = ManifestRecord.getAlias("HST0SAA");
                        Alerts.this.tableSelected(manifest);
                    }
                    Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"perspectiveActivated");
                }
            };
        }
        return this.perspectiveListener;
    }

    @Override
    public void dispose() {
        super.dispose();
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().removePerspectiveListener(this.getPerspectiveListener());
    }
}

