/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.utilities;

import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.List;

public class MessagePackage {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String description = null;
    private ColumnDefinition[] descriptionInserts1 = null;
    private ColumnDefinition[][] descriptionInserts2 = null;

    public MessagePackage(String description, ColumnDefinition[] descriptionInserts) {
        this.description = description;
        this.descriptionInserts1 = descriptionInserts;
    }

    public MessagePackage(String description, ColumnDefinition[][] descriptionInserts) {
        this.description = description;
        this.descriptionInserts2 = descriptionInserts;
    }

    public static String presentSQLException(SQLException sqle) {
        return "SQL " + (sqle instanceof SQLWarning ? "Warning" : "Exception") + " Sql state : " + (sqle.getSQLState() != null ? sqle.getSQLState() : "null") + " Message: " + (sqle.getMessage() != null ? sqle.getMessage() : "null") + " Error  : " + sqle.getErrorCode();
    }

    public String resolve(ColumnDefinition[] columnDefinition, Object[] row) {
        String revisedDescription;
        block10: {
            block9: {
                revisedDescription = this.description;
                if (this.descriptionInserts1 == null) break block9;
                int ctr = 0;
                int column = 0;
                ColumnDefinition[] columnDefinitionArray = this.descriptionInserts1;
                int n = this.descriptionInserts1.length;
                int n2 = 0;
                while (n2 < n) {
                    ColumnDefinition lookup = columnDefinitionArray[n2];
                    column = -1;
                    int i = 0;
                    while (i < columnDefinition.length) {
                        if (lookup != null && lookup.equals(columnDefinition[i])) {
                            column = i;
                        }
                        ++i;
                    }
                    int index = revisedDescription.indexOf("{" + ctr + "}");
                    if (index != -1 && row != null) {
                        String absolute = column > -1 ? DataTypeUtilities.seekAbsolution(row[column], false) : Messages.getString("MessagePackage.QuestionMark");
                        revisedDescription = String.valueOf(revisedDescription.substring(0, index)) + absolute + revisedDescription.substring(index + 3);
                    }
                    ++ctr;
                    ++n2;
                }
                break block10;
            }
            if (this.descriptionInserts2 == null) break block10;
            int ctr = 0;
            String absolute = "";
            int p = 0;
            while (p < this.descriptionInserts2.length) {
                Double accumulator = 0.0;
                ColumnDefinition[] columnDefinitionArray = this.descriptionInserts2[p];
                int n = columnDefinitionArray.length;
                int n3 = 0;
                while (n3 < n) {
                    ColumnDefinition lookup = columnDefinitionArray[n3];
                    int column = 0;
                    while (column < columnDefinition.length) {
                        if (lookup.equals(columnDefinition[column])) {
                            accumulator = (Double)DataTypeUtilities.sum(accumulator, row[column]);
                        }
                        ++column;
                    }
                    ++n3;
                }
                absolute = DataTypeUtilities.getAsString(accumulator);
                int index = revisedDescription.indexOf("{" + ctr + "}]");
                if (index != -1 && row != null) {
                    revisedDescription = String.valueOf(revisedDescription.substring(0, index)) + absolute + revisedDescription.substring(index + 3);
                }
                ++ctr;
                ++p;
            }
        }
        return revisedDescription;
    }

    public List<ColumnDefinition> getColumns() {
        int n;
        int n2;
        ColumnDefinition[] columnDefinitionArray;
        ArrayList<ColumnDefinition> results = new ArrayList<ColumnDefinition>();
        if (this.descriptionInserts1 != null) {
            columnDefinitionArray = this.descriptionInserts1;
            n2 = this.descriptionInserts1.length;
            n = 0;
            while (n < n2) {
                ColumnDefinition definition = columnDefinitionArray[n];
                results.add(definition);
                ++n;
            }
        }
        if (this.descriptionInserts2 != null) {
            columnDefinitionArray = this.descriptionInserts2;
            n2 = this.descriptionInserts2.length;
            n = 0;
            while (n < n2) {
                ColumnDefinition definitions;
                ColumnDefinition columnDefinition = definitions = columnDefinitionArray[n];
                int n3 = ((ColumnDefinition)columnDefinition).length;
                int n4 = 0;
                while (n4 < n3) {
                    ColumnDefinition definition = columnDefinition[n4];
                    results.add(definition);
                    ++n4;
                }
                ++n;
            }
        }
        return results;
    }
}

