/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.utilities;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.utilities.SheetViewPersistenceManager;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class LayoutImportExportUtils {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String LAYOUTS = "VIEW_LAYOUTS";
    private static final String LAYOUT = "LAYOUT";
    private static final String KEY = "KEY";
    private static final String VALUE = "VALUE";
    private static final Debug debug = new Debug(LayoutImportExportUtils.class);

    public static void exportTo(String filePath) throws IOException {
        debug.enter("exportTo");
        Map<String, String> layouts = SheetViewPersistenceManager.getAllTemplates();
        XMLMemento root = XMLMemento.createWriteRoot((String)LAYOUTS);
        for (String easyLay : layouts.keySet()) {
            IMemento typeRoot = root.createChild(LAYOUT);
            typeRoot.putString(KEY, easyLay);
            typeRoot.putString(VALUE, layouts.get(easyLay));
        }
        FileWriter writer = new FileWriter(filePath);
        root.save((Writer)writer);
        writer.close();
        debug.exit("exportTo");
    }

    public static void importFrom(String filePath) throws Exception {
        debug.enter("importfrom");
        FileReader reader = new FileReader(filePath);
        XMLMemento root = XMLMemento.createReadRoot((Reader)reader);
        IMemento[] iMementoArray = root.getChildren(LAYOUT);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento memento = iMementoArray[n2];
            Activator.getDefault().getPluginInstancePreferences().put(memento.getString(KEY), memento.getString(VALUE));
            ++n2;
        }
        reader.close();
        debug.exit("importfrom");
    }
}

