/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.utilities;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.eclipse.common.Utilities;
import com.ibm.cics.pa.model.DateCaveat;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.Messages;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataTypeUtilities {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2009, 2023 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String[] cos = new String[]{ColumnDefinition.START_DATE.getDBColumnRef(), ColumnDefinition.START_TIME.getDBColumnRef(), ColumnDefinition.APPLID.getDBColumnRef(), ColumnDefinition.MVSID.getDBColumnRef(), ColumnDefinition.VRM.getDBColumnRef(), ColumnDefinition.INTERVAL_TYPE.getDBColumnRef(), ColumnDefinition.INTERVAL_NUMBER.getDBColumnRef()};
    private static final Logger logger = Logger.getLogger("com.ibm.cics.pa.ui");
    private static boolean initialized = false;
    public static final DateFormat formaterDate = new SimpleDateFormat("yyyy-MM-dd");
    public static final DateFormat formaterTime = new SimpleDateFormat("HH.mm.ss");
    public static final DateFormat formaterTimestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSS");
    public static final DateFormat formaterCSVDate = new SimpleDateFormat("dd/MM/yyyy");
    public static final DateFormat formaterAltCSVDate = new SimpleDateFormat("dd-MM-yyyy");
    public static final DateFormat formaterCSVTimestamp = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss");
    public static final DateFormat formaterCSVTime = new SimpleDateFormat("HH:mm:ss.SSS");
    private static final NumberFormat withCommas = NumberFormat.getInstance();
    private static final NumberFormat formatter7 = NumberFormat.getInstance();
    private static final NumberFormat formatter6 = NumberFormat.getInstance();
    private static final NumberFormat formatter2 = NumberFormat.getInstance();
    private static final NumberFormat formatter4 = NumberFormat.getInstance();
    private static final NumberFormat formatterMoney = NumberFormat.getInstance();
    private static final NumberFormat formaterNoCommas = NumberFormat.getInstance();
    public static ColumnDefinition[] significantColumns = new ColumnDefinition[]{ColumnDefinition.ATI_TRAN_ID, ColumnDefinition.CONNECTION_NAME, ColumnDefinition.CONNECTION_NETNAME, ColumnDefinition.DSA_NAME, ColumnDefinition.EVENTBINDING_NAME, ColumnDefinition.FILE_NAME, ColumnDefinition.IPCONN_APPLID, ColumnDefinition.IPCONN_NAME, ColumnDefinition.JVM_PROFILE_NAME, ColumnDefinition.JVMSERVER_JVMPROF, ColumnDefinition.LIB_NAME, ColumnDefinition.LSRPOOL_ID, ColumnDefinition.LSR_POOL_NUMBER, ColumnDefinition.PIPELINE_NAME, ColumnDefinition.PLANEXIT_NAME, ColumnDefinition.POOL_PLANEXIT_NAME, ColumnDefinition.PROGRAM_NAME, ColumnDefinition.WEBSERVICE_PROGRAM, ColumnDefinition.REMOTE_SYSID, ColumnDefinition.REMOTE_SYSTEM_ID, ColumnDefinition.RESNAME, ColumnDefinition.TEMPLATE_EXIT_PGM, ColumnDefinition.TEMPLATE_FILE_NAME, ColumnDefinition.TEMPLATE_PGM_NAME, ColumnDefinition.TD_QUEUE_ID, ColumnDefinition.TCLASS_NAME, ColumnDefinition.URIMAP_ATOMSER_NAM, ColumnDefinition.URIMAP_CONVERTER, ColumnDefinition.URIMAP_NAME, ColumnDefinition.URIMAP_PIPELINE, ColumnDefinition.URIMAP_PROGRAM, ColumnDefinition.URIMAP_TCPIP_SERV, ColumnDefinition.URIMAP_TEMPLATE, ColumnDefinition.URIMAP_TRAN_ID, ColumnDefinition.URIMAP_WEBSERVICE, ColumnDefinition.TCPIP_URM};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object assignAppropriateCSVBasedObject(ColumnDefinition defn, String value) throws ParseException {
        if (!initialized) {
            DataTypeUtilities.initialize();
        }
        if (value.equals("*")) {
            return value;
        }
        switch (defn.getType()) {
            case BigDecimal: {
                try {
                    return BigDecimal.valueOf(Long.valueOf(value));
                }
                catch (NumberFormatException e) {
                    Debug.event((Logger)logger, (String)DataTypeUtilities.class.getName(), (String)"assignAppropriateObject", (Object)"Double NFE", (Object)value);
                    return 0;
                }
            }
            case Double: {
                try {
                    Double res = Double.valueOf(value);
                    if (res == (double)res.intValue()) {
                        return res.intValue();
                    }
                    return (double)res;
                }
                catch (NumberFormatException e) {
                    Debug.event((Logger)logger, (String)DataTypeUtilities.class.getName(), (String)"assignAppropriateObject", (Object)"Double NFE", (Object)value);
                    return 0;
                }
            }
            case Float: {
                try {
                    Float res = Float.valueOf(value);
                    if (res.floatValue() == (float)res.intValue()) {
                        return res.intValue();
                    }
                    return res.doubleValue();
                }
                catch (NumberFormatException e) {
                    Debug.event((Logger)logger, (String)DataTypeUtilities.class.getName(), (String)"assignAppropriateObject", (Object)"Float NFE", (Object)value);
                    return 0;
                }
            }
            case Integer: {
                try {
                    return Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    Debug.event((Logger)logger, (String)DataTypeUtilities.class.getName(), (String)"assignAppropriateObject", (Object)"Integer NFE", (Object)value);
                    return 0;
                }
            }
            case Byte: {
                try {
                    return Byte.valueOf(value);
                }
                catch (NumberFormatException e) {
                    Debug.event((Logger)logger, (String)DataTypeUtilities.class.getName(), (String)"assignAppropriateObject", (Object)"Byte NFE", (Object)value);
                    return 0;
                }
            }
            case Time: {
                java.util.Date t1 = null;
                if (!Utilities.hasContent((String)value) || value.trim().equals("Missing")) {
                    return "";
                }
                if (value.length() == 8) {
                    DateFormat dateFormat = formaterTime;
                    synchronized (dateFormat) {
                        t1 = formaterTime.parse(value);
                    }
                }
                DateFormat dateFormat = formaterCSVTime;
                synchronized (dateFormat) {
                    t1 = formaterCSVTime.parse(value);
                }
                if (t1 != null) {
                    return new Time(t1.getTime());
                }
                return value.toString();
            }
            case Timestamp: {
                if (!Utilities.hasContent((String)value) || value.trim().equals("Missing")) {
                    return "";
                }
                DateFormat dateFormat = formaterCSVTimestamp;
                synchronized (dateFormat) {
                    return new Timestamp(formaterCSVTimestamp.parse(value).getTime());
                }
            }
            case Date: {
                Date d1 = null;
                String altValue = value;
                if (!Utilities.hasContent((String)altValue) || altValue.trim().equals("Missing")) {
                    return "";
                }
                if (altValue.indexOf(47) > -1) {
                    altValue = altValue.replace('/', '-');
                }
                if (altValue.indexOf(45) == 2) {
                    DateFormat dateFormat = formaterAltCSVDate;
                    synchronized (dateFormat) {
                        d1 = new Date(formaterAltCSVDate.parse(altValue).getTime());
                    }
                }
                if (altValue.indexOf(45) == 4) {
                    DateFormat dateFormat = formaterDate;
                    synchronized (dateFormat) {
                        d1 = new Date(formaterDate.parse(altValue).getTime());
                    }
                }
                if (d1 != null) {
                    return d1;
                }
            }
            case Boolean: {
                if (value.trim().equals("Missing")) {
                    return false;
                }
                return Boolean.valueOf(value);
            }
        }
        return value;
    }

    public static Object assignAppropriateNonCSVBasedObject(Object value, ColumnReference.DataType type) {
        Object retValue = value;
        if (value instanceof Double && (Double)value == (double)((Number)value).intValue()) {
            retValue = ((Number)value).intValue();
        } else if (value instanceof Float && ((Float)value).floatValue() == (float)((Number)value).intValue()) {
            retValue = ((Number)value).intValue();
        } else if (value instanceof String) {
            retValue = ((String)value).trim();
            if (type == ColumnReference.DataType.Char || ((String)value).length() == 1 && (((String)value).toCharArray()[0] >= '\u0000' || ((String)value).toCharArray()[0] <= '\t')) {
                retValue = DataTypeUtilities.hexConvert((String)value);
                retValue = DataTypeUtilities.hexConvert((String)value);
            }
        }
        return retValue;
    }

    public static int compare(ColumnDefinition defn, int direction, Object objectA, Object objectB) {
        block16: {
            block15: {
                block14: {
                    try {
                        if (objectA != objectB) break block14;
                        return 0;
                    }
                    catch (ClassCastException cce) {
                        logger.logp(Level.SEVERE, DataTypeUtilities.class.getName(), "compare", cce.getLocalizedMessage(), cce);
                        cce.printStackTrace();
                        return 0;
                    }
                }
                if (objectA != null) break block15;
                return -1;
            }
            if (objectB != null) break block16;
            return 1;
        }
        Object object1 = objectA;
        Object object2 = objectB;
        if (direction != 128) {
            object1 = objectB;
            object2 = objectA;
        }
        if (object1 instanceof String && object2 instanceof String) {
            return ((String)object1).compareTo((String)object2);
        }
        switch (defn.getType()) {
            case Double: {
                return Double.compare(((Number)object1).doubleValue(), ((Number)object2).doubleValue());
            }
            case Float: {
                return Float.compare(((Number)object1).floatValue(), ((Number)object2).floatValue());
            }
            case Integer: {
                return ((Number)object1).intValue() < ((Number)object2).intValue() ? -1 : (((Number)object1).intValue() == ((Number)object2).intValue() ? 0 : 1);
            }
            case Byte: {
                return ((Byte)object1).compareTo((Byte)object2);
            }
            case Date: {
                return ((Date)object1).compareTo((Date)object2);
            }
        }
        return object1.toString().compareTo(object2.toString());
    }

    public static String getAsString(Object object) {
        if (!initialized) {
            DataTypeUtilities.initialize();
        }
        if (object == null) {
            return "";
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Double) {
            if ((double)((Number)object).intValue() == ((Number)object).doubleValue()) {
                Integer newVal = new Integer(((Number)object).intValue());
                if (newVal > 1000) {
                    return withCommas.format(newVal);
                }
                return newVal.toString();
            }
            return formatter6.format(object);
        }
        if (object instanceof Float) {
            if ((float)((Number)object).intValue() == ((Number)object).floatValue()) {
                return new Integer(((Number)object).intValue()).toString();
            }
            return formatter6.format(object);
        }
        if (object instanceof Integer) {
            if ((Integer)object > 1000) {
                return withCommas.format(object);
            }
            return ((Integer)object).toString();
        }
        if (object instanceof Byte) {
            return ((Byte)object).toString();
        }
        if (object instanceof Timestamp) {
            return object.toString();
        }
        if (object instanceof Time) {
            return formaterTime.format((Time)object);
        }
        if (object instanceof Date) {
            return formaterDate.format((Date)object);
        }
        if (object instanceof Boolean) {
            return ((Boolean)object).toString();
        }
        return "";
    }

    public static String getAs2PositionPercentageString(Number number, Number divisor) {
        if (number != null && divisor != null && number.doubleValue() != 0.0 && divisor.doubleValue() != 0.0) {
            return DataTypeUtilities.getAs2PositionPercentageString(number.doubleValue(), divisor.doubleValue());
        }
        return "0";
    }

    private static String getAs2PositionPercentageString(double number, double divisor) {
        return Double.valueOf(DataTypeUtilities.getAs2PositionPercentage(number, divisor)).toString();
    }

    public static double getAs2PositionPercentage(double number, double divisor) {
        return new BigDecimal(number).multiply(new BigDecimal(100)).divide(new BigDecimal(divisor), RoundingMode.HALF_UP).setScale(2, 4).doubleValue();
    }

    private static void initialize() {
        initialized = true;
        formatter7.setMinimumFractionDigits(7);
        formatter6.setMinimumFractionDigits(6);
        formatter4.setMinimumFractionDigits(4);
        formatterMoney.setMaximumFractionDigits(2);
        formatterMoney.setMinimumFractionDigits(2);
        formaterNoCommas.setGroupingUsed(false);
        formaterNoCommas.setMaximumFractionDigits(6);
    }

    /*
     * Unable to fully structure code
     */
    private static String hexConvert(String value) {
        block5: {
            newVal = value;
            i = value.length() - 1;
            while (value.toCharArray()[i] == ' ') {
                newVal = value.substring(0, i);
                --i;
            }
            originalSize = newVal.length();
            try {
                newVal = String.format("%x", new Object[]{new BigInteger(1, value.getBytes("CP1047"))}).toUpperCase();
                if (newVal.length() == 1 && newVal.compareTo("1") > -1 && newVal.compareTo("9") < 1) break block5;
                while (newVal.length() < originalSize * 2) {
                    newVal = String.valueOf('0') + newVal;
                }
                break block5;
            }
            catch (UnsupportedEncodingException e) {
                Debug.error((Logger)DataTypeUtilities.logger, (String)DataTypeUtilities.class.getName(), (String)"hexConvert", (Throwable)e);
                newVal = String.format("%x", new Object[]{new BigInteger(1, value.getBytes())}).toUpperCase();
                if (newVal.length() == 1 && newVal.compareTo("1") > -1 && newVal.compareTo("9") < 1) break block5;
                ** while (newVal.length() < originalSize * 2)
            }
lbl-1000:
            // 1 sources

            {
                newVal = String.valueOf('0') + newVal;
                continue;
            }
        }
        return newVal;
    }

    public static Object sum(Object object1, Object object2) {
        if (object1 instanceof String) {
            return String.valueOf((String)object1) + object2;
        }
        if (object1 instanceof Double && object2 instanceof Number) {
            return (Double)object1 + ((Number)object2).doubleValue();
        }
        if (object1 instanceof Float && object2 instanceof Number) {
            return Float.valueOf(((Float)object1).floatValue() + ((Number)object2).floatValue());
        }
        if (object1 instanceof Integer && object2 instanceof Number) {
            return (Integer)object1 + ((Number)object2).intValue();
        }
        if (object1 instanceof Boolean && object2 instanceof Boolean) {
            if (((Boolean)object1).booleanValue() && ((Boolean)object2).booleanValue()) {
                return true;
            }
            return false;
        }
        return "";
    }

    public static boolean containsNonASCIICharacters(byte[] bytearray) {
        CharsetDecoder d = Charset.forName("ASCII").newDecoder();
        try {
            CharBuffer r = d.decode(ByteBuffer.wrap(bytearray));
            r.toString();
        }
        catch (CharacterCodingException e) {
            return true;
        }
        return false;
    }

    public static String getNumberAsShorterString(float value) {
        if (!initialized) {
            DataTypeUtilities.initialize();
        }
        String response = "";
        if (formatter7.format(value).endsWith("0")) {
            if ((float)Math.round(value) == value) {
                response = new Integer(Math.round(value)).toString();
            } else {
                response = formatter6.format(value);
                if (response.endsWith("00") && (response = formatter4.format(value)).endsWith("00")) {
                    response = formatter2.format(value);
                }
            }
        }
        return response;
    }

    public static String getNumberAsShorterString(double value) {
        if (!initialized) {
            DataTypeUtilities.initialize();
        }
        String response = "";
        if ((double)Math.round(Math.round(value)) == value) {
            response = new Integer(Math.round(Math.round(value))).toString();
        } else {
            response = formatter6.format(value);
            if (response.endsWith("00") && (response = formatter4.format(value)).endsWith("00")) {
                response = formatter2.format(value);
            }
        }
        return response;
    }

    public static String seekAbsolution(Object object, boolean force) {
        if (object instanceof Double) {
            if ((Double)object == 0.0) {
                return "0";
            }
            if (force || (double)((Double)object).intValue() == (Double)object) {
                return new Integer(((Double)object).intValue()).toString();
            }
        } else if (object instanceof Float) {
            if (((Float)object).floatValue() == 0.0f) {
                return "0";
            }
            if (force || (float)((Float)object).intValue() == ((Float)object).floatValue()) {
                return new Integer(((Float)object).intValue()).toString();
            }
        }
        return DataTypeUtilities.getAsString(object);
    }

    public static String getAsCSVString(Object object) {
        if (object instanceof String) {
            return ((String)object).replaceAll(",", "");
        }
        if (object instanceof Time) {
            return formaterCSVTime.format((Time)object);
        }
        if (object instanceof Timestamp) {
            return formaterCSVTimestamp.format((Timestamp)object);
        }
        if (object instanceof Date) {
            return formaterDate.format((Date)object);
        }
        if (object instanceof Number) {
            return formaterNoCommas.format(object);
        }
        return DataTypeUtilities.getAsString(object);
    }

    public static ColumnReference[] statColumnSorter(ColumnReference[] columns) {
        ColumnReference temp = null;
        int j = 0;
        while (j < cos.length) {
            int i = 0;
            while (i < columns.length) {
                if (columns[i].getColumnName().equals(cos[j]) && i != j && j < columns.length) {
                    temp = columns[j];
                    columns[j] = columns[i];
                    columns[i] = temp;
                }
                ++i;
            }
            ++j;
        }
        return columns;
    }

    public static ColumnDefinition firstSignificantColumn(ColumnReference[] columns) {
        int i = 0;
        while (i < columns.length) {
            int j = 0;
            while (j < significantColumns.length) {
                if (columns[i].getColumnName().equals(significantColumns[j].getDBColumnRef())) {
                    return significantColumns[j];
                }
                ++j;
            }
            ++i;
        }
        return DataTypeUtilities.firstSignificantColumn1(columns);
    }

    public static ColumnDefinition firstSignificantColumn1(ColumnReference[] columns) {
        int i = 0;
        while (i < columns.length) {
            boolean hit = false;
            int j = 0;
            while (j < cos.length) {
                if (columns[i].getColumnName().equals(cos[j])) {
                    hit = true;
                }
                ++j;
            }
            if (!hit) {
                return ColumnDefinition.getByDBColumnRef(columns[i].getColumnName());
            }
            ++i;
        }
        return null;
    }

    public static void interpretHeadersForTransfer(String[] headers, ColumnDefinition[] columnDefinitions, char character1, StringBuffer buffer1, char character2, StringBuffer buffer2) {
        int i = 0;
        while (i < columnDefinitions.length) {
            if (i > 0) {
                buffer1.append(character1);
                buffer2.append(character2);
            }
            buffer1.append(columnDefinitions[i] == ColumnDefinition.UNKNOWN ? headers[i] : columnDefinitions[i].getColumnRef());
            buffer2.append(columnDefinitions[i] == ColumnDefinition.UNKNOWN ? headers[i] : columnDefinitions[i].getColumnRef());
            ++i;
        }
    }

    public static void interpretForTransfer(Object[] row, char character1, StringBuffer buffer1, char character2, StringBuffer buffer2) {
        int i = 0;
        while (i < row.length) {
            if (i > 0) {
                buffer1.append(character1);
                buffer2.append(character2);
            }
            String result = DataTypeUtilities.getAsCSVString(row[i]);
            buffer1.append(result);
            buffer2.append(result);
            ++i;
        }
    }

    public static void compare(Integer integer, ColumnDefinition columnDefinition) {
        if (columnDefinition == null) {
            Debug.warning((Logger)logger, (String)DataTypeUtilities.class.getName(), (String)"compare", (Object)"ColumnDefinition is null");
            return;
        }
        if (integer == 12 || integer == 1) {
            if (columnDefinition.getType() != ColumnReference.DataType.String) {
                Debug.warning((Logger)logger, (String)DataTypeUtilities.class.getName(), (String)"compare", (Object)(String.valueOf(columnDefinition.getDBColumnRef()) + " String"));
            }
        } else if (integer == 8) {
            if (columnDefinition.getType() != ColumnReference.DataType.Double && columnDefinition.getType() != ColumnReference.DataType.Integer) {
                Debug.warning((Logger)logger, (String)DataTypeUtilities.class.getName(), (String)"compare", (Object)(String.valueOf(columnDefinition.getDBColumnRef()) + " Double"));
            }
        } else if (integer == 6) {
            if (columnDefinition.getType() != ColumnReference.DataType.Float) {
                Debug.warning((Logger)logger, (String)DataTypeUtilities.class.getName(), (String)"compare", (Object)(String.valueOf(columnDefinition.getDBColumnRef()) + " Float"));
            }
        } else if (integer == 4) {
            if (columnDefinition.getType() != ColumnReference.DataType.Integer) {
                Debug.warning((Logger)logger, (String)DataTypeUtilities.class.getName(), (String)"compare", (Object)(String.valueOf(columnDefinition.getDBColumnRef()) + " Integer"));
            }
        } else if (integer == 1) {
            if (columnDefinition.getType() != ColumnReference.DataType.Byte) {
                Debug.warning((Logger)logger, (String)DataTypeUtilities.class.getName(), (String)"compare", (Object)(String.valueOf(columnDefinition.getDBColumnRef()) + " Byte"));
            }
        } else if (integer == 93) {
            if (columnDefinition.getType() != ColumnReference.DataType.Timestamp) {
                Debug.warning((Logger)logger, (String)DataTypeUtilities.class.getName(), (String)"compare", (Object)(String.valueOf(columnDefinition.getDBColumnRef()) + " Timestamp"));
            }
        } else if (integer == 92) {
            if (columnDefinition.getType() != ColumnReference.DataType.Time) {
                Debug.warning((Logger)logger, (String)DataTypeUtilities.class.getName(), (String)"compare", (Object)(String.valueOf(columnDefinition.getDBColumnRef()) + " Time"));
            }
        } else if (integer == 91) {
            if (columnDefinition.getType() != ColumnReference.DataType.Date) {
                Debug.warning((Logger)logger, (String)DataTypeUtilities.class.getName(), (String)"compare", (Object)(String.valueOf(columnDefinition.getDBColumnRef()) + " date"));
            }
        } else if (integer == 16) {
            if (columnDefinition.getType() != ColumnReference.DataType.Boolean) {
                Debug.warning((Logger)logger, (String)DataTypeUtilities.class.getName(), (String)"compare", (Object)(String.valueOf(columnDefinition.getDBColumnRef()) + " Boolean"));
            }
        } else if (integer == 3) {
            if (columnDefinition.getType() != ColumnReference.DataType.BigDecimal) {
                Debug.warning((Logger)logger, (String)DataTypeUtilities.class.getName(), (String)"compare", (Object)(String.valueOf(columnDefinition.getDBColumnRef()) + " BigDecimal"));
            }
        } else {
            Debug.warning((Logger)logger, (String)DataTypeUtilities.class.getName(), (String)"compare", (Object)(String.valueOf(columnDefinition.getDBColumnRef()) + " Unknown int " + integer));
        }
    }

    public static String interpretStatsElement(Map<String, Object> mapping, DateCaveat aDate, List<String> list) {
        String contentDescription = "";
        for (String key : mapping.keySet()) {
            ColumnDefinition realKey = ColumnDefinition.getByDBColumnRef(key.startsWith(":") ? key.substring(1) : key);
            if (realKey == null || aDate != null && (realKey == ColumnDefinition.START_DATE || realKey == ColumnDefinition.START_TIME || realKey == ColumnDefinition.START || realKey == ColumnDefinition.START_TIME) || "*".equals(mapping.get(key)) || list.contains(key)) continue;
            contentDescription = String.valueOf(contentDescription) + (contentDescription.length() == 0 ? Character.valueOf(' ') : ", ");
            contentDescription = String.valueOf(contentDescription) + realKey.getLabel(null) + '=' + mapping.get(key);
        }
        if (aDate != null) {
            contentDescription = String.valueOf(contentDescription) + ' ' + aDate.getLabel();
        }
        return contentDescription;
    }

    public static String interpretSummaryDetails(Map<String, Object> mapping, DateCaveat aDate) {
        String contentDescription = "";
        String applid = (String)mapping.get(String.valueOf(':') + ColumnDefinition.APPLID.getDBColumnRef());
        String tran = (String)mapping.get(String.valueOf(':') + ColumnDefinition.TRAN.getDBColumnRef());
        Date startDate = null;
        Time startTime = null;
        Object tempDate = mapping.get(String.valueOf(':') + ColumnDefinition.START_DATE.getDBColumnRef());
        if (tempDate != null && !tempDate.equals("*")) {
            try {
                startDate = (Date)(tempDate instanceof String ? DataTypeUtilities.assignAppropriateCSVBasedObject(ColumnDefinition.START_DATE, (String)tempDate) : tempDate);
            }
            catch (ParseException e) {
                Debug.error((Logger)logger, (String)DataTypeUtilities.class.getName(), (String)"interpretSummaryDetails", (Throwable)e);
            }
            tempDate = mapping.get(String.valueOf(':') + ColumnDefinition.START_TIME.getDBColumnRef());
            if (tempDate != null && !tempDate.equals("*")) {
                try {
                    startTime = (Time)(tempDate instanceof String ? DataTypeUtilities.assignAppropriateCSVBasedObject(ColumnDefinition.START_TIME, (String)tempDate) : tempDate);
                }
                catch (ParseException e) {
                    Debug.error((Logger)logger, (String)DataTypeUtilities.class.getName(), (String)"interpretSummaryDetails", (Throwable)e);
                }
                startTime = (Time)tempDate;
            }
        }
        if (Utilities.hasContent((String)applid)) {
            contentDescription = String.valueOf(contentDescription) + ColumnDefinition.APPLID.getLabel(null) + '=' + applid;
        }
        if (Utilities.hasContent((String)tran)) {
            contentDescription = String.valueOf(contentDescription) + ' ' + ColumnDefinition.TRAN.getLabel(null) + '=' + tran;
        }
        if (aDate != null) {
            contentDescription = String.valueOf(contentDescription) + ' ' + aDate.getLabel();
        }
        if (startDate != null) {
            contentDescription = String.valueOf(contentDescription) + ' ' + DateCaveat.createSpecificDateCaveat(DataTypeUtilities.combineDateTime(startDate, startTime)).getLabel();
        }
        return contentDescription;
    }

    public static String interpretAppSummaryDetails(Map<String, Object> mapping, DateCaveat aDate) {
        String contentDescription = "";
        String platform = (String)mapping.get(String.valueOf(':') + ColumnDefinition.ACPLATNM.getDBColumnRef());
        String application = (String)mapping.get(String.valueOf(':') + ColumnDefinition.ACAPPLNM.getDBColumnRef());
        String version = (String)mapping.get(String.valueOf(':') + ColumnDefinition.ACAPPLVR.getDBColumnRef());
        String operation = (String)mapping.get(String.valueOf(':') + ColumnDefinition.ACOPERNM.getDBColumnRef());
        Date startDate = null;
        Time startTime = null;
        Object tempDate = mapping.get(String.valueOf(':') + ColumnDefinition.START_DATE.getDBColumnRef());
        if (tempDate != null && !tempDate.equals("*")) {
            try {
                startDate = (Date)(tempDate instanceof String ? DataTypeUtilities.assignAppropriateCSVBasedObject(ColumnDefinition.START_DATE, (String)tempDate) : tempDate);
            }
            catch (ParseException e) {
                Debug.error((Logger)logger, (String)DataTypeUtilities.class.getName(), (String)"interpretSummaryDetails", (Throwable)e);
            }
            tempDate = mapping.get(String.valueOf(':') + ColumnDefinition.START_TIME.getDBColumnRef());
            if (tempDate != null && !tempDate.equals("*")) {
                try {
                    startTime = (Time)(tempDate instanceof String ? DataTypeUtilities.assignAppropriateCSVBasedObject(ColumnDefinition.START_TIME, (String)tempDate) : tempDate);
                }
                catch (ParseException e) {
                    Debug.error((Logger)logger, (String)DataTypeUtilities.class.getName(), (String)"interpretSummaryDetails", (Throwable)e);
                }
                startTime = (Time)tempDate;
            }
        }
        if (Utilities.hasContent((String)platform)) {
            contentDescription = String.valueOf(contentDescription) + ColumnDefinition.ACPLATNM.getLabel(null) + '=' + platform;
        }
        if (Utilities.hasContent((String)application)) {
            contentDescription = String.valueOf(contentDescription) + ' ' + ColumnDefinition.ACAPPLNM.getLabel(null) + '=' + application;
        }
        if (Utilities.hasContent((String)version)) {
            contentDescription = String.valueOf(contentDescription) + ColumnDefinition.ACAPPLVR.getLabel(null) + '=' + version;
        }
        if (Utilities.hasContent((String)operation)) {
            contentDescription = String.valueOf(contentDescription) + ' ' + ColumnDefinition.ACOPERNM.getLabel(null) + '=' + operation;
        }
        if (aDate != null) {
            contentDescription = String.valueOf(contentDescription) + ' ' + aDate.getLabel();
        }
        if (startDate != null) {
            contentDescription = String.valueOf(contentDescription) + ' ' + DateCaveat.createSpecificDateCaveat(DataTypeUtilities.combineDateTime(startDate, startTime)).getLabel();
        }
        return contentDescription;
    }

    public static Date combineDateTime(Date date, Time time) {
        Date combinedDate = null;
        if (date != null && time != null) {
            Calendar cal1 = Calendar.getInstance();
            cal1.setTime(date);
            Calendar cal2 = Calendar.getInstance();
            cal2.setTime(time);
            cal1.add(11, cal2.get(11));
            cal1.add(12, cal2.get(12));
            cal1.add(13, cal2.get(13));
            combinedDate = new Date(cal1.getTime().getTime());
        }
        return combinedDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object ensureAppropriateType(ColumnReference.DataType type, Object value) {
        Object val = value;
        if (val == null) return val;
        switch (type) {
            case Date: {
                if (!(val instanceof String)) return val;
                try {
                    if (((String)val).indexOf("/") > -1) {
                        val = ((String)val).replace('/', '-');
                    }
                    if (((String)val).indexOf(45) == 2) {
                        DateFormat dateFormat = formaterAltCSVDate;
                        synchronized (dateFormat) {
                            return new Date(formaterAltCSVDate.parse((String)val).getTime());
                        }
                    }
                    if (((String)val).indexOf(45) != 4) return val;
                    DateFormat dateFormat = formaterDate;
                    synchronized (dateFormat) {
                        return new Date(formaterDate.parse((String)val).getTime());
                    }
                }
                catch (ParseException e) {
                    Debug.error((Logger)logger, (String)DataTypeUtilities.class.getName(), (String)"ensureAppropriateType", (Throwable)e);
                }
                return val;
            }
            case Time: {
                if (!(val instanceof String)) return val;
                try {
                    if (((String)val).length() != 8) return new Time(formaterCSVTime.parse((String)val).getTime());
                    val = ((String)val).replace(':', '.');
                    return new Time(formaterTime.parse((String)val).getTime());
                }
                catch (ParseException e) {
                    Debug.error((Logger)logger, (String)DataTypeUtilities.class.getName(), (String)"ensureAppropriateType", (Throwable)e);
                }
            }
        }
        return val;
    }

    public static String wildcardToRegexp(String filterValue) {
        StringBuffer s = new StringBuffer(filterValue.length());
        s.append('^');
        int i = 0;
        int is = filterValue.length();
        while (i < is) {
            char c = filterValue.charAt(i);
            switch (c) {
                case '*': {
                    s.append(".*");
                    break;
                }
                default: {
                    s.append(c);
                }
            }
            ++i;
        }
        s.append('$');
        return s.toString();
    }

    public static String getPercentageAsInteger(Object div, Object divisor) {
        if (div == null || divisor == null || (Number)div == new Integer(0) || (Number)divisor == new Integer(0)) {
            return "";
        }
        long value = Math.round(((Number)div).floatValue() / ((Number)divisor).floatValue() * 100.0f);
        return MessageFormat.format(Messages.getString("PlotView.relative.percentage"), value);
    }

    public static String getAverageRatio(Object div, Object divisor) {
        if (div == null || divisor == null || (Number)div == new Integer(0) || (Number)divisor == new Integer(0)) {
            return "0";
        }
        return DataTypeUtilities.getAsString(Math.round(((Number)div).floatValue() / ((Number)divisor).floatValue()));
    }

    public static String getRatio(Object div, Object divisor) {
        if (div == null || divisor == null || ((Number)div).intValue() == 0 || ((Number)divisor).intValue() == 0) {
            return "0";
        }
        BigDecimal res = new BigDecimal(((Number)div).doubleValue() / ((Number)divisor).doubleValue()).setScale(2, 6);
        return MessageFormat.format(Messages.getString("Ratio.container"), res);
    }

    public static String getAsString(Object value, ColumnDefinition defn) {
        Object value1 = value;
        if (defn == ColumnDefinition.DISP_Q_TASKS_AVE && (Integer)value1 > 0) {
            value1 = Float.valueOf(((Integer)value1).floatValue() / 100.0f);
            return formatterMoney.format(value1);
        }
        return DataTypeUtilities.getAsString(value1);
    }
}

