/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.remote;

import com.ibm.cics.pa.model.DataKeyElement;
import com.ibm.cics.pa.model.GenericDataProvider;
import com.ibm.cics.pa.model.IUniqueRecord;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.ColumnDefinitionHelper;
import com.ibm.cics.pa.model.definitions.DataProviderKey;
import com.ibm.cics.pa.ui.remote.HierarchicalRemoteElement;
import com.ibm.cics.pa.ui.remote.RemotePerfSummUniqueRecord;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public class RemoteUniqueRecord
extends HierarchicalRemoteElement
implements IUniqueRecord {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Object[] row = null;
    HashMap<ColumnDefinition, Object> map = null;

    protected RemoteUniqueRecord(ColumnDefinition columnDefinition, Object label, int i, Object[] dataRow) {
        super(columnDefinition, label, i);
        this.row = dataRow;
    }

    protected RemoteUniqueRecord(GenericDataProvider provider, DataKeyElement key) {
        super(provider, key);
    }

    public static RemoteUniqueRecord createForParent(GenericDataProvider provider, DataKeyElement key) {
        if (!key.isAppPerformanceSummary() && key.isPerformanceSummary()) {
            return new RemotePerfSummUniqueRecord(provider, key);
        }
        return new RemoteUniqueRecord(provider, key);
    }

    public String getFullPathLabel(boolean withTypeLabelling) {
        String label = "";
        Map<ColumnDefinition, Object> mapping = this.getReferenceMapping();
        DataProviderKey key = this.getStructureKey();
        ColumnDefinition[] columnDefinitionArray = key.getColumnDefinitions();
        int n = columnDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnDefinition defn = columnDefinitionArray[n2];
            if (withTypeLabelling) {
                label = String.valueOf(label) + defn.getLabel(null) + "=";
            }
            label = String.valueOf(label) + mapping.get(defn) + " ";
            ++n2;
        }
        return label;
    }

    @Override
    public boolean isContainer() {
        return false;
    }

    @Override
    public Object[] getRow() {
        return this.row;
    }

    @Override
    public DataKeyElement getDataKey() {
        if (this.dataKey == null) {
            if (this.isRoot()) {
                super.getDataKey();
            } else {
                this.dataKey = DataKeyElement.createDataKey(this.getSourceProvider(), this.getRow());
            }
        }
        return this.dataKey;
    }

    @Override
    public Object[] getChildren(Object o) {
        return new Object[0];
    }

    protected void selectFrom(Object[][] data2) {
    }

    @Override
    public IUniqueRecord findEquivalentIn(Object[] array) {
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (this.equals(obj)) {
                return (IUniqueRecord)obj;
            }
            ++n2;
        }
        return this;
    }

    public Object getEditableValue() {
        return this.getLabel();
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return ColumnDefinitionHelper.createPropertyDescriptors(this.getSourceProvider().getColumnDefinitions());
    }

    public Object getPropertyValue(Object id) {
        if (id.equals("UNKNOWN") || id == ColumnDefinition.UNKNOWN) {
            return "Not PA specific";
        }
        ColumnDefinition defn = id instanceof ColumnDefinition ? (ColumnDefinition)id : ColumnDefinition.getByDBColumnRef((String)id);
        return defn != null ? DataTypeUtilities.getAsString(this.getRow()[this.getSourceProvider().getColumnPosition(defn)]) : null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySource.class) {
            return this;
        }
        if (adapter == IWorkbenchAdapter.class) {
            return this;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public String getDescription(Object anElement) {
        return (String)this.getLabel();
    }

    @Override
    public Map<ColumnDefinition, Object> getCompleteMapping(boolean withMutations) {
        if (this.map == null) {
            this.map = new HashMap();
            ColumnDefinition[] columnDefinitionArray = this.getSourceProvider().getColumnDefinitions();
            int n = columnDefinitionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ColumnDefinition defn = columnDefinitionArray[n2];
                Object value = this.getRow()[this.getSourceProvider().getColumnPosition(defn)];
                this.map.put(defn, value);
                if (withMutations) {
                    String[] stringArray = defn.getMutations();
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String defnS = stringArray[n4];
                        ColumnDefinition defn1 = ColumnDefinition.getByDBColumnRef(defnS);
                        if (defn1 != null) {
                            Object value1;
                            int position = this.getSourceProvider().getColumnPosition(defn1);
                            Object object = value1 = position > -1 ? this.getRow()[position] : null;
                            if (value == null && value1 != null) {
                                this.map.put(defn, value1);
                                this.map.put(defn1, value1);
                            } else if (value != null && value1 == null) {
                                this.map.put(defn1, value);
                            } else {
                                this.map.put(defn1, value1);
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return this.map;
    }

    @Override
    public boolean equals(Object comp) {
        boolean matches = true;
        if (comp instanceof RemoteUniqueRecord) {
            boolean bl = matches = this.row.length == ((RemoteUniqueRecord)comp).row.length;
            if (matches) {
                int i = 0;
                while (i < this.row.length) {
                    boolean bl2 = this.row[i] == null ? ((RemoteUniqueRecord)comp).row[i] == null : (matches = this.row[i].equals(((RemoteUniqueRecord)comp).row[i]));
                    if (!matches) {
                        return false;
                    }
                    ++i;
                }
            }
        }
        return matches;
    }

    @Override
    public int hashCode() {
        return this.row.hashCode();
    }
}

