/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.remote;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.core.comm.IConnectable;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.dbfunc.DB2Host;
import com.ibm.cics.eclipse.common.Utilities;
import com.ibm.cics.eclipse.common.ViewHelper;
import com.ibm.cics.pa.comm.PAConnectable;
import com.ibm.cics.pa.model.ManifestRecord;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.handlers.PAContextListener;
import com.ibm.cics.pa.ui.remote.ConnectivityToken;
import com.ibm.cics.pa.ui.remote.PAConnectionListener;
import com.ibm.cics.pa.ui.views.Alerts;
import com.ibm.cics.pa.ui.views.PerformanceAlerts;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;

public class PAConnectionTracker
extends ConnectionServiceListener {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final Logger logger = Logger.getLogger(PAConnectionTracker.class.getPackage().getName());
    private static PAConnectionTracker instance;
    Collection<PAConnectionListener> connectionListeners = new HashSet<PAConnectionListener>();
    Collection<PAContextListener> contextListeners = new HashSet<PAContextListener>();
    IConnectable connectable = null;
    String currentSchema = null;
    PAConnectionListener.Era era = PAConnectionListener.Era.ABSENT;
    protected Collection<String> discoveredTables;

    private PAConnectionTracker() {
        ConnectionsPlugin.getDefault().getConnectionService().addConnectionServiceListener((ConnectionServiceListener)this);
    }

    public static PAConnectionTracker getInstance() {
        if (instance == null) {
            instance = new PAConnectionTracker();
        }
        return instance;
    }

    public void addPAConnectionTrackerListener(PAConnectionListener listener) {
        this.connectionListeners.add(listener);
        if (this.isConnected()) {
            listener.connected(this.era);
        }
    }

    public void addPAContextListener(PAContextListener listener) {
        this.contextListeners.add(listener);
    }

    public void removePAConnectionTrackerListener(PAConnectionListener listener) {
        this.connectionListeners.remove(listener);
    }

    public void removePAContextListener(PAContextListener listener) {
        this.contextListeners.remove(listener);
    }

    public boolean isConnected() {
        return this.connectable != null && this.connectable.isConnected();
    }

    public boolean isPost32() {
        return this.isConnected() && this.era == PAConnectionListener.Era.POST;
    }

    DatabaseMetaData seekConnectionMetaData() {
        Connection connection = null;
        try {
            connection = DB2Host.getDefault((String)"com.ibm.cics.pa.connection").getDB2Connection();
            if (connection != null) {
                SQLWarning se = connection.getWarnings();
                while (se != null) {
                    Debug.warning((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"seekConnectionMetaData", (Object)this.presentSQLException(se));
                    se = se.getNextWarning();
                }
                return connection.getMetaData();
            }
        }
        catch (SQLException e1) {
            Debug.error((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"seekConnectionMetaData", (Throwable)e1);
        }
        catch (ConnectionException e) {
            Debug.error((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"seekConnectionMetaData", (Throwable)e);
        }
        return null;
    }

    public IConnectable getConnectable() {
        return this.connectable;
    }

    public ConnectivityToken createToken() {
        if (this.connectable != null && this.connectable.isConnected()) {
            return new ConnectivityToken(this.connectable.getConnection().getConfiguration().getID(), this.connectable.getConnection().getConfiguration().getName());
        }
        return null;
    }

    public boolean isConnected(String reference) {
        return this.isConnected() && (reference == null || reference.equals(this.connectable.getConnection().getConfiguration().getID()));
    }

    public void manifestRead(final ManifestRecord manifestRecord) {
        if (manifestRecord != null && manifestRecord.isPresent()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    for (PAContextListener listener : PAConnectionTracker.this.contextListeners) {
                        if ((!(listener instanceof Alerts) || !manifestRecord.isAlert()) && (!(listener instanceof PerformanceAlerts) || !manifestRecord.isPerformanceAlert())) continue;
                        listener.tableSelected(manifestRecord);
                    }
                }
            });
        }
    }

    public ManifestRecord getAlertManifest() {
        ManifestRecord manifest = null;
        if (Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.pa.ui.alert.table.ts", true, null)) {
            manifest = ManifestRecord.getAlias("HST0SAA");
        } else if (Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.pa.ui.alert.table.tg", true, null)) {
            manifest = ManifestRecord.getAlias("HSTG0SAA");
        }
        return manifest;
    }

    public ManifestRecord getPerformanceAlertManifest() {
        return ManifestRecord.getAlias("CMFALERT");
    }

    private String presentSQLException(SQLException sqle) {
        return "SQL " + (sqle instanceof SQLWarning ? "Warning" : "Exception") + " Sql state : " + (sqle.getSQLState() != null ? sqle.getSQLState() : "null") + " Message: " + (sqle.getMessage() != null ? sqle.getMessage() : "null") + " Error  : " + sqle.getErrorCode();
    }

    public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
        if (event.getConnectable() instanceof PAConnectable) {
            this.connectable = event.getConnectable();
            if (event instanceof ConnectionServiceListener.ConnectedEvent) {
                Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"connected", (Object)event.getConnectable());
                this.discoveredTables = new ArrayList<String>();
                Job job = new Job(""){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    protected IStatus run(IProgressMonitor monitor) {
                        PAConnectionTracker.this.era = PAConnectionListener.Era.ABSENT;
                        PAConnectionTracker.this.currentSchema = PAConnectionTracker.this.connectable.getConnection().getConfiguration().getExtendedAttribute("SCHEMA_NAME");
                        DatabaseMetaData dbData = PAConnectionTracker.this.seekConnectionMetaData();
                        if (dbData != null) {
                            String table;
                            ResultSet rs1;
                            try {
                                rs1 = null;
                                try {
                                    rs1 = dbData.getTables(null, PAConnectionTracker.this.currentSchema, null, null);
                                    while (!rs1.isClosed() && rs1.next()) {
                                        table = rs1.getString(3);
                                        if (Utilities.hasContent((String)table)) {
                                            PAConnectionTracker.this.discoveredTables.add(table);
                                        }
                                        if (!"CPA_MANIFEST".equals(table)) continue;
                                        Debug.event((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"connected run", (Object)("We have found a Manifest table " + table));
                                        PAConnectionTracker.this.era = PAConnectionListener.Era.POST;
                                        ViewHelper.setDeferredStatusInformationMessage((String)MessageFormat.format(Messages.getString("Connected"), table));
                                    }
                                }
                                finally {
                                    if (rs1 != null && !rs1.isClosed()) {
                                        rs1.close();
                                    }
                                }
                            }
                            catch (SQLException e) {
                                Debug.warning((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"SQLException", (Object)e);
                                ViewHelper.setDeferredStatusErrorMessage((String)Messages.getString("PAX0104W.Overview.NoManifest"));
                            }
                            try {
                                if (PAConnectionTracker.this.era == PAConnectionListener.Era.ABSENT) {
                                    ViewHelper.setDeferredStatusInformationMessage((String)Messages.getString("PAX0104W.Overview.NoManifest"));
                                    rs1 = null;
                                    try {
                                        rs1 = dbData.getTables(null, PAConnectionTracker.this.currentSchema, ManifestRecord.OLD_LOCAL_SUMMARY_TABLE, null);
                                        while (!rs1.isClosed() && rs1.next()) {
                                            table = rs1.getString(3);
                                            if (!Utilities.hasContent((String)table)) continue;
                                            Debug.event((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"connected run", (Object)("We have found a pre 32 Summary table " + table));
                                            PAConnectionTracker.this.era = PAConnectionListener.Era.PRE;
                                            ViewHelper.setDeferredStatusInformationMessage((String)MessageFormat.format(Messages.getString("Connected"), MessageFormat.format(Messages.getString("Connected"), table)));
                                        }
                                    }
                                    finally {
                                        if (rs1 != null && !rs1.isClosed()) {
                                            rs1.close();
                                        }
                                    }
                                }
                                if (PAConnectionTracker.this.era == PAConnectionListener.Era.ABSENT) {
                                    logger.logp(Level.SEVERE, ((Object)((Object)this)).getClass().getName(), "run", "No tables available for analysis. Check with DBAdm they exist");
                                    ViewHelper.setDeferredStatusErrorMessage((String)Messages.getString("PAX0104W.Overview.NoManifest"));
                                }
                                dbData.getConnection().close();
                            }
                            catch (SQLException e) {
                                Debug.error((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"SQLException", (Throwable)e);
                                ViewHelper.setDeferredStatusErrorMessage((String)Messages.getString("PAX0104W.Overview.NoManifest"));
                            }
                        }
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                for (PAConnectionListener listener : (this).PAConnectionTracker.this.connectionListeners) {
                                    listener.connected((this).PAConnectionTracker.this.era);
                                }
                            }
                        });
                        return Status.OK_STATUS;
                    }
                };
                job.setPriority(20);
                job.schedule();
                Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"connected");
            } else if (event instanceof ConnectionServiceListener.DisconnectedEvent) {
                this.discoveredTables = new ArrayList<String>();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        for (PAConnectionListener listener : PAConnectionTracker.this.connectionListeners) {
                            listener.disconnected();
                        }
                    }
                });
                for (PAContextListener listener : this.contextListeners) {
                    listener.disconnected();
                }
            } else if (event instanceof ConnectionServiceListener.DisconnectingEvent) {
                this.discoveredTables = new ArrayList<String>();
                PAConnectionListener[] pAConnectionListenerArray = this.connectionListeners.toArray(new PAConnectionListener[this.connectionListeners.size()]);
                int n = pAConnectionListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    PAConnectionListener listener = pAConnectionListenerArray[n2];
                    listener.disconnecting();
                    ++n2;
                }
            } else if (event instanceof ConnectionServiceListener.DisconnectingEvent) {
                this.connectable = null;
            }
        }
    }

    public Collection<String> getDiscoveredTables() {
        return this.discoveredTables;
    }

    public void stop() {
        super.makeStale();
        instance = null;
    }

    public synchronized void makeStale() {
        Debug.event((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"makeStale");
        super.makeStale();
    }
}

