/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.menus;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.Presentation;
import com.ibm.cics.eclipse.common.Utilities;
import com.ibm.cics.pa.model.ManifestRecord;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.QueryCache;
import com.ibm.cics.pa.ui.remote.RemoteUniqueRecord;
import com.ibm.cics.pa.ui.views.SheetView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;

public class Stats
extends CompoundContributionItem {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2010, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(Stats.class.getPackage().getName());

    protected IContributionItem[] getContributionItems() {
        Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"getContributionItems");
        ArrayList<CommandContributionItem> menuitems = new ArrayList<CommandContributionItem>();
        IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        MenuManager parent = (MenuManager)this.getParent();
        String originatorId = parent.getId();
        HashMap<String, String> map = new HashMap<String, String>();
        if (Utilities.hasContent((String)originatorId)) {
            String prefix = "com.ibm.cics.pa.ui.links.";
            Set<String> mapping = Stats.findLinks(part, originatorId.substring(prefix.length()));
            for (String menuItem : mapping) {
                map.put("com.ibm.cics.pa.ui.commandMenu", menuItem);
                String menu = Messages.getString("Menu." + menuItem);
                if (menu.startsWith("!") && Messages.hasString(menu = QueryCache.getInstance().getAppropriatePresentation(menuItem, null).getMenu())) {
                    menu = Messages.getString(menu);
                }
                CommandContributionItemParameter contributionParameter = new CommandContributionItemParameter((IServiceLocator)PlatformUI.getWorkbench().getActiveWorkbenchWindow(), menuItem, "com.ibm.cics.pa.ui.commands.stats", 8);
                contributionParameter.parameters = map;
                contributionParameter.icon = null;
                contributionParameter.disabledIcon = null;
                contributionParameter.hoverIcon = null;
                contributionParameter.label = menu;
                contributionParameter.mnemonic = null;
                contributionParameter.tooltip = null;
                contributionParameter.helpContextId = null;
                contributionParameter.visibleEnabled = true;
                CommandContributionItem cci = new CommandContributionItem(contributionParameter);
                menuitems.add(cci);
            }
        }
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"getContributionItems");
        return menuitems.toArray(new IContributionItem[menuitems.size()]);
    }

    public static Set<String> findLinks(IWorkbenchPart part, String extraColumn) {
        Set<String> mapping = new HashSet<String>();
        if (Utilities.hasContent((String)extraColumn)) {
            RemoteUniqueRecord rec;
            StructuredSelection sel;
            ColumnDefinition[] columns = new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_NUMBER, ColumnDefinition.getByDBColumnRef(extraColumn)};
            ManifestRecord record = ((SheetView)part).getManifestRecord();
            String table = "";
            if (record != null) {
                table = record.getAlias();
            }
            ArrayList<ColumnDefinition> restrictions = null;
            String vrm = null;
            if (ColumnDefinition.getByDBColumnRef(extraColumn) == ColumnDefinition.RESNAME) {
                restrictions = new ArrayList<ColumnDefinition>();
                sel = ((SheetView)part).getSelection();
                rec = (RemoteUniqueRecord)sel.getFirstElement();
                if (rec != null) {
                    vrm = (String)rec.getPropertyValue(ColumnDefinition.VRM);
                    Object restype = rec.getCompleteMapping(false).get(ColumnDefinition.RESTYPE);
                    if (restype != null) {
                        if (restype.equals("FILE")) {
                            restrictions.add(ColumnDefinition.FILE_NAME);
                        } else if (restype.equals("PROGRAM")) {
                            restrictions.add(ColumnDefinition.PROGRAM_NAME);
                        }
                    }
                }
            } else if (ColumnDefinition.getByDBColumnRef(extraColumn) == ColumnDefinition.DSA_NAME && (rec = (RemoteUniqueRecord)(sel = ((SheetView)part).getSelection()).getFirstElement()) != null) {
                vrm = (String)rec.getPropertyValue(ColumnDefinition.VRM);
                Integer pools = (Integer)rec.getCompleteMapping(false).get(ColumnDefinition.SUBPOOLS_CUR);
                if (pools == null || pools == 0) {
                    return mapping;
                }
            }
            if (vrm == null && table.equals("CMFALERT") || table.equals("CMFALERT")) {
                vrm = "700";
            }
            mapping = QueryCache.getInstance().findPossbleLinks(columns, table, restrictions, vrm);
            String[] stringArray = mapping.toArray(new String[mapping.size()]);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String code = stringArray[n2];
                Presentation presentation = QueryCache.getInstance().getAppropriatePresentation(code, "700");
                ManifestRecord record1 = ManifestRecord.deriveFromSelection(presentation);
                if (record1 == null || !record1.isPresent()) {
                    mapping.remove(code);
                }
                ++n2;
            }
        }
        return mapping;
    }
}

