/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.handlers;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Presentation;
import com.ibm.cics.eclipse.common.ViewHelper;
import com.ibm.cics.pa.model.IUniqueRecord;
import com.ibm.cics.pa.model.ManifestRecord;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.SheetViewDefinition;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.QueryCache;
import com.ibm.cics.pa.ui.handlers.CommonHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class StatsHandler
extends CommonHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2010, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Debug.enter((Logger)logger, (String)StatsHandler.class.getName(), (String)"execute");
        String chart = event.getParameter("com.ibm.cics.pa.ui.commandMenu");
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (chart != null) {
            HashMap<String, Object> parameterMap = new HashMap<String, Object>();
            String contentDescription = "";
            Presentation presentation = QueryCache.getInstance().getAppropriatePresentation(chart, (String)parameterMap.get(ColumnDefinition.VRM.getDBColumnRef()));
            if (presentation != null) {
                ManifestRecord manifest;
                Map requiredDefinitions = presentation.getInputColumns();
                StructuredSelection selected = (StructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
                if (!selected.isEmpty() && selected.getFirstElement() instanceof IUniqueRecord) {
                    Object[] input = selected.toArray();
                    int j = 0;
                    while (j < input.length) {
                        ColumnDefinition[] definitions = ((IUniqueRecord)input[j]).getSourceProvider().getColumnDefinitions();
                        Object[] row = ((IUniqueRecord)input[j]).getRow();
                        for (ColumnReference column : requiredDefinitions.keySet()) {
                            int i = 0;
                            while (i < definitions.length) {
                                if (this.hasAffinity(column, definitions[i])) {
                                    String parmKey = (String)requiredDefinitions.get(column);
                                    if (selected.size() > 1) {
                                        parmKey = String.valueOf(parmKey) + j;
                                    }
                                    parameterMap.put(parmKey, row[i]);
                                    contentDescription = String.valueOf(contentDescription) + definitions[i].getLabel(null) + ": ";
                                    contentDescription = String.valueOf(contentDescription) + row[i] + ". ";
                                }
                                ++i;
                            }
                        }
                        ++j;
                    }
                }
                if ((manifest = ManifestRecord.deriveFromSelection(presentation)).isPresent()) {
                    presentation.getSelection().applyTableMapping(ManifestRecord.getAliasMapping());
                    this.dbQuery(part, presentation.getSelection(), contentDescription, parameterMap, SheetViewDefinition.createForPresentation(presentation), presentation.getTitle(), manifest);
                } else {
                    ViewHelper.setDeferredStatusInformationMessage((String)Messages.getString("PAX0105W.Overview.NoSummary"));
                }
            }
        }
        Debug.exit((Logger)logger, (String)StatsHandler.class.getName(), (String)"execute", (Object)chart);
        return "";
    }

    private boolean hasAffinity(ColumnReference column, ColumnDefinition definition) {
        if (column.getColumnName().equals(definition.getDBColumnRef())) {
            return true;
        }
        String[] stringArray = definition.getMutations();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String defn = stringArray[n2];
            if (column.getColumnName().equals(defn)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

