/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.handlers;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Presentation;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.ui.ScrollLimitManager;
import com.ibm.cics.eclipse.common.ViewHelper;
import com.ibm.cics.eclipse.common.ui.Utilities;
import com.ibm.cics.pa.model.AlertElement;
import com.ibm.cics.pa.model.Chart;
import com.ibm.cics.pa.model.DateCaveat;
import com.ibm.cics.pa.model.IUniqueRecord;
import com.ibm.cics.pa.model.ManifestRecord;
import com.ibm.cics.pa.model.PlotModel;
import com.ibm.cics.pa.model.definitions.CategorisationHelper;
import com.ibm.cics.pa.model.definitions.ChartSpecification;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.IntervalSpecificDefinitions;
import com.ibm.cics.pa.model.definitions.PersistedChartDefinition;
import com.ibm.cics.pa.ui.ChartManager;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.handlers.CommonHandler;
import com.ibm.cics.pa.ui.handlers.VisualizationHandler;
import com.ibm.cics.pa.ui.remote.DBQueryFactoryCustomer;
import com.ibm.cics.pa.ui.remote.PAConnectionTracker;
import com.ibm.cics.pa.ui.remote.RemoteEditorInput;
import com.ibm.cics.pa.ui.remote.RemoteUniqueRecord;
import com.ibm.cics.pa.ui.views.PerformanceListRecordFormsView;
import com.ibm.cics.pa.ui.views.SheetView;
import java.sql.Time;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class IntervalTracker
extends CommonHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(IntervalTracker.class);
    String vrm;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        debug.enter("execute", (Object)event);
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        String dsaLabel = null;
        if (part == null) {
            return "";
        }
        if (part instanceof PerformanceListRecordFormsView) {
            AlertElement alert = ((PerformanceListRecordFormsView)part).getNextAlert();
            if (alert != null) {
                this.executeAnAlert(part, ((PerformanceListRecordFormsView)part).getNextAlert());
            }
        } else if (part instanceof SheetView) {
            String alias = ((SheetView)part).getManifestRecord().getAlias();
            RemoteUniqueRecord record = (RemoteUniqueRecord)((SheetView)part).getSelection().getFirstElement();
            if (record != null) {
                Map<String, Object> variables = this.convertToWhereParameters(record);
                this.vrm = (String)variables.get(String.valueOf(':') + ColumnDefinition.VRM.getDBColumnRef());
                Presentation presentation = CategorisationHelper.findBestIntervalPresentationForTable(alias, this.vrm);
                if (presentation != null) {
                    String maintitle;
                    String resourceValue;
                    Time duration = (Time)variables.get(String.valueOf(':') + ColumnDefinition.INTERVAL_DURATION.getDBColumnRef());
                    Date date = (Date)variables.get(String.valueOf(':') + ColumnDefinition.START_DATE.getDBColumnRef());
                    Time time = (Time)variables.get(String.valueOf(':') + ColumnDefinition.START_TIME.getDBColumnRef());
                    String applid = (String)variables.get(String.valueOf(':') + ColumnDefinition.APPLID.getDBColumnRef());
                    if (variables.containsKey(String.valueOf(':') + ColumnDefinition.DSA_NAME.getDBColumnRef())) {
                        String DSAName = (String)variables.get(String.valueOf(':') + ColumnDefinition.DSA_NAME.getDBColumnRef());
                        if (DSAName.startsWith("E") || DSAName.startsWith("'E")) {
                            variables.put(String.valueOf(':') + ColumnDefinition.DSA_INDEX.getDBColumnRef(), "9, 10, 11, 12, 13");
                            variables.put(String.valueOf(':') + ColumnDefinition.DSA_NAME.getDBColumnRef(), "'ECDSA', 'EUDSA', 'ESDSA', 'ERDSA', 'ETDSA'");
                            dsaLabel = Messages.getString("ChartDefinition.EDSA_TRACE_LONG");
                        } else if (DSAName.startsWith("G") || DSAName.startsWith("'G")) {
                            variables.put(String.valueOf(':') + ColumnDefinition.DSA_INDEX.getDBColumnRef(), "17, 18, 19");
                            variables.put(String.valueOf(':') + ColumnDefinition.DSA_NAME.getDBColumnRef(), "'GCDSA', 'GUDSA'");
                            dsaLabel = Messages.getString("ChartDefinition.GDSA_TRACE_LONG");
                        } else {
                            variables.put(String.valueOf(':') + ColumnDefinition.DSA_INDEX.getDBColumnRef(), "1,2,3,4");
                            variables.put(String.valueOf(':') + ColumnDefinition.DSA_NAME.getDBColumnRef(), "'CDSA', 'UDSA', 'SDSA', 'RDSA'");
                            dsaLabel = Messages.getString("ChartDefinition.DSA_TRACE_LONG");
                        }
                    }
                    DateCaveat dateRange = this.createRangeDateCaveat(date, time, duration, 12);
                    Selection selectionObject1 = presentation.getSelection();
                    String parameter = presentation.getParameter("chart_content_insert");
                    String string = resourceValue = parameter == null ? null : (String)variables.get(String.valueOf(':') + parameter);
                    if (dateRange != null) {
                        variables.put("TemporaryConstraintAnd", dateRange.getConstraint(alias, false));
                    }
                    PersistedChartDefinition chartReference = PersistedChartDefinition.getDefinition(presentation);
                    IntervalSpecificDefinitions specificDefinitions = (IntervalSpecificDefinitions)chartReference.getSpecificType();
                    specificDefinitions.setVRM((String)record.getReferenceMapping().get(ColumnDefinition.VRM));
                    parameter = presentation.getParameter("chart_content");
                    String string2 = maintitle = Messages.hasString(parameter) ? Messages.getString(parameter) : parameter;
                    if (StringUtil.hasContent((String)dsaLabel)) {
                        maintitle = MessageFormat.format(maintitle, dsaLabel);
                    }
                    if (dateRange != null) {
                        maintitle = resourceValue != null ? String.valueOf(MessageFormat.format(maintitle, applid, resourceValue)) + dateRange.getLabel() : String.valueOf(MessageFormat.format(maintitle, applid)) + dateRange.getLabel();
                    }
                    selectionObject1.applyTableMapping(ManifestRecord.getAliasMapping());
                    this.dbQuery(part, selectionObject1, maintitle, variables, chartReference, ManifestRecord.getAlias(alias).getDescription(), record, time, ((SheetView)part).getManifestRecord(), dateRange);
                }
            } else {
                ViewHelper.setStatusInformationMessage((IWorkbenchPart)part, (String)Messages.getString("PAX0107W.Visualisation_notable"));
            }
        } else {
            StructuredSelection selection = (StructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            if (selection != null && selection.getFirstElement() != null) {
                if (selection.getFirstElement() instanceof AlertElement || selection.getFirstElement() instanceof PlotModel.PlotModelElement) {
                    AlertElement element = selection.getFirstElement() instanceof AlertElement ? (AlertElement)selection.getFirstElement() : ((PlotModel.PlotModelElement)selection.getFirstElement()).getNextAlert();
                    this.executeAnAlert(part, element);
                } else {
                    ViewHelper.setStatusInformationMessage((IWorkbenchPart)part, (String)Messages.getString("PAX0107W.Visualisation_notable"));
                }
            }
        }
        debug.exit("execute");
        return null;
    }

    private void executeAnAlert(IWorkbenchPart part, AlertElement element) {
        if (element != null) {
            String dsaLabel = null;
            String alias = element.getTableAlias();
            this.vrm = element.getVRM();
            Presentation presentation = CategorisationHelper.findBestIntervalPresentationForTable(alias, this.vrm);
            if (presentation != null) {
                String maintitle;
                String resourceValue;
                Time duration = (Time)element.getDefinitionMapping().get(ColumnDefinition.INTERVAL_DURATION);
                Date date = (Date)element.getDefinitionMapping().get(ColumnDefinition.START_DATE);
                Time time = (Time)element.getDefinitionMapping().get(ColumnDefinition.START_TIME);
                String applid = (String)element.getDefinitionMapping().get(ColumnDefinition.APPLID);
                String mvs = (String)element.getDefinitionMapping().get(ColumnDefinition.MVSID);
                DateCaveat dateRange = this.createRangeDateCaveat(date, time, duration, 12);
                Selection selectionObject1 = presentation.getSelection();
                HashMap<String, Object> variables = new HashMap<String, Object>();
                variables.put(String.valueOf(':') + ColumnDefinition.APPLID.getDBColumnRef(), applid);
                variables.put(String.valueOf(':') + ColumnDefinition.MVSID.getDBColumnRef(), mvs);
                ColumnDefinition resource_defn = element.getResourceDefinition();
                String string = resourceValue = resource_defn == null ? null : (String)element.getDefinitionMapping().get(resource_defn);
                if (Utilities.hasContent(resourceValue) && resource_defn != null) {
                    variables.put(String.valueOf(':') + resource_defn.getDBColumnRef(), resourceValue);
                }
                if (variables.containsKey(String.valueOf(':') + ColumnDefinition.DSA_NAME.getDBColumnRef())) {
                    String DSAName = (String)variables.get(String.valueOf(':') + ColumnDefinition.DSA_NAME.getDBColumnRef());
                    if (DSAName.startsWith("E") || DSAName.startsWith("'E")) {
                        variables.put(String.valueOf(':') + ColumnDefinition.DSA_INDEX.getDBColumnRef(), "9, 10, 11, 12, 13");
                        variables.put(String.valueOf(':') + ColumnDefinition.DSA_NAME.getDBColumnRef(), "'ECDSA', 'EUDSA', 'ESDSA', 'ERDSA', 'ETDSA'");
                        dsaLabel = Messages.getString(alias.equals("HST030B") ? "ChartDefinition.LDG_EDSA_TRACE_LONG" : "ChartDefinition.EDSA_TRACE_LONG");
                    } else if (DSAName.startsWith("G") || DSAName.startsWith("'G")) {
                        variables.put(String.valueOf(':') + ColumnDefinition.DSA_INDEX.getDBColumnRef(), "17, 18, 19");
                        variables.put(String.valueOf(':') + ColumnDefinition.DSA_NAME.getDBColumnRef(), "'GCDSA', 'GUDSA'");
                        dsaLabel = Messages.getString("ChartDefinition.GDSA_TRACE_LONG");
                    } else {
                        variables.put(String.valueOf(':') + ColumnDefinition.DSA_INDEX.getDBColumnRef(), "1,2,3,4");
                        variables.put(String.valueOf(':') + ColumnDefinition.DSA_NAME.getDBColumnRef(), "'CDSA', 'UDSA', 'SDSA', 'RDSA'");
                        dsaLabel = Messages.getString(alias.equals("HST030B") ? "ChartDefinition.LDG_DSA_TRACE_LONG" : "ChartDefinition.DSA_TRACE_LONG");
                    }
                }
                if (dateRange != null) {
                    variables.put("TemporaryConstraintAnd", dateRange.getConstraint(alias, false));
                }
                if (variables.containsKey(String.valueOf(':') + ColumnDefinition.DSA_INDEX.getDBColumnRef())) {
                    String DSAIndex = (String)variables.get(String.valueOf(':') + ColumnDefinition.DSA_INDEX.getDBColumnRef());
                    dsaLabel = DSAIndex.startsWith("9") ? Messages.getString(alias.equals("HST030B") ? "ChartDefinition.LDG_EDSA_TRACE_LONG" : "ChartDefinition.EDSA_TRACE_LONG") : (DSAIndex.startsWith("17") ? Messages.getString("ChartDefinition.GDSA_TRACE_LONG") : Messages.getString(alias.equals("HST030B") ? "ChartDefinition.LDG_DSA_TRACE_LONG" : "ChartDefinition.DSA_TRACE_LONG"));
                }
                PersistedChartDefinition chartReference = PersistedChartDefinition.getDefinition(presentation);
                IntervalSpecificDefinitions specificDefinitions = (IntervalSpecificDefinitions)chartReference.getSpecificType();
                specificDefinitions.setVRM(element.getVRM());
                String parameter = presentation.getParameter("chart_content");
                String string2 = maintitle = Messages.hasString(parameter) ? Messages.getString(parameter) : parameter;
                if (StringUtil.hasContent(dsaLabel)) {
                    maintitle = MessageFormat.format(maintitle, dsaLabel);
                }
                if (dateRange != null) {
                    maintitle = resourceValue != null ? String.valueOf(MessageFormat.format(maintitle, applid, resourceValue)) + dateRange.getLabel() : String.valueOf(MessageFormat.format(maintitle, applid)) + dateRange.getLabel();
                }
                selectionObject1.applyTableMapping(ManifestRecord.getAliasMapping());
                this.dbQuery(part, selectionObject1, maintitle, variables, chartReference, ManifestRecord.getAlias(alias).getDescription(), null, time, element.getManifestRecord(), dateRange);
            }
        }
    }

    public String dbQuery(final IWorkbenchPart activePart, final Selection select, final String contentDescription, final Map<String, Object> parameterMap, final ChartSpecification chartReference, final String tabLabel, final IUniqueRecord record, final Time time, final ManifestRecord manifestRecord, final DateCaveat dateCaveat) {
        debug.enter("dbQuery");
        String newId = Chart.calculateReference(chartReference, contentDescription);
        IViewReference existing = activePart.getSite().getPage().findViewReference(chartReference.getType().getId(), newId);
        if (existing != null) {
            existing.getView(true);
        }
        if (!PAConnectionTracker.getInstance().isConnected()) {
            ViewHelper.setDeferredStatusErrorMessage((String)Messages.getString("PAX0102I.Not_Connected"));
            debug.exit("dbQuery", (Object)"not connected");
            return "";
        }
        Job job = new Job(Messages.getString("PAConnections.checking")){

            protected IStatus run(final IProgressMonitor monitor) {
                ViewHelper.setStatusInformationMessage((IWorkbenchPart)activePart, (String)Messages.getString("Query.update"));
                final int[] totalrows = new int[]{-1};
                DBQueryFactoryCustomer customer = new DBQueryFactoryCustomer(){
                    private Command currentEngine;

                    @Override
                    public void receiveNotification(final int total) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ViewHelper.setStatusInformationMessage((IWorkbenchPart)activePart, (String)MessageFormat.format(Messages.getString("Results.CollectedOf"), 0, total));
                            }
                        });
                        if (totalrows[0] == -1) {
                            totalrows[0] = total;
                            if (total == 0) {
                                Presentation presentation = ((IntervalSpecificDefinitions)chartReference.getSpecificType()).getAlternativePresentation();
                                if (presentation != null) {
                                    IntervalTracker.this.respinAlternative(activePart, contentDescription, parameterMap, presentation, tabLabel, record, time, manifestRecord, dateCaveat);
                                } else {
                                    Display.getDefault().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            ViewHelper.setStatusInformationMessage((IWorkbenchPart)activePart, (String)Messages.getString("PAX0103I.Results.NoData"));
                                        }
                                    });
                                }
                            }
                        }
                    }

                    @Override
                    public void refresh(final RemoteEditorInput dataProvider, boolean isInterimRefresh) {
                        if (dataProvider.getColumnDefinitions() != null && totalrows[0] > 0) {
                            IntervalTracker.this.checkColumns(dataProvider, select);
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    String id = ChartManager.getInstance().createChart(chartReference, dataProvider, contentDescription, record, monitor);
                                    if (Utilities.hasContent((String)id)) {
                                        try {
                                            PlotModel model = (PlotModel)Chart.getReference(id);
                                            if (model != null) {
                                                model.setSelectionInterval(time);
                                            }
                                            activePart.getSite().getPage().showView(chartReference.getType().getId(), id, 1);
                                        }
                                        catch (PartInitException e) {
                                            logger.logp(Level.SEVERE, VisualizationHandler.class.getName(), "specificTranJob", "Part initialization", e);
                                        }
                                    } else {
                                        ViewHelper.setStatusInformationMessage((IWorkbenchPart)activePart, (String)Messages.getString("PAX0103I.Results.NoData"));
                                    }
                                }
                            });
                            Presentation presentation = ((IntervalSpecificDefinitions)chartReference.getSpecificType()).getMergePresentation();
                            if (presentation != null) {
                                IntervalTracker.this.respinAlternative(activePart, contentDescription, parameterMap, presentation, tabLabel, record, time, manifestRecord, dateCaveat);
                            }
                        }
                    }

                    @Override
                    public void upDateCommand(Command engine) {
                        this.currentEngine = engine;
                    }

                    @Override
                    public Command getCurrentCommand() {
                        return this.currentEngine;
                    }

                    @Override
                    public ScrollLimitManager getScrollLimitManager() {
                        return null;
                    }

                    @Override
                    public void abort() {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                IWorkbenchPart apart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
                                if (apart != null) {
                                    ViewHelper.setStatusInformationMessage((IWorkbenchPart)apart, (String)Messages.getString("PAX0101E.FailureOcurred"));
                                }
                            }
                        });
                    }

                    @Override
                    public IWorkbenchSite getSite() {
                        return activePart.getSite();
                    }
                };
                RemoteEditorInput dataProvider = RemoteEditorInput.runQuery(customer, select, parameterMap, chartReference, contentDescription, manifestRecord, 4000);
                if (dataProvider != null) {
                    dataProvider.setInitialTab(tabLabel);
                    return Status.OK_STATUS;
                }
                return Status.CANCEL_STATUS;
            }
        };
        job.setPriority(20);
        IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)activePart.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        siteService.schedule(job, 0L, true);
        debug.exit("dbQuery", (Object)"scheduled");
        return "";
    }

    void respinAlternative(IWorkbenchPart part, String contentDescription, Map<String, Object> variables, Presentation presentation, String tabLabel, IUniqueRecord record, Time time, ManifestRecord manifestRecord, DateCaveat dateRange) {
        PersistedChartDefinition chartReference = PersistedChartDefinition.getDefinition(presentation);
        Selection selectionObject1 = presentation.getSelection();
        selectionObject1.applyTableMapping(ManifestRecord.getAliasMapping());
        String alias = (String)presentation.getTargetTables().toArray()[0];
        variables.put("TemporaryConstraintAnd", dateRange.getConstraint(alias, false));
        this.dbQuery(part, selectionObject1, contentDescription, variables, chartReference, tabLabel, record, time, manifestRecord, dateRange);
    }

    private DateCaveat createRangeDateCaveat(Date date, Time time, Time duration, int targetResults) {
        Date enddate = DateCaveat.join(date, time, duration, targetResults / 2);
        Date startdate = DateCaveat.join(date, time, duration, -targetResults / 2);
        return DateCaveat.createRangeDateCaveat(startdate, enddate);
    }

    void checkColumns(RemoteEditorInput dataProvider, Selection select) {
        if (select.getSelect().getColumns().size() > 1 && select.getSelect().getColumns().size() == dataProvider.getColumnDefinitions().length) {
            int i = 0;
            while (i < dataProvider.getColumnDefinitions().length) {
                ColumnDefinition def2;
                if (dataProvider.getColumnDefinitions()[i] == ColumnDefinition.UNKNOWN && (def2 = ColumnDefinition.getByDBColumnRef(((ColumnReference)select.getSelect().getColumns().get(i)).getColumnName())) != null && def2 != ColumnDefinition.UNKNOWN) {
                    dataProvider.getColumnDefinitions()[i] = def2;
                    dataProvider.getHeaders()[i] = def2.getLabel(null);
                }
                ++i;
            }
        }
    }
}

