/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.figures;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.pa.model.PlotModel;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.IntervalTypes;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.figures.IIntervalColumnFigure;
import com.ibm.cics.pa.ui.figures.IntervalPlotFigure;
import com.ibm.cics.pa.ui.figures.IntervalPlotTooltip;
import com.ibm.cics.pa.ui.figures.SiblingColumnFigure;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class SingleIntervalFigure
extends Figure
implements IIntervalColumnFigure {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(SingleIntervalFigure.class);
    protected Object[] values;
    protected IntervalPlotFigure plot;
    protected Color colour;
    protected PlotModel.PlotModelElement element;
    private Label timesAtFigure;
    protected int positionT;
    protected List<Figure> childFigures = new ArrayList<Figure>();
    private IntervalTypes intervalType;
    private ColumnDefinition[] labels;
    protected double rangeFactor;
    private static Image warnImage = Activator.getDefault().getImage("alert");

    public SingleIntervalFigure(IntervalPlotFigure parent, PlotModel.PlotModelElement plotModelElement, Color aNiceColour, ColumnDefinition[] labels) {
        debug.enter("SingleIntervalFigure", (Object)plotModelElement);
        this.values = plotModelElement.getPlotHeaderData();
        this.plot = parent;
        this.element = plotModelElement;
        this.labels = labels;
        this.setToolTip((IFigure)new IntervalPlotTooltip(plotModelElement, aNiceColour, labels));
        this.colour = aNiceColour;
        if (this.element.getTextNumber() != null) {
            this.timesAtFigure = new Label(MessageFormat.format(Messages.getString("ChartDefinition.Parenthesised"), this.element.getTextNumber()));
            this.timesAtFigure.setFont(Activator.getDefault().fontArial);
            this.timesAtFigure.setForegroundColor(this.element.getTextNumberColour());
            this.add((IFigure)this.timesAtFigure);
        }
        this.intervalType = IntervalTypes.getByName((String)this.element.getValueMap().get(ColumnDefinition.INTERVAL_TYPE));
        debug.exit("SingleIntervalFigure");
    }

    public void paint(Graphics graphics) {
        Rectangle clientArea = this.getBounds().getCopy();
        clientArea.height -= 64;
        clientArea.y += 64;
        this.rangeFactor = (this.plot.getHighRange() - this.plot.getLowRange()) / (double)clientArea.height;
        this.positionT = Math.round(Math.round((this.plot.getThreashold() - this.plot.getLowRange()) / this.rangeFactor));
        if (this.timesAtFigure != null) {
            int width = FigureUtilities.getTextWidth((String)this.timesAtFigure.getText(), (Font)Activator.getDefault().fontArial);
            int displacement = clientArea.width - width;
            clientArea.x += displacement / 2;
            clientArea.width = width;
            ++clientArea.y;
            clientArea.height -= this.positionT;
            this.timesAtFigure.setBounds(clientArea);
        }
        for (Object child : this.getChildren()) {
            if (!(child instanceof IIntervalColumnFigure)) continue;
            ((IFigure)child).setBounds(((IIntervalColumnFigure)child).calculateBounds(this.getBounds().getCopy(), this.rangeFactor));
        }
        this.paintHeader(graphics);
        this.paintBody(graphics);
        super.paint(graphics);
    }

    private void paintHeader(Graphics graphics) {
        Rectangle clientArea = this.getClientArea().getCopy();
        clientArea.height = 64;
        graphics.setBackgroundColor(this.colour);
        graphics.fillRectangle(clientArea);
        graphics.setForegroundColor(ColorConstants.lightBlue);
        graphics.setLineStyle(3);
        graphics.setForegroundColor(this.plot.isSelected(this) && this.plot.hasFocusColumn() ? ColorConstants.black : ColorConstants.darkGray);
        graphics.setFont(Activator.getDefault().fontArialSmall);
        String intText = DataTypeUtilities.getAsString(this.values[2]);
        int txtL = FigureUtilities.getTextWidth((String)intText, (Font)Activator.getDefault().fontArial);
        graphics.drawText(intText, clientArea.x + (64 - txtL) / 2, clientArea.y + clientArea.height / 3);
        graphics.setFont(Activator.getDefault().fontArial);
        intText = MessageFormat.format(Messages.getString("ChartDefinition.Parenthesised"), this.intervalType.name());
        intText = String.valueOf(intText) + ' ' + DataTypeUtilities.getAsString(this.values[1]);
        txtL = FigureUtilities.getTextWidth((String)intText, (Font)Activator.getDefault().fontArial);
        graphics.drawText(intText, clientArea.x + (64 - txtL) / 2, clientArea.y + clientArea.height * 2 / 3);
        if (((Boolean)this.values[0]).booleanValue()) {
            graphics.drawImage(warnImage, clientArea.x + 24, clientArea.y + 4);
        }
        if (this.plot.isSelected(this)) {
            graphics.setForegroundColor(this.plot.hasFocusColumn() ? ColorConstants.darkGray : ColorConstants.gray);
            graphics.setLineWidth(this.plot.hasFocusColumn() ? 2 : 2);
            graphics.setLineStyle(1);
        } else {
            graphics.setForegroundColor(ColorConstants.lightBlue);
            graphics.setLineStyle(3);
        }
        graphics.drawLine(clientArea.x + 1, clientArea.y, clientArea.x + 1, clientArea.height - 2);
        graphics.drawLine(clientArea.x + clientArea.width - 1, clientArea.y, clientArea.x + clientArea.width - 1, clientArea.height - 2);
        graphics.setLineStyle(1);
        graphics.drawLine(clientArea.x, clientArea.y + clientArea.height - 1, clientArea.x + clientArea.width, clientArea.y + clientArea.height - 1);
        graphics.drawLine(clientArea.x, clientArea.y + 1, clientArea.x + clientArea.width, clientArea.y + 1);
    }

    protected void paintBody(Graphics graphics) {
        Rectangle clientArea = this.getBounds().getCopy();
        clientArea.height -= 64;
        clientArea.y += 64;
        graphics.setBackgroundColor(this.plot.isSelected(this) && this.plot.hasFocusColumn() ? ColorConstants.lightGray : ColorConstants.white);
        graphics.setForegroundColor(this.colour);
        graphics.fillGradient(clientArea, true);
        graphics.setForegroundColor(ColorConstants.lightBlue);
        graphics.setLineStyle(3);
        if (this.plot.isSelected(this)) {
            graphics.setForegroundColor(this.plot.hasFocusColumn() ? ColorConstants.darkGray : ColorConstants.gray);
            graphics.setLineWidth(this.plot.hasFocusColumn() ? 2 : 2);
            graphics.setLineStyle(1);
        } else {
            graphics.setForegroundColor(ColorConstants.lightBlue);
            graphics.setLineWidth(1);
            graphics.setLineStyle(3);
        }
        graphics.drawLine(clientArea.x + 1, clientArea.y, clientArea.x + 1, clientArea.y + clientArea.height - 2);
        graphics.drawLine(clientArea.x + clientArea.width - 1, clientArea.y, clientArea.x + clientArea.width - 1, clientArea.y + clientArea.height - 1);
        graphics.drawLine(clientArea.x, clientArea.y + clientArea.height - 1, clientArea.x + clientArea.width, clientArea.y + clientArea.height - 1);
    }

    public PlotModel.PlotModelElement getElement() {
        return this.element;
    }

    @Override
    public void forceRepaint() {
        this.setToolTip((IFigure)new IntervalPlotTooltip(this.element, this.colour, this.labels));
        for (Object figure : this.getChildren()) {
            if (!(figure instanceof IIntervalColumnFigure)) continue;
            ((IIntervalColumnFigure)figure).forceRepaint();
        }
    }

    @Override
    public Rectangle calculateBounds(Rectangle clientArea, double rangeFactor) {
        return clientArea;
    }

    public IFigure createSiblingColumn(PlotModel.PlotModelElement plotModelElement, int relativeDisplacement, long valuePeak, long valueCurrent, long usedValue, long programValue, ColumnDefinition peakColumnDefinition, ColumnDefinition currentColumnDefinition, ColumnDefinition usedColumnDefinition, ColumnDefinition programsColumnDefinition) {
        debug.enter("createSiblingColumn", (Object)relativeDisplacement);
        SiblingColumnFigure figure = new SiblingColumnFigure(this.element, relativeDisplacement, valuePeak, valueCurrent, usedValue, programValue, peakColumnDefinition, currentColumnDefinition, usedColumnDefinition, programsColumnDefinition, this.colour);
        this.add(figure);
        debug.exit("createSiblingColumn", (Object)figure);
        return figure;
    }
}

