/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.figures;

import com.ibm.cics.pa.model.ChartType;
import com.ibm.cics.pa.model.Column;
import com.ibm.cics.pa.model.GraphModel;
import com.ibm.cics.pa.model.Histogram;
import com.ibm.cics.pa.model.IUniqueRecord;
import com.ibm.cics.pa.model.definitions.ChartSpecification;
import com.ibm.cics.pa.model.definitions.ColumnContainment;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.HistogramChartSpecificDefinitions;
import com.ibm.cics.pa.ui.figures.ChartSelectable;
import com.ibm.cics.pa.ui.figures.ColumnSection;
import com.ibm.cics.pa.ui.figures.CommonHistogram;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;

public class SelectableColumn
extends ChartSelectable {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private double primaryTotalValue = 0.0;
    private double secondaryTotalValue = 0.0;
    protected ArrayList<ColumnSection[]> secondarySubSections = null;
    private ArrayList<ColumnSection[]> primarySubSections = null;

    public SelectableColumn(IUniqueRecord viewModel, ChartSpecification chartReference, ColumnDefinition[] headers) {
        super(viewModel, chartReference);
        double value;
        int pos;
        ColumnSection section;
        Panel tooltip = new Panel();
        tooltip.setLayoutManager((LayoutManager)new GridLayout(2, false));
        ColumnDefinition[] columnDefinitionArray = ((HistogramChartSpecificDefinitions)chartReference.getSpecificType()).getPrimaryReqts();
        int n = columnDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnDefinition column = columnDefinitionArray[n2];
            int columnPositionInRow = SelectableColumn.getColumnPosition(headers, column);
            if (columnPositionInRow > -1 && viewModel.getRow()[columnPositionInRow] instanceof Number) {
                double value2 = ((Number)viewModel.getRow()[columnPositionInRow]).doubleValue();
                Label label = new Label(column.getLabel(null));
                label.setIcon(Column.getFor(column).getImage());
                tooltip.add((IFigure)label);
                label = new Label(DataTypeUtilities.getAsString(value2));
                tooltip.add((IFigure)label);
                if (value2 > 0.0) {
                    section = new ColumnSection(column, this.primaryTotalValue, value2);
                    this.addPrimarySection(section);
                    this.primaryTotalValue += section.getValue();
                }
            } else {
                logger.logp(Level.SEVERE, SelectableColumn.class.getName(), "SelectableColumn", "SelectableColumn: Column missing issue, invalid input file " + column.getLabel(null), viewModel.getSourceProvider().getFileReference());
            }
            ++n2;
        }
        ColumnContainment containment = ((HistogramChartSpecificDefinitions)chartReference.getSpecificType()).getContainment();
        if (containment != null && (pos = SelectableColumn.getColumnPosition(headers, containment.getPrimary())) > -1 && viewModel.getRow()[pos] instanceof Number && (value = ((Number)viewModel.getRow()[pos]).doubleValue()) > 0.0) {
            ColumnSection section2 = new ColumnSection(containment.getPrimary(), this.primaryTotalValue, value - this.primaryTotalValue);
            section2.isTotal();
            this.addPrimarySection(section2);
            this.primaryTotalValue = value;
        }
        ColumnDefinition[] columnDefinitionArray2 = ((HistogramChartSpecificDefinitions)chartReference.getSpecificType()).getSecondaryReqts();
        int n3 = columnDefinitionArray2.length;
        n = 0;
        while (n < n3) {
            ColumnDefinition column = columnDefinitionArray2[n];
            int columnPositionInRow = SelectableColumn.getColumnPosition(headers, column);
            if (viewModel.getRow()[columnPositionInRow] instanceof Number) {
                double value3 = ((Number)viewModel.getRow()[columnPositionInRow]).doubleValue();
                if (value3 > 0.0) {
                    section = new ColumnSection(column, this.secondaryTotalValue, value3);
                    this.addSecondarySection(section);
                    this.secondaryTotalValue += ((Number)section.getValue()).doubleValue();
                }
            } else {
                logger.logp(Level.SEVERE, SelectableColumn.class.getName(), "SelectableColumn", "SelectableColumn: Column missing issue, invalid input file " + column.getLabel(null), viewModel.getSourceProvider().getFileReference());
            }
            ++n;
        }
        this.setToolTip((IFigure)tooltip);
    }

    protected void paintFigure(Graphics g) {
        int h;
        int w;
        int y;
        super.paintFigure(g);
        this.setFocusTraversable(true);
        Rectangle area = this.getClientArea().getCopy();
        int height = Math.round(Math.round(Math.max(this.getTotalPrimary() * ((Histogram)this.model).primaryScalingFactor, this.getTotalSecondary() * ((Histogram)this.model).secondaryScalingFactor)));
        area = new Rectangle(area.x, area.y + area.height - height, this.model.barWidth * (((Histogram)this.model).isTwinAxis() ? 2 : 1), height);
        if (((Histogram)this.model).isTwinAxis()) {
            area = this.getClientArea();
            height = Math.round(Math.round(this.getTotalPrimary() * ((Histogram)this.model).primaryScalingFactor));
            area = new Rectangle(area.x, area.y + area.height - height, this.model.barWidth, height);
        }
        g.setLineWidth(1);
        g.setBackgroundColor(ColorConstants.white);
        g.fillRectangle(area);
        for (ColumnSection[] primary : this.getPrimarySubSections()) {
            this.setConstraint((IFigure)primary[0], area);
            primary[0].setBounds(area);
        }
        g.setForegroundColor(ColorConstants.darkGray);
        g.setBackgroundColor(ColorConstants.gray);
        g.setForegroundColor(ColorConstants.gray);
        g.setLineWidth(1);
        if (!this.isCompact()) {
            g.drawLine(area.x + area.width + 1, area.y - 1, area.x + area.width + 1, area.y + area.height + 1);
            g.drawLine(area.x + area.width + 2, area.y - 2, area.x + area.width + 2, area.y + area.height + 2);
            g.drawLine(area.x + 1, area.y - 1, area.x + area.width + 1, area.y - 1);
            g.drawLine(area.x + 2, area.y - 2, area.x + area.width + 2, area.y - 2);
            g.drawLine(area.x + 3, area.y - 3, area.x + area.width + 2, area.y - 3);
        }
        if (this.selected) {
            g.setAlpha(200);
            g.setForegroundColor(ColorConstants.darkGray);
            int j = 0;
            while (j < area.height + area.width - 1) {
                int x = area.x;
                y = area.y + j;
                w = x + area.width;
                h = y - area.width;
                while (h < area.y) {
                    h += 2;
                    w -= 2;
                }
                g.setLineWidth(2);
                g.drawLine(x, y, w, h);
                j += 4;
            }
        }
        g.drawRectangle(area);
        if (((Histogram)this.model).isTwinAxis()) {
            area = this.getClientArea();
            height = Math.round(Math.round(this.getTotalSecondary() * ((Histogram)this.model).secondaryScalingFactor));
            g.setLineWidth(2);
            area = new Rectangle(area.x + ((Histogram)this.model).barWidth, area.y + area.height - height, ((Histogram)this.model).barWidth, height);
            g.setLineWidth(1);
            g.setBackgroundColor(ColorConstants.white);
            g.fillRectangle(area);
            for (ColumnSection[] secondary : this.getSecondarySections()) {
                this.setConstraint((IFigure)secondary[0], area);
                secondary[0].setBounds(area);
            }
            g.setForegroundColor(ColorConstants.darkGray);
            g.setBackgroundColor(ColorConstants.gray);
            g.setLineWidth(1);
            g.drawLine(area.x + area.width + 1, area.y - 1, area.x + area.width + 1, area.y + area.height + 1);
            g.drawLine(area.x + area.width + 2, area.y - 2, area.x + area.width + 2, area.y + area.height + 2);
            g.drawLine(area.x + 1, area.y - 1, area.x + area.width + 1, area.y - 1);
            g.drawLine(area.x + 2, area.y - 2, area.x + area.width + 2, area.y - 2);
            if (this.selected) {
                g.setAlpha(200);
                g.setForegroundColor(ColorConstants.darkGray);
                int j = 0;
                while (j < area.height + area.width - 1) {
                    int x = area.x;
                    y = area.y + j;
                    w = x + area.width;
                    h = y - area.width;
                    while (h < area.y) {
                        h += 2;
                        w -= 2;
                    }
                    g.setLineWidth(2);
                    g.drawLine(x, y, w, h);
                    j += 4;
                }
            }
            g.drawRectangle(area);
        }
        g.setXORMode(false);
    }

    @Override
    public double getTotalPrimary() {
        return this.primaryTotalValue;
    }

    @Override
    public double getTotalSecondary() {
        return this.secondaryTotalValue;
    }

    public boolean containsPoint(int x, int y) {
        Rectangle area = this.getBounds().getCopy();
        area.y -= 5;
        area.height += 15;
        return area.contains(x, y);
    }

    @Override
    public void setModel(GraphModel model) {
        super.setModel(model);
        int i = 0;
        while (i < this.getChildren().size()) {
            ((ColumnSection)((Object)this.getChildren().get(i))).setModel(model);
            ++i;
        }
    }

    @Override
    public boolean isTwinAxis() {
        return !this.getSecondarySections().isEmpty();
    }

    public void addAssociatedPrimarySections(ColumnSection[] section) {
        this.getPrimarySubSections().add(section);
    }

    public void addPrimarySection(ColumnSection section) {
        this.getPrimarySubSections().add(new ColumnSection[]{section});
        this.add((IFigure)section);
    }

    public ArrayList<ColumnSection[]> getPrimarySubSections() {
        if (this.primarySubSections == null) {
            this.primarySubSections = new ArrayList();
        }
        return this.primarySubSections;
    }

    public void addAssociatedSecondarySections(ColumnSection[] section) {
        this.getSecondarySections().add(section);
    }

    public void addSecondarySection(ColumnSection section) {
        this.getSecondarySections().add(new ColumnSection[]{section});
        this.add((IFigure)section);
    }

    public ArrayList<ColumnSection[]> getSecondarySections() {
        if (this.secondarySubSections == null) {
            this.secondarySubSections = new ArrayList();
        }
        return this.secondarySubSections;
    }

    @Override
    public void setFocussed(boolean b) {
        super.setFocussed(b);
        for (ColumnSection[] section : this.getPrimarySubSections()) {
            section[0].setFocussed(b);
        }
        for (ColumnSection[] section : this.getSecondarySections()) {
            section[0].setFocussed(b);
        }
    }

    @Override
    public Image getUpArrow() {
        return ((CommonHistogram)this.getParent()).getUpArrow();
    }

    private boolean isCompact() {
        return this.model.getChartReference().getType().equals((Object)ChartType.COMPACT_HISTOGRAM);
    }

    @Override
    public String getAccesibilityName() {
        ColumnSection section;
        int n;
        int n2;
        ColumnSection[] columnSectionArray;
        ColumnSection[] sections;
        String aName = "";
        Iterator<ColumnSection[]> iterator = this.primarySubSections.iterator();
        while (iterator.hasNext()) {
            columnSectionArray = sections = iterator.next();
            n2 = sections.length;
            n = 0;
            while (n < n2) {
                section = columnSectionArray[n];
                aName = String.valueOf(aName) + section.getLabel() + ' ';
                ++n;
            }
        }
        if (this.secondarySubSections != null) {
            iterator = this.secondarySubSections.iterator();
            while (iterator.hasNext()) {
                columnSectionArray = sections = iterator.next();
                n2 = sections.length;
                n = 0;
                while (n < n2) {
                    section = columnSectionArray[n];
                    aName = String.valueOf(aName) + section.getLabel() + ' ';
                    ++n;
                }
            }
        }
        return aName;
    }
}

