/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.figures;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.pa.model.Column;
import com.ibm.cics.pa.model.definitions.ColumnContainment;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.figures.PieSlice;
import java.util.ArrayList;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.FlowPage;

public class PieSector
extends Figure {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(PieSector.class);
    private ArrayList<PieSlice> slices = new ArrayList();
    private int startAngle;
    private int relativeEndAngle;
    private int meanAngle;
    private int radius;
    private Point centrePoint;
    private int sliceEndAngle = 0;
    private FlowPage text = new FlowPage();
    private boolean selected = false;
    private String name;
    private Column column;
    private boolean emphasise;
    private ColumnContainment contain;
    private boolean isDonut = false;

    protected PieSector(int sectorAngle, int sectorEndAngle, String primaryLabel, ColumnContainment contain, Boolean isDonut) {
        debug.enter("PieSector");
        this.startAngle = sectorAngle;
        this.relativeEndAngle = sectorEndAngle;
        this.contain = contain;
        this.name = primaryLabel;
        this.meanAngle = sectorEndAngle / 2 + this.startAngle;
        this.column = Column.getFor(contain.getPrimary());
        this.isDonut = isDonut;
        debug.exit("PieSector");
    }

    protected void addSlices(ArrayList<PieSlice> slices) {
        debug.enter("addSlices");
        this.slices.addAll(slices);
        debug.exit("addSlices");
    }

    public void paintFigure(Graphics g) {
        super.paintFigure(g);
        int explodeRadius = Math.round(Math.min(this.getBounds().width, this.getBounds().height) / 20);
        this.radius = Math.round(Math.min(this.getClientArea().width, this.getBounds().height) * 7 / 16);
        Point centre = this.getBounds().getCenter();
        Point offsetStart = null;
        Point offsetEnd = null;
        this.centrePoint = centre.getCopy();
        this.centrePoint.x -= this.radius;
        this.centrePoint.y -= this.radius;
        if (this.meanAngle != 180) {
            int x = Math.round(Math.round((double)explodeRadius * Math.cos(Math.toRadians(this.meanAngle))));
            int y = -Math.round(Math.round((double)explodeRadius * Math.sin(Math.toRadians(this.meanAngle))));
            this.centrePoint.x += x;
            this.centrePoint.y += y;
            centre.x += x;
            centre.y += y;
        }
        Point startPoint = centre.getCopy();
        Point endPoint = centre.getCopy();
        Point midPoint = centre.getCopy();
        startPoint.x += Math.round(Math.round((double)this.radius * Math.cos(Math.toRadians(this.startAngle))));
        startPoint.y += -Math.round(Math.round((double)this.radius * Math.sin(Math.toRadians(this.startAngle))));
        endPoint.x += Math.round(Math.round((double)this.radius * Math.cos(Math.toRadians(this.relativeEndAngle + this.startAngle))));
        endPoint.y += -Math.round(Math.round((double)this.radius * Math.sin(Math.toRadians(this.relativeEndAngle + this.startAngle))));
        g.setForegroundColor(ColorConstants.gray);
        g.setLineWidth(1);
        if (this.getBounds().height > 100 || this.emphasise) {
            g.setLineWidth(3);
        }
        if (this.getBounds().height > 200) {
            g.setLineWidth(4);
        }
        midPoint = centre.getCopy();
        if (this.isDonut) {
            offsetStart = centre.getCopy();
            offsetEnd = centre.getCopy();
            offsetStart.x += (startPoint.x - offsetStart.x) / 2;
            offsetStart.y += (startPoint.y - offsetStart.y) / 2;
            offsetEnd.x += (endPoint.x - offsetEnd.x) / 2;
            offsetEnd.y += (endPoint.y - offsetEnd.y) / 2;
        }
        ++centre.x;
        --centre.y;
        ++startPoint.x;
        --startPoint.y;
        ++endPoint.x;
        --endPoint.y;
        g.setForegroundColor(this.isDonut ? this.column.getColor() : ColorConstants.lightGray);
        if (this.selected && this.getBounds().height > 200) {
            if (this.isDonut) {
                g.setForegroundColor(this.column.getColor());
            } else {
                g.setAlpha(100);
                g.setBackgroundPattern(Activator.getDefault().bluePattern);
            }
        } else if (!this.isDonut) {
            g.setBackgroundColor(this.column.getColor());
        }
        if (!this.fullCircle()) {
            g.setLineWidth(this.getBounds().height > 200 || this.emphasise ? 2 : 1);
            if (this.isDonut) {
                g.drawLine(offsetStart, startPoint);
                g.drawLine(offsetEnd, endPoint);
            } else {
                g.drawLine(centre, startPoint);
                g.drawLine(centre, endPoint);
            }
        }
        g.drawArc(this.centrePoint.x, this.centrePoint.y, this.radius * 2, this.radius * 2, this.startAngle, this.relativeEndAngle);
        if (this.isDonut && this.selected) {
            g.setBackgroundPattern(Activator.getDefault().greyPattern);
            g.fillArc(this.centrePoint.x, this.centrePoint.y, this.radius * 2, this.radius * 2, this.startAngle, this.relativeEndAngle);
        }
        g.setAlpha(75);
        g.fillArc(this.centrePoint.x, this.centrePoint.y, this.radius * 2, this.radius * 2, this.startAngle, this.relativeEndAngle);
        if (this.sliceEndAngle > 0 && this.sliceEndAngle < this.relativeEndAngle) {
            int alpha;
            if (this.selected) {
                g.setBackgroundPattern(Activator.getDefault().greyPattern);
                g.fillArc(this.centrePoint.x, this.centrePoint.y, 2 * this.radius, 2 * this.radius, this.startAngle, this.relativeEndAngle);
                if (this.isDonut) {
                    alpha = g.getAlpha();
                    g.setAlpha(255);
                    g.fillArc(this.centrePoint.x + this.radius / 2, this.centrePoint.y + this.radius / 2, this.radius, this.radius, this.startAngle, this.relativeEndAngle);
                    g.setAlpha(alpha);
                }
            } else if (this.startAngle != 0 || this.relativeEndAngle != 360) {
                g.setBackgroundColor(ColorConstants.listBackground);
                g.fillArc(this.centrePoint.x, this.centrePoint.y, 2 * this.radius, 2 * this.radius, this.startAngle + this.sliceEndAngle, this.relativeEndAngle - this.sliceEndAngle);
                if (this.isDonut) {
                    alpha = g.getAlpha();
                    g.setBackgroundColor(ColorConstants.listBackground);
                    g.setAlpha(255);
                    g.fillArc(this.centrePoint.x + this.radius / 2, this.centrePoint.y + this.radius / 2, this.radius, this.radius, this.startAngle + this.sliceEndAngle, this.relativeEndAngle - this.sliceEndAngle);
                    g.setAlpha(alpha);
                }
            }
        }
        for (PieSlice slice : this.slices) {
            slice.set(this.centrePoint, this.radius);
            slice.setBounds(this.getClientArea().getCopy());
        }
        if (this.isDonut) {
            int alpha = g.getAlpha();
            g.setAlpha(255);
            g.setBackgroundColor(ColorConstants.listBackground);
            g.fillArc(this.centrePoint.x + this.radius / 2, this.centrePoint.y + this.radius / 2, this.radius, this.radius, this.startAngle, this.relativeEndAngle);
            g.setAlpha(alpha);
            g.drawArc(this.centrePoint.x + this.radius / 2, this.centrePoint.y + this.radius / 2, this.radius, this.radius, this.startAngle, this.relativeEndAngle);
        } else {
            int decrement = this.radius / 4;
            g.setAlpha(150);
            g.setForegroundColor(ColorConstants.white);
            g.setLineWidth(2);
            g.drawArc(this.centrePoint.x + decrement / 2, this.centrePoint.y + decrement / 2, this.radius * 2 - decrement, this.radius * 2 - decrement, this.startAngle, this.relativeEndAngle);
            g.setForegroundColor(ColorConstants.lightGray);
            g.setLineWidth(1);
            g.drawArc(this.centrePoint.x + decrement / 2, this.centrePoint.y + decrement / 2, this.radius * 2 - decrement, this.radius * 2 - decrement, this.startAngle, this.relativeEndAngle);
        }
        midPoint.x += Math.round(Math.round((double)this.radius * Math.cos(Math.toRadians(this.meanAngle))));
        midPoint.y += -Math.round(Math.round((double)this.radius * Math.sin(Math.toRadians(this.meanAngle))));
        if (midPoint.x + 100 > this.getClientArea().width) {
            midPoint.x = this.getClientArea().width - 100;
        }
        if (this.meanAngle > 45 && this.meanAngle < 90) {
            midPoint.y -= 20;
        }
        if (this.meanAngle > 90 && this.meanAngle < 270) {
            midPoint.x -= 50;
            if (midPoint.x < 0) {
                midPoint.x = 1;
            }
        }
        if (this.meanAngle > 180 && midPoint.x < 0) {
            midPoint.x = 1;
        }
        this.text.setBounds(new Rectangle(midPoint.x, midPoint.y, 150, 15));
    }

    private boolean fullCircle() {
        return this.startAngle == 0 && this.relativeEndAngle == 360;
    }

    public boolean containsPoint(int x, int y) {
        if (this.radius == 0) {
            return false;
        }
        int yDif = this.centrePoint.y + this.radius - y;
        int xDif = x - this.centrePoint.x - this.radius;
        if (xDif != 0 && yDif != 0) {
            double angle = Math.toDegrees(Math.atan2(yDif, xDif));
            if (angle < 0.0) {
                angle += 360.0;
            }
            return (double)this.startAngle <= angle && (double)(this.relativeEndAngle + this.startAngle) >= angle && xDif < this.radius && yDif < this.radius;
        }
        return false;
    }

    protected FlowPage getText() {
        return this.text;
    }

    protected void updateSliceAngles(int sliceEndAngle) {
        this.sliceEndAngle = sliceEndAngle;
    }

    protected boolean isSelected() {
        return this.selected;
    }

    protected void setSelected(boolean selected) {
        this.selected = selected;
        for (PieSlice slice : this.slices) {
            slice.parentSelected(selected);
        }
    }

    public String getName() {
        return this.name;
    }

    public int getStartAngle() {
        return this.startAngle;
    }

    public int getRelativeEndAngle() {
        return this.relativeEndAngle;
    }

    protected void setPieSelected(boolean selected) {
        this.emphasise = selected;
    }

    protected ColumnContainment getColumnContainment() {
        return this.contain;
    }

    public String toString() {
        return this.name;
    }
}

