/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.figures;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.pa.model.PlotModel;
import com.ibm.cics.pa.model.PlotPoint;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.figures.IIntervalColumnFigure;
import com.ibm.cics.pa.ui.figures.IntervalFigureFactory;
import com.ibm.cics.pa.ui.figures.IntervalPlotTooltip;
import com.ibm.cics.pa.ui.figures.SingleIntervalFigure;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.graphics.Color;

public class IntervalPlotFigure
extends Figure
implements ISelectionProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(IntervalPlotFigure.class);
    SingleIntervalFigure currentlySelected;
    private FigureCanvas canvas;
    PlotModel model;
    private boolean hasFocus;
    private List<SingleIntervalFigure> intervalFigureChildren;
    private List<BarFigure> barFigureChildren;
    private List<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();
    private Color colour;

    public IntervalPlotFigure(Color aNiceColour, FigureCanvas figureCanvas, PlotModel model) {
        debug.enter("IntervalPlotFigure", (Object)model);
        this.colour = aNiceColour;
        this.initialise(model);
        this.canvas = figureCanvas;
        this.setLayoutManager((LayoutManager)new XYLayout());
        this.accessibility(figureCanvas);
        debug.exit("IntervalPlotFigure");
    }

    public void initialise(PlotModel model) {
        this.model = model;
        this.removeAll();
        if (this.model.getElements().length > 0) {
            this.intervalFigureChildren = new ArrayList<SingleIntervalFigure>();
            this.barFigureChildren = new ArrayList<BarFigure>();
            int i = 0;
            while (i < this.model.getElements().length) {
                ColumnDefinition[] definitions;
                ColumnDefinition[] labels = this.model.getElements()[i].getToolTipLabels();
                SingleIntervalFigure latest = IntervalFigureFactory.getInstance().render(this, this.model.getElements()[i], this.colour, labels);
                if (i == 0) {
                    this.currentlySelected = latest;
                }
                this.add(latest);
                this.intervalFigureChildren.add(latest);
                ColumnDefinition[] columnDefinitionArray = definitions = this.model.isPercentages() ? this.model.getPercentagesOf().toArray(new ColumnDefinition[this.model.getPercentagesOf().size()]) : this.model.getPlotLines().toArray(new ColumnDefinition[this.model.getPlotLines().size()]);
                if (this.model.isDSARecord()) {
                    switch (this.model.getDSAType()) {
                        case DSA: {
                            definitions = new ColumnDefinition[]{ColumnDefinition.TRAN_MXT, ColumnDefinition.DSA_LIMIT};
                            break;
                        }
                        case EDSA: {
                            definitions = new ColumnDefinition[]{ColumnDefinition.TRAN_MXT, ColumnDefinition.EDSA_LIMIT};
                            break;
                        }
                        default: {
                            definitions = new ColumnDefinition[]{ColumnDefinition.TRAN_MXT, ColumnDefinition.MEMLIMIT_SIZE};
                        }
                    }
                }
                if (this.model.getElements()[i].getPlotLineArray().length > 0) {
                    PlotModel.PlotModelElement element = this.model.getElements()[i];
                    long[] values = element.getPlotLineArray();
                    long val = element.isPercentage() ? 100L : values[0];
                    BarFigure barFigure = new BarFigure(val);
                    barFigure.setToolTip((IFigure)new IntervalPlotTooltip(element, this.colour, definitions, Messages.getString("Threshold.title")));
                    this.add((IFigure)barFigure);
                    this.barFigureChildren.add(barFigure);
                }
                ++i;
            }
        }
    }

    public void paint(Graphics graphics) {
        Rectangle clientArea = this.getBounds().getCopy();
        clientArea.height = this.getPreferredSize().height;
        clientArea.width = this.getPreferredSize().width;
        if (!this.canvas.isDisposed()) {
            clientArea.x -= this.canvas.getViewport().getClientArea().x;
        }
        int currentIncrement = 0;
        for (SingleIntervalFigure child : this.getIntervalFigureChildren()) {
            this.setConstraint(child, new Rectangle(clientArea.x + currentIncrement, clientArea.y, 64, clientArea.height));
            currentIncrement += 64;
        }
        currentIncrement = 0;
        clientArea.height -= 64;
        clientArea.y += 64;
        double rangeFactor = (this.getHighRange() - this.getLowRange()) / (double)clientArea.height;
        for (BarFigure child : this.getBarFigureChildren()) {
            int position = Math.round(Math.round(((double)child.getValue() - this.getLowRange()) / rangeFactor));
            this.setConstraint((IFigure)child, new Rectangle(clientArea.x + currentIncrement, clientArea.y + clientArea.height - position - 2, 64, 4));
            currentIncrement += 64;
        }
        super.paint(graphics);
        int threshold = Math.round(Math.round((100.0 - this.getLowRange()) / rangeFactor));
        this.localPaint(graphics, clientArea, rangeFactor, threshold);
    }

    public boolean isSelected(SingleIntervalFigure intervalFigure) {
        return this.currentlySelected == intervalFigure;
    }

    public double getThreashold() {
        return this.model.getThreshold();
    }

    public double getHighRange() {
        return this.getThreashold() * 1.2;
    }

    public double getLowRange() {
        return 0.0;
    }

    protected boolean useLocalCoordinates() {
        return true;
    }

    public SingleIntervalFigure moveSelection(boolean asc) {
        int i = 0;
        while (i < this.getIntervalFigureChildren().size()) {
            if (this.currentlySelected == this.getIntervalFigureChildren().get(i)) {
                if (asc && i + 1 < this.getIntervalFigureChildren().size()) {
                    return this.setSelected1(this.getIntervalFigureChildren().get(i + 1));
                }
                if (!asc && i > 0) {
                    return this.setSelected1(this.getIntervalFigureChildren().get(i - 1));
                }
            }
            ++i;
        }
        return null;
    }

    private SingleIntervalFigure setSelected1(IFigure figure) {
        return this.setSelected(figure);
    }

    public SingleIntervalFigure setSelected(IFigure figure) {
        debug.enter("setSelected", (Object)figure);
        this.currentlySelected = (SingleIntervalFigure)figure;
        this.repaint();
        this.canvas.getAccessible().selectionChanged();
        this.canvas.getAccessible().setFocus(this.getCurrentSelectionDisplacement());
        this.setSelection((ISelection)new StructuredSelection((Object)this.currentlySelected.getElement()));
        debug.exit("setSelected");
        return (SingleIntervalFigure)figure;
    }

    public int reveal(IFigure target) {
        debug.enter("reveal", (Object)target);
        Viewport port = this.canvas.getViewport();
        int original = port.getViewLocation().x;
        Rectangle exposeRegion = target.getBounds().getCopy();
        if (port.containsPoint(exposeRegion.x, exposeRegion.y) && port.containsPoint(exposeRegion.x + exposeRegion.width, exposeRegion.y + exposeRegion.height)) {
            debug.exit("reveal", (Object)0);
            return 0;
        }
        IFigure revisedTarget = target.getParent();
        while (revisedTarget != null && revisedTarget != port) {
            revisedTarget.translateToParent((Translatable)exposeRegion);
            revisedTarget = revisedTarget.getParent();
        }
        exposeRegion.expand(0, 0);
        Point topLeft = exposeRegion.getTopLeft();
        Point finalLocation = new Point();
        finalLocation.x = Math.min(topLeft.x, Math.max(topLeft.x, port.getViewLocation().x));
        this.canvas.scrollSmoothTo(finalLocation.x, 0);
        debug.exit("reveal", (Object)(finalLocation.x - original));
        return finalLocation.x - original;
    }

    private void localPaint(Graphics graphics, Rectangle clientArea, double rangeFactor, int threshold) {
        clientArea.width = 64;
        Point[] starts = new Point[this.model.getPlotPoints().size()];
        Point[] ends = new Point[this.model.getPlotPoints().size()];
        if (this.model.getElements().length > 0 && this.model.getElements()[0].isPercentage()) {
            graphics.drawText(Messages.getString("Threshold.title"), clientArea.x, clientArea.y + clientArea.height - threshold - 20);
        }
        int i = 0;
        PlotModel.PlotModelElement[] plotModelElementArray = this.model.getElements();
        int n = plotModelElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            PlotModel.PlotModelElement element = plotModelElementArray[n2];
            long[] values = element.getPlotPointArray();
            int j = 0;
            while (j < this.model.getPlotPoints().size()) {
                PlotPoint point = this.model.getPlotPoints().get(j);
                int position = Math.round(Math.round(((double)values[j] - this.getLowRange()) / rangeFactor));
                ends[j] = new Point(clientArea.x + 32, clientArea.y + clientArea.height - position);
                if (!(starts[j] == null || IntervalFigureFactory.DISPLAY_AS_COLUMNS.contains(point.getPlotReference()) || IntervalFigureFactory.DISPLAY_AS_USED.contains(point.getPlotReference()) || IntervalFigureFactory.DISPLAY_AS_PROGRAMS.contains(point.getPlotReference()) || IntervalFigureFactory.DISPLAY_AS_LEVEL.contains(point.getPlotReference()) || IntervalFigureFactory.DISPLAY_AS_STORAGE.contains(point.getPlotReference()))) {
                    this.paintTrace(graphics, starts, ends, j, i + 1 == this.getIntervalFigureChildren().size());
                }
                starts[j] = new Point(ends[j].x, ends[j].y);
                ++j;
            }
            values = element.getPlotLineArray();
            graphics.setAlpha(150);
            graphics.setLineWidth(2);
            if (values.length != 0) {
                j = 0;
                while (j < this.model.getPlotLines().size()) {
                    ++j;
                }
            }
            clientArea.x += 64;
            ++i;
            ++n2;
        }
    }

    public void setModel(PlotModel model) {
        this.model = model;
    }

    public SingleIntervalFigure setInitialSelected() {
        if (this.getIntervalFigureChildren().size() == 0) {
            return null;
        }
        this.currentlySelected = this.getIntervalFigureChildren().get(this.model.getInitialSelection());
        this.setSelection((ISelection)new StructuredSelection((Object)this.currentlySelected.getElement()));
        return this.currentlySelected;
    }

    public void setSelectLast() {
        this.setSelected1(this.getIntervalFigureChildren().get(this.getIntervalFigureChildren().size() - 1));
    }

    public void setSelectFirst() {
        this.setSelected1(this.getIntervalFigureChildren().get(0));
    }

    public void setBounds(Rectangle bounds) {
        super.setBounds(bounds);
    }

    public void showFocusColumn(boolean b) {
        this.hasFocus = b;
        this.setSelected(this.currentlySelected);
    }

    public boolean hasFocusColumn() {
        return this.hasFocus;
    }

    public PlotModel.PlotModelElement getCurrentElement() {
        return this.currentlySelected.getElement();
    }

    public int getCurrentSelectionDisplacement() {
        int i = 0;
        while (i < this.getIntervalFigureChildren().size()) {
            if (this.getIntervalFigureChildren().get(i) == this.currentlySelected) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void forceRepaint() {
        for (SingleIntervalFigure figure : this.getIntervalFigureChildren()) {
            if (!(figure instanceof IIntervalColumnFigure)) continue;
            ((IIntervalColumnFigure)figure).forceRepaint();
        }
        this.repaint();
    }

    public void accessibility(FigureCanvas figureCanvas) {
        figureCanvas.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID > -1 && e.childID < IntervalPlotFigure.this.getIntervalFigureChildren().size()) {
                    e.result = IntervalPlotFigure.this.getIntervalFigureChildren().get(e.childID).getElement().getAccessibleLabel();
                }
            }

            public void getDescription(AccessibleEvent e) {
            }
        });
        figureCanvas.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = IntervalPlotFigure.this.model.getElements().length;
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle clientArea = e.childID > -1 ? ((IFigure)IntervalPlotFigure.this.getIntervalFigureChildren().get(e.childID)).getBounds() : IntervalPlotFigure.this.getBounds();
                e.x = clientArea.x;
                e.y = clientArea.y;
                e.width = clientArea.width;
                e.height = clientArea.height;
            }

            public void getChildren(AccessibleControlEvent e) {
                ArrayList<Integer> ints = new ArrayList<Integer>();
                int i = 0;
                while (i < IntervalPlotFigure.this.model.getElements().length) {
                    ints.add(i);
                    ++i;
                }
                e.children = ints.toArray();
            }

            public void getSelection(AccessibleControlEvent e) {
                e.childID = -2;
                int i = 0;
                while (i < IntervalPlotFigure.this.getIntervalFigureChildren().size()) {
                    if (IntervalPlotFigure.this.getIntervalFigureChildren().get(i) == IntervalPlotFigure.this.currentlySelected) {
                        e.childID = i;
                    }
                    ++i;
                }
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = e.childID == -1 ? 33 : 34;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 4;
            }

            public void getFocus(AccessibleControlEvent e) {
                e.childID = -2;
                int i = 0;
                while (i < IntervalPlotFigure.this.getIntervalFigureChildren().size()) {
                    if (IntervalPlotFigure.this.getIntervalFigureChildren().get(i) == IntervalPlotFigure.this.currentlySelected) {
                        e.childID = i;
                    }
                    ++i;
                }
            }

            public void getValue(AccessibleControlEvent e) {
            }
        });
    }

    private void paintTrace(Graphics graphics, Point[] starts, Point[] ends, int line, boolean lastOne) {
        switch (line) {
            case 0: {
                graphics.setLineStyle(1);
                break;
            }
            case 1: {
                graphics.setLineStyle(3);
                break;
            }
            case 2: {
                graphics.setLineStyle(4);
                break;
            }
            case 3: {
                graphics.setLineStyle(5);
                break;
            }
            default: {
                graphics.setLineStyle(1);
            }
        }
        graphics.setForegroundColor(this.model.getPlotPointColour(line));
        graphics.setBackgroundColor(this.model.getPlotPointColour(line));
        graphics.drawLine(starts[line], ends[line]);
        this.paintIcon(graphics, starts[line], line);
        if (lastOne) {
            this.paintIcon(graphics, ends[line], line);
        }
    }

    private void paintIcon(Graphics graphics, Point point, int line) {
        switch (line) {
            case 0: {
                graphics.fillRectangle(point.x - 4, point.y - 4, 8, 8);
                break;
            }
            case 1: {
                graphics.fillOval(point.x - 4, point.y - 4, 8, 8);
                break;
            }
            case 2: {
                graphics.fillPolygon(new int[]{point.x, point.y - 4, point.x + 4, point.y, point.x, point.y + 4, point.x - 4, point.y});
                break;
            }
            case 3: {
                graphics.fillArc(point.x - 4, point.y - 4, 8, 8, 180, 90);
                break;
            }
            default: {
                graphics.fillArc(point.x - 4, point.y - 4, 8, 8, 270, 90);
            }
        }
    }

    List<SingleIntervalFigure> getIntervalFigureChildren() {
        return this.intervalFigureChildren;
    }

    private List<BarFigure> getBarFigureChildren() {
        return this.barFigureChildren;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public ISelection getSelection() {
        return new StructuredSelection((Object)this.currentlySelected.getElement());
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        final SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        Iterator<ISelectionChangedListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ISelectionChangedListener listener;
            final ISelectionChangedListener finalListener = listener = iterator.next();
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    finalListener.selectionChanged(event);
                }
            });
        }
    }

    class BarFigure
    extends Figure {
        private long value;

        public BarFigure(long val) {
            this.value = val;
        }

        protected long getValue() {
            return this.value;
        }

        public void paint(Graphics graphics) {
            Rectangle clientArea = this.getBounds().getCopy();
            clientArea.height = this.getPreferredSize().height;
            clientArea.width = this.getPreferredSize().width;
            PlotModel.PlotModelElement element = IntervalPlotFigure.this.model.getElements()[0];
            long[] values = element.getPlotPointArray();
            graphics.setAlpha(150);
            graphics.setLineWidth(2);
            if (values.length != 0) {
                int j = 0;
                while (j < IntervalPlotFigure.this.model.getPlotLines().size()) {
                    graphics.setForegroundColor(element.getParent().getPlotLineColour(0));
                    graphics.setLineStyle(1);
                    Point st = new Point(clientArea.x + 1, clientArea.y);
                    Point end = new Point(clientArea.x + 64, clientArea.y);
                    graphics.drawLine(st, end);
                    st = new Point(clientArea.x + 1, clientArea.y + clientArea.height);
                    end = new Point(clientArea.x + 64, clientArea.y + clientArea.height);
                    graphics.drawLine(st, end);
                    ++j;
                }
            }
            clientArea.x += 64;
            super.paint(graphics);
        }
    }
}

