/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.figures;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.pa.model.PlotModel;
import com.ibm.cics.pa.model.PlotPoint;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.figures.DSASingleIntervalFigure;
import com.ibm.cics.pa.ui.figures.IntervalPlotFigure;
import com.ibm.cics.pa.ui.figures.SingleIntervalFigure;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.graphics.Color;

public class IntervalFigureFactory {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(IntervalFigureFactory.class);
    public static final List<ColumnDefinition> DISPLAY_AS_COLUMNS = Arrays.asList(ColumnDefinition.DSA_TOTAL_PEAK, ColumnDefinition.EDSA_TOTAL_PEAK, ColumnDefinition.PEAK_GDSA_ACTIVE);
    public static final List<ColumnDefinition> DIVISOR = Arrays.asList(ColumnDefinition.DSA_LIMIT, ColumnDefinition.EDSA_LIMIT, ColumnDefinition.MEMLIMIT_SIZE);
    public static final List<ColumnDefinition> DISPLAY_AS_USED = Arrays.asList(ColumnDefinition.DSA_SIZE_USED, ColumnDefinition.EDSA_SIZE_USED, ColumnDefinition.GDSA_SIZE_USED);
    public static final List<ColumnDefinition> DISPLAY_AS_PROGRAMS = Arrays.asList(ColumnDefinition.DSA_SIZE_PGMS, ColumnDefinition.EDSA_SIZE_PGMS);
    public static final List<ColumnDefinition> DISPLAY_AS_LEVEL = Arrays.asList(ColumnDefinition.DSA_CURRENT_TOTAL, ColumnDefinition.EDSA_CURRENT_TOTAL, ColumnDefinition.CURRENT_ACTIV_GDSA, ColumnDefinition.DSA_SIZE_USED, ColumnDefinition.DSA_SIZE_USED_PERCENT, ColumnDefinition.EDSA_SIZE_USED, ColumnDefinition.EDSA_SIZE_USED_PERCENT, ColumnDefinition.GDSA_SIZE_USED, ColumnDefinition.GDSA_SIZE_USED_PERCENT);
    public static final List<ColumnDefinition> DISPLAY_AS_STORAGE = Arrays.asList(ColumnDefinition.CDSA, ColumnDefinition.UDSA, ColumnDefinition.SDSA, ColumnDefinition.RDSA, ColumnDefinition.ECDSA, ColumnDefinition.EUDSA, ColumnDefinition.ESDSA, ColumnDefinition.ERDSA, ColumnDefinition.GCDSA, ColumnDefinition.GUDSA, ColumnDefinition.GSDSA, ColumnDefinition.ETDSA);
    private static IntervalFigureFactory instance = new IntervalFigureFactory();

    private IntervalFigureFactory() {
    }

    public static IntervalFigureFactory getInstance() {
        return instance;
    }

    public SingleIntervalFigure render(IntervalPlotFigure intervalPlotFigure, PlotModel.PlotModelElement plotModelElement, Color aNiceColour, ColumnDefinition[] labels) {
        debug.enter("render");
        SingleIntervalFigure figure = null;
        if (plotModelElement.getParent().isDSARecord() || plotModelElement.getParent().isSMTRecord() || plotModelElement.getParent().isLDGDSARecord()) {
            plotModelElement.getDSAPackets();
            figure = new DSASingleIntervalFigure(intervalPlotFigure, plotModelElement, aNiceColour, plotModelElement.getDSAHeadings());
        } else {
            figure = new SingleIntervalFigure(intervalPlotFigure, plotModelElement, aNiceColour, labels);
            if (plotModelElement.getParent().isSMSRecord()) {
                long[] values = plotModelElement.getPlotPointArray();
                int j = 0;
                while (j < plotModelElement.getParent().getPlotPoints().size()) {
                    PlotPoint point = plotModelElement.getParent().getPlotPoints().get(j);
                    int x = 0;
                    while (x < DISPLAY_AS_COLUMNS.size()) {
                        if (point.getPlotReference() == DISPLAY_AS_COLUMNS.get(x)) {
                            int k = 0;
                            while (k < plotModelElement.getParent().getPlotPoints().size()) {
                                if (plotModelElement.getParent().getPlotPoints().get(k).getPlotReference() == DISPLAY_AS_LEVEL.get(x)) {
                                    plotModelElement.resolveSMSSubValues(DISPLAY_AS_USED.get(x));
                                    Object value = plotModelElement.getValueMap().get(DISPLAY_AS_USED.get(x));
                                    Object divisor = plotModelElement.getValueMap().get(DIVISOR.get(x));
                                    long usedValue = value != null ? Math.round((double)(((Number)value).floatValue() / ((Number)divisor).floatValue() * 100.0f) + 0.5) : -1L;
                                    figure.createSiblingColumn(plotModelElement, x, values[j], values[k], usedValue, -1L, DISPLAY_AS_COLUMNS.get(x), DISPLAY_AS_LEVEL.get(x), DISPLAY_AS_USED.get(x), null);
                                }
                                ++k;
                            }
                        }
                        ++x;
                    }
                    ++j;
                }
            } else if (plotModelElement.getParent().isLDGRecord()) {
                long[] values = plotModelElement.getPlotPointArray();
                int j = 0;
                while (j < plotModelElement.getParent().getPlotPoints().size()) {
                    PlotPoint point = plotModelElement.getParent().getPlotPoints().get(j);
                    int x = 0;
                    while (x < DISPLAY_AS_COLUMNS.size()) {
                        if (point.getPlotReference() == DISPLAY_AS_COLUMNS.get(x)) {
                            int k = 0;
                            while (k < plotModelElement.getParent().getPlotPoints().size()) {
                                if (plotModelElement.getParent().getPlotPoints().get(k).getPlotReference() == DISPLAY_AS_LEVEL.get(x)) {
                                    plotModelElement.resolveLDGSubValues(DISPLAY_AS_PROGRAMS.get(x));
                                    Object valuep = plotModelElement.getValueMap().get(DISPLAY_AS_PROGRAMS.get(x));
                                    Object valueu = plotModelElement.getValueMap().get(DISPLAY_AS_USED.get(x));
                                    Object divisor = plotModelElement.getValueMap().get(DIVISOR.get(x));
                                    long pgmsValue = valuep != null ? (long)Math.round(((Number)valuep).floatValue() / ((Number)divisor).floatValue() * 100.0f) : -1L;
                                    long usedValue = valueu != null ? Math.round((double)(((Number)valueu).floatValue() / ((Number)divisor).floatValue() * 100.0f) + 0.5) : -1L;
                                    figure.createSiblingColumn(plotModelElement, x, values[j], values[k], usedValue, pgmsValue, DISPLAY_AS_COLUMNS.get(x), DISPLAY_AS_LEVEL.get(x), DISPLAY_AS_USED.get(x), DISPLAY_AS_PROGRAMS.get(x));
                                }
                                ++k;
                            }
                        }
                        ++x;
                    }
                    ++j;
                }
            }
        }
        debug.exit("render", (Object)figure);
        return figure;
    }
}

