/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.figures;

import com.ibm.cics.pa.model.Column;
import com.ibm.cics.pa.model.GraphModel;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.figures.ChartSelectable;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;

public class ColumnSection
extends Figure {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ColumnDefinition keyColumn;
    private double value;
    private GraphModel model;
    private double start;
    private Rectangle currentBar;
    private boolean focussed = false;
    private String label = null;
    private boolean isTot = false;

    public ColumnSection(ColumnDefinition keyColumn, double startValue, double value) {
        this.keyColumn = keyColumn;
        this.value = value;
        this.start = startValue;
        Label tooltip = new Label(this.toString());
        tooltip.setIcon(Column.getFor(keyColumn).getImage());
    }

    public ColumnDefinition getKeyColumn() {
        return this.keyColumn;
    }

    public double getValue() {
        return this.value;
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.model != null) {
            this.setFocusTraversable(true);
            Rectangle clientArea = this.getClientArea();
            g.setBackgroundColor(Column.getFor(this.keyColumn).getColor());
            g.setForegroundColor(Column.getFor(this.keyColumn).getColor());
            g.setAlpha(150);
            if (this.isTot) {
                g.setAlpha(0);
            }
            int height = Math.round(Math.round(Double.valueOf(this.value) * this.model.primaryScalingFactor));
            int startheight = Math.round(Math.round(Double.valueOf(this.start) * this.model.primaryScalingFactor));
            this.currentBar = new Rectangle(clientArea.x + 1, clientArea.y + clientArea.height - startheight - height, this.model.barWidth - 1, height);
            if (this.focussed) {
                this.currentBar.shrink(2, 0);
            }
            g.fillRectangle(this.currentBar);
            if (clientArea.y + clientArea.height - startheight - height < 0 && !this.model.isCompact()) {
                g.drawImage(this.getUpArrow(), new Point(clientArea.x + this.model.barWidth / 2 - 8, this.model.getTopMargin()));
            }
        }
    }

    private Image getUpArrow() {
        return ((ChartSelectable)this.getParent()).getUpArrow();
    }

    public void setModel(GraphModel model) {
        this.model = model;
        this.setPreferredSize(model.barWidth, 100);
    }

    protected boolean useLocalCoordinates() {
        return false;
    }

    public String toString() {
        return this.getLabel();
    }

    public boolean containsPoint(int x, int y) {
        return this.currentBar != null && this.currentBar.x < x && this.currentBar.x + this.currentBar.width > x && this.currentBar.y < y && this.currentBar.y + this.currentBar.height > y;
    }

    public void setFocussed(boolean setting) {
        this.focussed = setting;
    }

    public String getLabel() {
        if (this.label == null) {
            Number val = this.getValue();
            if (val == (double)((Number)val).intValue()) {
                val = ((Number)val).intValue();
            }
            this.label = String.valueOf(this.keyColumn.getLabel(null)) + "=" + DataTypeUtilities.getAsString(val);
        }
        return this.label;
    }

    public void isTotal() {
        this.isTot = true;
        Number val = this.value;
        if (val.doubleValue() == (double)val.intValue()) {
            val = val.intValue();
        }
        this.label = String.valueOf(Messages.getString("ColumnSection.Other")) + DataTypeUtilities.getAsString(val);
        val = this.value + this.start;
        if (val.doubleValue() == (double)val.intValue()) {
            val = val.intValue();
        }
        this.label = String.valueOf(this.label) + "\n" + this.keyColumn.getLabel(null) + Messages.getString("ColumnSection.Equal") + DataTypeUtilities.getAsString(val);
        this.setToolTip((IFigure)new Label(this.toString()));
    }
}

