/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.figures;

import com.ibm.cics.pa.model.GraphModel;
import com.ibm.cics.pa.model.IUniqueRecord;
import com.ibm.cics.pa.model.definitions.ChartSpecification;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.DataProviderKey;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.Figure;
import org.eclipse.swt.graphics.Image;

public abstract class ChartSelectable
extends Figure
implements IAdaptable {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final Logger logger = Logger.getLogger("com.ibm.cics.pa.ui");
    private IUniqueRecord modelRef = null;
    private ChartSpecification chartReference;
    protected boolean focussed = false;
    protected boolean selected = false;
    protected GraphModel model;

    public ChartSelectable(IUniqueRecord viewModel, ChartSpecification chartReference) {
        this.modelRef = viewModel;
        this.chartReference = chartReference;
    }

    public Object[] getDataRow() {
        return this.modelRef.getRow();
    }

    public String getLabel() {
        return (String)this.modelRef.getLabel();
    }

    public static int getColumnPosition(ColumnDefinition[] columnDefinitions, ColumnDefinition columnLookup) {
        int column = -1;
        int i = 0;
        while (i < columnDefinitions.length) {
            if (columnLookup.equals(columnDefinitions[i])) {
                return i;
            }
            ++i;
        }
        return column;
    }

    public void setSelected(boolean setting) {
        this.selected = setting;
    }

    public ChartSpecification getChartReference() {
        return this.chartReference;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public boolean matchesOn(Object[] row) {
        DataProviderKey structureKey = this.getModel().getDataProvider().getDataProviderKey();
        int[] relativeColumns = this.getModel().getDataProvider().getColumnPositions(structureKey);
        boolean pass = true;
        int i = 0;
        while (i < relativeColumns.length && pass) {
            pass = this.getDataRow()[i].equals(row[i]);
            ++i;
        }
        return pass;
    }

    public void setFocussed(boolean b) {
        this.focussed = b;
    }

    public GraphModel getModel() {
        return this.model;
    }

    public void setModel(GraphModel model) {
        this.model = model;
    }

    public String getId() {
        return this.getLabel();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public String toString() {
        return "ChartSelectable " + this.getLabel() + " " + this.bounds.toString();
    }

    public IUniqueRecord getUniqueRecord() {
        return this.modelRef;
    }

    public boolean isTwinAxis() {
        return false;
    }

    public abstract double getTotalPrimary();

    public abstract double getTotalSecondary();

    public abstract Image getUpArrow();

    public abstract String getAccesibilityName();
}

