/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.editors;

import com.ibm.cics.pa.model.ChartingFile;
import com.ibm.cics.pa.model.GenericDataProvider;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.handlers.SpreadSheetHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorLauncher;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class SheetViewLauncher
implements IEditorLauncher {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2010, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final Logger logger = Logger.getLogger("com.ibm.cics.pa.ui");

    public void open(IPath file) {
        IWorkspace workspace;
        IFile[] fil;
        if (file.getFileExtension().equalsIgnoreCase("csv") && (fil = (workspace = ResourcesPlugin.getWorkspace()).getRoot().findFilesForLocationURI(URIUtil.toURI((IPath)file))).length == 1) {
            Job job = new Job(Messages.getString("Locating.records")){

                protected IStatus run(IProgressMonitor monitor) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                GenericDataProvider provider = ChartingFile.getReference(fil[0]);
                                String id = provider.getFileReference();
                                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.ibm.cics.pa.ui.sheeteditor_multi", id, 2);
                            }
                            catch (PartInitException e) {
                                logger.logp(Level.SEVERE, SpreadSheetHandler.class.getName(), "SheetViewLauncher", "Part initialization", e);
                            }
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(20);
            job.schedule();
        }
    }
}

