/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.editors;

import com.ibm.cics.pa.model.ChartingFile;
import com.ibm.cics.pa.model.GenericDataProvider;
import com.ibm.cics.pa.ui.views.SheetView;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;

public class PAResourceChangeListener
implements IResourceChangeListener {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger("com.ibm.cics.pa.ui");
    IViewPart viewer = null;
    IPath path = null;
    GenericDataProvider inputFile = null;

    public PAResourceChangeListener(IViewPart viewer, IPath path) {
        this.viewer = viewer;
        this.path = path;
    }

    public PAResourceChangeListener(GenericDataProvider inputFile, IPath path) {
        this.inputFile = inputFile;
        this.path = path;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        switch (event.getType()) {
            case 2: 
            case 4: {
                if (this.path == null || !event.getResource().getLocation().isPrefixOf(this.path)) break;
                this.closeIt();
                break;
            }
            case 1: {
                try {
                    event.getDelta().accept(new IResourceDeltaVisitor(){

                        public boolean visit(IResourceDelta delta) throws CoreException {
                            switch (delta.getKind()) {
                                case 1: {
                                    break;
                                }
                                case 2: 
                                case 4: 
                                case 4096: {
                                    if (PAResourceChangeListener.this.path == null || !PAResourceChangeListener.this.path.equals((Object)delta.getResource().getLocation())) break;
                                    PAResourceChangeListener.this.closeIt();
                                }
                            }
                            return true;
                        }
                    });
                    break;
                }
                catch (CoreException e) {
                    logger.logp(Level.SEVERE, PAResourceChangeListener.class.getName(), "resourceChanged", "ChartEditor interpretting resource change events: ", e);
                }
            }
        }
    }

    void closeIt() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (PAResourceChangeListener.this.viewer != null) {
                    if (PAResourceChangeListener.this.viewer.getSite().getId().equals("com.ibm.cics.pa.ui.sheeteditor")) {
                        ((SheetView)PAResourceChangeListener.this.viewer).removeAll();
                    } else {
                        PAResourceChangeListener.this.viewer.getSite().getPage().hideView(PAResourceChangeListener.this.viewer);
                    }
                }
                if (PAResourceChangeListener.this.inputFile != null) {
                    ((ChartingFile)PAResourceChangeListener.this.inputFile).dispose();
                }
            }
        });
    }
}

