/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.dialogs;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.eclipse.common.ui.TextInput;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.utilities.LayoutImportExportUtils;
import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ExportLayoutsDialog
extends TitleAreaDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(ExportLayoutsDialog.class);
    public static String LAST_EXPORT_FILE = "LAST_EXPORT_FILE";
    Text locationText;

    public ExportLayoutsDialog(Shell shell) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("LayoutExportDialog_text"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        this.setTitle(Messages.getString("LayoutExportDialog_title"));
        this.setMessage(Messages.getString("LayoutExportDialog_msg"));
        Composite childArea = new Composite(c, 0);
        GridData data = new GridData(1808);
        childArea.setLayoutData((Object)data);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginRight = 10;
        gridLayout.marginLeft = 10;
        gridLayout.marginTop = 10;
        childArea.setLayout((Layout)gridLayout);
        Label l = new Label(childArea, 0);
        l.setText(Messages.getString("FileLocation"));
        data = new GridData(4, 0x1000000, false, false);
        l.setLayoutData((Object)data);
        this.locationText = new Text(childArea, 2048);
        TextInput.setAccessibleLabel((Text)this.locationText, (Label)l);
        data = new GridData(4, 0x1000000, true, false);
        this.locationText.setLayoutData((Object)data);
        Button browseButton = new Button(childArea, 8);
        browseButton.setText(Messages.getString("SampleNewCSVPage.browse"));
        data = new GridData(4, 0x1000000, false, false);
        browseButton.setLayoutData((Object)data);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(ExportLayoutsDialog.this.getShell(), 8192);
                fd.setOverwrite(true);
                fd.setFilterExtensions(new String[]{"*.lpref"});
                String file = fd.open();
                if (file != null) {
                    ExportLayoutsDialog.this.locationText.setText(file);
                }
            }
        });
        String lastFile = Activator.getDefault().getPluginInstancePreferences().get(LAST_EXPORT_FILE, "");
        if (StringUtil.hasContent((String)lastFile)) {
            this.locationText.setText(lastFile);
        } else {
            Location instanceLocation = Platform.getInstanceLocation();
            URL workspaceURL = instanceLocation.getURL();
            String absolutePath = workspaceURL.getPath();
            String fileNamePlaceholder = "my_layouts";
            File exportLocation = new File(String.valueOf(absolutePath) + fileNamePlaceholder + ".lpref");
            this.locationText.setText(exportLocation.getAbsolutePath());
        }
        this.locationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportLayoutsDialog.this.getButton(0).setEnabled(StringUtil.hasContent((String)ExportLayoutsDialog.this.locationText.getText()));
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.cics.pa.ui.exportlayouts");
        return c;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.setErrorMessage(null);
            String fileName = this.locationText.getText();
            if (!fileName.endsWith(".lpref")) {
                fileName = fileName.concat(".lpref");
            }
            this.exportPreferencesTo(fileName);
            if (this.getErrorMessage() == null) {
                super.buttonPressed(buttonId);
                Activator.getDefault().getPluginInstancePreferences().put(LAST_EXPORT_FILE, fileName);
            }
        } else {
            super.buttonPressed(buttonId);
        }
    }

    public void exportPreferencesTo(String filePath) {
        debug.enter("exportPreferencesTo");
        try {
            LayoutImportExportUtils.exportTo(filePath);
        }
        catch (Exception e) {
            this.setErrorMessage(String.valueOf(Messages.getString("Layout_export_failed_msg")) + " " + e.getLocalizedMessage());
            debug.error("exportPreferencesTo", filePath, (Throwable)e);
        }
        debug.exit("exportPreferencesTo");
    }
}

