/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.pa.model.ManifestRecord;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.utilities.SheetViewPersistenceManager;
import com.ibm.cics.pa.ui.views.internal.IColumnReorderingView;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class SheetViewColumnDialog
extends TrayDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2009, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(SheetViewColumnDialog.class);
    public static final String ID = "com.ibm.cics.pa.ui.columns_dialog";
    static final String COLUMN_DEFINITION = "PROPERTY_DESCRIPTOR";
    private static final String DIALOG_HELP_CONTEXT_ID = "com.ibm.cics.pa.ui.columns_dialog";
    private static final String NAME = "NAME";
    private static final int RESET = 12345;
    Table availableColumnsTable;
    Table currentlyUsedColumnsTable;
    private Set<ColumnDefinition> currentlyUsedPropertyDescriptors = new HashSet<ColumnDefinition>();
    private Set<ColumnDefinition> availablePropertyDescriptors = new HashSet<ColumnDefinition>();
    Button addButton;
    Button removeButton;
    private Button upButton;
    private Button downButton;
    ColumnDefinition[] columnDefinitions = new ColumnDefinition[0];
    private IColumnReorderingView view;
    private String reftable;
    private String title;
    private String currentText;
    int[] widths;
    int[] columnOrder;
    static final String X_LOCATION = "SheetView.customizeColumns.dialog.x_location";
    static final String Y_LOCATION = "SheetView.customizeColumns.dialog.y_location";
    static final String WIDTH = "SheetView.customizeColumns.dialog.width";
    static final String HEIGHT = "SheetView.customizeColumns.dialog.height";

    public SheetViewColumnDialog(Shell shell, IColumnReorderingView sheetView, ColumnDefinition[] columnDefinitions, String reftable, ManifestRecord manifest, String currentLayout) {
        super(shell);
        debug.enter("ResourcesViewColumnDialog");
        this.setShellStyle(this.getShellStyle() | 0x10000 | 0x10);
        this.columnDefinitions = columnDefinitions;
        this.view = sheetView;
        this.reftable = reftable;
        this.currentText = currentLayout;
        this.title = MessageFormat.format(Messages.getString("ResourcesViewColumnDialog.customiseColumns"), manifest == null ? reftable : manifest.getDescription());
        if (StringUtil.hasContent((String)this.currentText)) {
            this.title = String.valueOf(this.title) + MessageFormat.format(Messages.getString("SheetView.applied.layout2"), this.currentText);
        }
        this.widths = (int[])this.view.getColumnWidths().clone();
        int i = 0;
        while (i < this.widths.length) {
            if (this.widths[i] == 0) {
                this.widths[i] = -1;
            }
            ++i;
        }
        this.columnOrder = this.view.getColumnOrder();
        debug.exit("ResourcesViewColumnDialog");
    }

    protected void initializeBounds() {
        super.initializeBounds();
        int x_location = this.getPreferenceValue(X_LOCATION);
        int y_location = this.getPreferenceValue(Y_LOCATION);
        if (x_location != 0 && y_location != 0) {
            this.getShell().setLocation(x_location, y_location);
        }
        int width = this.getPreferenceValue(WIDTH);
        int height = this.getPreferenceValue(HEIGHT);
        if (width != 0 && height != 0) {
            this.getShell().setSize(width, height);
        }
    }

    private int getPreferenceValue(String preferenceKey) {
        return Activator.getDefault().getPluginInstancePreferences().getInt(preferenceKey, 0);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.title);
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(1, false));
        c.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite columnsComposite = new Composite(c, 0);
        columnsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        columnsComposite.setLayout((Layout)new GridLayout(4, false));
        Label l = new Label(columnsComposite, 0);
        l.setText(Messages.getString("ResourcesViewColumnDialog.availableAttributes"));
        l = new Label(columnsComposite, 0);
        l = new Label(columnsComposite, 0);
        l.setText(Messages.getString("ResourcesViewColumnDialog.currentViewerColumns"));
        l = new Label(columnsComposite, 0);
        this.availableColumnsTable = new Table(columnsComposite, 2818);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        data.widthHint = 185;
        this.availableColumnsTable.setLayoutData((Object)data);
        Composite buttonArea = new Composite(columnsComposite, 0);
        buttonArea.setLayout((Layout)new GridLayout(1, true));
        data = new GridData(0, 4, false, true);
        buttonArea.setLayoutData((Object)data);
        this.currentlyUsedColumnsTable = new Table(columnsComposite, 2818);
        data = new GridData(4, 4, true, true);
        data.heightHint = 200;
        data.widthHint = 185;
        this.currentlyUsedColumnsTable.setLayoutData((Object)data);
        Composite upDownButtonArea = new Composite(columnsComposite, 0);
        upDownButtonArea.setLayout((Layout)new GridLayout(1, true));
        data = new GridData(0, 4, false, true);
        upDownButtonArea.setLayoutData((Object)data);
        this.addButton = new Button(buttonArea, 8);
        this.addButton.setText(String.valueOf(Messages.getString("ResourcesViewColumnDialog.add")) + " -->");
        data = new GridData(4, 0, true, false);
        this.addButton.setLayoutData((Object)data);
        this.addButton.setEnabled(false);
        this.removeButton = new Button(buttonArea, 8);
        this.removeButton.setText("<-- " + Messages.getString("ResourcesViewColumnDialog.remove"));
        this.removeButton.setEnabled(false);
        this.removeButton.setLayoutData((Object)data);
        this.upButton = new Button(upDownButtonArea, 8);
        this.upButton.setToolTipText(Messages.getString("ResourcesViewColumnDialog.up"));
        this.upButton.setImage(Activator.getDefault().getImage("upArrow"));
        data = new GridData(4, 0, true, false);
        this.upButton.setLayoutData((Object)data);
        this.upButton.setEnabled(false);
        this.downButton = new Button(upDownButtonArea, 8);
        this.downButton.setToolTipText(Messages.getString("ResourcesViewColumnDialog.down"));
        this.downButton.setImage(Activator.getDefault().getImage("downArrow"));
        this.downButton.setEnabled(false);
        this.downButton.setLayoutData((Object)data);
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableItem replacedItem;
                ColumnDefinition targetItemDefinition;
                int index = SheetViewColumnDialog.this.currentlyUsedColumnsTable.getSelectionIndex();
                TableItem movingItem = SheetViewColumnDialog.this.currentlyUsedColumnsTable.getItem(index);
                String movingItemText = movingItem.getText();
                ColumnDefinition movingItemDefinition = (ColumnDefinition)movingItem.getData(SheetViewColumnDialog.COLUMN_DEFINITION);
                if (SheetViewColumnDialog.this.swapColumns(movingItemDefinition, targetItemDefinition = (ColumnDefinition)(replacedItem = SheetViewColumnDialog.this.currentlyUsedColumnsTable.getItem(index + 1)).getData(SheetViewColumnDialog.COLUMN_DEFINITION))) {
                    movingItem.setText(replacedItem.getText());
                    movingItem.setData(SheetViewColumnDialog.COLUMN_DEFINITION, replacedItem.getData(SheetViewColumnDialog.COLUMN_DEFINITION));
                    replacedItem.setText(movingItemText);
                    replacedItem.setData(SheetViewColumnDialog.COLUMN_DEFINITION, (Object)movingItemDefinition);
                    SheetViewColumnDialog.this.currentlyUsedColumnsTable.setSelection(index + 1);
                }
                SheetViewColumnDialog.this.checkUpDownButtons();
            }
        });
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = SheetViewColumnDialog.this.currentlyUsedColumnsTable.getSelectionIndex();
                if (index > 0) {
                    TableItem replacedItem;
                    ColumnDefinition targetItemDefinition;
                    TableItem movingItem = SheetViewColumnDialog.this.currentlyUsedColumnsTable.getItem(index);
                    String movingItemText = movingItem.getText();
                    ColumnDefinition movingItemDefinition = (ColumnDefinition)movingItem.getData(SheetViewColumnDialog.COLUMN_DEFINITION);
                    if (SheetViewColumnDialog.this.swapColumns(movingItemDefinition, targetItemDefinition = (ColumnDefinition)(replacedItem = SheetViewColumnDialog.this.currentlyUsedColumnsTable.getItem(index - 1)).getData(SheetViewColumnDialog.COLUMN_DEFINITION))) {
                        movingItem.setText(replacedItem.getText());
                        movingItem.setData(SheetViewColumnDialog.COLUMN_DEFINITION, replacedItem.getData(SheetViewColumnDialog.COLUMN_DEFINITION));
                        replacedItem.setText(movingItemText);
                        replacedItem.setData(SheetViewColumnDialog.COLUMN_DEFINITION, (Object)movingItemDefinition);
                        SheetViewColumnDialog.this.currentlyUsedColumnsTable.setSelection(index - 1);
                    }
                    SheetViewColumnDialog.this.checkUpDownButtons();
                }
            }
        });
        this.currentlyUsedColumnsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SheetViewColumnDialog.this.removeButton.setEnabled(SheetViewColumnDialog.this.hasColumnsToRemove());
                SheetViewColumnDialog.this.checkUpDownButtons();
            }
        });
        this.availableColumnsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SheetViewColumnDialog.this.addButton.setEnabled(SheetViewColumnDialog.this.availableColumnsTable.getSelectionCount() >= 1);
            }
        });
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SheetViewColumnDialog.this.addSelectedColumn();
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SheetViewColumnDialog.this.removeSelectedColumn();
            }
        });
        this.initialize();
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Point location = SheetViewColumnDialog.this.getShell().getLocation();
                Point size = SheetViewColumnDialog.this.getShell().getSize();
                IEclipsePreferences preferenceStore = Activator.getDefault().getPluginInstancePreferences();
                preferenceStore.putInt(SheetViewColumnDialog.X_LOCATION, location.x);
                preferenceStore.putInt(SheetViewColumnDialog.Y_LOCATION, location.y);
                preferenceStore.putInt(SheetViewColumnDialog.WIDTH, size.x);
                preferenceStore.putInt(SheetViewColumnDialog.HEIGHT, size.y);
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent.getShell(), "com.ibm.cics.pa.ui.columns_dialog");
        return c;
    }

    boolean hasColumnsToRemove() {
        if (this.currentlyUsedColumnsTable.getSelectionCount() >= 2) {
            return true;
        }
        if (this.currentlyUsedColumnsTable.getSelectionCount() == 1) {
            return !NAME.equalsIgnoreCase(((ColumnDefinition)this.currentlyUsedColumnsTable.getSelection()[0].getData(COLUMN_DEFINITION)).getLabel(null));
        }
        return false;
    }

    void addSelectedColumn() {
        TableItem[] columnsToAdd = this.availableColumnsTable.getSelection();
        ArrayList<ColumnDefinition> propertyDescriptorsToAdd = new ArrayList<ColumnDefinition>();
        int i = 0;
        while (i < columnsToAdd.length) {
            ColumnDefinition propertyDescriptor = (ColumnDefinition)columnsToAdd[i].getData(COLUMN_DEFINITION);
            propertyDescriptorsToAdd.add(propertyDescriptor);
            int position = 0;
            while (position < this.columnDefinitions.length) {
                if (this.columnDefinitions[position].equals(propertyDescriptor)) {
                    this.widths[position] = 70;
                    this.availablePropertyDescriptors.remove(propertyDescriptor);
                    this.currentlyUsedPropertyDescriptors.add(propertyDescriptor);
                    TableItem[] availableTableItems = this.availableColumnsTable.getItems();
                    int j = 0;
                    while (j < availableTableItems.length) {
                        if (availableTableItems[j].getData(COLUMN_DEFINITION).equals(propertyDescriptor)) {
                            availableTableItems[j].dispose();
                            this.availablePropertyDescriptors.remove(propertyDescriptor);
                        }
                        ++j;
                    }
                }
                ++position;
            }
            ++i;
        }
        if (StringUtil.hasContent((String)this.currentText) && this.currentText.indexOf(Messages.getString("Custom")) == -1) {
            this.currentText = String.valueOf(Messages.getString("Custom")) + this.currentText;
        }
        this.initializeCurrentlyUsed(this.columnOrder, this.widths);
        TableItem[] items = this.currentlyUsedColumnsTable.getItems();
        ArrayList<TableItem> newlyAddedItems = new ArrayList<TableItem>();
        int i2 = 0;
        while (i2 < items.length) {
            if (propertyDescriptorsToAdd.contains(items[i2].getData(COLUMN_DEFINITION))) {
                newlyAddedItems.add(items[i2]);
            }
            ++i2;
        }
        TableItem[] tableItemsArray = newlyAddedItems.toArray(new TableItem[0]);
        this.currentlyUsedColumnsTable.setSelection(tableItemsArray);
    }

    void removeSelectedColumn() {
        ColumnDefinition propertyDescriptor;
        TableItem[] columnsToRemove = this.currentlyUsedColumnsTable.getSelection();
        ArrayList<ColumnDefinition> propertyDescriptorsToRemove = new ArrayList<ColumnDefinition>();
        int i = 0;
        while (i < columnsToRemove.length) {
            TableItem columnToRemove = columnsToRemove[i];
            propertyDescriptor = (ColumnDefinition)columnToRemove.getData(COLUMN_DEFINITION);
            int k = 0;
            while (k < this.columnDefinitions.length) {
                if (this.columnDefinitions[k].equals(propertyDescriptor)) {
                    this.widths[k] = -1;
                }
                ++k;
            }
            columnToRemove.dispose();
            propertyDescriptorsToRemove.add(propertyDescriptor);
            this.currentlyUsedPropertyDescriptors.remove(propertyDescriptor);
            this.availablePropertyDescriptors.add(propertyDescriptor);
            ++i;
        }
        ArrayList<TableItem> newlyAddedItems = new ArrayList<TableItem>();
        this.availableColumnsTable.setRedraw(false);
        try {
            this.availableColumnsTable.removeAll();
            int position = 0;
            while (position < this.columnDefinitions.length) {
                propertyDescriptor = this.columnDefinitions[position];
                if (!this.currentlyUsedPropertyDescriptors.contains(propertyDescriptor)) {
                    TableItem tableItem = new TableItem(this.availableColumnsTable, 0);
                    tableItem.setText(0, propertyDescriptor.getLabel(null));
                    tableItem.setData(COLUMN_DEFINITION, (Object)propertyDescriptor);
                    this.availablePropertyDescriptors.add(propertyDescriptor);
                    if (propertyDescriptorsToRemove.contains(propertyDescriptor)) {
                        newlyAddedItems.add(tableItem);
                    }
                }
                ++position;
            }
        }
        finally {
            this.availableColumnsTable.setRedraw(true);
        }
        this.removeButton.setEnabled(false);
        if (StringUtil.hasContent((String)this.currentText) && this.currentText.indexOf(Messages.getString("Custom")) == -1) {
            this.currentText = String.valueOf(Messages.getString("Custom")) + this.currentText;
        }
        TableItem[] tableItemsArray = newlyAddedItems.toArray(new TableItem[0]);
        this.availableColumnsTable.setSelection(tableItemsArray);
    }

    private void initialize() {
        BusyIndicator.showWhile((Display)this.currentlyUsedColumnsTable.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                SheetViewColumnDialog.this.availableColumnsTable.setRedraw(false);
                SheetViewColumnDialog.this.currentlyUsedColumnsTable.setRedraw(false);
                try {
                    if (SheetViewColumnDialog.this.columnDefinitions.length > 0) {
                        SheetViewColumnDialog.this.availableColumnsTable.removeAll();
                        SheetViewColumnDialog.this.currentlyUsedColumnsTable.removeAll();
                        int i = 0;
                        while (i < SheetViewColumnDialog.this.columnOrder.length) {
                            if (SheetViewColumnDialog.this.widths[SheetViewColumnDialog.this.columnOrder[i]] > 0) {
                                SheetViewColumnDialog.this.createCurrentlyUsedTableItem(SheetViewColumnDialog.this.columnDefinitions[SheetViewColumnDialog.this.columnOrder[i]], -1);
                            }
                            ++i;
                        }
                        SheetViewColumnDialog.this.refreshAvailablePropertyDescriptors();
                    }
                }
                finally {
                    SheetViewColumnDialog.this.availableColumnsTable.setRedraw(true);
                    SheetViewColumnDialog.this.currentlyUsedColumnsTable.setRedraw(true);
                }
            }
        });
    }

    private void initializeCurrentlyUsed(final int[] columnOrder, final int[] columns) {
        BusyIndicator.showWhile((Display)this.currentlyUsedColumnsTable.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                SheetViewColumnDialog.this.currentlyUsedColumnsTable.setRedraw(false);
                try {
                    if (SheetViewColumnDialog.this.columnDefinitions.length > 0) {
                        SheetViewColumnDialog.this.currentlyUsedColumnsTable.removeAll();
                        int i = 0;
                        while (i < columnOrder.length) {
                            if (columns[columnOrder[i]] > 0) {
                                SheetViewColumnDialog.this.createCurrentlyUsedTableItem(SheetViewColumnDialog.this.columnDefinitions[columnOrder[i]], -1);
                            }
                            ++i;
                        }
                    }
                }
                finally {
                    SheetViewColumnDialog.this.currentlyUsedColumnsTable.setRedraw(true);
                }
            }
        });
    }

    void refreshAvailablePropertyDescriptors() {
        int currentTopItemNumber = this.availableColumnsTable.getTopIndex();
        if (this.availableColumnsTable.getItemCount() > 0) {
            currentTopItemNumber = this.availableColumnsTable.getTopIndex();
        }
        ColumnDefinition[] propertyDescriptors = this.columnDefinitions;
        int position = 0;
        while (position < propertyDescriptors.length) {
            ColumnDefinition propertyDescriptor = propertyDescriptors[position];
            if (!this.currentlyUsedPropertyDescriptors.contains(propertyDescriptor) && propertyDescriptor != null) {
                TableItem tableItem = new TableItem(this.availableColumnsTable, 0);
                tableItem.setText(0, propertyDescriptor.getLabel(null));
                tableItem.setData(COLUMN_DEFINITION, (Object)propertyDescriptor);
                this.availablePropertyDescriptors.add(propertyDescriptor);
            }
            ++position;
        }
        TableColumn[] columns = this.availableColumnsTable.getColumns();
        int i = 0;
        while (i < columns.length) {
            columns[i].pack();
            ++i;
        }
        if (currentTopItemNumber != -1) {
            this.availableColumnsTable.setTopIndex(currentTopItemNumber);
        }
    }

    void createCurrentlyUsedTableItem(ColumnDefinition aPropertyDescriptor, int location) {
        TableItem currentlyUsedTableItem = location > -1 && location < this.currentlyUsedColumnsTable.getItemCount() ? new TableItem(this.currentlyUsedColumnsTable, 0, location) : new TableItem(this.currentlyUsedColumnsTable, 0);
        currentlyUsedTableItem.setText(aPropertyDescriptor.getLabel(null));
        currentlyUsedTableItem.setData(COLUMN_DEFINITION, (Object)aPropertyDescriptor);
        this.currentlyUsedPropertyDescriptors.add(aPropertyDescriptor);
        if (NAME.equalsIgnoreCase(aPropertyDescriptor.getLabel(null))) {
            currentlyUsedTableItem.setForeground(this.availableColumnsTable.getDisplay().getSystemColor(15));
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 12345) {
            this.view.resetColumns();
            this.widths = (int[])this.view.getColumnWidths().clone();
            int i = 0;
            while (i < this.widths.length) {
                if (this.widths[i] == 0) {
                    this.widths[i] = -1;
                }
                ++i;
            }
            this.columnOrder = this.view.getColumnOrder();
            this.initialize();
        } else {
            super.buttonPressed(buttonId);
            if (!Arrays.equals(this.view.getColumnOrder(), this.columnOrder) || !Arrays.equals(this.view.getColumnWidths(), this.widths)) {
                this.view.applyOrdering(this.columnOrder, this.widths);
                SheetViewPersistenceManager.getInstance(this.reftable).setCombinedColumnOrder(this.columnOrder, this.widths, this.columnDefinitions);
            }
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 12345, Messages.getString("ResourcesViewColumnDialog.reset"), false);
        this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, true);
    }

    void checkUpDownButtons() {
        if (this.currentlyUsedColumnsTable != null) {
            if (this.currentlyUsedColumnsTable.getSelectionCount() != 1) {
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(false);
            } else {
                int index = this.currentlyUsedColumnsTable.getSelectionIndex();
                this.upButton.setEnabled(index > 0);
                this.downButton.setEnabled(index > -1 && index < this.currentlyUsedColumnsTable.getItemCount() - 1);
            }
        }
    }

    boolean swapColumns(ColumnDefinition sourceItemDefinition, ColumnDefinition targetItemDefinition) {
        boolean beenSorted = false;
        int sourcePointer = -1;
        int targetPointer = -1;
        if (this.columnDefinitions != null) {
            int i = 0;
            while (i < this.columnDefinitions.length) {
                if (this.columnDefinitions[i].equals(sourceItemDefinition)) {
                    sourcePointer = i;
                } else if (this.columnDefinitions[i].equals(targetItemDefinition)) {
                    targetPointer = i;
                }
                ++i;
            }
        }
        int sourcePosition = -1;
        int targetPosition = -1;
        int i = 0;
        while (i < this.columnOrder.length) {
            if (sourcePointer == this.columnOrder[i]) {
                sourcePosition = i;
            }
            if (targetPointer == this.columnOrder[i]) {
                targetPosition = i;
            }
            ++i;
        }
        if (sourcePosition > -1 && targetPosition > -1 && sourcePosition < this.columnOrder.length && targetPosition < this.columnOrder.length) {
            int tempPos = this.columnOrder[sourcePosition];
            this.columnOrder[sourcePosition] = this.columnOrder[targetPosition];
            this.columnOrder[targetPosition] = tempPos;
            beenSorted = true;
        }
        return beenSorted;
    }
}

