/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.pa.model.ChartingFile;
import com.ibm.cics.pa.model.DataKeyElement;
import com.ibm.cics.pa.model.GenericDataProvider;
import com.ibm.cics.pa.model.TreeElement;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.Messages;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class SheetOpenActionProvider
extends CommonActionProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private IAction openAction;
    static final Logger logger = Logger.getLogger("com.ibm.cics.pa.ui");

    public void init(ICommonActionExtensionSite aSite) {
        Debug.enter((Logger)logger, (String)SheetOpenActionProvider.class.getName(), (String)"init", (Object)aSite);
        ICommonViewerSite viewSite = aSite.getViewSite();
        if (viewSite instanceof ICommonViewerWorkbenchSite) {
            ICommonViewerWorkbenchSite site = (ICommonViewerWorkbenchSite)viewSite;
            this.openAction = new OpenAction1(site.getPage(), site.getSelectionProvider());
        }
        Debug.exit((Logger)logger, (String)SheetOpenActionProvider.class.getName(), (String)"init", (Object)this.openAction);
    }

    public void fillActionBars(IActionBars actionBars) {
        if (this.openAction.isEnabled()) {
            actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", this.openAction);
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        if (this.openAction.isEnabled() && !this.getContext().getSelection().isEmpty()) {
            Object element = ((StructuredSelection)this.getContext().getSelection()).getFirstElement();
            if (element instanceof TreeElement) {
                DataKeyElement dk = ((TreeElement)element).getDataKey();
                this.openAction.setText(dk.isAppPerformanceSummary() ? Messages.getString("SpreadSheet.Application") : (dk.isPerformanceSummary() ? Messages.getString("SpreadSheet.Spreadsheet") : Messages.getString("SpreadSheet.Statistics")));
                this.openAction.setImageDescriptor(dk.isAppPerformanceSummary() ? Activator.getDefault().getImageDescriptor("anal_history") : (dk.isPerformanceSummary() ? Activator.getDefault().getImageDescriptor(Activator.IMGD_TRAN) : Activator.getDefault().getImageDescriptor("table")));
            }
            menu.prependToGroup("group.edit", this.openAction);
        }
    }

    public class OpenAction1
    extends Action {
        IWorkbenchPage page;
        private ISelectionProvider provider;
        StructuredSelection selection;

        public OpenAction1(IWorkbenchPage page, ISelectionProvider selectionProvider) {
            this.setText(Messages.getString("SpreadSheet.Statistics"));
            this.page = page;
            this.provider = selectionProvider;
        }

        public boolean isEnabled() {
            this.selection = (StructuredSelection)this.provider.getSelection();
            return !this.selection.isEmpty() && this.selection.size() > 0 && this.selection.getFirstElement() instanceof TreeElement;
        }

        public void run() {
            Job job = new Job("Visualizing selection."){

                protected IStatus run(IProgressMonitor monitor) {
                    Debug.enter((Logger)logger, (String)OpenAction1.class.getName(), (String)"run");
                    if (OpenAction1.this.selection.getFirstElement() instanceof TreeElement) {
                        TreeElement element = (TreeElement)OpenAction1.this.selection.getFirstElement();
                        GenericDataProvider provider2 = ChartingFile.adaptFor(element.getSourceProvider(), OpenAction1.this.selection, null);
                        provider2.getData(monitor);
                        final String id = provider2.getFileReference();
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    (this).OpenAction1.this.page.showView("com.ibm.cics.pa.ui.sheeteditor_multi", id, 2);
                                }
                                catch (PartInitException e) {
                                    logger.logp(Level.SEVERE, OpenAction1.class.getName(), "run", "PartInitException ", e);
                                }
                            }
                        });
                    }
                    Debug.exit((Logger)logger, (String)OpenAction1.class.getName(), (String)"run", (Object)"Status.OK_STATUS");
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(20);
            IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)this.page.getActivePart().getSite().getAdapter(IWorkbenchSiteProgressService.class);
            siteService.schedule(job, 0L, true);
        }

        public String toString() {
            return String.valueOf(((Object)((Object)this)).getClass().getName()) + " " + this.getText();
        }
    }
}

