/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.dbfunc.DBUtilities;
import com.ibm.cics.dbfunc.command.Engine;
import com.ibm.cics.dbfunc.command.EngineShell;
import com.ibm.cics.dbfunc.command.RowProcessor;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.eclipse.common.ViewHelper;
import com.ibm.cics.eclipse.common.ui.Utilities;
import com.ibm.cics.pa.model.ManifestRecord;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.DataProviderKey;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.QueryCache;
import com.ibm.cics.pa.ui.handlers.PAContextListener;
import com.ibm.cics.pa.ui.remote.PAConnectionListener;
import com.ibm.cics.pa.ui.remote.PAConnectionTracker;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import com.ibm.cics.pa.ui.views.PerformanceAlerts;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Display;

public class PAContextTracker
implements PAConnectionListener {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2010, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final Logger logger = Logger.getLogger("com.ibm.cics.pa.ui");
    private static PAContextTracker instance = null;
    private String currentSchema = null;
    String[] headers = null;
    ColumnDefinition[] columnDefinitions;
    DataProviderKey structureKey = null;
    boolean isDBSource = true;
    ManifestRecord record = null;
    String perfSummTableName = null;
    Collection<PAContextListener> listeners = new HashSet<PAContextListener>();
    private LinkedList<String> recordHistory = null;

    private PAContextTracker() {
        PAConnectionTracker.getInstance().addPAConnectionTrackerListener(this);
    }

    public static PAContextTracker getInstance() {
        if (instance == null) {
            instance = new PAContextTracker();
        }
        return instance;
    }

    public String getFullTableReference() {
        if (this.record != null) {
            return Utilities.hasContent((String)this.currentSchema) ? String.valueOf(this.currentSchema) + "." + this.record.getName() : (this.record != null ? this.record.getName() : null);
        }
        return null;
    }

    public String getShortTableReference() {
        if (this.record != null) {
            return this.record.getName();
        }
        return null;
    }

    private void readManifestTable() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"readManifestTable");
        Selection selection = PresentationFactory.getInstance().createSelectAllForTable("CPA_MANIFEST", ":schema");
        final Engine engine = new Engine("com.ibm.cics.pa.connection", new RowProcessor((SelectionObject)selection){
            private final /* synthetic */ SelectionObject val$selection;
            {
                this.val$selection = selectionObject;
            }

            public Map<String, Object> getParameterMap() {
                return new HashMap<String, Object>();
            }

            public SelectionObject getSelectionObject() {
                return this.val$selection;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object processRow(ResultSet resultSet) throws SQLException {
                ManifestRecord record = null;
                try {
                    ResultSet resultSet2 = resultSet;
                    synchronized (resultSet2) {
                        record = ManifestRecord.createManifestRecord(resultSet);
                    }
                    if (record != null && record.getAlias().equals("CMFPSUM")) {
                        PAContextTracker.this.perfSummTableName = record.getName();
                        Activator.getDefault().getPluginInstancePreferences().put("lastperf", PAContextTracker.this.perfSummTableName);
                    }
                }
                catch (SQLException sqle) {
                    if (DBUtilities.isUserIDInvalidPrivelege((SQLException)sqle)) {
                        try {
                            ConnectionsPlugin.getDefault().getConnectionService().disconnect("com.ibm.cics.pa.connection");
                        }
                        catch (ConnectionException e1) {
                            Debug.error((Logger)logger, (String)this.getClass().getName(), (String)"readManifestTable", (Throwable)e1);
                        }
                        ViewHelper.setDeferredStatusErrorMessage((String)Messages.getString("PAX0106E.Manifest_privileges"));
                    }
                    Debug.error((Logger)logger, (String)this.getClass().getName(), (String)"readManifestTable", (Throwable)sqle);
                }
                return record;
            }
        });
        engine.addListener(new EngineShell.EngineListener(){

            public void dataAvailable(Collection<Object> items) {
            }

            public void notifyResultCount(int count) {
            }

            public void statusUpdate(EngineShell.EngineStatus es) {
                switch (es) {
                    case Cancelled: {
                        engine.removeListener((EngineShell.EngineListener)this);
                        break;
                    }
                    case Error: {
                        engine.removeListener((EngineShell.EngineListener)this);
                        Exception e = engine.getLastException();
                        if (e instanceof SQLException && DBUtilities.isUserIDInvalidPrivelege((SQLException)((SQLException)e))) {
                            try {
                                ConnectionsPlugin.getDefault().getConnectionService().disconnect("com.ibm.cics.pa.connection");
                            }
                            catch (ConnectionException e1) {
                                Debug.error((Logger)logger, (String)this.getClass().getName(), (String)"readManifestTable", (Throwable)e1);
                            }
                            ViewHelper.setDeferredStatusErrorMessage((String)Messages.getString("PAX0106E.Manifest_privileges"));
                            break;
                        }
                        ViewHelper.setDeferredStatusErrorMessage((String)Messages.getString("PAX0105W.Overview.NoSummary"));
                        PAContextTracker.this.readPre32Table(ManifestRecord.OLD_LOCAL_SUMMARY_TABLE);
                        break;
                    }
                    case Paused: 
                    case Complete: {
                        engine.removeListener((EngineShell.EngineListener)this);
                        ManifestRecord record = ManifestRecord.getLastOrDefault();
                        if (record != null) {
                            PAContextTracker.this.readRecordFromManifest(record);
                        }
                        PAContextTracker.this.initialiseTables();
                        break;
                    }
                }
            }
        });
        engine.setPageSize(1000);
        engine.setNotifyOnCount(false);
        if (PAConnectionTracker.getInstance().isConnected()) {
            engine.start();
        }
        this.structureKey = DataProviderKey.NONE;
        this.headers = new String[0];
        this.columnDefinitions = new ColumnDefinition[0];
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"readManifestTable");
    }

    void readPre32Table(String table) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"readPre32Table");
        this.perfSummTableName = ManifestRecord.old().getName();
        Activator.getDefault().getPluginInstancePreferences().put("lastperf", this.perfSummTableName);
        this.setCurrentManifest(ManifestRecord.old());
        final Selection selection = PresentationFactory.getInstance().createSelectAllForTable(table, ":schema");
        selection.firstRowOnly();
        final Engine engine = new Engine("com.ibm.cics.pa.connection", new RowProcessor(){

            public Map<String, Object> getParameterMap() {
                return new HashMap<String, Object>();
            }

            public SelectionObject getSelectionObject() {
                return selection;
            }

            public Object processRow(ResultSet resultSet) {
                try {
                    ResultSetMetaData rsmd = resultSet.getMetaData();
                    ArrayList<String> cols = new ArrayList<String>();
                    int i = 1;
                    while (i <= rsmd.getColumnCount()) {
                        cols.add(rsmd.getColumnName(i));
                        ++i;
                    }
                    PAContextTracker.this.headers = cols.toArray(new String[cols.size()]);
                    if (PAContextTracker.this.structureKey == null || PAContextTracker.this.structureKey.equals((Object)DataProviderKey.NONE)) {
                        PAContextTracker.this.structureKey = DataProviderKey.matchOn(new String[]{PAContextTracker.this.headers[0], PAContextTracker.this.headers[1], PAContextTracker.this.headers[2], PAContextTracker.this.headers[3]}, PAContextTracker.this.isDBSource);
                    }
                    PAContextTracker.this.columnDefinitions = new ColumnDefinition[PAContextTracker.this.headers.length];
                    i = 0;
                    while (i < PAContextTracker.this.headers.length) {
                        ColumnDefinition defn = ColumnDefinition.getByDBColumnRef(PAContextTracker.this.headers[i]);
                        if (defn != null) {
                            PAContextTracker.this.columnDefinitions[i] = defn;
                            PAContextTracker.this.headers[i] = defn.getLabel(PAContextTracker.this.record.getAlias());
                        } else {
                            PAContextTracker.this.columnDefinitions[i] = ColumnDefinition.UNKNOWN;
                        }
                        ++i;
                    }
                }
                catch (SQLException e) {
                    Debug.error((Logger)logger, (String)this.getClass().getName(), (String)"readPre32Table processRow", (Throwable)e);
                }
                return null;
            }
        });
        engine.setPageSize(1000);
        engine.addListener(new EngineShell.EngineListener(){

            public void dataAvailable(Collection<Object> items) {
            }

            public void notifyResultCount(int count) {
            }

            public void statusUpdate(EngineShell.EngineStatus es) {
                switch (es) {
                    case Cancelled: {
                        engine.removeListener((EngineShell.EngineListener)this);
                        ViewHelper.setDeferredStatusInformationMessage((String)Messages.getString("Overview.Cancelled"));
                        break;
                    }
                    case Error: {
                        engine.removeListener((EngineShell.EngineListener)this);
                        ViewHelper.setDeferredStatusErrorMessage((String)Messages.getString("PAX0105W.Overview.NoSummary"));
                        break;
                    }
                    case Complete: {
                        engine.removeListener((EngineShell.EngineListener)this);
                        PAContextTracker.this.record = ManifestRecord.old();
                        QueryCache.getInstance();
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                for (PAContextListener listener : (this).PAContextTracker.this.listeners) {
                                    listener.tableSelected((this).PAContextTracker.this.record);
                                }
                            }
                        });
                        break;
                    }
                }
            }
        });
        engine.setNotifyOnCount(false);
        if (PAConnectionTracker.getInstance().isConnected()) {
            engine.start();
        }
        this.structureKey = DataProviderKey.NONE;
        this.headers = new String[0];
        this.columnDefinitions = new ColumnDefinition[0];
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"readPre32Table");
    }

    public void readRecordFromManifest(final ManifestRecord record1) {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"readRecordFromManifest");
        this.managePersist(record1);
        this.setCurrentManifest(record1);
        int ctr = 0;
        while (!record1.isPresent() && ctr < 20) {
            try {
                Thread.yield();
                Thread.sleep(250L);
                ++ctr;
            }
            catch (InterruptedException e) {
                Debug.error((Logger)logger, (String)PerformanceAlerts.class.getName(), (String)"initialise", (Throwable)e);
            }
        }
        if (record1.isPresent()) {
            final Selection selection = PresentationFactory.getInstance().createSelectAllForTable(record1.getName(), ":schema");
            selection.firstRowOnly();
            final Engine engine = new Engine("com.ibm.cics.pa.connection", new RowProcessor(){

                public Map<String, Object> getParameterMap() {
                    return new HashMap<String, Object>();
                }

                public SelectionObject getSelectionObject() {
                    return selection;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object processRow(ResultSet resultSet) {
                    try {
                        ResultSetMetaData rsmd = resultSet.getMetaData();
                        ArrayList<String> cols = new ArrayList<String>();
                        ArrayList<Integer> colst = new ArrayList<Integer>();
                        int i = 1;
                        while (i <= rsmd.getColumnCount()) {
                            cols.add(rsmd.getColumnName(i));
                            colst.add(rsmd.getColumnType(i));
                            ++i;
                        }
                        Integer[] types = colst.toArray(new Integer[colst.size()]);
                        String[] stringArray = PAContextTracker.this.headers = cols.toArray(new String[cols.size()]);
                        synchronized (PAContextTracker.this.headers) {
                            PAContextTracker.this.structureKey = record1.getKey();
                            PAContextTracker.this.columnDefinitions = new ColumnDefinition[PAContextTracker.this.headers.length];
                            int i2 = 0;
                            while (i2 < PAContextTracker.this.headers.length) {
                                ColumnDefinition defn = ColumnDefinition.getByDBColumnRef(PAContextTracker.this.headers[i2]);
                                if (defn != null) {
                                    PAContextTracker.this.columnDefinitions[i2] = defn;
                                    PAContextTracker.this.headers[i2] = defn.getLabel(PAContextTracker.this.record.getAlias());
                                    DataTypeUtilities.compare(types[i2], PAContextTracker.this.columnDefinitions[i2]);
                                } else {
                                    logger.log(Level.WARNING, this.getClass().getName(), "readRecordFromManifest missing header " + PAContextTracker.this.headers[i2]);
                                    PAContextTracker.this.columnDefinitions[i2] = ColumnDefinition.UNKNOWN;
                                }
                                ++i2;
                            }
                            // ** MonitorExit[var6_8] (shouldn't be in output)
                        }
                    }
                    catch (SQLException e) {
                        Debug.error((Logger)logger, (String)this.getClass().getName(), (String)"readRecordFromManifest processRow", (Throwable)e);
                    }
                    {
                        return null;
                    }
                }
            });
            engine.setPageSize(1000);
            engine.addListener(new EngineShell.EngineListener(){

                public void dataAvailable(Collection<Object> items) {
                    if (items.isEmpty()) {
                        String[] stringArray = engine.getColumnNames();
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String column = stringArray[n2];
                            ColumnDefinition col = ColumnDefinition.getByDBColumnRef(column);
                            if (col == null || col == ColumnDefinition.UNKNOWN) {
                                Debug.warning((Logger)logger, (String)this.getClass().getName(), (String)"dataAvailable missing", (Object)("ColumnDefinition." + column + '=' + column));
                            }
                            ++n2;
                        }
                    }
                }

                public void notifyResultCount(int count) {
                    Debug.warning((Logger)logger, (String)this.getClass().getName(), (String)"notifyResultCount", (Object)selection, (Object)count);
                }

                public void statusUpdate(EngineShell.EngineStatus es) {
                    switch (es) {
                        case Cancelled: {
                            engine.removeListener((EngineShell.EngineListener)this);
                            break;
                        }
                        case Error: {
                            PAContextTracker.this.record = null;
                        }
                        case Complete: {
                            engine.removeListener((EngineShell.EngineListener)this);
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    for (PAContextListener listener : (this).PAContextTracker.this.listeners) {
                                        listener.tableSelected((this).PAContextTracker.this.record);
                                    }
                                }
                            });
                            break;
                        }
                    }
                }
            });
            engine.setNotifyOnCount(false);
            if (PAConnectionTracker.getInstance().isConnected()) {
                engine.start();
            }
        }
        this.structureKey = DataProviderKey.NONE;
        this.headers = new String[0];
        this.columnDefinitions = new ColumnDefinition[0];
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"accessMetaData1");
    }

    public String[] getHeaders() {
        return this.headers;
    }

    public DataProviderKey getStructureKey() {
        return this.structureKey;
    }

    public ColumnDefinition[] getColumnDefinitions() {
        return this.columnDefinitions;
    }

    public boolean isDBSource() {
        return this.isDBSource;
    }

    public void addPAContextListenerListener(PAContextListener listener) {
        this.listeners.add(listener);
    }

    public void removePAContextListenerListener(PAContextListener listener) {
        this.listeners.remove(listener);
    }

    public boolean isInitialised() {
        return this.getHeaders() != null && this.getHeaders().length > 0;
    }

    public ManifestRecord getCurrentManifest() {
        return this.record;
    }

    private void setCurrentManifest(ManifestRecord newRecord) {
        this.record = newRecord;
    }

    public String getPerformanceTableReference() {
        if (this.perfSummTableName == null) {
            this.perfSummTableName = Platform.getPreferencesService().getString(Activator.getDefault().getBundle().getSymbolicName(), "lastperf", ManifestRecord.OLD_LOCAL_SUMMARY_TABLE, null);
        }
        return this.perfSummTableName;
    }

    void initialiseTables() {
        ManifestRecord[] manifestRecordArray = new ManifestRecord[]{PAConnectionTracker.getInstance().getAlertManifest(), PAConnectionTracker.getInstance().getPerformanceAlertManifest()};
        int n = manifestRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            ManifestRecord record = manifestRecordArray[n2];
            if (record != null) {
                record.isPresent();
            }
            ++n2;
        }
        LinkedList<String> records = this.getRecordHistory();
        int i = 1;
        while (i < records.size() && i < 6) {
            ManifestRecord record = ManifestRecord.getAlias(records.get(i));
            if (record != null) {
                record.isPresent();
            }
            ++i;
        }
        ManifestRecord.lookThemAllUp();
    }

    private void managePersist(ManifestRecord record1) {
        this.getRecordHistory().remove(record1.getAlias());
        this.getRecordHistory().addFirst(record1.getAlias());
        StringBuffer alias = new StringBuffer("");
        int i = 0;
        while (i < this.getRecordHistory().size() && i < 5) {
            if (i > 0) {
                alias.append(',');
            }
            alias.append(this.getRecordHistory().get(i));
            ++i;
        }
        Activator.getDefault().getPluginInstancePreferences().put("TABLE_HISTORY", alias.toString());
    }

    public LinkedList<String> getRecordHistory() {
        if (this.recordHistory == null) {
            String aliases;
            this.recordHistory = new LinkedList();
            if (PAConnectionTracker.getInstance().isConnected() && (aliases = Platform.getPreferencesService().getString(Activator.getDefault().getBundle().getSymbolicName(), "TABLE_HISTORY", "", null)) != null) {
                StringTokenizer tokenizer = new StringTokenizer(aliases, ",");
                while (tokenizer.hasMoreElements()) {
                    ManifestRecord record1 = ManifestRecord.getAlias((String)tokenizer.nextElement());
                    if (record1 == null) continue;
                    this.recordHistory.addLast(record1.getAlias());
                }
            }
        }
        return this.recordHistory;
    }

    @Override
    public void connected(PAConnectionListener.Era era) {
        ManifestRecord.resetList();
        if (era == PAConnectionListener.Era.POST) {
            this.readManifestTable();
        } else if (era == PAConnectionListener.Era.PRE) {
            this.readPre32Table(ManifestRecord.OLD_LOCAL_SUMMARY_TABLE);
        }
    }

    @Override
    public void disconnected() {
        for (PAContextListener listener : this.listeners) {
            listener.disconnected();
        }
        this.recordHistory = null;
    }

    @Override
    public void disconnecting() {
    }

    public static boolean inOverviewMode() {
        return Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), "MODE_OVERVIEW", false, null);
    }

    public boolean isStatsManifest() {
        return this.record != null && !this.record.isPerformanceSummaryRecord() && !this.record.isPerformanceList() && !this.record.isApplicationSummaryRecord();
    }
}

