/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.model.definitions;

import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Direction;
import com.ibm.cics.dbfunc.model.Presentation;
import com.ibm.cics.eclipse.common.Utilities;
import com.ibm.cics.pa.model.ChartType;
import com.ibm.cics.pa.model.PlotPoint;
import com.ibm.cics.pa.model.definitions.AbstractChartDefinition;
import com.ibm.cics.pa.model.definitions.ChartCategorisation;
import com.ibm.cics.pa.model.definitions.ChartSpecificDefinitions;
import com.ibm.cics.pa.model.definitions.ColumnContainment;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.CompactHistogramChartSpecificDefinitions;
import com.ibm.cics.pa.model.definitions.HistogramChartSpecificDefinitions;
import com.ibm.cics.pa.model.definitions.IntervalSpecificDefinitions;
import com.ibm.cics.pa.model.definitions.PieChartSpecificDefinitions;
import com.ibm.cics.pa.model.definitions.SortedCombinedHistogramLineSpecificDefinitions;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.utilities.MessagePackage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;

public class PersistedChartDefinition
extends AbstractChartDefinition {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Map<Presentation, PersistedChartDefinition> lookup = null;
    private ChartSpecificDefinitions specificDefns;
    private ChartType type;
    private String title;
    private ChartCategorisation[] chartCategorisation;
    private String tableCategorisation;
    private String code;
    private static final String LABEL_PREFIX = "label";
    private static final String LINE_PREFIX = "line";
    private static final String PLOT_PREFIX = "plot";
    private static final String PERCENT_PREFIX = "percent";
    private static final String ALTERNATIVE_COLUMN_PREFIX = "alternative_column";
    private static final String ALTERNATIVE_PRESENTATION = "alternative_presentation";
    private static final String MERGE_PRESENTATION = "merge_presentation";
    private static final String RENAME_COLUMN_PREFIX = "rename_column";
    private static final String TEXT_NUMBER_PREFIX = "text_number";
    private static final String SUB_COLUMN_LABEL_PREFIX = "sub_label";
    private static final String SUB_COLUMN_VALUE_PREFIX = "sub_value";
    private static final String CHEAT_SHEET = "cheat_sheet";
    private static final String TOOLTIP_PREFIX = "tooltip";

    private static Map<Presentation, PersistedChartDefinition> getLookup() {
        if (lookup == null) {
            lookup = new HashMap<Presentation, PersistedChartDefinition>();
        }
        return lookup;
    }

    public static PersistedChartDefinition getDefinition(Presentation presentation) {
        PersistedChartDefinition definition = PersistedChartDefinition.getLookup().get(presentation);
        if (definition == null && presentation != null) {
            PersistedChartDefinition.updateDefinition(presentation);
        }
        return definition;
    }

    private PersistedChartDefinition(Presentation presentation) {
        super(presentation.getCode());
        this.type = ChartType.deriveFrom(presentation.getImplType());
        ColumnReference[][] columns = presentation.getPresentationColumns();
        String[] labels = presentation.getPresentationColumnLabels();
        this.tableCategorisation = presentation.getCategorization();
        this.code = presentation.getCode();
        switch (this.type) {
            case HISTOGRAM: {
                String parmString;
                ColumnContainment[] containment = this.assessContainment(columns, labels);
                String parameter = presentation.getParameter("chart_heading");
                String heading = Messages.hasString(parameter) ? Messages.getString(parameter) : parameter;
                parameter = presentation.getParameter("left_axis");
                String leftAxis = Messages.hasString(parameter) ? Messages.getString(parameter) : parameter;
                parameter = presentation.getParameter("right_axis");
                String rightAxis = Messages.hasString(parameter) ? Messages.getString(parameter) : parameter;
                parameter = presentation.getTitle();
                String maintitle = Messages.hasString(parameter) ? Messages.getString(parameter) : parameter;
                parameter = presentation.getFormattedLabelString();
                String string = parmString = Messages.hasString(parameter) ? Messages.getString(parameter) : parameter;
                this.specificDefns = containment == null ? new HistogramChartSpecificDefinitions(ColumnDefinition.convert(columns[0]), columns.length > 1 ? ColumnDefinition.convert(columns[1]) : new ColumnDefinition[]{}, leftAxis, rightAxis, heading, new MessagePackage(parmString, ColumnDefinition.convert(presentation.getFormattedLabelColumns()))) : new HistogramChartSpecificDefinitions(containment[0], leftAxis, rightAxis, heading, new MessagePackage(parmString, ColumnDefinition.convert(presentation.getFormattedLabelColumns())));
                this.title = maintitle;
                this.chartCategorisation = new ChartCategorisation[]{ChartCategorisation.getByName(presentation.getParameter("categorisation"))};
                break;
            }
            case COMPACT_HISTOGRAM: {
                String parmString;
                ColumnContainment[] containment = this.assessContainment(columns, labels);
                String parameter = presentation.getParameter("chart_heading");
                String heading = Messages.hasString(parameter) ? Messages.getString(parameter) : parameter;
                parameter = presentation.getParameter("left_axis");
                String leftAxis = Messages.hasString(parameter) ? Messages.getString(parameter) : parameter;
                parameter = presentation.getParameter("right_axis");
                String rightAxis = Messages.hasString(parameter) ? Messages.getString(parameter) : parameter;
                parameter = presentation.getTitle();
                String maintitle = Messages.hasString(parameter) ? Messages.getString(parameter) : parameter;
                parameter = presentation.getFormattedLabelString();
                String string = parmString = Messages.hasString(parameter) ? Messages.getString(parameter) : parameter;
                this.specificDefns = containment == null ? new CompactHistogramChartSpecificDefinitions(ColumnDefinition.convert(columns[0]), columns.length > 1 ? ColumnDefinition.convert(columns[1]) : new ColumnDefinition[]{}, leftAxis, rightAxis, heading, new MessagePackage(parmString, ColumnDefinition.convert(presentation.getFormattedLabelColumns()))) : new CompactHistogramChartSpecificDefinitions(containment[0], leftAxis, rightAxis, heading, new MessagePackage(parmString, ColumnDefinition.convert(presentation.getFormattedLabelColumns())));
                this.title = maintitle;
                this.chartCategorisation = new ChartCategorisation[]{ChartCategorisation.getByName(presentation.getParameter("categorisation"))};
                break;
            }
            case COMBINEDHISTOGRAMLINE: {
                ColumnContainment[] containment = this.assessContainment(columns, labels);
                String parameter = presentation.getParameter("chart_heading");
                String heading = Messages.hasString(parameter) ? Messages.getString(parameter) : parameter;
                parameter = presentation.getParameter("left_axis");
                String leftAxis = Messages.hasString(parameter) ? Messages.getString(parameter) : parameter;
                parameter = presentation.getParameter("right_axis");
                String rightAxis = Messages.hasString(parameter) ? Messages.getString(parameter) : parameter;
                parameter = presentation.getTitle();
                String maintitle = Messages.hasString(parameter) ? Messages.getString(parameter) : parameter;
                parameter = presentation.getFormattedLabelString();
                String parmString = Messages.hasString(parameter) ? Messages.getString(parameter) : parameter;
                ColumnReference reference = null;
                String ref = ColumnDefinition.APPLID.getDBColumnRef();
                boolean sortDescending = true;
                if (presentation.getSelection().getOrderBy() != null && presentation.getSelection().getOrderBy().getColumns() != null && (reference = (ColumnReference)presentation.getSelection().getOrderBy().getColumns().get(0)) != null) {
                    ref = reference.getColumnName();
                    boolean bl = sortDescending = reference.getDirection() == Direction.DESC;
                }
                this.specificDefns = containment == null ? new SortedCombinedHistogramLineSpecificDefinitions(ColumnDefinition.convert(columns[0]), columns.length > 1 ? ColumnDefinition.convert(columns[1]) : new ColumnDefinition[]{}, leftAxis, rightAxis, heading, new MessagePackage(parmString, ColumnDefinition.convert(presentation.getFormattedLabelColumns())), ColumnDefinition.getByDBColumnRef(ref), sortDescending) : new SortedCombinedHistogramLineSpecificDefinitions(containment[0], leftAxis, rightAxis, heading, new MessagePackage(parmString, ColumnDefinition.convert(presentation.getFormattedLabelColumns())), ColumnDefinition.getByDBColumnRef(ref), sortDescending);
                this.title = maintitle;
                this.chartCategorisation = new ChartCategorisation[]{ChartCategorisation.getByName(presentation.getParameter("categorisation"))};
                break;
            }
            case PIE: {
                ColumnContainment[] containment = this.assessContainment(columns, labels);
                String parameter = presentation.getParameter("chart_heading");
                String heading = Messages.hasString(parameter) ? Messages.getString(parameter) : parameter;
                int incrementor = 0;
                String parm = LABEL_PREFIX + incrementor;
                ArrayList<String> quickList = new ArrayList<String>();
                parameter = presentation.getParameter(parm);
                while (parameter != null) {
                    quickList.add(Messages.hasString(parameter) ? Messages.getString(parameter) : parameter);
                    parm = LABEL_PREFIX + ++incrementor;
                    parameter = presentation.getParameter(parm);
                }
                String[] labels1 = quickList.toArray(new String[quickList.size()]);
                incrementor = 0;
                parm = TOOLTIP_PREFIX + incrementor;
                quickList.clear();
                parameter = presentation.getParameter(parm);
                while (parameter != null) {
                    quickList.add(Messages.hasString(parameter) ? Messages.getString(parameter) : parameter);
                    parm = TOOLTIP_PREFIX + ++incrementor;
                    parameter = presentation.getParameter(parm);
                }
                String[] tooltips1 = quickList.toArray(new String[quickList.size()]);
                parameter = presentation.getTitle();
                String maintitle = Messages.hasString(parameter) ? Messages.getString(parameter) : parameter;
                parameter = presentation.getFormattedLabelString();
                String parmString = Messages.hasString(parameter) ? Messages.getString(parameter) : parameter;
                this.specificDefns = new PieChartSpecificDefinitions(new MessagePackage(parmString, ColumnDefinition.convert(presentation.getFormattedLabelColumns())), containment, labels1, tooltips1, presentation.getParameter("top_column"));
                this.title = maintitle;
                this.chartCategorisation = new ChartCategorisation[]{ChartCategorisation.getByName(presentation.getParameter("categorisation"))};
                break;
            }
            case SHEET: {
                this.title = presentation.getTitle();
                this.chartCategorisation = new ChartCategorisation[]{ChartCategorisation.getByName(presentation.getParameter("categorisation"))};
                break;
            }
            case INTERVAL_PLOT: {
                this.title = presentation.getTitle();
                String parameter = presentation.getTitle();
                this.title = Messages.hasString(parameter) ? Messages.getString(parameter) : parameter;
                parameter = presentation.getParameter("chart_content");
                String maintitle = Messages.hasString(parameter) ? Messages.getString(parameter) : parameter;
                this.chartCategorisation = new ChartCategorisation[]{ChartCategorisation.getByName(presentation.getParameter("categorisation"))};
                int incrementor = 0;
                String parm = PLOT_PREFIX + incrementor;
                String perc = PERCENT_PREFIX + incrementor;
                ArrayList<PlotPoint> plotList = new ArrayList<PlotPoint>();
                parameter = presentation.getParameter(parm);
                String percent = presentation.getParameter(perc);
                while (Utilities.hasContent((String)parameter)) {
                    ColumnDefinition defn = ColumnDefinition.getByDBColumnRef(parameter);
                    if (defn != ColumnDefinition.UNKNOWN) {
                        ColumnDefinition percentage;
                        PlotPoint point = new PlotPoint(defn);
                        if (Utilities.hasContent((String)percent) && (percentage = ColumnDefinition.getByDBColumnRef(percent)) != ColumnDefinition.UNKNOWN) {
                            point.addPercent(percentage);
                        }
                        plotList.add(point);
                    }
                    parm = PLOT_PREFIX + ++incrementor;
                    perc = PERCENT_PREFIX + incrementor;
                    parameter = presentation.getParameter(parm);
                    percent = presentation.getParameter(perc);
                }
                incrementor = 0;
                parm = LINE_PREFIX + incrementor;
                ArrayList<ColumnDefinition> lineList = new ArrayList<ColumnDefinition>();
                parameter = presentation.getParameter(parm);
                while (Utilities.hasContent((String)parameter)) {
                    ColumnDefinition defn = ColumnDefinition.getByDBColumnRef(parameter);
                    if (defn != ColumnDefinition.UNKNOWN) {
                        lineList.add(defn);
                    }
                    parm = LINE_PREFIX + ++incrementor;
                    parameter = presentation.getParameter(parm);
                }
                incrementor = 0;
                parm = ALTERNATIVE_COLUMN_PREFIX + incrementor;
                ArrayList<ColumnDefinition> altColumnLabels = new ArrayList<ColumnDefinition>();
                parameter = presentation.getParameter(parm);
                while (Utilities.hasContent((String)parameter)) {
                    ColumnDefinition defn = ColumnDefinition.getByDBColumnRef(parameter);
                    if (defn != ColumnDefinition.UNKNOWN) {
                        altColumnLabels.add(defn);
                    }
                    parm = ALTERNATIVE_COLUMN_PREFIX + ++incrementor;
                    parameter = presentation.getParameter(parm);
                }
                incrementor = 0;
                parm = RENAME_COLUMN_PREFIX + incrementor;
                ArrayList<ColumnDefinition> renameColumnLabels = new ArrayList<ColumnDefinition>();
                parameter = presentation.getParameter(parm);
                while (Utilities.hasContent((String)parameter)) {
                    ColumnDefinition defn = ColumnDefinition.getByDBColumnRef(parameter);
                    if (defn != ColumnDefinition.UNKNOWN) {
                        renameColumnLabels.add(defn);
                    }
                    parm = RENAME_COLUMN_PREFIX + ++incrementor;
                    parameter = presentation.getParameter(parm);
                }
                incrementor = 0;
                parm = SUB_COLUMN_LABEL_PREFIX + incrementor;
                ArrayList<ColumnDefinition> subColumnLabels = new ArrayList<ColumnDefinition>();
                parameter = presentation.getParameter(parm);
                while (Utilities.hasContent((String)parameter)) {
                    ColumnDefinition defn = ColumnDefinition.getByDBColumnRef(parameter);
                    if (defn != ColumnDefinition.UNKNOWN) {
                        subColumnLabels.add(defn);
                    }
                    parm = SUB_COLUMN_LABEL_PREFIX + ++incrementor;
                    parameter = presentation.getParameter(parm);
                }
                incrementor = 0;
                parm = SUB_COLUMN_VALUE_PREFIX + incrementor;
                ArrayList<ColumnDefinition> subColumnValues = new ArrayList<ColumnDefinition>();
                parameter = presentation.getParameter(parm);
                while (Utilities.hasContent((String)parameter)) {
                    ColumnDefinition defn = ColumnDefinition.getByDBColumnRef(parameter);
                    if (defn != ColumnDefinition.UNKNOWN) {
                        subColumnValues.add(defn);
                    }
                    parm = SUB_COLUMN_VALUE_PREFIX + ++incrementor;
                    parameter = presentation.getParameter(parm);
                }
                String alternative_presentation = presentation.getParameter(ALTERNATIVE_PRESENTATION);
                String merge_presentation = presentation.getParameter(MERGE_PRESENTATION);
                parameter = presentation.getParameter(TEXT_NUMBER_PREFIX);
                ColumnDefinition tvalue = parameter == null ? null : ColumnDefinition.getByDBColumnRef(parameter);
                String cheat = presentation.getParameter(CHEAT_SHEET);
                this.specificDefns = new IntervalSpecificDefinitions(plotList, lineList, altColumnLabels, renameColumnLabels, subColumnLabels, subColumnValues, tvalue, cheat, alternative_presentation, merge_presentation);
                this.chartCategorisation = new ChartCategorisation[]{ChartCategorisation.getByName(presentation.getParameter("categorisation"))};
            }
        }
    }

    @Override
    public List<ColumnDefinition> getAllColumnDefinitions() {
        ArrayList<ColumnDefinition> results = new ArrayList<ColumnDefinition>();
        results.addAll(this.specificDefns.getAllColumns());
        return results;
    }

    @Override
    public ChartCategorisation[] getCategorisation() {
        return this.chartCategorisation;
    }

    public ChartCategorisation[] getChartCategorisation() {
        return this.chartCategorisation;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        switch (this.getType()) {
            case PIE: {
                return Activator.getDefault().getImageDescriptor("pie");
            }
            case LINE: 
            case COMPACT_HISTOGRAM: {
                return Activator.getDefault().getImageDescriptor(LINE_PREFIX);
            }
        }
        return Activator.getDefault().getImageDescriptor("histogram");
    }

    @Override
    public ChartSpecificDefinitions getSpecificType() {
        return this.specificDefns;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public String getTableCategorisation() {
        return this.tableCategorisation;
    }

    @Override
    public ChartType getType() {
        return this.type;
    }

    private ColumnContainment[] assessContainment(ColumnReference[][] columnRefs, String[] labels) {
        ArrayList<ColumnContainment> cols = new ArrayList<ColumnContainment>();
        int i = 0;
        while (i < columnRefs.length) {
            if (Utilities.hasContent((String)labels[i])) {
                cols.add(new ColumnContainment(ColumnDefinition.getByDBColumnRef(labels[i]), ColumnDefinition.convert(columnRefs[i])));
            }
            ++i;
        }
        if (cols.size() > 0) {
            return cols.toArray(new ColumnContainment[cols.size()]);
        }
        return null;
    }

    public static PersistedChartDefinition updateDefinition(Presentation presentation) {
        PersistedChartDefinition definition = new PersistedChartDefinition(presentation);
        PersistedChartDefinition.getLookup().put(presentation, definition);
        return definition;
    }

    public String toString() {
        return String.valueOf(this.title) + ' ' + this.code;
    }
}

