/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.model.definitions;

import com.ibm.cics.eclipse.common.Utilities;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.StringTokenizer;

public enum DataProviderKey {
    HST006A(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_DURATION, ColumnDefinition.INTERVAL_NUMBER, ColumnDefinition.LOCATION, ColumnDefinition.DSA_NAME}),
    HST011A(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_DURATION, ColumnDefinition.INTERVAL_NUMBER, ColumnDefinition.TRAN_ID}),
    DSA_NAME(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_DURATION, ColumnDefinition.INTERVAL_NUMBER, ColumnDefinition.DSA_NAME}),
    HST012A(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_DURATION, ColumnDefinition.INTERVAL_NUMBER, ColumnDefinition.TCLASS_NAME}),
    HST017A(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_DURATION, ColumnDefinition.INTERVAL_NUMBER, ColumnDefinition.POOL_NAME, ColumnDefinition.TARGET_NAME}),
    HST016A(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_DURATION, ColumnDefinition.INTERVAL_NUMBER, ColumnDefinition.POOL_NAME}),
    HST018A(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_DURATION, ColumnDefinition.INTERVAL_NUMBER, ColumnDefinition.TARGET_NAME, ColumnDefinition.POOL_NAME}),
    HST031A(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_DURATION, ColumnDefinition.INTERVAL_NUMBER, ColumnDefinition.LIB_NAME}),
    HST034A(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_DURATION, ColumnDefinition.INTERVAL_NUMBER, ColumnDefinition.TERMINAL_ID}),
    HST040A(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_DURATION, ColumnDefinition.INTERVAL_NUMBER, ColumnDefinition.LSR_POOL_NUMBER, ColumnDefinition.FILE_NAME}),
    HST039A(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_DURATION, ColumnDefinition.INTERVAL_NUMBER, ColumnDefinition.LSR_POOL_NUMBER}),
    HST042A(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_DURATION, ColumnDefinition.INTERVAL_NUMBER, ColumnDefinition.TD_QUEUE_ID}),
    HST052A(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_DURATION, ColumnDefinition.INTERVAL_NUMBER, ColumnDefinition.CONNECTION_NAME}),
    HST060B(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_DURATION, ColumnDefinition.INTERVAL_NUMBER, ColumnDefinition.TCB_MODE_NAME}),
    HST060C(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_DURATION, ColumnDefinition.INTERVAL_NUMBER, ColumnDefinition.TCB_POOL}),
    HST065A(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_DURATION, ColumnDefinition.INTERVAL_NUMBER, ColumnDefinition.TCB_ADDRESS}),
    HST067A(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_DURATION, ColumnDefinition.INTERVAL_NUMBER, ColumnDefinition.FILE_NAME}),
    HST074A(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_DURATION, ColumnDefinition.INTERVAL_NUMBER, ColumnDefinition.QUEUE_MANAGER_NAME}),
    HST076A(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_NUMBER, ColumnDefinition.APPC_SYSTEM_NAME, ColumnDefinition.MODE_NAME}),
    DUMP(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_DURATION, ColumnDefinition.INTERVAL_NUMBER, ColumnDefinition.DUMP_CODE}),
    HST093A(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_DURATION, ColumnDefinition.INTERVAL_NUMBER, ColumnDefinition.JOURNAL_NAME}),
    HST094A(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_DURATION, ColumnDefinition.INTERVAL_NUMBER, ColumnDefinition.LOGSTREAM_NAME}),
    HST100A(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_DURATION, ColumnDefinition.INTERVAL_NUMBER, ColumnDefinition.BUNDLE_NAME}),
    HST102A(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_DURATION, ColumnDefinition.INTERVAL_NUMBER, ColumnDefinition.DB2CONN_NAME}),
    HST103A(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_DURATION, ColumnDefinition.INTERVAL_NUMBER, ColumnDefinition.DB2ENTRY_NAME}),
    HST104A(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_DURATION, ColumnDefinition.INTERVAL_NUMBER, ColumnDefinition.URIMAP_NAME}),
    HST105A(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_DURATION, ColumnDefinition.INTERVAL_NUMBER, ColumnDefinition.PIPELINE_NAME}),
    HST106A(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_DURATION, ColumnDefinition.INTERVAL_NUMBER, ColumnDefinition.WEBSERVICE_NAME}),
    HST108A(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_DURATION, ColumnDefinition.INTERVAL_NUMBER, ColumnDefinition.TCPIP_SERVICE}),
    HST109A(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_DURATION, ColumnDefinition.INTERVAL_NUMBER, ColumnDefinition.IPCONN_NAME}),
    HST110A(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_DURATION, ColumnDefinition.INTERVAL_NUMBER, ColumnDefinition.ATOMSERVICE_NAME}),
    HST112A(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_DURATION, ColumnDefinition.INTERVAL_NUMBER, ColumnDefinition.DOCTEMPLATE_NAME}),
    HST113A(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_DURATION, ColumnDefinition.INTERVAL_NUMBER, ColumnDefinition.XMLTRANSFORM_NAME}),
    HST114A(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_DURATION, ColumnDefinition.INTERVAL_NUMBER, ColumnDefinition.CORBASERVER_NAME}),
    HST115A(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_DURATION, ColumnDefinition.INTERVAL_NUMBER, ColumnDefinition.BEAN_NAME, ColumnDefinition.CORBASERVER_NAME, ColumnDefinition.DJAR_NAME}),
    HST116A(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_DURATION, ColumnDefinition.INTERVAL_NUMBER, ColumnDefinition.JVMSERVER_NAME}),
    HST118A(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_DURATION, ColumnDefinition.INTERVAL_NUMBER, ColumnDefinition.JVM_PROFILE_NAME}),
    HST143A(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_DURATION, ColumnDefinition.INTERVAL_NUMBER, ColumnDefinition.EVENTBINDING_NAME, ColumnDefinition.CAPTURESPEC_NAME}),
    HST141A(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_DURATION, ColumnDefinition.INTERVAL_NUMBER, ColumnDefinition.EVENTBINDING_NAME}),
    ALERT(new ColumnDefinition[]{ColumnDefinition.ALERT, ColumnDefinition.SEVERITY, ColumnDefinition.RESOURCE_VALUE}),
    STATS_DEFAULT(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_NUMBER}),
    STARTTIME_APPLID_SUBPOOL_NAME(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_DURATION, ColumnDefinition.INTERVAL_NUMBER, ColumnDefinition.SUBPOOL_NAME}),
    STARTTIME_APPLID_PROGRAM(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_DURATION, ColumnDefinition.INTERVAL_NUMBER, ColumnDefinition.PROGRAM_NAME}),
    STARTTIME_APPLID_TRAN(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.TRAN}),
    PERFORMANCE_ALERT(new ColumnDefinition[]{ColumnDefinition.START, ColumnDefinition.STOP, ColumnDefinition.APPLID, ColumnDefinition.TRAN, ColumnDefinition.TASKNO}),
    PERFORMANCE_LIST(new ColumnDefinition[]{ColumnDefinition.START, ColumnDefinition.STOP, ColumnDefinition.APPLID, ColumnDefinition.TRAN, ColumnDefinition.TASKNO}),
    STARTTIME_APPLICATION(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.ACPLATNM, ColumnDefinition.ACAPPLNM, ColumnDefinition.ACAPPLVR, ColumnDefinition.ACOPERNM}),
    NONE(new ColumnDefinition[0]),
    APPLID_ONLY(new ColumnDefinition[]{ColumnDefinition.APPLID}),
    TRAN_ONLY(new ColumnDefinition[]{ColumnDefinition.TRAN}),
    APPLID_TRAN(new ColumnDefinition[]{ColumnDefinition.APPLID, ColumnDefinition.TRAN}),
    HST010A(new ColumnDefinition[]{ColumnDefinition.START_DATE, ColumnDefinition.START_TIME, ColumnDefinition.APPLID, ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_NUMBER});

    private static List<ColumnDefinition> boringList;
    private ColumnDefinition[] definitions;
    public static final String mementoReference = "DataStructure";

    static {
        boringList = new ArrayList<ColumnDefinition>(Arrays.asList(ColumnDefinition.MVSID, ColumnDefinition.VRM, ColumnDefinition.INTERVAL_TYPE, ColumnDefinition.INTERVAL_DURATION, ColumnDefinition.INTERVAL_NUMBER, ColumnDefinition.PROGRAM_NAME));
    }

    private DataProviderKey(ColumnDefinition[] definitions) {
        this.definitions = definitions;
    }

    public ColumnDefinition[] getColumnDefinitions() {
        return this.definitions;
    }

    public static DataProviderKey getByName(String ref) {
        for (DataProviderKey reference : EnumSet.allOf(DataProviderKey.class)) {
            if (!reference.name().equals(ref)) continue;
            return reference;
        }
        return null;
    }

    public static DataProviderKey matchOn(Object[] keys, boolean isDB) {
        for (DataProviderKey provider : EnumSet.allOf(DataProviderKey.class)) {
            ArrayList<ColumnDefinition> providerdef = new ArrayList<ColumnDefinition>(Arrays.asList(provider.definitions));
            int matchedCount = 0;
            int counter = 0;
            while (counter < keys.length) {
                ColumnDefinition defn;
                ColumnDefinition columnDefinition = defn = isDB ? ColumnDefinition.getByDBColumnRef((String)keys[counter]) : ColumnDefinition.getByColumnRef((String)keys[counter]);
                if (defn != null && providerdef.contains(defn)) {
                    providerdef.remove(defn);
                    ++matchedCount;
                }
                if (matchedCount == provider.definitions.length) {
                    if (provider == PERFORMANCE_ALERT && keys.length > 50) {
                        provider = PERFORMANCE_LIST;
                    }
                    return provider;
                }
                ++counter;
            }
        }
        return NONE;
    }

    public static DataProviderKey parse(String keyString) {
        String value;
        StringTokenizer tokenizer = new StringTokenizer(keyString, ",");
        ArrayList<String> valueList = new ArrayList<String>();
        while (tokenizer.hasMoreElements()) {
            value = tokenizer.nextToken().trim().toUpperCase();
            if (!Utilities.hasContent((String)value)) continue;
            if (value.equals("START")) {
                value = tokenizer.nextToken().trim().toUpperCase();
                if (value.equals("STOP")) {
                    valueList.add("START");
                    valueList.add("STOP");
                    continue;
                }
                valueList.add(ColumnDefinition.START_DATE.getDBColumnRef());
                valueList.add(ColumnDefinition.START_TIME.getDBColumnRef());
                valueList.add(value);
                continue;
            }
            valueList.add(value);
        }
        DataProviderKey result = DataProviderKey.matchOn(valueList.toArray(), true);
        if (result == NONE) {
            tokenizer = new StringTokenizer(keyString, ",");
            valueList = new ArrayList();
            valueList.add(ColumnDefinition.START_DATE.getDBColumnRef());
            valueList.add(ColumnDefinition.START_TIME.getDBColumnRef());
            valueList.add(ColumnDefinition.APPLID.getDBColumnRef());
            valueList.add(ColumnDefinition.MVSID.getDBColumnRef());
            valueList.add(ColumnDefinition.VRM.getDBColumnRef());
            valueList.add(ColumnDefinition.INTERVAL_TYPE.getDBColumnRef());
            valueList.add(ColumnDefinition.INTERVAL_NUMBER.getDBColumnRef());
            while (tokenizer.hasMoreElements()) {
                value = tokenizer.nextToken().trim().toUpperCase();
                if (!Utilities.hasContent((String)value)) continue;
                valueList.add(value);
            }
            result = DataProviderKey.matchOn(valueList.toArray(), true);
        }
        return result;
    }

    public boolean isNotAKey() {
        return this.equals((Object)NONE);
    }

    public boolean isValidKey() {
        return !this.isNotAKey();
    }

    public ColumnDefinition getNext(ColumnDefinition column) {
        ColumnDefinition defn = null;
        int i = 0;
        while (i < this.definitions.length) {
            if (column == null) {
                return this.definitions[0];
            }
            if (column.equals(this.definitions[i]) && i + 1 < this.definitions.length) {
                int disp = i + 1;
                while (disp < this.definitions.length) {
                    if (!boringList.contains(this.definitions[disp])) {
                        return this.definitions[disp];
                    }
                    ++disp;
                }
            }
            ++i;
        }
        return defn;
    }

    public boolean contains(ColumnDefinition aDefn) {
        ColumnDefinition[] columnDefinitionArray = this.definitions;
        int n = this.definitions.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnDefinition defn = columnDefinitionArray[n2];
            if (defn == aDefn) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

