/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.model.definitions;

import com.ibm.cics.eclipse.common.Utilities;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.Activator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class ColumnDefinitionHelper {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Map<ColumnDefinition, ColumnDefinition[]> mapping = new HashMap<ColumnDefinition, ColumnDefinition[]>(){
        {
            this.put(ColumnDefinition.DISPATCH_TIME_AVG, new ColumnDefinition[]{ColumnDefinition.CPU_TIME_AVG});
            this.put(ColumnDefinition.SUSPEND_TIME_AVG, new ColumnDefinition[]{ColumnDefinition.DISPWAIT_TIME_AVG});
            this.put(ColumnDefinition.MSCPU_TIME_AVG, new ColumnDefinition[]{ColumnDefinition.ROCPU_TIME_AVG});
            this.put(ColumnDefinition.CPU_TIME_AVG, new ColumnDefinition[]{ColumnDefinition.QRCPU_TIME_AVG, ColumnDefinition.MSCPU_TIME_AVG, ColumnDefinition.KY8CPU_TIME_AVG, ColumnDefinition.KY9CPU_TIME_AVG});
            this.put(ColumnDefinition.KY9CPU_TIME_AVG, new ColumnDefinition[]{ColumnDefinition.J9CPU_TIME_AVG, ColumnDefinition.L9CPU_TIME_AVG, ColumnDefinition.X9CPU_TIME_AVG});
            this.put(ColumnDefinition.KY8CPU_TIME_AVG, new ColumnDefinition[]{ColumnDefinition.J8CPU_TIME_AVG, ColumnDefinition.L8CPU_TIME_AVG, ColumnDefinition.S8CPU_TIME_AVG, ColumnDefinition.X8CPU_TIME_AVG});
            this.put(ColumnDefinition.RESPONSE_TIME_AVG, new ColumnDefinition[]{ColumnDefinition.MSCPU_TIME_AVG, ColumnDefinition.KY9CPU_TIME_AVG, ColumnDefinition.KY8CPU_TIME_AVG, ColumnDefinition.QRCPU_TIME_AVG});
            this.put(ColumnDefinition.QRCPU_TIME_AVG, new ColumnDefinition[0]);
        }
    };

    public static void main(String[] args) {
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String label = stringArray[n2];
            String nicelabel = label.toLowerCase().replace('_', ' ');
            nicelabel = nicelabel.replaceAll("db2", "DB2 ");
            nicelabel = nicelabel.replaceAll("count", "Count");
            nicelabel = nicelabel.replaceAll("time", "Time");
            nicelabel = nicelabel.replaceAll("wait", "Wait");
            nicelabel = nicelabel.replaceAll("avg", "Avg");
            nicelabel = nicelabel.replaceAll("lu6", "LU6");
            nicelabel = nicelabel.replaceAll("ims", "IMS ");
            nicelabel = nicelabel.replaceAll("ky8", "Ky8 ");
            nicelabel = nicelabel.replaceAll("ky9", "Ky9 ");
            nicelabel = nicelabel.replaceAll("sc2", "SC2");
            nicelabel = nicelabel.replaceAll("sc3", "SC3");
            nicelabel = nicelabel.replaceAll("rmi", "RMI ");
            System.out.println("ColumnDefinition." + label + "=" + nicelabel);
            ++n2;
        }
    }

    public static boolean definitionHasChildren(ColumnDefinition definition) {
        return mapping.keySet().contains(definition) && ColumnDefinitionHelper.getDefinitionChildren(definition).length > 0;
    }

    public static ColumnDefinition[] getDefinitionChildren(ColumnDefinition definition) {
        return mapping.get(definition);
    }

    public static ColumnDefinition[] getDefinitionParent(ColumnDefinition definition) {
        ArrayList<ColumnDefinition> parents = new ArrayList<ColumnDefinition>();
        for (ColumnDefinition key : mapping.keySet()) {
            ColumnDefinition[] columnDefinitionArray = mapping.get(key);
            int n = columnDefinitionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ColumnDefinition defn = columnDefinitionArray[n2];
                if (defn.equals(definition)) {
                    parents.add(key);
                }
                ++n2;
            }
        }
        return parents.toArray(new ColumnDefinition[parents.size()]);
    }

    public static RGB definitionRGB(ColumnDefinition definition) {
        RGB colour = StringConverter.asRGB((String)Platform.getPreferencesService().getString(Activator.getDefault().getBundle().getSymbolicName(), definition.getDBColumnRef(), "255,255,255", null));
        if (colour == null) {
            return new RGB(0, 0, 0);
        }
        return colour;
    }

    public static RGB defaultDefinitionRGB(ColumnDefinition definition) {
        IEclipsePreferences store = Activator.getDefault().getPluginDefaultPreferences();
        RGB colour = StringConverter.asRGB((String)store.get(definition.getDBColumnRef(), null));
        if (colour == null) {
            return new RGB(0, 0, 0);
        }
        return colour;
    }

    public static void setDefinitionRGB(RGB rgb, ColumnDefinition definition) {
        IEclipsePreferences store = Activator.getDefault().getPluginInstancePreferences();
        store.put(definition.getDBColumnRef(), StringConverter.asString((RGB)rgb));
    }

    public static RGB resetDefinitionRGB(ColumnDefinition definition) {
        IEclipsePreferences instance_store = Activator.getDefault().getPluginInstancePreferences();
        IEclipsePreferences store = Activator.getDefault().getPluginDefaultPreferences();
        String colour = store.get(definition.getDBColumnRef(), null);
        if (colour == null) {
            colour = StringConverter.asString((RGB)new RGB(0, 0, 0));
        }
        instance_store.put(definition.getDBColumnRef(), colour);
        return StringConverter.asRGB((String)colour);
    }

    public static IPropertyDescriptor[] createPropertyDescriptors(ColumnDefinition[] columnDefinitions) {
        ArrayList<PropertyDescriptor> descriptorArray = new ArrayList<PropertyDescriptor>();
        int i = 0;
        while (i < columnDefinitions.length) {
            if (!columnDefinitions[i].equals(ColumnDefinition.UNKNOWN)) {
                PropertyDescriptor descriptor = new PropertyDescriptor((Object)columnDefinitions[i].getDBColumnRef(), columnDefinitions[i].getLabel(null));
                String description = columnDefinitions[i].getTooltip(null);
                if (Utilities.hasContent((String)description)) {
                    descriptor.setDescription(description);
                }
                descriptor.setAlwaysIncompatible(true);
                descriptorArray.add(descriptor);
            }
            ++i;
        }
        return descriptorArray.toArray(new IPropertyDescriptor[descriptorArray.size()]);
    }
}

