/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.model;

import com.ibm.cics.pa.model.Chart;
import com.ibm.cics.pa.model.GenericDataProvider;
import com.ibm.cics.pa.model.IUniqueRecord;
import com.ibm.cics.pa.model.TreeElement;
import com.ibm.cics.pa.model.definitions.ChartSpecification;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.YardStickSpecificDefinitions;
import com.ibm.cics.pa.ui.Activator;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;

public class YardStick
extends Chart {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Object[] row = null;
    private IUniqueRecord explorerViewModel = null;
    private String primaryAxisLabel;
    private Map<ColumnDefinition, Object> completeValues;
    private String elementName;

    public YardStick(ChartSpecification chartReference, GenericDataProvider dataStore, Map<ColumnDefinition, Object> values, String elementName, IUniqueRecord record) {
        super(chartReference, dataStore);
        this.row = record.getRow();
        this.primaryAxisLabel = ((YardStickSpecificDefinitions)chartReference.getSpecificType()).getPkg().resolve(dataStore.getColumnDefinitions(), this.row);
        this.completeValues = values;
        this.elementName = elementName;
        this.explorerViewModel = record;
        this.chartTitle = String.valueOf(this.chartTitle) + record.getLabel();
        this.setChartId(String.valueOf(chartReference.name()) + " " + dataStore.getFileReference() + " " + elementName);
        references.put(this.getChartId(), this);
    }

    public IUniqueRecord getUniqueRecord() {
        if (this.explorerViewModel == null && this.getDataProvider() != null) {
            this.explorerViewModel = ((TreeElement)this.getDataProvider().getRootTreeElement().getChildren()[0]).findExplorerViewModelElement(this.row);
        }
        return this.explorerViewModel;
    }

    public Object[] getRow() {
        return this.row;
    }

    @Override
    public String getPrimaryLabel() {
        return this.primaryAxisLabel;
    }

    public ImageDescriptor getImageDescriptor() {
        return Activator.getDefault().getImageDescriptor("pie");
    }

    public Map<ColumnDefinition, Object> getCompleteValues() {
        return this.completeValues;
    }

    public String getElementName() {
        return this.elementName;
    }

    public boolean noData() {
        for (Object values : this.completeValues.values()) {
            if (!(values instanceof Number)) continue;
            return false;
        }
        return true;
    }
}

