/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.pa.model.Pie;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import java.text.MessageFormat;

public class WaitAnalysis {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(WaitAnalysis.class);
    public static final int MULTIPLIER = 600;
    private static final int FUDGE_FACTOR = 5;
    private ColumnDefinition[] requiredColumns = new ColumnDefinition[]{ColumnDefinition.RESPONSE_TIME_AVG, ColumnDefinition.SUSPEND_TIME_AVG, ColumnDefinition.DISPWAIT_TIME_AVG, ColumnDefinition.DISPATCH_TIME_AVG, ColumnDefinition.CPU_TIME_AVG, ColumnDefinition.SUSPEND_COUNT_AVG, ColumnDefinition.DISPWAIT_COUNT_AVG, ColumnDefinition.DISPATCH_COUNT_AVG, ColumnDefinition.CPU_COUNT_AVG};
    private ColumnDefinition[] requiredColumnsPList = new ColumnDefinition[]{ColumnDefinition.RESPONSE_TIME, ColumnDefinition.SUSPEND_TIME, ColumnDefinition.DISPWAIT_TIME, ColumnDefinition.DISPATCH_TIME, ColumnDefinition.CPU_TIME, ColumnDefinition.SUSPEND_COUNT, ColumnDefinition.DISPWAIT_COUNT, ColumnDefinition.DISPATCH_COUNT, ColumnDefinition.CPU_COUNT};
    private Double oaFigure;
    private Double suspFigure;
    private double suspendPercent;
    private Double dispatchFigure;
    private double dispatchPercent;
    private Double dispFigure;
    private double dispPercent;
    private Double cpuFigure;
    private double cpuPercent;
    private Boolean reliable = true;
    private Double suspCount;
    private Double dispWaitCount;
    private Double userDispCount;
    private Double userCPUCount;
    private boolean isPlist;

    public WaitAnalysis(Pie startingModel) {
        debug.enter("WaitAnalysis");
        if (startingModel.isPListRecord()) {
            this.isPlist = true;
            this.initialisePList(startingModel);
        } else {
            this.initialise(startingModel);
            this.isPlist = false;
        }
        debug.exit("WaitAnalysis");
    }

    private void initialisePList(Pie startingModel) {
        debug.enter("initialisePList");
        ColumnDefinition[] columnDefinitionArray = this.requiredColumnsPList;
        int n = this.requiredColumnsPList.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnDefinition definition = columnDefinitionArray[n2];
            int position = startingModel.getDataProvider().getColumnPosition(definition);
            if (position != -1) {
                Object value = startingModel.getUniqueRecord().getRow()[startingModel.getDataProvider().getColumnPosition(definition)];
                if (definition == ColumnDefinition.RESPONSE_TIME && value != null && value instanceof Number) {
                    this.oaFigure = ((Number)value).doubleValue();
                }
                if (definition == ColumnDefinition.SUSPEND_TIME && value != null && value instanceof Number) {
                    this.suspFigure = ((Number)value).doubleValue();
                    this.suspendPercent = DataTypeUtilities.getAs2PositionPercentage(this.suspFigure, this.oaFigure);
                }
                if (definition == ColumnDefinition.SUSPEND_COUNT && value != null && value instanceof Number) {
                    this.suspCount = ((Number)value).doubleValue();
                }
                if (definition == ColumnDefinition.DISPWAIT_TIME && value != null && value instanceof Number) {
                    this.dispFigure = ((Number)value).doubleValue();
                    this.dispPercent = DataTypeUtilities.getAs2PositionPercentage(this.dispFigure, this.oaFigure);
                }
                if (definition == ColumnDefinition.DISPWAIT_COUNT && value != null && value instanceof Number) {
                    this.dispWaitCount = ((Number)value).doubleValue();
                }
                if (definition == ColumnDefinition.DISPATCH_TIME && value != null && value instanceof Number) {
                    this.dispatchFigure = ((Number)value).doubleValue();
                    this.dispatchPercent = DataTypeUtilities.getAs2PositionPercentage(this.dispatchFigure, this.oaFigure);
                }
                if (definition == ColumnDefinition.DISPATCH_COUNT && value != null && value instanceof Number) {
                    this.userDispCount = ((Number)value).doubleValue();
                }
                if (definition == ColumnDefinition.CPU_TIME && value != null && value instanceof Number) {
                    this.cpuFigure = ((Number)value).doubleValue();
                    this.cpuPercent = DataTypeUtilities.getAs2PositionPercentage(this.cpuFigure, this.oaFigure);
                }
                if (definition == ColumnDefinition.CPU_COUNT && value != null && value instanceof Number) {
                    this.userCPUCount = ((Number)value).doubleValue();
                }
            } else {
                this.reliable = false;
            }
            ++n2;
        }
        debug.exit("initialisePList");
    }

    private void initialise(Pie startingModel) {
        debug.enter("initialise");
        ColumnDefinition[] columnDefinitionArray = this.requiredColumns;
        int n = this.requiredColumns.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnDefinition definition = columnDefinitionArray[n2];
            int position = startingModel.getDataProvider().getColumnPosition(definition);
            if (position != -1) {
                Object value = startingModel.getUniqueRecord().getRow()[startingModel.getDataProvider().getColumnPosition(definition)];
                if (definition == ColumnDefinition.RESPONSE_TIME_AVG && value != null && value instanceof Number) {
                    this.oaFigure = ((Number)value).doubleValue();
                }
                if (definition == ColumnDefinition.SUSPEND_TIME_AVG && value != null && value instanceof Number) {
                    this.suspFigure = ((Number)value).doubleValue();
                    this.suspendPercent = DataTypeUtilities.getAs2PositionPercentage(this.suspFigure, this.oaFigure);
                }
                if (definition == ColumnDefinition.SUSPEND_COUNT_AVG && value != null && value instanceof Number) {
                    this.suspCount = ((Number)value).doubleValue();
                }
                if (definition == ColumnDefinition.DISPWAIT_TIME_AVG && value != null && value instanceof Number) {
                    this.dispFigure = ((Number)value).doubleValue();
                    this.dispPercent = DataTypeUtilities.getAs2PositionPercentage(this.dispFigure, this.oaFigure);
                }
                if (definition == ColumnDefinition.DISPWAIT_COUNT_AVG && value != null && value instanceof Number) {
                    this.dispWaitCount = ((Number)value).doubleValue();
                }
                if (definition == ColumnDefinition.DISPATCH_TIME_AVG && value != null && value instanceof Number) {
                    this.dispatchFigure = ((Number)value).doubleValue();
                    this.dispatchPercent = DataTypeUtilities.getAs2PositionPercentage(this.dispatchFigure, this.oaFigure);
                }
                if (definition == ColumnDefinition.DISPATCH_COUNT_AVG && value != null && value instanceof Number) {
                    this.userDispCount = ((Number)value).doubleValue();
                }
                if (definition == ColumnDefinition.CPU_TIME_AVG && value != null && value instanceof Number) {
                    this.cpuFigure = ((Number)value).doubleValue();
                    this.cpuPercent = DataTypeUtilities.getAs2PositionPercentage(this.cpuFigure, this.oaFigure);
                }
                if (definition == ColumnDefinition.CPU_COUNT_AVG && value != null && value instanceof Number) {
                    this.userCPUCount = ((Number)value).doubleValue();
                }
            } else if (definition != ColumnDefinition.CPU_COUNT_AVG || startingModel.getDataProvider().isRemote()) {
                this.reliable = false;
            }
            ++n2;
        }
        debug.exit("initialise");
    }

    public int getPixelLengthFor(ColumnDefinition definition) {
        debug.enter("getPixelLengthFor", (Object)definition);
        int length = 0;
        if (definition == ColumnDefinition.RESPONSE_TIME_AVG) {
            length = 600;
        } else if (definition == ColumnDefinition.SUSPEND_TIME_AVG || definition == ColumnDefinition.SUSPEND_TIME) {
            length = Math.round(Math.round(6.0 * this.suspendPercent));
        } else if (definition == ColumnDefinition.DISPWAIT_TIME_AVG || definition == ColumnDefinition.DISPWAIT_TIME) {
            length = Math.round(Math.round(6.0 * this.dispPercent));
        } else if (definition == ColumnDefinition.DISPATCH_TIME_AVG || definition == ColumnDefinition.DISPATCH_TIME) {
            length = Math.round(Math.round(6.0 * this.dispatchPercent));
        } else if (definition == ColumnDefinition.CPU_TIME_AVG || definition == ColumnDefinition.CPU_TIME) {
            length = Math.min(Math.round(Math.round(6.0 * this.cpuPercent)), Math.round(Math.round(6.0 * this.dispatchPercent)));
        }
        debug.exit("getPixelLengthFor", (Object)length);
        return length;
    }

    public String getLabelFor(ColumnDefinition definition) {
        debug.enter("getLabelFor");
        String label = "";
        if (definition == ColumnDefinition.RESPONSE_TIME_AVG && this.oaFigure != null) {
            label = MessageFormat.format(Messages.getString("PiePage.label.AverageResponseTime"), DataTypeUtilities.getAsString(this.oaFigure));
        } else if (definition == ColumnDefinition.SUSPEND_TIME_AVG && this.suspFigure != null) {
            label = MessageFormat.format(Messages.getString("PiePage.stdlabel.AverageSuspenseTime"), DataTypeUtilities.getAsString(this.suspFigure), Double.valueOf(this.suspendPercent).toString());
        } else if (definition == ColumnDefinition.DISPWAIT_TIME_AVG && this.dispFigure != null) {
            label = MessageFormat.format(Messages.getString("PiePage.stdlabel.AverageDispatchWaitTime"), DataTypeUtilities.getAsString(this.dispFigure), DataTypeUtilities.getAs2PositionPercentageString(this.dispFigure, this.suspFigure), Double.valueOf(this.dispPercent).toString());
        } else if (definition == ColumnDefinition.DISPATCH_TIME_AVG && this.dispatchFigure != null) {
            label = MessageFormat.format(Messages.getString("PiePage.stdlabel.AverageDispatchTime"), DataTypeUtilities.getAsString(this.dispatchFigure), Double.valueOf(this.dispatchPercent).toString());
        } else if (definition == ColumnDefinition.CPU_TIME_AVG && this.cpuFigure != null) {
            label = MessageFormat.format(Messages.getString("PiePage.stdlabel.AverageCPUTime"), DataTypeUtilities.getAsString(this.cpuFigure), DataTypeUtilities.getAs2PositionPercentageString(this.cpuFigure, this.dispatchFigure), Double.valueOf(this.cpuPercent).toString());
        } else if (definition == ColumnDefinition.RESPONSE_TIME && this.oaFigure != null) {
            label = MessageFormat.format(Messages.getString("PiePage.label.ResponseTime"), DataTypeUtilities.getAsString(this.oaFigure));
        } else if (definition == ColumnDefinition.SUSPEND_TIME && this.suspFigure != null) {
            label = MessageFormat.format(Messages.getString("PiePage.stdlabel.SuspenseTime"), DataTypeUtilities.getAsString(this.suspFigure), Double.valueOf(this.suspendPercent).toString());
        } else if (definition == ColumnDefinition.DISPWAIT_TIME && this.dispFigure != null) {
            label = MessageFormat.format(Messages.getString("PiePage.stdlabel.DispatchWaitTime"), DataTypeUtilities.getAsString(this.dispFigure), DataTypeUtilities.getAs2PositionPercentageString(this.dispFigure, this.suspFigure), Double.valueOf(this.dispPercent).toString());
        } else if (definition == ColumnDefinition.DISPATCH_TIME && this.dispatchFigure != null) {
            label = MessageFormat.format(Messages.getString("PiePage.stdlabel.DispatchTime"), DataTypeUtilities.getAsString(this.dispatchFigure), Double.valueOf(this.dispatchPercent).toString());
        } else if (definition == ColumnDefinition.CPU_TIME && this.cpuFigure != null) {
            label = MessageFormat.format(Messages.getString("PiePage.stdlabel.CPUTime"), DataTypeUtilities.getAsString(this.cpuFigure), DataTypeUtilities.getAs2PositionPercentageString(this.cpuFigure, this.dispatchFigure), Double.valueOf(this.cpuPercent).toString());
        }
        debug.exit("getLabelFor", (Object)label);
        return label;
    }

    public String getTooltipFor(ColumnDefinition definition) {
        debug.enter("getLabelFor");
        String label = "";
        if (definition == ColumnDefinition.RESPONSE_TIME_AVG && this.oaFigure != null) {
            label = MessageFormat.format(Messages.getString("PiePage.label.AverageResponseTime"), DataTypeUtilities.getAsString(this.oaFigure));
        } else if (definition == ColumnDefinition.SUSPEND_TIME_AVG && this.suspFigure != null) {
            label = MessageFormat.format(Messages.getString("PiePage.tooltip.AverageSuspenseTime"), DataTypeUtilities.getAsString(this.suspFigure), DataTypeUtilities.getAsString(this.suspCount));
        } else if (definition == ColumnDefinition.DISPWAIT_TIME_AVG && this.dispFigure != null) {
            label = MessageFormat.format(Messages.getString("PiePage.tooltip.AverageDispatchWaitTime"), DataTypeUtilities.getAsString(this.dispFigure), DataTypeUtilities.getAsString(this.dispWaitCount));
        } else if (definition == ColumnDefinition.DISPATCH_TIME_AVG && this.dispatchFigure != null) {
            label = MessageFormat.format(Messages.getString("PiePage.tooltip.AverageDispatchTime"), DataTypeUtilities.getAsString(this.dispatchFigure), DataTypeUtilities.getAsString(this.userDispCount));
        } else if (definition == ColumnDefinition.CPU_TIME_AVG && this.cpuFigure != null) {
            label = MessageFormat.format(Messages.getString("PiePage.tooltip.AverageCPUTime"), DataTypeUtilities.getAsString(this.cpuFigure), DataTypeUtilities.getAsString(this.userCPUCount));
        } else if (definition == ColumnDefinition.RESPONSE_TIME && this.oaFigure != null) {
            label = MessageFormat.format(Messages.getString("PiePage.label.ResponseTime"), DataTypeUtilities.getAsString(this.oaFigure));
        } else if (definition == ColumnDefinition.SUSPEND_TIME && this.suspFigure != null) {
            label = MessageFormat.format(Messages.getString("PiePage.tooltip.SuspenseTime"), DataTypeUtilities.getAsString(this.suspFigure), DataTypeUtilities.getAsString(this.suspCount));
        } else if (definition == ColumnDefinition.DISPWAIT_TIME && this.dispFigure != null) {
            label = MessageFormat.format(Messages.getString("PiePage.tooltip.DispatchWaitTime"), DataTypeUtilities.getAsString(this.dispFigure), DataTypeUtilities.getAsString(this.dispWaitCount));
        } else if (definition == ColumnDefinition.DISPATCH_TIME && this.dispatchFigure != null) {
            label = MessageFormat.format(Messages.getString("PiePage.tooltip.DispatchTime"), DataTypeUtilities.getAsString(this.dispatchFigure), DataTypeUtilities.getAsString(this.userDispCount));
        } else if (definition == ColumnDefinition.CPU_TIME && this.cpuFigure != null) {
            label = MessageFormat.format(Messages.getString("PiePage.tooltip.CPUTime"), DataTypeUtilities.getAsString(this.cpuFigure), DataTypeUtilities.getAsString(this.userCPUCount));
        }
        debug.exit("getLabelFor", (Object)label);
        return label;
    }

    public String getAccessibleMessage() {
        debug.enter("getAccessibleMessage");
        StringBuffer messageBuffer = new StringBuffer();
        if (this.oaFigure != null && this.isReliable()) {
            messageBuffer.append(MessageFormat.format(this.isPlist() ? "PiePage.label.ResponseTime" : Messages.getString("PiePage.label.AverageResponseTime"), DataTypeUtilities.getAsString(this.oaFigure)));
            if (this.suspFigure != null) {
                messageBuffer.append(Messages.getString(this.isPlist() ? "PiePage.label.ResponseTimeMadeUp" : "PiePage.label.AverageResponseTimeMadeUp"));
                messageBuffer.append(MessageFormat.format(Messages.getString("PiePage.label.AverageSuspenseTime"), DataTypeUtilities.getAsString(this.suspFigure), DataTypeUtilities.getAsString(this.suspendPercent)));
                if (this.dispatchFigure != null) {
                    messageBuffer.append(Messages.getString("PiePage.label.plus"));
                    messageBuffer.append(MessageFormat.format(Messages.getString(this.isPlist() ? "PiePage.label.DispatchTime" : "PiePage.label.AverageDispatchTime"), DataTypeUtilities.getAsString(this.dispatchFigure), DataTypeUtilities.getAsString(this.dispatchPercent)));
                }
            } else if (this.dispatchFigure != null) {
                messageBuffer.append(Messages.getString(this.isPlist() ? "PiePage.label.ResponseTimeMadeUp" : "PiePage.label.AverageResponseTimeMadeUp"));
                messageBuffer.append(MessageFormat.format(Messages.getString(this.isPlist() ? "PiePage.label.DispatchTime" : "PiePage.label.AverageDispatchTime"), DataTypeUtilities.getAsString(this.dispatchFigure), DataTypeUtilities.getAsString(Math.round(Math.round(100.0 * this.dispatchPercent)))));
            }
            messageBuffer.append(' ');
            if (this.dispFigure != null) {
                messageBuffer.append(MessageFormat.format(Messages.getString(this.isPlist() ? "PiePage.label.DispatchWaitTime" : "PiePage.label.AverageDispatchWaitTime"), DataTypeUtilities.getAsString(this.dispFigure), DataTypeUtilities.getAsString(Math.round(Math.round(100.0 * this.dispFigure / this.suspFigure))), DataTypeUtilities.getAsString(Math.round(Math.round(100.0 * this.dispPercent)))));
            }
            if (this.cpuFigure != null) {
                messageBuffer.append(MessageFormat.format(Messages.getString(this.isPlist() ? "PiePage.label.CPUTime" : "PiePage.label.AverageCPUTime"), DataTypeUtilities.getAsString(this.cpuFigure), DataTypeUtilities.getAsString(Math.round(Math.round(100.0 * this.cpuFigure / this.dispatchFigure))), DataTypeUtilities.getAsString(Math.round(Math.round(100.0 * this.cpuPercent)))));
            }
        } else {
            messageBuffer.append(Messages.getString("PiePage.label.dataissues"));
        }
        debug.exit("getAccessibleMessage", (Object)messageBuffer.toString());
        return messageBuffer.toString();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " " + this.getLabelFor(ColumnDefinition.RESPONSE_TIME_AVG);
    }

    public boolean isReliable() {
        debug.enter("isReliable");
        if (this.reliable == null) {
            if (this.isPlist()) {
                this.reliable = this.isPlist() ? this.getPixelLengthFor(ColumnDefinition.SUSPEND_TIME) <= 605 && this.getPixelLengthFor(ColumnDefinition.DISPWAIT_TIME) <= this.getPixelLengthFor(ColumnDefinition.SUSPEND_TIME_AVG) + 5 && this.getPixelLengthFor(ColumnDefinition.DISPATCH_TIME) <= 605 && this.getPixelLengthFor(ColumnDefinition.CPU_TIME) <= this.getPixelLengthFor(ColumnDefinition.DISPATCH_TIME_AVG) + 5 : this.getPixelLengthFor(ColumnDefinition.SUSPEND_TIME_AVG) <= 605 && this.getPixelLengthFor(ColumnDefinition.DISPWAIT_TIME_AVG) <= this.getPixelLengthFor(ColumnDefinition.SUSPEND_TIME_AVG) + 5 && this.getPixelLengthFor(ColumnDefinition.DISPATCH_TIME_AVG) <= 605 && this.getPixelLengthFor(ColumnDefinition.CPU_TIME_AVG) <= this.getPixelLengthFor(ColumnDefinition.DISPATCH_TIME_AVG) + 5;
            }
            if (!this.reliable.booleanValue()) {
                StringBuffer messageBuffer = new StringBuffer();
                ColumnDefinition[] columnDefinitionArray = this.requiredColumns;
                int n = this.requiredColumns.length;
                int n2 = 0;
                while (n2 < n) {
                    ColumnDefinition definition = columnDefinitionArray[n2];
                    if (messageBuffer.length() > 0) {
                        messageBuffer.append(',');
                        messageBuffer.append(' ');
                    }
                    messageBuffer.append(this.getLabelFor(definition));
                    ++n2;
                }
                messageBuffer.toString();
                debug.error("isReliable", messageBuffer.toString());
            }
        }
        debug.exit("isReliable", (Object)this.reliable);
        return this.reliable;
    }

    public boolean isPlist() {
        return this.isPlist;
    }
}

