/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.model;

import com.ibm.cics.pa.model.CSVFile;
import com.ibm.cics.pa.model.ChartingFile;
import com.ibm.cics.pa.model.GenericDataProvider;
import com.ibm.cics.pa.model.TreeElement;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.DataProviderKey;
import com.ibm.cics.pa.ui.editors.PAResourceChangeListener;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;

public class SortedCSVFile
extends ChartingFile {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    boolean sortDescending;
    ColumnDefinition sortColumn;
    private GenericDataProvider source;

    protected SortedCSVFile(GenericDataProvider source, ColumnDefinition sortColumn, boolean descending) {
        super(source.deriveSubReferenceFor(String.valueOf(sortColumn.getDBColumnRef()) + (descending ? "-desc" : "-asc")));
        this.source = source;
        this.setSortColumn(sortColumn);
        this.setDescending(descending);
        this.resourceListener = new PAResourceChangeListener(this, ((CSVFile)this.getRootSource()).getRealPath());
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceListener);
    }

    public static SortedCSVFile getFor(GenericDataProvider source, ColumnDefinition sortColumn) {
        return SortedCSVFile.getFor(source, sortColumn, true);
    }

    public static SortedCSVFile getFor(GenericDataProvider source, ColumnDefinition sortColumn, boolean descending) {
        return new SortedCSVFile(source, sortColumn, descending);
    }

    private void setSortColumn(ColumnDefinition sortColumn) {
        this.sortColumn = sortColumn;
    }

    private void setDescending(boolean descending) {
        this.sortDescending = descending;
    }

    public boolean isSortDescending() {
        return this.sortDescending;
    }

    @Override
    public ColumnDefinition[] getColumnDefinitions() {
        return this.source.getColumnDefinitions();
    }

    @Override
    public int getColumnPosition(ColumnDefinition definition) {
        return this.source.getColumnPosition(definition);
    }

    @Override
    public int[] getColumnPositions(DataProviderKey definition) {
        return this.source.getColumnPositions(definition);
    }

    @Override
    public DataProviderKey getDataProviderKey() {
        return this.source.getDataProviderKey();
    }

    @Override
    public String[] getHeaders() {
        return this.source.getHeaders();
    }

    @Override
    public String getId() {
        return String.valueOf(this.source.getId()) + this.sortColumn.getDBColumnRef() + (this.sortDescending ? "-desc" : "-asc");
    }

    @Override
    public Object[] getValuesFor(ColumnDefinition definition) {
        Object[] vals = null;
        int i = 0;
        while (i < this.getColumnDefinitions().length) {
            if (this.getColumnDefinitions()[i] == definition) {
                vals = new Object[this.data.length];
                int j = 0;
                while (j < this.data.length) {
                    vals[j] = this.data[j][i];
                    ++j;
                }
            }
            ++i;
        }
        return vals;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    @Override
    public String getName() {
        return this.getTabName();
    }

    @Override
    public String getToolTipText() {
        if (this.source != null) {
            return String.valueOf(this.source.getToolTipText()) + " (" + this.sortColumn.getLabel(null) + ")";
        }
        return "";
    }

    @Override
    public boolean isPopulated() {
        return this.data != null;
    }

    @Override
    public String getTabName() {
        if (this.tabName == null) {
            if (this.source != null) {
                return String.valueOf(this.source.getTabName()) + " (" + this.sortColumn.getLabel(null) + ")";
            }
            this.tabName = "";
        }
        return this.tabName;
    }

    @Override
    public Object[][] getData(IProgressMonitor monitor) {
        if (this.data == null) {
            this.data = (Object[][])this.source.getData().clone();
            Arrays.sort(this.data, new Comparator<Object[]>(){

                @Override
                public int compare(Object[] a, Object[] b) {
                    return DataTypeUtilities.compare(SortedCSVFile.this.sortColumn, SortedCSVFile.this.sortDescending ? 1024 : 128, a[SortedCSVFile.this.getColumnPosition(SortedCSVFile.this.sortColumn)], b[SortedCSVFile.this.getColumnPosition(SortedCSVFile.this.sortColumn)]);
                }
            });
            this.getExplorerViewModel();
        }
        return this.data;
    }

    @Override
    public TreeElement getRootTreeElement() {
        return this.source.getRootTreeElement();
    }

    @Override
    public GenericDataProvider getRootSource() {
        GenericDataProvider immediateParent = this.source;
        while (immediateParent != null && !(immediateParent instanceof CSVFile)) {
            immediateParent = immediateParent.getRootSource();
        }
        return immediateParent;
    }

    @Override
    public int getTotalRows() {
        return this.data != null ? this.data.length : 0;
    }
}

