/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.pa.model.PBKey;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.ProfilerLayout;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ProfilerBucket {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(ProfilerBucket.class);
    private static ProfilerBucket instanceBase = new ProfilerBucket();
    private static ProfilerBucket instanceVariant = new ProfilerBucket();
    private String applid;
    private String transaction;
    private PBKey[] keys = null;
    private Object[] maximums = null;
    private Map<PBKey, Object[]> multibucket = new TreeMap<PBKey, Object[]>(new Comparator<PBKey>(){

        @Override
        public int compare(PBKey o1, PBKey o2) {
            return o1.compareTo(o2);
        }
    });

    public void createFor(String applid, String transaction) {
        debug.enter("createFor");
        this.keys = null;
        this.maximums = null;
        this.multibucket.clear();
        this.applid = applid;
        this.transaction = transaction;
        debug.exit("createFor");
    }

    private ProfilerBucket() {
    }

    public Object processRow(ResultSet rs) {
        Date date = null;
        Time time = null;
        Object[] metrics = new Object[ProfilerLayout.allColumns().length];
        int i = 0;
        while (i < ProfilerLayout.allColumns().length) {
            try {
                metrics[i] = rs.getObject(ProfilerLayout.allColumns()[i].getDBColumnRef());
                if (ProfilerLayout.allColumns()[i] == ColumnDefinition.START_DATE) {
                    date = (Date)metrics[i];
                } else if (ProfilerLayout.allColumns()[i] == ColumnDefinition.START_TIME) {
                    time = (Time)metrics[i];
                }
            }
            catch (SQLException e) {
                debug.error("processRow", (Throwable)e);
            }
            ++i;
        }
        return new AbstractMap.SimpleEntry<PBKey, Object[]>(new PBKey(date, time), metrics);
    }

    public String getString() {
        return "ProfilerBucket - Applid " + this.applid + " Transaction " + this.transaction + " " + this.multibucket.size();
    }

    public String getApplid() {
        return this.applid;
    }

    public String getTransaction() {
        return this.transaction;
    }

    public PBKey[] getAllKeys() {
        if (this.keys == null) {
            this.keys = this.multibucket.keySet().toArray(new PBKey[this.multibucket.size()]);
        }
        return this.keys;
    }

    public int getSize() {
        return this.multibucket.size();
    }

    public PBKey getKeyAtLocation(int location) {
        if (location > -1 && location < this.getSize()) {
            return this.getAllKeys()[location];
        }
        return null;
    }

    public void addAll(List<Object> res) {
        if (this.maximums == null) {
            this.maximums = new Object[ProfilerLayout.allColumns().length];
            int i = 0;
            while (i < this.maximums.length) {
                this.maximums[i] = 0;
                ++i;
            }
        }
        for (Object element : res) {
            AbstractMap.SimpleEntry entry = (AbstractMap.SimpleEntry)element;
            if (entry.getKey() == null || this.multibucket.containsKey(entry.getKey())) continue;
            this.multibucket.put((PBKey)entry.getKey(), (Object[])entry.getValue());
            int i = 0;
            while (i < this.maximums.length) {
                if (((Object[])entry.getValue())[i] instanceof Number) {
                    this.maximums[i] = Math.max(((Number)((Object[])entry.getValue())[i]).doubleValue(), ((Number)this.maximums[i]).doubleValue());
                }
                ++i;
            }
        }
        this.keys = null;
    }

    public Object[] getMetricsFor(PBKey key) {
        return this.multibucket.get(key);
    }

    public double getMaximumValue(int position) {
        if (this.maximums == null) {
            return 0.0;
        }
        return ((Number)this.maximums[position]).doubleValue();
    }

    public double getMaximumValue(ProfilerLayout layout) {
        double max = 0.0;
        for (PBKey key : this.multibucket.keySet()) {
            Object[] values = this.multibucket.get(key);
            if (values == null) continue;
            int i = 0;
            while (i < values.length) {
                if (values[i] instanceof Number && layout.getDefinitionsAsArray().contains(ProfilerLayout.allColumns()[i])) {
                    max = Math.max(max, ((Number)values[i]).doubleValue());
                }
                ++i;
            }
        }
        return max;
    }

    public static ProfilerBucket getBaseInstance() {
        return instanceBase;
    }

    public static ProfilerBucket getVariantInstance() {
        return instanceVariant;
    }
}

