/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.pa.model.Chart;
import com.ibm.cics.pa.model.GenericDataProvider;
import com.ibm.cics.pa.model.IUniqueRecord;
import com.ibm.cics.pa.model.TreeElement;
import com.ibm.cics.pa.model.definitions.ChartCategorisation;
import com.ibm.cics.pa.model.definitions.ChartSpecification;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.PieChartSpecificDefinitions;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.views.internal.FilePieViewVariance;
import com.ibm.cics.pa.ui.views.internal.IPieViewVariance;
import com.ibm.cics.pa.ui.views.internal.PieViewVariance;
import com.ibm.cics.pa.ui.views.internal.ProgramRequestPieViewVariance;
import com.ibm.cics.pa.ui.views.internal.StoragePieViewVariance;
import com.ibm.cics.pa.ui.views.internal.TemporaryStoragePieViewVariance;
import com.ibm.cics.pa.ui.views.internal.TransientDataPieViewVariance;
import com.ibm.cics.pa.ui.views.internal.UserCPUPieViewVariance;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;

public class Pie
extends Chart {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(Pie.class);
    private Object[] row = null;
    private IUniqueRecord explorerViewModel = null;
    private String primaryAxisLabel;
    private Map<ColumnDefinition, Object> completeValues;
    private String elementName;
    private boolean noHeader = false;

    public Pie(ChartSpecification chartReference, GenericDataProvider dataStore, Map<ColumnDefinition, Object> values, String elementName, IUniqueRecord record) {
        super(chartReference, dataStore);
        this.row = record.getRow();
        this.primaryAxisLabel = ((PieChartSpecificDefinitions)chartReference.getSpecificType()).getPkg().resolve(dataStore.getColumnDefinitions(), this.row);
        this.completeValues = values;
        this.elementName = elementName;
        this.explorerViewModel = record;
        this.chartTitle = String.valueOf(this.chartTitle) + record.getLabel();
        this.setChartId(String.valueOf(chartReference.name()) + " " + dataStore.getFileReference() + " " + record.getRelativeText());
        references.put(this.getChartId(), this);
        this.setToolTipText(record.getDataKey().getColumnDescriptiveFullReference());
    }

    public IUniqueRecord getUniqueRecord() {
        if (this.explorerViewModel == null && this.getDataProvider() != null) {
            this.explorerViewModel = ((TreeElement)this.getDataProvider().getRootTreeElement().getChildren()[0]).findExplorerViewModelElement(this.row);
        }
        return this.explorerViewModel;
    }

    public Object[] getRow() {
        return this.row;
    }

    @Override
    public String getPrimaryLabel() {
        return this.primaryAxisLabel;
    }

    public ImageDescriptor getImageDescriptor() {
        return Activator.getDefault().getImageDescriptor("pie");
    }

    public Map<ColumnDefinition, Object> getCompleteValues() {
        return this.completeValues;
    }

    public String getElementName() {
        return this.elementName;
    }

    public boolean isNoHeader() {
        return this.noHeader;
    }

    public boolean isDonut() {
        return this.getChartReference().getCategorisation()[0] == ChartCategorisation.STORAGE;
    }

    public void setNoHeader(boolean noHeader) {
        this.noHeader = noHeader;
    }

    public IPieViewVariance establishVariance() {
        debug.enter("establishVariance");
        PieViewVariance variance = null;
        variance = ChartCategorisation.STORAGE == this.getChartReference().getCategorisation()[0] ? new StoragePieViewVariance(this) : (ChartCategorisation.FILEUSAGE == this.getChartReference().getCategorisation()[0] ? new FilePieViewVariance(this) : (ChartCategorisation.CPUTIME == this.getChartReference().getCategorisation()[0] ? new UserCPUPieViewVariance(this) : (ChartCategorisation.TRANSIENT_DATA == this.getChartReference().getCategorisation()[0] ? new TransientDataPieViewVariance(this) : (ChartCategorisation.TEMPORARY_STORAGE == this.getChartReference().getCategorisation()[0] ? new TemporaryStoragePieViewVariance(this) : (ChartCategorisation.PROGRAMREQUEST == this.getChartReference().getCategorisation()[0] ? new ProgramRequestPieViewVariance(this) : new PieViewVariance(this))))));
        debug.exit("establishVariance", (Object)variance);
        return variance;
    }

    @Override
    public String getToolTipText() {
        String tooltip = this.getChartReference().getTitle();
        if (ChartCategorisation.STORAGE == this.getChartReference().getCategorisation()[0]) {
            tooltip = Messages.getString("PieTooltip.STORAGE");
        } else if (ChartCategorisation.FILEUSAGE == this.getChartReference().getCategorisation()[0]) {
            tooltip = Messages.getString("PieTooltip.FILEUSAGE");
        } else if (ChartCategorisation.CPUTIME == this.getChartReference().getCategorisation()[0]) {
            tooltip = Messages.getString("PieTooltip.CPUTIME");
        } else if (ChartCategorisation.TRANSIENT_DATA == this.getChartReference().getCategorisation()[0]) {
            tooltip = Messages.getString("PieTooltip.TRANSIENT_DATA");
        } else if (ChartCategorisation.TEMPORARY_STORAGE == this.getChartReference().getCategorisation()[0]) {
            tooltip = Messages.getString("PieTooltip.TEMPORARY_STORAGE");
        } else if (ChartCategorisation.PROGRAMREQUEST == this.getChartReference().getCategorisation()[0]) {
            tooltip = Messages.getString("PieTooltip.PROGRAMREQUEST");
        } else if (ChartCategorisation.RMI == this.getChartReference().getCategorisation()[0]) {
            tooltip = Messages.getString("PieTooltip.RMI");
        } else if (ChartCategorisation.SUSPEND == this.getChartReference().getCategorisation()[0]) {
            tooltip = Messages.getString("PieTooltip.SUSPEND");
        } else if (ChartCategorisation.RESPONSETIME == this.getChartReference().getCategorisation()[0]) {
            tooltip = Messages.getString("PieTooltip.RESPONSETIME");
        }
        return tooltip;
    }

    public boolean isPListRecord() {
        return this.getUniqueRecord().getDataKey().isPerformanceList() || this.getUniqueRecord().getDataKey().isPerformanceAlert();
    }

    public boolean twoTree() {
        boolean isTwo = false;
        if (ChartCategorisation.STORAGE == this.getChartReference().getCategorisation()[0]) {
            isTwo = true;
        } else if (ChartCategorisation.FILEUSAGE == this.getChartReference().getCategorisation()[0]) {
            isTwo = true;
        } else if (ChartCategorisation.CPUTIME == this.getChartReference().getCategorisation()[0]) {
            isTwo = true;
        } else if (ChartCategorisation.TRANSIENT_DATA == this.getChartReference().getCategorisation()[0]) {
            isTwo = true;
        } else if (ChartCategorisation.TEMPORARY_STORAGE == this.getChartReference().getCategorisation()[0]) {
            isTwo = true;
        } else if (ChartCategorisation.PROGRAMREQUEST == this.getChartReference().getCategorisation()[0]) {
            isTwo = true;
        }
        return isTwo;
    }
}

