/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.Clause;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.Activator;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;

public class IntervalsCaveat {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2010, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(IntervalsCaveat.class.getPackage().getName());
    private static IntervalsCaveat instance;
    private Clause clause = null;

    private IntervalsCaveat() {
        this.reassess();
    }

    public static IntervalsCaveat getInstance() {
        if (instance == null) {
            instance = new IntervalsCaveat();
        }
        return instance;
    }

    public void reassess() {
        String[] ints;
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"reassess");
        ArrayList<String> values = new ArrayList<String>();
        String[] stringArray = ints = new String[]{"com.ibm.cics.pa.ui.commands.int", "com.ibm.cics.pa.ui.commands.eod", "com.ibm.cics.pa.ui.commands.uss", "com.ibm.cics.pa.ui.commands.req", "com.ibm.cics.pa.ui.commands.rrt"};
        int n = ints.length;
        int n2 = 0;
        while (n2 < n) {
            String i = stringArray[n2];
            if (Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), i, true, null)) {
                values.add(i.substring(28).toUpperCase());
            }
            ++n2;
        }
        this.clause = values.size() == ints.length ? null : PresentationFactory.getInstance().createSimpleCondition(ColumnDefinition.INTERVAL_TYPE.getDBColumnRef(), null, ColumnReference.DataType.String, Comparator.IN, values.toArray(), false);
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"reassess", (Object)this.clause);
    }

    public Clause getClause() {
        Debug.enter((Logger)logger, (String)this.getClass().getName(), (String)"getClause");
        Debug.exit((Logger)logger, (String)this.getClass().getName(), (String)"getClause", (Object)this.clause);
        return this.clause;
    }
}

