/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.model;

import com.ibm.cics.pa.model.CommonTree;
import com.ibm.cics.pa.model.GenericDataProvider;
import com.ibm.cics.pa.model.IUniqueRecord;
import com.ibm.cics.pa.model.PAAppSummUniqueRecord;
import com.ibm.cics.pa.model.PAPerfSummUniqueRecord;
import com.ibm.cics.pa.model.PAUniqueRecord;
import com.ibm.cics.pa.model.TreeElement;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.DataProviderKey;
import com.ibm.cics.pa.ui.remote.HierarchicalRemoteElement;
import com.ibm.cics.pa.ui.remote.RemoteConnectionProvider;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public class ExplorerViewModel
extends CommonTree
implements TreeElement {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static TreeElement createExplorerViewModel(GenericDataProvider adaptableObject, DataProviderKey structureKey) {
        if (adaptableObject instanceof RemoteConnectionProvider) {
            return HierarchicalRemoteElement.createExplorerViewModel((RemoteConnectionProvider)adaptableObject);
        }
        return new ExplorerViewModel(adaptableObject, structureKey);
    }

    public static IUniqueRecord findExplorerViewModelElement(TreeElement startModel, Object[] row) {
        TreeElement model = null;
        ArrayList<ExplorerViewModel> elements = new ArrayList<ExplorerViewModel>();
        if (startModel != null && row != null) {
            Object[] children = startModel.getChildren();
            int i = 0;
            while (i < children.length) {
                ((ExplorerViewModel)children[i]).findExplorerViewModelElement(elements, row);
                ++i;
            }
            if (elements.size() > 0) {
                model = (TreeElement)elements.get(0);
            }
        }
        return (IUniqueRecord)model;
    }

    protected ExplorerViewModel(ColumnDefinition column, Object label, int columnRef) {
        this.column = column;
        this.columnRef = columnRef;
        this.parent = null;
        this.label = label;
    }

    protected ExplorerViewModel(GenericDataProvider adaptableObject, DataProviderKey structureKey) {
        this.columnRef = -1;
        this.source = adaptableObject;
        this.structureKey = structureKey;
    }

    @Override
    public IUniqueRecord findExplorerViewModelElement(Object[] row) {
        TreeElement model = null;
        ArrayList<ExplorerViewModel> elements = new ArrayList<ExplorerViewModel>();
        if (row != null) {
            Object[] children = this.getChildren();
            int i = 0;
            while (i < children.length) {
                ((ExplorerViewModel)children[i]).findExplorerViewModelElement(elements, row);
                ++i;
            }
            if (elements.size() > 0) {
                model = (TreeElement)elements.get(0);
            }
        }
        return (IUniqueRecord)model;
    }

    private void findExplorerViewModelElement(ArrayList<ExplorerViewModel> elements, Object[] row) {
        if (row != null && row[this.getColumnRef()].equals(this.getLabel())) {
            if (this instanceof IUniqueRecord) {
                elements.add(this);
            } else {
                Object[] children = this.getChildren();
                int i = 0;
                while (i < children.length) {
                    ((ExplorerViewModel)children[i]).findExplorerViewModelElement(elements, row);
                    ++i;
                }
            }
        }
    }

    private void addChild(TreeElement modelItem) {
        this.children.put(modelItem.getLabel(), modelItem);
        ((ExplorerViewModel)modelItem).setParent(this);
    }

    @Override
    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public static String getLabel(TreeElement startModel, ColumnDefinition defn) {
        TreeElement model = startModel;
        String lab = null;
        while (lab == null && !model.isRoot()) {
            if (model.getColumn() == defn) {
                lab = (String)model.getLabel();
                continue;
            }
            model = model.getParent();
        }
        return lab;
    }

    @Override
    public TreeElement getChild(ColumnDefinition columnDefinition, Object label, int i) {
        TreeElement child = (TreeElement)this.children.get(label);
        if (child == null) {
            child = new ExplorerViewModel(columnDefinition, label, i);
            this.addChild(child);
        }
        return child;
    }

    @Override
    public TreeElement getChild(ColumnDefinition columnDefinition, Object label, int i, Object[] dataRow) {
        TreeElement child = (TreeElement)this.children.get(label);
        if (child == null) {
            child = columnDefinition == ColumnDefinition.TRAN ? new PAPerfSummUniqueRecord(columnDefinition, label, i, dataRow) : (columnDefinition == ColumnDefinition.ACOPERNM ? new PAAppSummUniqueRecord(columnDefinition, label, i, dataRow) : new PAUniqueRecord(columnDefinition, label, i, dataRow));
            this.addChild(child);
        }
        return child;
    }

    protected DataProviderKey getStructureKey() {
        if (this.isRoot()) {
            return this.structureKey;
        }
        if (this.parent != null) {
            return ((ExplorerViewModel)this.parent).getStructureKey();
        }
        return DataProviderKey.STARTTIME_APPLID_TRAN;
    }

    @Override
    public void clear() {
        for (TreeElement child : this.children.values()) {
            child.clear();
        }
        this.children = new LinkedHashMap();
        this.parent = null;
    }
}

