/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.ConstraintElement;
import com.ibm.cics.pa.model.NullRangeDateCaveat;
import com.ibm.cics.pa.model.PostRangeDateCaveat;
import com.ibm.cics.pa.model.PreRangeDateCaveat;
import com.ibm.cics.pa.model.RangeDateCaveat;
import com.ibm.cics.pa.model.SpecificDateCaveat;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.ui.IMemento;

public abstract class DateCaveat {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2010, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(DateCaveat.class);
    protected Date startdate = null;
    protected Date enddate = null;
    public static final String AND = " AND ";
    public static final String WHERE = " WHERE ";
    private static final String START = "CalStart";
    private static final String END = "CalEnd";
    protected static final String SPECIFIC = "Specific";
    protected static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH.mm.ss");

    public static DateCaveat createSpecificDateCaveat(Date startdate) {
        return new SpecificDateCaveat(startdate);
    }

    public static DateCaveat createRangeDateCaveat(Date afterDate, Date beforeDate) {
        if (afterDate != null) {
            if (beforeDate != null) {
                return new RangeDateCaveat(afterDate, beforeDate);
            }
            return new PostRangeDateCaveat(afterDate);
        }
        if (beforeDate != null) {
            return new PreRangeDateCaveat(beforeDate);
        }
        return new NullRangeDateCaveat();
    }

    public static DateCaveat createSpecificDateCaveat(Date d1, Time d2) {
        if (d1 == null || d2 == null) {
            return new NullRangeDateCaveat();
        }
        return DateCaveat.createSpecificDateCaveat(DateCaveat.join(d1, d2, null, 0));
    }

    protected DateCaveat(Date startdate, Date enddate) {
        this.startdate = startdate;
        this.enddate = enddate;
    }

    protected DateCaveat(Date date) {
        this.startdate = date;
    }

    protected DateCaveat() {
    }

    public boolean isSpecified() {
        return this.startdate != null;
    }

    public abstract String getAsWhereClause(String var1);

    public static DateCaveat init(IMemento memento) {
        Date date1 = null;
        Date date2 = null;
        if (memento != null) {
            Float value2;
            Boolean isSpecific = memento.getBoolean(SPECIFIC);
            Float value1 = memento.getFloat(START);
            if (value1 != null) {
                date1 = new Date(value1.longValue());
            }
            if ((value2 = memento.getFloat(END)) != null) {
                date2 = new Date(value2.longValue());
            }
            if (isSpecific != null && isSpecific.booleanValue()) {
                return DateCaveat.createSpecificDateCaveat(date1);
            }
        }
        return DateCaveat.createRangeDateCaveat(date1, date2);
    }

    public void persist(IMemento memento) {
        if (this.startdate != null) {
            memento.putFloat(START, new Float(this.startdate.getTime()).floatValue());
        }
        if (this.enddate != null) {
            memento.putFloat(END, new Float(this.enddate.getTime()).floatValue());
        }
        if (this instanceof SpecificDateCaveat) {
            memento.putBoolean(SPECIFIC, true);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " " + this.getLabel();
    }

    public abstract String getLabel();

    public long getStartTimeInMillis() {
        return this.startdate != null ? this.startdate.getTime() : 0L;
    }

    public long getEndTimeInMillis() {
        return this.enddate != null ? this.enddate.getTime() : 0L;
    }

    public abstract ConstraintElement getConstraint(String var1, boolean var2);

    public static Date join(Date start, Time time, Time duration, int factor) {
        debug.enter("join", (Object)start, (Object)time, (Object)duration, (Object)factor);
        Calendar cal = Calendar.getInstance();
        cal.setTime(start);
        Calendar tim = Calendar.getInstance();
        tim.setTime(time);
        cal.add(11, tim.get(11));
        cal.add(12, tim.get(12));
        cal.add(13, tim.get(13));
        cal.add(14, tim.get(14));
        Calendar dur = Calendar.getInstance();
        if (duration != null) {
            dur.setTime(duration);
            cal.add(11, dur.get(11) * factor);
            cal.add(12, dur.get(12) * factor);
            cal.add(13, dur.get(13) * factor);
            cal.add(14, dur.get(14) * factor);
        }
        debug.exit("join", (Object)cal.getTime());
        return cal.getTime();
    }

    public static Date join(Date start, int factor) {
        debug.enter("join", (Object)start, (Object)factor);
        Calendar cal = Calendar.getInstance();
        cal.setTime(start);
        cal.add(11, 3 * factor);
        debug.exit("join", (Object)cal.getTime());
        return cal.getTime();
    }

    public static DateCaveat createRangeDateCaveat(DateCaveat caveat1, DateCaveat caveat2) {
        return DateCaveat.createRangeDateCaveat(caveat1.startdate == null ? caveat1.enddate : caveat1.startdate, caveat2.enddate == null ? caveat2.startdate : caveat2.enddate);
    }
}

