/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.pa.model.CSVDataProviderFilter;
import com.ibm.cics.pa.model.ChartingFile;
import com.ibm.cics.pa.model.GenericDataProvider;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.DataProviderKey;
import com.ibm.cics.pa.ui.editors.PAResourceChangeListener;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Date;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;

public class CSVFile
extends ChartingFile
implements Serializable {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final long serialVersionUID = 1L;
    private static Pattern withQuotesPattern = Pattern.compile(",(?=([^\"]*\"[^\"]*\")*(?![^\"]*\"))");
    private static Pattern basicPattern = Pattern.compile(",");
    protected String[] headers = null;
    protected ColumnDefinition[] columnDefinitions = null;
    private CSVDataProviderFilter filter = null;
    private DataProviderKey bestMatch = null;
    private int[] bestMatchPositions;
    private boolean populated = false;
    private IFile realFile = null;

    public static GenericDataProvider getReference(String selectedFile) {
        return new CSVFile(selectedFile);
    }

    public static GenericDataProvider getReference(IFile file) {
        CSVFile fil = new CSVFile(file.getFullPath().toPortableString());
        fil.realFile = file;
        fil.resourceListener = new PAResourceChangeListener(fil, file.getLocation());
        ResourcesPlugin.getWorkspace().addResourceChangeListener(fil.resourceListener);
        return fil;
    }

    protected CSVFile(String selectedFile) {
        super(selectedFile);
    }

    /*
     * Exception decompiling
     */
    @Override
    public synchronized Object[][] getData(IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [16[CATCHBLOCK]], but top level block is 14[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String[] getHeaders() {
        if (this.headers == null) {
            Debug.enter((Logger)logger, (String)CSVFile.class.getName(), (String)"getHeaders", (Object[])this.headers);
            this.headers = new String[0];
            if (this.realFile != null && this.realFile.isAccessible()) {
                BufferedReader reader = null;
                try {
                    try {
                        reader = new BufferedReader(new FileReader(this.realFile.getLocation().toFile()));
                        String line = reader.readLine();
                        if (line != null) {
                            this.headers = basicPattern.split(line);
                            this.columnDefinitions = new ColumnDefinition[this.headers.length];
                            int i = 0;
                            while (i < this.headers.length) {
                                ColumnDefinition defn = ColumnDefinition.getByColumnRef(this.headers[i]);
                                if (defn != null) {
                                    this.columnDefinitions[i] = defn;
                                } else {
                                    this.columnDefinitions[i] = ColumnDefinition.UNKNOWN;
                                    logger.logp(Level.WARNING, CSVFile.class.getName(), "getHeaders", "No Column Definition for " + this.headers[i]);
                                }
                                if (defn != null) {
                                    this.headers[i] = defn.getLabel(null);
                                }
                                ++i;
                            }
                        }
                    }
                    catch (FileNotFoundException e) {
                        logger.logp(Level.SEVERE, CSVFile.class.getName(), "getHeaders", "File not found error", e);
                        Debug.exit((Logger)logger, (String)CSVFile.class.getName(), (String)"getHeaders", (Object)new String[0]);
                        String[] stringArray = new String[]{};
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return stringArray;
                    }
                    catch (IOException e) {
                        logger.logp(Level.SEVERE, CSVFile.class.getName(), "getHeaders", "IO error", e);
                        Debug.exit((Logger)logger, (String)CSVFile.class.getName(), (String)"getHeaders", (Object)new String[0]);
                        String[] stringArray = new String[]{};
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return stringArray;
                    }
                }
                finally {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            Debug.exit((Logger)logger, (String)CSVFile.class.getName(), (String)"getHeaders", (Object)this.headers);
        }
        return this.headers;
    }

    @Override
    public ColumnDefinition[] getColumnDefinitions() {
        if (this.columnDefinitions == null) {
            this.getHeaders();
        }
        return this.columnDefinitions;
    }

    @Override
    public Object[] getValuesFor(ColumnDefinition definition) {
        Object[] vals = null;
        int i = 0;
        while (i < this.columnDefinitions.length) {
            if (this.columnDefinitions[i] == definition) {
                vals = new Object[this.data.length];
                int j = 0;
                while (j < this.data.length) {
                    vals[j] = this.data[j][i];
                    ++j;
                }
            }
            ++i;
        }
        return vals;
    }

    @Override
    public int getColumnPosition(ColumnDefinition definition) {
        this.getHeaders();
        int i = 0;
        while (i < this.columnDefinitions.length) {
            if (this.columnDefinitions[i] == definition) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int[] getColumnPositions(DataProviderKey definition) {
        ColumnDefinition[] definitions = definition.getColumnDefinitions();
        int[] positions = new int[definitions.length];
        int i = 0;
        while (i < positions.length) {
            positions[i] = this.getColumnPosition(definitions[i]);
            ++i;
        }
        return positions;
    }

    public int[] getBestMatchPositions() {
        if (this.bestMatch == null) {
            this.getDataProviderKey();
        }
        return this.bestMatchPositions;
    }

    public void setBestMatch(DataProviderKey bestMatch) {
        this.bestMatch = bestMatch;
        this.bestMatchPositions = this.getColumnPositions(bestMatch);
    }

    @Override
    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public static CSVFile get(IFile id) {
        return (CSVFile)ChartingFile.getReference(id);
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    @Override
    public String getName() {
        return this.getTabName();
    }

    @Override
    public String getToolTipText() {
        return this.getReference();
    }

    public void dumpMe() throws FileNotFoundException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream("C:/colin.txt"));
        PrintStream ps = new PrintStream(bos);
        this.getData();
        int i = 0;
        while (i < this.headers.length) {
            ps.print("new String(\"" + this.headers[i] + "\"" + "),");
            ++i;
        }
        ps.println("/n");
        int j = 0;
        while (j < this.data.length) {
            int i2 = 0;
            while (i2 < this.headers.length) {
                String item = DataTypeUtilities.getAsString(this.data[j][i2]);
                if (this.data[j][i2] instanceof String) {
                    ps.print("new String(\"" + item + "\"" + "),");
                } else if (this.data[j][i2] instanceof Double) {
                    ps.print("new Double(\"" + item + "\"" + "),");
                } else if (this.data[j][i2] instanceof Float) {
                    ps.print("new Float(\"" + item + "\"" + "),");
                } else if (this.data[j][i2] instanceof Integer) {
                    ps.print("new Integer(\"" + item + "\"" + "),");
                } else if (this.data[j][i2] instanceof Byte) {
                    ps.print("new Byte(\"" + item + "\"" + "),");
                } else if (this.data[j][i2] instanceof Boolean) {
                    ps.print("new Boolean(\"" + item + "\"" + "),");
                } else if (this.data[j][i2] instanceof Date) {
                    ps.print("new Date(\"" + item + "\"" + "),");
                }
                ++i2;
            }
            ps.println("/n");
            ++j;
        }
        ps.close();
    }

    @Override
    public DataProviderKey getDataProviderKey() {
        if (this.bestMatch == null) {
            this.getHeaders();
            EnumSet<DataProviderKey> list = EnumSet.allOf(DataProviderKey.class);
            for (DataProviderKey definition : list) {
                int[] pos = this.getColumnPositions(definition);
                boolean valid = true;
                int i = 0;
                while (i < pos.length) {
                    if (valid) {
                        valid = pos[i] > -1;
                    }
                    ++i;
                }
                if (!valid) continue;
                this.bestMatch = definition;
                this.bestMatchPositions = pos;
                return this.bestMatch;
            }
        }
        return this.bestMatch;
    }

    @Override
    public boolean isPopulated() {
        return this.populated;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void decrementUseCount() {
        Debug.enter((Logger)logger, (String)CSVFile.class.getName(), (String)"decrementUseCount", (Object)this.getReference());
        --this.useCount;
        Debug.exit((Logger)logger, (String)CSVFile.class.getName(), (String)"decrementUseCount", (Object)(String.valueOf(this.getReference()) + " " + this.useCount));
    }

    @Override
    public GenericDataProvider getRootSource() {
        return this;
    }

    @Override
    public int getTotalRows() {
        return this.data != null ? this.data.length : 0;
    }

    @Override
    public String getTabName() {
        if (this.tabName == null && this.realFile != null) {
            this.tabName = this.realFile.getName();
        }
        return this.tabName;
    }

    public IPath getRealPath() {
        return this.realFile.getLocation();
    }
}

