/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.model;

import com.ibm.cics.pa.model.AllRowsFilter;
import com.ibm.cics.pa.model.CSVDataProviderFilter;
import com.ibm.cics.pa.model.CSVFile;
import com.ibm.cics.pa.model.ChartingFile;
import com.ibm.cics.pa.model.GenericDataProvider;
import com.ibm.cics.pa.model.SQLStyleCSVFilter;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.DataProviderKey;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.editors.PAResourceChangeListener;
import com.ibm.cics.pa.ui.remote.DBQueryFactoryCustomer;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import com.ibm.cics.pa.ui.utilities.FilterElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;

public class CSVDataExtract
extends ChartingFile {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private GenericDataProvider source;
    private CSVDataProviderFilter filter;

    public static GenericDataProvider getFor(GenericDataProvider source, CSVDataProviderFilter filter) {
        String ref = source.deriveSubReferenceFor(filter.getId());
        GenericDataProvider extract = CSVDataExtract.referenceExists(ref) ? CSVDataExtract.getReference(ref) : new CSVDataExtract(source, filter, ref);
        return extract;
    }

    public static GenericDataProvider getFor(GenericDataProvider source, SQLStyleCSVFilter filter) {
        String ref;
        GenericDataProvider revisedSource = source;
        if (revisedSource instanceof CSVDataExtract && ((CSVDataExtract)revisedSource).getFilter() instanceof SQLStyleCSVFilter) {
            revisedSource = ((CSVDataExtract)revisedSource).getRootSource();
        }
        GenericDataProvider extract = CSVDataExtract.referenceExists(ref = revisedSource.deriveSubReferenceFor(filter.getId())) ? CSVDataExtract.getReference(ref) : new CSVDataExtract(revisedSource, filter, ref);
        return extract;
    }

    protected CSVDataExtract(GenericDataProvider source, CSVDataProviderFilter filter, String ref) {
        super(ref);
        this.source = source;
        this.filter = filter;
        this.resourceListener = new PAResourceChangeListener(this, (IPath)new Path(this.getRootSource().getFileReference()));
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceListener);
    }

    @Override
    public ColumnDefinition[] getColumnDefinitions() {
        return this.source.getColumnDefinitions();
    }

    @Override
    public int getColumnPosition(ColumnDefinition definition) {
        return this.source.getColumnPosition(definition);
    }

    @Override
    public int[] getColumnPositions(DataProviderKey definition) {
        return this.source.getColumnPositions(definition);
    }

    @Override
    public String[] getHeaders() {
        return this.source.getHeaders();
    }

    @Override
    public String getId() {
        return String.valueOf(this.source.getId()) + this.filter.getId();
    }

    @Override
    public String getReference() {
        return String.valueOf(this.source.getReference()) + ' ' + this.filter.getReference();
    }

    @Override
    public String getAbridgedReference() {
        String text = this.getReference();
        if (text.length() > 75) {
            return this.getTabName();
        }
        return text;
    }

    @Override
    public Object[] getValuesFor(ColumnDefinition definition) {
        Object[] vals = null;
        int i = 0;
        while (i < this.getColumnDefinitions().length) {
            if (this.getColumnDefinitions()[i] == definition) {
                vals = new Object[this.data.length];
                int j = 0;
                while (j < this.data.length) {
                    vals[j] = this.data[j][i];
                    ++j;
                }
            }
            ++i;
        }
        return vals;
    }

    @Override
    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    @Override
    public String getName() {
        return this.getTabName();
    }

    @Override
    public String getToolTipText() {
        return this.getTabName();
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof GenericDataProvider && ((GenericDataProvider)object).getReference().equals(this.getReference());
    }

    @Override
    public boolean isValid() {
        return this.source.isValid();
    }

    @Override
    public DataProviderKey getDataProviderKey() {
        return this.source.getDataProviderKey();
    }

    @Override
    public boolean isPopulated() {
        return this.data != null;
    }

    @Override
    public String getTabName() {
        if (this.tabName == null) {
            if (this.source != null) {
                if (!this.isPopulated()) {
                    return String.valueOf(this.source.getTabName()) + Messages.getString("CSVDataExtract.Subset");
                }
                this.tabName = String.valueOf(this.source.getTabName()) + Messages.getString("CSVDataExtract.InnerBracket") + this.data.length + Messages.getString("CSVDataExtract.OuterBracket");
            } else {
                this.tabName = "";
            }
        }
        return this.tabName;
    }

    @Override
    public synchronized Object[][] getData(IProgressMonitor monitor) {
        if (this.data == null) {
            if (this.filter instanceof AllRowsFilter) {
                this.data = this.source.getData();
            } else {
                Object[][] sourceData = this.source.getData(monitor);
                ArrayList<Object[]> tempStore = new ArrayList<Object[]>();
                int i = 0;
                while (i < sourceData.length) {
                    if (this.filter.accepts(sourceData[i])) {
                        tempStore.add(sourceData[i]);
                    }
                    ++i;
                }
                this.data = new Object[tempStore.size()][];
                i = 0;
                while (i < tempStore.size()) {
                    this.data[i] = (Object[])tempStore.get(i);
                    ++i;
                }
            }
            this.getExplorerViewModel();
        }
        return this.data;
    }

    @Override
    public void incrementUseCount() {
        if (this.source != null) {
            this.source.incrementUseCount();
        }
        super.incrementUseCount();
    }

    @Override
    public void decrementUseCount() {
        if (this.source != null) {
            this.source.decrementUseCount();
        }
        super.decrementUseCount();
    }

    @Override
    public GenericDataProvider getRootSource() {
        GenericDataProvider immediateParent = this.source;
        while (immediateParent != null && !(immediateParent instanceof CSVFile)) {
            immediateParent = immediateParent.getRootSource();
        }
        return immediateParent;
    }

    @Override
    public int getTotalRows() {
        return this.data != null ? this.data.length : 0;
    }

    protected CSVDataProviderFilter getFilter() {
        return this.filter;
    }

    @Override
    public GenericDataProvider sort(DBQueryFactoryCustomer recipientView, final ColumnDefinition defn, final int direction, final int realIndex, List<FilterElement> filters) {
        if (this.filter instanceof SQLStyleCSVFilter) {
            if (direction == 0) {
                this.source.resetOrdering();
            } else {
                Arrays.sort(this.source.getData(), new Comparator<Object[]>(){

                    @Override
                    public int compare(Object[] a, Object[] b) {
                        return DataTypeUtilities.compare(defn, direction, a[realIndex], b[realIndex]);
                    }
                });
            }
            if (filters == null || filters.isEmpty()) {
                return this.source;
            }
            this.filter = SQLStyleCSVFilter.getFilterFor(this.source, filters);
            this.data = null;
            this.getData();
            return this;
        }
        return super.sort(recipientView, defn, direction, realIndex, filters);
    }
}

