/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.model;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.Direction;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.eclipse.common.Utilities;
import com.ibm.cics.pa.model.AlertBucket;
import com.ibm.cics.pa.model.DateCaveat;
import com.ibm.cics.pa.model.ManifestRecord;
import com.ibm.cics.pa.model.NullRangeDateCaveat;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.PAContextTracker;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import com.ibm.cics.pa.ui.views.AlertsView;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class AlertElement
implements IPropertySource {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(AlertElement.class);
    private final AlertsView alerts;
    private Map<ColumnDefinition, Object> mapping = new HashMap<ColumnDefinition, Object>();
    private ManifestRecord record;
    private String alias;
    private Comparator resourceComparator = Comparator.EQ;
    private final String tablename = "TableRef";
    private String description;
    private String accessibleLabel;
    private AlertBucket parent;

    public AlertElement(AlertsView alerts, List<ColumnDefinition> defns, ResultSet resultSet) {
        this.alerts = alerts;
        try {
            Iterator<ColumnDefinition> iterator = defns.iterator();
            while (iterator.hasNext()) {
                ColumnDefinition defn;
                Object obj = resultSet.getObject((defn = iterator.next()).getDBColumnRef());
                this.mapping.put(defn, obj instanceof String ? ((String)obj).trim() : obj);
            }
        }
        catch (SQLException e) {
            debug.error(this.getClass().getName(), "tableSelected ", (Throwable)e);
        }
        if (alerts != null) {
            if (((String)this.mapping.get(ColumnDefinition.SEVERITY)).trim().equals("Critical")) {
                this.alerts.getBucket(AlertBucket.SEVERITY.CRITICAL).add(this);
            } else if (((String)this.mapping.get(ColumnDefinition.SEVERITY)).trim().equals("Warning")) {
                this.alerts.getBucket(AlertBucket.SEVERITY.WARNING).add(this);
            } else if (((String)this.mapping.get(ColumnDefinition.SEVERITY)).trim().equals("Info")) {
                this.alerts.getBucket(AlertBucket.SEVERITY.INFORMATION).add(this);
            }
        }
        if (this.isLSR_POOL_NUMBER()) {
            this.mapping.put(ColumnDefinition.RESOURCE_VALUE, Integer.parseInt((String)this.mapping.get(ColumnDefinition.RESOURCE_VALUE)));
        }
    }

    public AlertElement(Map<ColumnDefinition, Object> valueMap, ColumnDefinition resource, String columnValue, Comparator valueComparator, String tableAlias) {
        debug.enter("AlertElement");
        this.alerts = null;
        Set<Map.Entry<ColumnDefinition, Object>> original = valueMap.entrySet();
        for (Map.Entry<ColumnDefinition, Object> e : original) {
            this.mapping.put(e.getKey(), e.getValue());
        }
        this.alias = tableAlias != null ? tableAlias : resource.tableLookup(columnValue);
        this.mapping.put(ColumnDefinition.RESOURCE_VALUE, columnValue);
        this.mapping.put(ColumnDefinition.RESOURCE_NAME, resource.getLabel(null));
        this.mapping.put(ColumnDefinition.RESOURCE_COLUMN, resource.getDBColumnRef());
        this.mapping.put(ColumnDefinition.BLOCKID, this.alias.substring(this.alias.length() - 1));
        this.mapping.put(ColumnDefinition.STATSID, this.alias.substring(this.alias.length() - 4, this.alias.length() - 1));
        this.resourceComparator = valueComparator;
    }

    public Image getImage() {
        if (((String)this.mapping.get(ColumnDefinition.SEVERITY)).trim().equals("Critical")) {
            return Activator.getDefault().getImage("critical");
        }
        if (((String)this.mapping.get(ColumnDefinition.SEVERITY)).trim().equals("Warning")) {
            return Activator.getDefault().getImage("warning");
        }
        return Activator.getDefault().getImage("information");
    }

    public ColumnDefinition getResourceDefinition() {
        ColumnDefinition defn;
        String def;
        if (this.mapping.containsKey(ColumnDefinition.RESOURCE_COLUMN) && Utilities.hasContent((String)(def = ((String)this.mapping.get(ColumnDefinition.RESOURCE_COLUMN)).trim().toUpperCase())) && (defn = ColumnDefinition.getByDBColumnRef(def)) != null && defn != ColumnDefinition.UNKNOWN) {
            return defn;
        }
        return null;
    }

    public Object getResourceValue() {
        if (this.mapping.containsKey(ColumnDefinition.RESOURCE_VALUE)) {
            return this.mapping.get(ColumnDefinition.RESOURCE_VALUE);
        }
        return null;
    }

    public String getLabel(ColumnDefinition defn) {
        if (defn == ColumnDefinition.TASKNO) {
            return ((Integer)this.mapping.get(defn)).toString();
        }
        return DataTypeUtilities.getAsString(this.mapping.get(defn));
    }

    public String getTableAlias() {
        if (this.alias == null) {
            String prefix = Platform.getPreferencesService().getBoolean(Activator.getDefault().getBundle().getSymbolicName(), "com.ibm.cics.pa.ui.alert.table.ts", true, null) ? "HST" : "HSTG";
            this.alias = String.valueOf(prefix) + this.mapping.get(ColumnDefinition.STATSID) + this.mapping.get(ColumnDefinition.BLOCKID);
            ManifestRecord byName = ManifestRecord.getName(this.alias);
            this.alias = byName != null ? byName.getAlias() : ManifestRecord.validateAliasName(this.alias);
        }
        return this.alias;
    }

    public String getVRM() {
        return (String)this.mapping.get(ColumnDefinition.VRM);
    }

    public Selection getSelection() {
        Selection selection = null;
        if (this.canBeOpened()) {
            this.record = ManifestRecord.getAlias(this.getTableAlias());
            if (this.record != null) {
                selection = PresentationFactory.getInstance().createSelectAllForTable(this.getTableAlias(), null);
                if (this.getTableAlias().equals("CMFPLST")) {
                    selection.appendCondition(ColumnDefinition.START.getDBColumnRef(), this.getTableAlias(), ColumnReference.DataType.Timestamp, Comparator.EQ, new Object[]{String.valueOf(':') + ColumnDefinition.START.getDBColumnRef()}, QueryElement.Predicate.AND, false);
                    selection.appendCondition(ColumnDefinition.STOP.getDBColumnRef(), this.getTableAlias(), ColumnReference.DataType.Timestamp, Comparator.EQ, new Object[]{String.valueOf(':') + ColumnDefinition.STOP.getDBColumnRef()}, QueryElement.Predicate.AND, false);
                    selection.appendCondition(ColumnDefinition.APPLID.getDBColumnRef(), this.getTableAlias(), ColumnReference.DataType.String, Comparator.EQ, new Object[]{String.valueOf(':') + ColumnDefinition.APPLID.getDBColumnRef()}, QueryElement.Predicate.AND, false);
                    selection.appendCondition(ColumnDefinition.TRAN.getDBColumnRef(), this.getTableAlias(), ColumnReference.DataType.String, Comparator.EQ, new Object[]{String.valueOf(':') + ColumnDefinition.TRAN.getDBColumnRef()}, QueryElement.Predicate.AND, false);
                    selection.appendCondition(ColumnDefinition.TASKNO.getDBColumnRef(), this.getTableAlias(), ColumnReference.DataType.Integer, Comparator.EQ, new Object[]{String.valueOf(':') + ColumnDefinition.TASKNO.getDBColumnRef()}, QueryElement.Predicate.AND, false);
                } else {
                    ColumnDefinition defn;
                    selection.appendCondition(ColumnDefinition.START_DATE.getDBColumnRef(), this.getTableAlias(), ColumnReference.DataType.Date, Comparator.EQ, new Object[]{String.valueOf(':') + ColumnDefinition.START_DATE.getDBColumnRef()}, QueryElement.Predicate.AND, false);
                    selection.appendCondition(ColumnDefinition.START_TIME.getDBColumnRef(), this.getTableAlias(), ColumnReference.DataType.Time, Comparator.EQ, new Object[]{String.valueOf(':') + ColumnDefinition.START_TIME.getDBColumnRef()}, QueryElement.Predicate.AND, false);
                    selection.appendCondition(ColumnDefinition.APPLID.getDBColumnRef(), this.getTableAlias(), ColumnReference.DataType.String, Comparator.EQ, new Object[]{String.valueOf(':') + ColumnDefinition.APPLID.getDBColumnRef()}, QueryElement.Predicate.AND, false);
                    selection.appendCondition(ColumnDefinition.MVSID.getDBColumnRef(), this.getTableAlias(), ColumnReference.DataType.String, Comparator.EQ, new Object[]{String.valueOf(':') + ColumnDefinition.MVSID.getDBColumnRef()}, QueryElement.Predicate.AND, false);
                    selection.appendCondition(ColumnDefinition.VRM.getDBColumnRef(), this.getTableAlias(), ColumnReference.DataType.String, Comparator.EQ, new Object[]{String.valueOf(':') + ColumnDefinition.VRM.getDBColumnRef()}, QueryElement.Predicate.AND, false);
                    selection.appendCondition(ColumnDefinition.INTERVAL_TYPE.getDBColumnRef(), this.getTableAlias(), ColumnReference.DataType.String, Comparator.EQ, new Object[]{String.valueOf(':') + ColumnDefinition.INTERVAL_TYPE.getDBColumnRef()}, QueryElement.Predicate.AND, false);
                    selection.appendCondition(ColumnDefinition.INTERVAL_NUMBER.getDBColumnRef(), this.getTableAlias(), ColumnReference.DataType.Integer, Comparator.EQ, new Object[]{String.valueOf(':') + ColumnDefinition.INTERVAL_NUMBER.getDBColumnRef()}, QueryElement.Predicate.AND, false);
                    String def = ((String)this.mapping.get(ColumnDefinition.RESOURCE_COLUMN)).trim().toUpperCase();
                    if (Utilities.hasContent((String)def) && (defn = ColumnDefinition.getByDBColumnRef(def)) != null && defn != ColumnDefinition.UNKNOWN && defn != ColumnDefinition.UNKNOWN) {
                        selection.appendCondition(defn.getDBColumnRef(), this.getTableAlias(), defn.getType(), this.resourceComparator, new Object[]{String.valueOf(':') + def}, QueryElement.Predicate.AND, false);
                    }
                }
            }
        }
        return selection;
    }

    public boolean isLSR_POOL_NUMBER() {
        String label = (String)this.mapping.get(ColumnDefinition.RESOURCE_COLUMN);
        if (label != null) {
            ColumnDefinition defn = ColumnDefinition.getByDBColumnRef(label);
            return defn == ColumnDefinition.LSR_POOL_NUMBER && ("HST039B".equals(this.getTableAlias()) || "HST039A".equals(this.getTableAlias()) || "HST040B".equals(this.getTableAlias()));
        }
        return false;
    }

    public boolean canBeOpened() {
        return this.getTableAlias() != null;
    }

    public ManifestRecord getManifestRecord() {
        return this.record;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ColumnDefinition[] fields = this.alerts.getFields();
        IPropertyDescriptor[] descriptors = new IPropertyDescriptor[fields.length + 1];
        int i = 0;
        while (i < fields.length) {
            descriptors[i] = new TextPropertyDescriptor((Object)fields[i], fields[i].getLabel(null));
            ++i;
        }
        descriptors[fields.length] = new TextPropertyDescriptor((Object)"TableRef", Messages.getString("DataConnectionPropertyPage.tableName"));
        return descriptors;
    }

    public Object getPropertyValue(Object id) {
        if (id.equals("TableRef")) {
            return this.getTableAlias();
        }
        return this.getLabel((ColumnDefinition)id);
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public Map<ColumnDefinition, Object> getDefinitionMapping() {
        HashMap<ColumnDefinition, Object> mapping2 = new HashMap<ColumnDefinition, Object>();
        if (this.record != null && this.record.isPerformanceList()) {
            mapping2.put(ColumnDefinition.START, this.mapping.get(ColumnDefinition.START));
            mapping2.put(ColumnDefinition.STOP, this.mapping.get(ColumnDefinition.STOP));
            mapping2.put(ColumnDefinition.APPLID, this.mapping.get(ColumnDefinition.APPLID));
            mapping2.put(ColumnDefinition.TRAN, this.mapping.get(ColumnDefinition.TRAN));
            mapping2.put(ColumnDefinition.TASKNO, this.mapping.get(ColumnDefinition.TASKNO));
        } else {
            mapping2.put(ColumnDefinition.START_DATE, this.mapping.get(ColumnDefinition.START_DATE));
            mapping2.put(ColumnDefinition.START_TIME, this.mapping.get(ColumnDefinition.START_TIME));
            mapping2.put(ColumnDefinition.APPLID, this.mapping.get(ColumnDefinition.APPLID));
            mapping2.put(ColumnDefinition.MVSID, this.mapping.get(ColumnDefinition.MVSID));
            mapping2.put(ColumnDefinition.VRM, this.mapping.get(ColumnDefinition.VRM));
            mapping2.put(ColumnDefinition.INTERVAL_TYPE, this.mapping.get(ColumnDefinition.INTERVAL_TYPE));
            mapping2.put(ColumnDefinition.INTERVAL_NUMBER, this.mapping.get(ColumnDefinition.INTERVAL_NUMBER));
            mapping2.put(ColumnDefinition.INTERVAL_DURATION, this.mapping.get(ColumnDefinition.INTERVAL_DURATION));
            ColumnDefinition defn = this.getResourceDefinition();
            if (defn != null) {
                Object resource = DataTypeUtilities.assignAppropriateNonCSVBasedObject(this.mapping.get(ColumnDefinition.RESOURCE_VALUE), ColumnDefinition.RESOURCE_VALUE.getType());
                mapping2.put(defn, resource);
            }
        }
        return mapping2;
    }

    public Map<String, Object> getRunableMapping() {
        debug.enter("getRunableMapping");
        LinkedHashMap<String, Object> mapping2 = new LinkedHashMap<String, Object>();
        if (this.record.isPerformanceList()) {
            mapping2.put(String.valueOf(':') + ColumnDefinition.START.getDBColumnRef(), this.mapping.get(ColumnDefinition.START));
            mapping2.put(String.valueOf(':') + ColumnDefinition.STOP.getDBColumnRef(), this.mapping.get(ColumnDefinition.STOP));
            mapping2.put(String.valueOf(':') + ColumnDefinition.APPLID.getDBColumnRef(), this.mapping.get(ColumnDefinition.APPLID));
            mapping2.put(String.valueOf(':') + ColumnDefinition.TRAN.getDBColumnRef(), this.mapping.get(ColumnDefinition.TRAN));
            mapping2.put(String.valueOf(':') + ColumnDefinition.TASKNO.getDBColumnRef(), this.mapping.get(ColumnDefinition.TASKNO));
        } else {
            ColumnDefinition defn;
            mapping2.put(String.valueOf(':') + ColumnDefinition.START_DATE.getDBColumnRef(), this.mapping.get(ColumnDefinition.START_DATE));
            mapping2.put(String.valueOf(':') + ColumnDefinition.START_TIME.getDBColumnRef(), this.mapping.get(ColumnDefinition.START_TIME));
            mapping2.put(String.valueOf(':') + ColumnDefinition.APPLID.getDBColumnRef(), this.mapping.get(ColumnDefinition.APPLID));
            mapping2.put(String.valueOf(':') + ColumnDefinition.MVSID.getDBColumnRef(), this.mapping.get(ColumnDefinition.MVSID));
            mapping2.put(String.valueOf(':') + ColumnDefinition.VRM.getDBColumnRef(), this.mapping.get(ColumnDefinition.VRM));
            mapping2.put(String.valueOf(':') + ColumnDefinition.INTERVAL_TYPE.getDBColumnRef(), this.mapping.get(ColumnDefinition.INTERVAL_TYPE));
            mapping2.put(String.valueOf(':') + ColumnDefinition.INTERVAL_NUMBER.getDBColumnRef(), this.mapping.get(ColumnDefinition.INTERVAL_NUMBER));
            String def = ((String)this.mapping.get(ColumnDefinition.RESOURCE_COLUMN)).trim().toUpperCase();
            if (Utilities.hasContent((String)def) && (defn = ColumnDefinition.getByDBColumnRef(def)) != null && defn != ColumnDefinition.UNKNOWN) {
                Object resource = DataTypeUtilities.assignAppropriateNonCSVBasedObject(this.mapping.get(ColumnDefinition.RESOURCE_VALUE), ColumnDefinition.RESOURCE_VALUE.getType());
                mapping2.put(String.valueOf(':') + def, resource);
            }
        }
        debug.exit("getRunableMapping", mapping2);
        return mapping2;
    }

    public DateCaveat applyConstraint(Selection selection, Direction direction) {
        DateCaveat dateCaveat = null;
        String perftableRef = PAContextTracker.getInstance().getPerformanceTableReference();
        Date date = (Date)this.mapping.get(ColumnDefinition.START_DATE);
        Time time = (Time)this.mapping.get(ColumnDefinition.START_TIME);
        if (direction == Direction.DESC) {
            dateCaveat = DateCaveat.createRangeDateCaveat(null, DateCaveat.join(date, time, null, 1));
        } else {
            Time duration = (Time)this.mapping.get(ColumnDefinition.INTERVAL_DURATION);
            dateCaveat = DateCaveat.createRangeDateCaveat(DateCaveat.join(date, time, duration, 1), null);
        }
        if (dateCaveat != null && !(dateCaveat instanceof NullRangeDateCaveat)) {
            selection.appendCondition(dateCaveat.getConstraint(null, false), QueryElement.Predicate.AND);
        }
        selection.appendCondition(ColumnDefinition.APPLID.getDBColumnRef(), perftableRef, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.mapping.get(ColumnDefinition.APPLID)}, QueryElement.Predicate.AND, false);
        selection.appendCondition(ColumnDefinition.TRAN.getDBColumnRef(), perftableRef, ColumnReference.DataType.String, Comparator.EQ, new Object[]{this.mapping.get(ColumnDefinition.TRAN_ID)}, QueryElement.Predicate.AND, false);
        selection.addOrderByCondition(ColumnDefinition.START_DATE.getDBColumnRef(), perftableRef, direction);
        selection.addOrderByCondition(ColumnDefinition.START_TIME.getDBColumnRef(), perftableRef, direction);
        selection.firstRowOnly();
        return dateCaveat;
    }

    public void setAlias(String newAlias) {
        this.alias = newAlias;
    }

    public String getDescription() {
        if (!StringUtil.hasContent((String)this.description)) {
            StringBuffer buffer = new StringBuffer();
            if ("CMFPLST".equals(this.getTableAlias())) {
                buffer.append(ColumnDefinition.ALT_DEF_NAME.getLabel(null));
                buffer.append('=');
                buffer.append(this.mapping.get(ColumnDefinition.ALT_DEF_NAME));
                buffer.append(',');
                buffer.append(' ');
                buffer.append(ColumnDefinition.SEVERITY.getLabel(null));
                buffer.append('=');
                buffer.append(this.mapping.get(ColumnDefinition.SEVERITY));
                buffer.append(',');
                buffer.append(' ');
                buffer.append(ColumnDefinition.ALT_FIELD_NAME.getLabel(null));
                buffer.append('=');
                buffer.append(this.mapping.get(ColumnDefinition.ALT_FIELD_NAME));
                buffer.append(',');
                buffer.append(' ');
                buffer.append(ColumnDefinition.ALT_FIELD_VALUE.getLabel(null));
                buffer.append('=');
                buffer.append(this.mapping.get(ColumnDefinition.ALT_FIELD_VALUE));
                buffer.append(',');
                buffer.append(' ');
                buffer.append(ColumnDefinition.ALT_FIELD_TYPE.getLabel(null));
                buffer.append('=');
                buffer.append(this.mapping.get(ColumnDefinition.ALT_FIELD_TYPE));
                buffer.append(',');
                buffer.append(' ');
                buffer.append(ColumnDefinition.THRESHOLD.getLabel(null));
                buffer.append('=');
                buffer.append(this.mapping.get(ColumnDefinition.THRESHOLD));
                if (StringUtil.hasContent((String)this.mapping.get(ColumnDefinition.RES_VALUE1).toString())) {
                    buffer.append(',');
                    buffer.append(' ');
                    buffer.append(ColumnDefinition.RES_NAME1.getLabel(null));
                    buffer.append('=');
                    buffer.append(this.mapping.get(ColumnDefinition.RES_NAME1));
                    buffer.append(',');
                    buffer.append(' ');
                    buffer.append(ColumnDefinition.RES_VALUE1.getLabel(null));
                    buffer.append('=');
                    buffer.append(this.mapping.get(ColumnDefinition.RES_VALUE1));
                }
                if (StringUtil.hasContent((String)this.mapping.get(ColumnDefinition.RES_VALUE2).toString())) {
                    buffer.append(',');
                    buffer.append(' ');
                    buffer.append(ColumnDefinition.RES_NAME2.getLabel(null));
                    buffer.append('=');
                    buffer.append(this.mapping.get(ColumnDefinition.RES_NAME2));
                    buffer.append(',');
                    buffer.append(' ');
                    buffer.append(ColumnDefinition.RES_VALUE2.getLabel(null));
                    buffer.append('=');
                    buffer.append(this.mapping.get(ColumnDefinition.RES_VALUE2));
                }
                if (StringUtil.hasContent((String)this.mapping.get(ColumnDefinition.RES_VALUE3).toString())) {
                    buffer.append(',');
                    buffer.append(' ');
                    buffer.append(ColumnDefinition.RES_NAME3.getLabel(null));
                    buffer.append('=');
                    buffer.append(this.mapping.get(ColumnDefinition.RES_NAME3));
                    buffer.append(',');
                    buffer.append(' ');
                    buffer.append(ColumnDefinition.RES_VALUE3.getLabel(null));
                    buffer.append('=');
                    buffer.append(this.mapping.get(ColumnDefinition.RES_VALUE3));
                }
                this.description = buffer.toString();
            }
        }
        return this.description;
    }

    public String getAccessibleLabel(ColumnDefinition[] columnDefinitions) {
        if (!StringUtil.hasContent((String)this.accessibleLabel)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.getLabel(ColumnDefinition.SEVERITY));
            ColumnDefinition[] columnDefinitionArray = columnDefinitions;
            int n = columnDefinitions.length;
            int n2 = 0;
            while (n2 < n) {
                ColumnDefinition defn = columnDefinitionArray[n2];
                buffer.append(' ');
                buffer.append(defn.getLabel(null));
                buffer.append(' ');
                buffer.append(this.getLabel(defn));
                ++n2;
            }
            this.accessibleLabel = buffer.toString();
        }
        return this.accessibleLabel;
    }

    public AlertBucket getParent() {
        return this.parent;
    }

    public void setParent(AlertBucket parent) {
        this.parent = parent;
    }
}

