/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.views.profiler;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.command.Command;
import com.ibm.cics.dbfunc.ui.ScrollLimitManager;
import com.ibm.cics.pa.model.ProfilerPairing;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.ProfilerLayout;
import com.ibm.cics.pa.ui.Activator;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.remote.PAConnectionTracker;
import com.ibm.cics.pa.ui.views.profiler.ProfileChart;
import com.ibm.cics.pa.ui.views.profiler.ProfileComposite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ProfileView
extends ViewPart {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(ProfileView.class);
    protected ProfileChart chart = new ProfileChart(this);
    private Composite leftArrows;
    private MenuManager templateMenu;
    protected ProfileComposite profilerComposite;
    private Composite ptopParent;
    private ProfilerPairing pairing;
    protected ProfilerLayout currentLayout;
    protected ScrollLimitManager scrollLimitManager;
    protected Composite parent;
    private static Color buttonBackground = new Color((Device)Display.getDefault(), 228, 228, 228);
    protected TraverseListener tListener = new TraverseListener(){

        public void keyTraversed(TraverseEvent event) {
            event.doit = event.detail == 16 ? true : (event.detail == 8 ? true : (event.detail == 0x1000007 ? true : true));
        }
    };

    public void setContent(ProfilerPairing pairing) {
        debug.enter("setContent");
        this.setContentDescription(String.valueOf(pairing.getDescription()) + ' ' + this.getLayout().getLabel());
        this.pairing = pairing;
        if (pairing.isPopulated()) {
            this.profilerComposite.setContent(pairing, this.getLayout(), this.getCheckedColumnDefinitions());
            this.chart.setContent(pairing, this.profilerComposite, this.getCheckedColumnDefinitions());
        } else {
            pairing.adviseWhenPopulated(this);
        }
        debug.exit("setContent");
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        if (!ProfilerPairing.pairingInitialised()) {
            this.closeMeAgain();
        }
    }

    private void closeMeAgain() {
        debug.enter("closeMeAgain");
        Job job = new Job(Messages.getString("Resource.status.disconnected")){

            protected IStatus run(IProgressMonitor monitor) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        page.hideView((IViewPart)ProfileView.this);
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.schedule();
        debug.exit("closeMeAgain");
    }

    public void createPartControl(final Composite parent1) {
        debug.enter("createPartControl");
        this.ptopParent = parent1;
        Composite splitComp = new Composite(parent1, 0);
        splitComp.setLayout((Layout)this.leanLayout(new GridLayout(2, false), 0));
        splitComp.setLayoutData((Object)new GridData(4, 4, true, true));
        splitComp.setBackground(buttonBackground);
        this.parent = new Composite(splitComp, 0);
        this.setTitleImage(Activator.getDefault().getImage("smallpro"));
        this.setContentDescription("");
        this.parent.setLayout((Layout)this.leanLayout(new GridLayout(3, false), 1));
        this.parent.setLayoutData((Object)new GridData(4, 4, true, true));
        this.parent.setBackground(ColorConstants.gray);
        this.leftArrows = new Composite(this.parent, 0);
        this.leftArrows.setLayout((Layout)this.leanLayout(new GridLayout(), 0));
        this.leftArrows.setLayoutData((Object)new GridData(16384, 4, false, true));
        this.leftArrows.setBackground(buttonBackground);
        this.leftArrows.setForeground(ColorConstants.darkGray);
        Composite interimComposite = new Composite(this.parent, 0);
        interimComposite.setLayout((Layout)this.leanLayout(new GridLayout(1, false), 0));
        interimComposite.setBackground(ColorConstants.lightBlue);
        GridData interimLayoutData = new GridData(4, 4, true, true);
        interimComposite.setLayoutData((Object)interimLayoutData);
        ScrollingGraphicalViewer graphicalViewerLine = new ScrollingGraphicalViewer();
        FigureCanvas figureCanvas = (FigureCanvas)graphicalViewerLine.createControl(interimComposite);
        LightweightSystem lws = new LightweightSystem((Canvas)figureCanvas);
        figureCanvas.setLayoutData((Object)new GridData(4, 4, true, true));
        figureCanvas.setVerticalScrollBarVisibility(FigureCanvas.NEVER);
        figureCanvas.setHorizontalScrollBarVisibility(FigureCanvas.NEVER);
        figureCanvas.setLayout((Layout)this.leanLayout(new GridLayout(1, false), 0));
        figureCanvas.setBackground(buttonBackground);
        this.chart.setLayoutManager((LayoutManager)new org.eclipse.draw2d.GridLayout(1, false));
        lws.setContents((IFigure)this.chart);
        Composite rightArrows = new Composite(this.parent, 0);
        rightArrows.setLayout((Layout)this.leanLayout(new GridLayout(), 0));
        rightArrows.setLayoutData((Object)new GridData(131072, 4, false, true));
        rightArrows.setBackground(buttonBackground);
        Button leftTopArrow = new Button(this.leftArrows, 16388);
        GridData leftTopData = new GridData(131072, 128, true, false);
        leftTopData.heightHint = 38;
        leftTopData.widthHint = 28;
        leftTopArrow.setLayoutData((Object)leftTopData);
        leftTopArrow.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProfileView.this.chart.buttonPressed(16512);
            }
        });
        Button leftSideArrow = new Button(this.leftArrows, 16388);
        GridData bigLeftButtonData = new GridData(4, 4, true, true);
        bigLeftButtonData.widthHint = 40;
        leftSideArrow.setLayoutData((Object)bigLeftButtonData);
        leftSideArrow.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProfileView.this.chart.buttonPressed(16384);
            }
        });
        Button rightTopArrow = new Button(rightArrows, 131076);
        GridData rightTopData = new GridData(16384, 128, true, false);
        rightTopData.heightHint = 38;
        rightTopData.widthHint = 28;
        rightTopArrow.setLayoutData((Object)rightTopData);
        rightTopArrow.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProfileView.this.chart.buttonPressed(131200);
            }
        });
        Button rightSideArrow = new Button(rightArrows, 131076);
        GridData bigRightButtonData = new GridData(4, 4, true, true);
        bigRightButtonData.widthHint = 40;
        rightSideArrow.setLayoutData((Object)bigRightButtonData);
        rightSideArrow.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProfileView.this.chart.buttonPressed(131072);
            }
        });
        Button leftBottomArrow = new Button(this.leftArrows, 16388);
        GridData leftBottomData = new GridData(131072, 1024, true, false);
        leftBottomData.heightHint = 38;
        leftBottomData.widthHint = 28;
        leftBottomArrow.setLayoutData((Object)leftBottomData);
        leftBottomArrow.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProfileView.this.chart.buttonPressed(17408);
            }
        });
        Button rightBottomArrow = new Button(rightArrows, 131076);
        GridData rightBottomData = new GridData(16384, 128, true, false);
        rightBottomData.heightHint = 38;
        rightBottomData.widthHint = 28;
        rightBottomArrow.setLayoutData((Object)rightBottomData);
        rightBottomArrow.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProfileView.this.chart.buttonPressed(132096);
            }
        });
        ScrolledComposite sc = new ScrolledComposite(splitComp, 512);
        sc.setBackground(buttonBackground);
        sc.setLayout((Layout)this.leanLayout(new GridLayout(1, false), 0));
        sc.setLayoutData((Object)new GridData(131072, 4, false, true));
        sc.setAlwaysShowScrollBars(false);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setMinHeight(250);
        sc.setShowFocusedControl(true);
        sc.getVerticalBar().setIncrement(10);
        sc.getVerticalBar().setPageIncrement(100);
        Composite reportsection = new Composite((Composite)sc, 0);
        reportsection.setBackground(buttonBackground);
        sc.setContent((Control)reportsection);
        this.profilerComposite = new ProfileComposite(this, reportsection);
        leftTopArrow.addTraverseListener(this.tListener);
        leftSideArrow.addTraverseListener(this.tListener);
        leftBottomArrow.addTraverseListener(this.tListener);
        rightTopArrow.addTraverseListener(this.tListener);
        rightSideArrow.addTraverseListener(this.tListener);
        rightBottomArrow.addTraverseListener(this.tListener);
        if (PAConnectionTracker.getInstance().isConnected()) {
            this.scrollLimitManager = new ScrollLimitManager(this.parent, Messages.getString("Records"), (IViewPart)this){

                public void scrollLimitReached(Command command) {
                    super.scrollLimitReached(command);
                    parent1.layout(new Control[]{ProfileView.this.parent, ProfileView.this.scrollLimitManager.scrollLimitComposite});
                }

                public void dispose() {
                    if (!parent1.isDisposed()) {
                        super.dispose();
                        parent1.layout(new Control[]{ProfileView.this.parent});
                    }
                }
            };
        }
        this.leftArrows.setTabList(new Control[]{leftTopArrow, leftSideArrow, leftBottomArrow});
        rightArrows.setTabList(new Control[]{rightTopArrow, rightSideArrow, rightBottomArrow});
        this.parent.setTabList(new Control[]{this.leftArrows, rightArrows, interimComposite});
        splitComp.setTabList(new Control[]{this.parent, sc});
        this.makeActions(this.getViewSite().getWorkbenchWindow());
        this.fillMenu(this.getViewSite().getActionBars());
        this.parent.layout();
        sc.setMinSize(reportsection.computeSize(500, -1));
        this.profilerComposite.applyLayout(this.getLayout(), this.getCheckedColumnDefinitions());
        debug.exit("createPartControl");
    }

    protected void fillMenu(IActionBars actionBars) {
        IMenuManager menu = actionBars.getMenuManager();
        this.fillViewMenuDropdown(menu);
        menu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ProfileView.this.fillViewMenuDropdown(manager);
            }
        });
        actionBars.updateActionBars();
    }

    void fillViewMenuDropdown(IMenuManager manager) {
        manager.removeAll();
        manager.add((IContributionItem)this.templateMenu);
        manager.update();
    }

    public void setFocus() {
        if (this.leftArrows != null) {
            this.leftArrows.getTabList()[0].setFocus();
        }
    }

    private GridLayout leanLayout(GridLayout noMargin, int thickness) {
        noMargin.marginBottom = thickness;
        noMargin.marginTop = thickness;
        noMargin.marginLeft = thickness;
        noMargin.marginRight = thickness;
        noMargin.marginWidth = thickness;
        noMargin.marginHeight = thickness;
        noMargin.verticalSpacing = thickness;
        noMargin.horizontalSpacing = thickness;
        return noMargin;
    }

    public void reset() {
        this.chart.reset();
    }

    protected void makeActions(IWorkbenchWindow window) {
        this.templateMenu = new MenuManager("Profile");
        this.templateMenu.add((IAction)new Action(){});
        this.templateMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.removeAll();
                ProfileView.this.fillCategorizedMenu(manager);
                manager.update();
            }
        });
    }

    protected void fillCategorizedMenu(IMenuManager manager) {
        ArrayList<ProfilerLayout> options = new ArrayList<ProfilerLayout>(Arrays.asList(ProfilerLayout.values()));
        options.remove((Object)ProfilerLayout.ALLREFS);
        Collections.sort(options, new Comparator<ProfilerLayout>(){

            @Override
            public int compare(ProfilerLayout o1, ProfilerLayout o2) {
                return o1.name().compareTo(o2.name());
            }
        });
        if (options.size() > 0) {
            for (ProfilerLayout template : options) {
                manager.add(this.createTemplateAction(template));
            }
            manager.add((IContributionItem)new Separator());
        }
        manager.update();
    }

    protected IAction createTemplateAction(final ProfilerLayout template) {
        Action templateAction = new Action(template.getLabel()){

            public void run() {
                ProfileView.this.currentLayout = template;
                Activator.getDefault().getPluginInstancePreferences().put("PROFILER_LAYOUT", template.name());
                List<ColumnDefinition> definitions = ProfileView.this.getCheckedColumnDefinitions();
                ProfileView.this.chart.setSelectedDefinitions(definitions);
                ProfileView.this.profilerComposite.applyLayout(template, definitions);
                ProfileView.this.setContentDescription(String.valueOf(ProfileView.this.pairing.getDescription()) + ' ' + template.getLabel());
                ProfileView.this.ptopParent.layout();
            }
        };
        return templateAction;
    }

    public ProfilerLayout getLayout() {
        debug.enter("getLayout");
        if (this.currentLayout == null) {
            String layout = Platform.getPreferencesService().getString(Activator.getDefault().getBundle().getSymbolicName(), "PROFILER_LAYOUT", ProfilerLayout.CPU.name(), null);
            this.currentLayout = ProfilerLayout.getByName(layout);
        }
        debug.exit("getLayout", (Object)this.currentLayout);
        return this.currentLayout;
    }

    public ProfilerLayout getCurrentLayoutSelection() {
        debug.enter("getCurrentLayoutSelection");
        String layout = Platform.getPreferencesService().getString(Activator.getDefault().getBundle().getSymbolicName(), "PROFILER_LAYOUT", ProfilerLayout.CPU.name(), null);
        debug.exit("getCurrentLayoutSelection", (Object)layout);
        return ProfilerLayout.getByName(layout);
    }

    public void setChecked(List<ColumnDefinition> definitions) {
        debug.enter("setChecked", definitions);
        this.chart.setSelectedDefinitions(definitions);
        StringBuffer columns = new StringBuffer();
        int i = 0;
        while (i < definitions.size()) {
            if (i > 0) {
                columns.append(',');
            }
            columns.append(definitions.get(i).getDBColumnRef());
            ++i;
        }
        Activator.getDefault().getPluginInstancePreferences().put("PROFILER_LAYOUT_SELECTION_" + this.getLayout().name(), columns.toString());
        debug.exit("setChecked", (Object)columns.toString());
    }

    public List<ColumnDefinition> getCheckedColumnDefinitions() {
        debug.enter("getCheckedColumnDefinitions");
        String tokens = Platform.getPreferencesService().getString(Activator.getDefault().getBundle().getSymbolicName(), "PROFILER_LAYOUT_SELECTION_" + this.getLayout().name(), "", null);
        ArrayList<ColumnDefinition> al = new ArrayList<ColumnDefinition>();
        StringTokenizer tokeniser = new StringTokenizer(tokens, ",");
        while (tokeniser.hasMoreElements()) {
            al.add(ColumnDefinition.getByDBColumnRef(tokeniser.nextToken()));
        }
        debug.exit("getCheckedColumnDefinitions", al);
        return al;
    }
}

