/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.views.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.pa.model.AlertElement;
import com.ibm.cics.pa.model.Column;
import com.ibm.cics.pa.model.PlotModel;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.PluginConstants;
import com.ibm.cics.pa.ui.figures.SingleIntervalFigure;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import com.ibm.cics.pa.ui.views.PlotView;
import com.ibm.cics.pa.ui.views.internal.PlotViewVariance;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class LDGDSAPlotViewVariance
extends PlotViewVariance {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(LDGDSAPlotViewVariance.class);
    private static ColumnDefinition[] rows = new ColumnDefinition[]{ColumnDefinition.PGMS_REMOVED_DPSC, ColumnDefinition.NIU_TIME_TOT, ColumnDefinition.NIU_TIME_AVG, ColumnDefinition.NIU_RECLAIMS, ColumnDefinition.NIU_PROGRAMS, ColumnDefinition.PAGE_STORAGE_CUR, ColumnDefinition.UNKNOWN, ColumnDefinition.DSA_SIZE_CUR, ColumnDefinition.DSA_SIZE_USED, ColumnDefinition.DSA_SIZE_USED_PERCENT, ColumnDefinition.DSA_SIZE_PEAK_USED, ColumnDefinition.DSA_SIZE_PEAK, ColumnDefinition.FREE_STORAGE, ColumnDefinition.FREE_AREA_LARGEST, ColumnDefinition.FREE_AREA_LARGEST_PERCENT, ColumnDefinition.UNKNOWN, ColumnDefinition.SUBPOOLS_CUR, ColumnDefinition.UNKNOWN, ColumnDefinition.GETMAINS_NO_STOR, ColumnDefinition.GETMAINS_SUSPENDED, ColumnDefinition.SUSPENDED_CUR, ColumnDefinition.SUSPENDED_PEAK, ColumnDefinition.SUSPENDED_PURGED, ColumnDefinition.UNKNOWN, ColumnDefinition.ACCESS, ColumnDefinition.UNKNOWN};
    protected static final List<ColumnDefinition> MBDEFNS = Arrays.asList(ColumnDefinition.FREE_STORAGE, ColumnDefinition.FREE_STORAGE_PEAK, ColumnDefinition.FREE_STORAGE_LOW, ColumnDefinition.FREE_AREA_LARGEST);
    private static final List<ColumnDefinition> DEFUNCT_LABELS = Arrays.asList(ColumnDefinition.UDSA, ColumnDefinition.EUDSA, ColumnDefinition.ETDSA);
    private ColumnDefinition[] headings = PluginConstants.GDSA;
    private Map<ColumnDefinition, Map<ColumnDefinition, Control>> controls = new HashMap<ColumnDefinition, Map<ColumnDefinition, Control>>();

    public LDGDSAPlotViewVariance(PlotModel plotModel) {
        super(plotModel);
    }

    @Override
    public Composite createDetailSection(PlotView viewPart, Composite parent, Composite sectionClient) {
        debug.enter("createDetailSection");
        if (this.model.getSubColumnValueLabel() != null && this.model.hasSubElements() && this.model.getElements().length > 0) {
            switch (this.model.getDSAType()) {
                case DSA: {
                    this.headings = PluginConstants.LDG_DSA;
                    viewPart.setPartName(Messages.getString("ChartDefinition.LDG_DSA_TRACE_LONG"));
                    break;
                }
                default: {
                    this.headings = PluginConstants.LDG_EDSA;
                    viewPart.setPartName(Messages.getString("ChartDefinition.LDG_EDSA_TRACE_LONG"));
                }
            }
        }
        this.viewPart = viewPart;
        this.parent = parent;
        this.detailSection = sectionClient;
        this.scrolledComposite = new ScrolledComposite(sectionClient, 512);
        this.scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setAlwaysShowScrollBars(true);
        this.detailColumnComposite = new Composite((Composite)this.scrolledComposite, 0);
        this.scrolledComposite.getVerticalBar().setIncrement(10);
        this.scrolledComposite.getVerticalBar().setPageIncrement(100);
        this.detailColumnComposite.setLayout((Layout)this.leanLayout(new GridLayout(2, false)));
        this.detailColumnComposite.setBackground(sectionClient.getBackground());
        this.scrolledComposite.setContent((Control)this.detailColumnComposite);
        this.scrolledComposite.setShowFocusedControl(true);
        this.dsaStyleHeadings(sectionClient.getBackground());
        Control lt = null;
        if (this.model.getSubColumnValueLabel() != null && this.model.hasSubElements() && this.model.getElements().length > 0) {
            Group contentBox = new Group(this.detailColumnComposite, 0);
            contentBox.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
            contentBox.setLayout((Layout)this.leanLayout(new GridLayout(1 + this.headings.length, false)));
            contentBox.setBackground(this.detailSection.getBackground());
            boolean drawLineFirst = true;
            ColumnDefinition[] columnDefinitionArray = rows;
            int n = rows.length;
            int n2 = 0;
            while (n2 < n) {
                Label l;
                ColumnDefinition definition = columnDefinitionArray[n2];
                if (ColumnDefinition.UNKNOWN == definition) {
                    if (drawLineFirst) {
                        l = new Label((Composite)contentBox, 131072);
                        l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                        l.setText("");
                        l.setBackground(this.detailSection.getBackground());
                        drawLineFirst = false;
                        l = new Label((Composite)contentBox, 258);
                        l.setLayoutData((Object)new GridData(4, 4, true, false, this.headings.length, 1));
                        l.setBackground(this.detailSection.getBackground());
                    } else {
                        l = new Label((Composite)contentBox, 131072);
                        l.setLayoutData((Object)new GridData(4, 4, true, false, 1 + this.headings.length, 1));
                        l.setText("");
                        l.setBackground(this.detailSection.getBackground());
                    }
                } else {
                    GridData gd;
                    ColumnDefinition headlabel;
                    int n3;
                    int n4;
                    ColumnDefinition[] columnDefinitionArray2;
                    if (definition == ColumnDefinition.PGMS_REMOVED_DPSC) {
                        l = new Label((Composite)contentBox, 16384);
                        l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                        l.setText("");
                        l.setBackground(this.detailSection.getBackground());
                        columnDefinitionArray2 = this.headings;
                        n4 = this.headings.length;
                        n3 = 0;
                        while (n3 < n4) {
                            headlabel = columnDefinitionArray2[n3];
                            gd = new GridData(4, 4, true, false, 1, 1);
                            gd.horizontalAlignment = 131072;
                            lt = this.createPoolsHyperLink1(headlabel, contentBox);
                            ((Hyperlink)lt).setText(headlabel.getLabel(null));
                            if (DEFUNCT_LABELS.contains(headlabel)) {
                                lt.setEnabled(false);
                            } else {
                                lt.setEnabled(true);
                                lt.setForeground(Column.getFor(headlabel).getColor());
                                viewPart.addPaintedLabel(lt, headlabel);
                            }
                            lt.setLayoutData((Object)gd);
                            lt.setBackground(this.detailSection.getBackground());
                            if (!this.controls.containsKey(headlabel)) {
                                this.controls.put(headlabel, new HashMap());
                            }
                            ++n3;
                        }
                    }
                    if (definition == ColumnDefinition.DSA_SIZE_CUR) {
                        l = new Label((Composite)contentBox, 16384);
                        l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                        l.setText("");
                        l.setBackground(this.detailSection.getBackground());
                        columnDefinitionArray2 = this.headings;
                        n4 = this.headings.length;
                        n3 = 0;
                        while (n3 < n4) {
                            headlabel = columnDefinitionArray2[n3];
                            lt = this.createPoolsHyperLink(headlabel, contentBox);
                            ((Hyperlink)lt).setText(headlabel.getLabel(null));
                            viewPart.addPaintedLabel(lt, headlabel);
                            lt.setForeground(Column.getFor(headlabel).getColor());
                            lt.setBackground(this.detailSection.getBackground());
                            if (!this.controls.containsKey(headlabel)) {
                                this.controls.put(headlabel, new HashMap());
                            }
                            ++n3;
                        }
                    }
                    l = new Label((Composite)contentBox, 16384);
                    l.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
                    if (definition == ColumnDefinition.PAGE_STORAGE_CUR) {
                        l.setText(Messages.getString("PlotView.PAGE_STORAGE_CUR"));
                    } else {
                        l.setText(definition.getLabel(null));
                    }
                    l.setForeground(ColorConstants.black);
                    l.setBackground(this.detailSection.getBackground());
                    columnDefinitionArray2 = this.headings;
                    n4 = this.headings.length;
                    n3 = 0;
                    while (n3 < n4) {
                        headlabel = columnDefinitionArray2[n3];
                        gd = new GridData(4, 4, true, false, 1, 1);
                        gd.horizontalAlignment = 131072;
                        if (definition == ColumnDefinition.SUBPOOLS_CUR) {
                            lt = this.createPoolsHyperLink(headlabel, contentBox);
                            lt.setForeground(Column.getFor(headlabel).getColor());
                        } else if (definition == ColumnDefinition.PAGE_STORAGE_CUR) {
                            lt = this.createPoolsHyperLink1(headlabel, contentBox);
                            lt.setForeground(Column.getFor(headlabel).getColor());
                        } else {
                            lt = new Label((Composite)contentBox, 131072);
                        }
                        lt.setToolTipText(String.valueOf(headlabel.getLabel(null)) + ' ' + definition.getLabel(null));
                        lt.setLayoutData((Object)gd);
                        lt.setBackground(this.detailSection.getBackground());
                        this.controls.get(headlabel).put(definition, lt);
                        ++n3;
                    }
                }
                ++n2;
            }
        }
        viewPart.addStandardAdditional(sectionClient, this.detailColumnComposite);
        debug.exit("createDetailSection");
        return this.detailColumnComposite;
    }

    protected Control createPoolsHyperLink1(ColumnDefinition headlabel, Group contentBox) {
        final String labex = headlabel.getLabel(null);
        final Hyperlink lt = new Hyperlink((Composite)contentBox, 131072);
        lt.setText("");
        lt.setToolTipText(this.model.getHyperlinkToolTip(labex.endsWith(ColumnDefinition.UDSA.getLabel(null)) ? ColumnDefinition.UDSA : ColumnDefinition.SUBPOOLS_CUR));
        GridData gdHyper = new GridData(4, 4, true, false, 1, 1);
        gdHyper.horizontalAlignment = 131072;
        lt.setLayoutData((Object)gdHyper);
        lt.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = String.valueOf(labex.endsWith(ColumnDefinition.UDSA.getLabel(null)) ? ColumnDefinition.UDSA.getLabel(null) : ColumnDefinition.SUBPOOLS_CUR.getLabel(null)) + ' ' + lt.getText();
            }
        });
        lt.setUnderlined(true);
        lt.addKeyListener(this.viewPart.genericKeyListener);
        lt.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                String values = "";
                if (labex.equals(ColumnDefinition.CDSA.getLabel(null))) {
                    values = "LDNRS', 'LDNUC";
                } else if (labex.equals(ColumnDefinition.ECDSA.getLabel(null))) {
                    values = "LDENRS', 'LDENUC";
                } else if (labex.equals(ColumnDefinition.SDSA.getLabel(null))) {
                    values = "LDPGM', 'LDRES";
                } else if (labex.equals(ColumnDefinition.ESDSA.getLabel(null))) {
                    values = "LDEPGM', 'LDERES";
                } else if (labex.equals(ColumnDefinition.RDSA.getLabel(null))) {
                    values = "LDNRSRO', 'LDNUCRO', 'LDPGMRO', 'LDRESRO";
                } else if (labex.equals(ColumnDefinition.ERDSA.getLabel(null))) {
                    values = "LDENRSRO', 'LDENUCRO', 'LDEPGMRO', 'LDERESRO";
                }
                AlertElement nextAlert = LDGDSAPlotViewVariance.this.viewPart.getCurrentElement().createElement(ColumnDefinition.SUBPOOL_NAME, values, Comparator.IN, "HST005A");
                LDGDSAPlotViewVariance.this.viewPart.activateSheetViewLink(nextAlert);
            }
        });
        return lt;
    }

    @Override
    public void updateDetailSection(SingleIntervalFigure figure) {
        debug.enter("updateDetailSection");
        super.updateDetailSection(figure);
        if (figure != null) {
            int i = 0;
            while (i < this.headings.length) {
                Object[] values = figure.getElement().getSubMap1().get(this.headings[i].getLabel(null));
                if (values != null) {
                    Map<ColumnDefinition, Control> currentControlMap = this.controls.get(this.headings[i]);
                    int j = 0;
                    while (j < this.model.getSubColumnValueLabel().size()) {
                        String text = j < values.length ? DataTypeUtilities.getAsString(values[j]) : "";
                        ColumnDefinition definition = this.model.getSubColumnValueLabel().get(j);
                        if (currentControlMap.containsKey(definition)) {
                            if (currentControlMap.get(definition) instanceof Label) {
                                ((Label)currentControlMap.get(definition)).setText(text);
                            } else if (currentControlMap.get(definition) instanceof Hyperlink) {
                                ((Hyperlink)currentControlMap.get(definition)).setText(text);
                                boolean enabled = text.length() > 0 && !text.equals("0");
                                ((Hyperlink)currentControlMap.get(definition)).setEnabled(enabled);
                                ((Hyperlink)currentControlMap.get(definition)).setUnderlined(enabled);
                                ((Hyperlink)currentControlMap.get(definition)).setForeground(enabled ? Column.getFor(this.headings[i]).getColor() : ColorConstants.black);
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        debug.exit("updateDetailSection");
    }

    @Override
    protected GridLayout leanLayout(GridLayout noMargin) {
        noMargin.marginBottom = 0;
        noMargin.marginTop = 0;
        noMargin.marginLeft = 0;
        noMargin.marginRight = 0;
        noMargin.marginWidth = 10;
        noMargin.marginHeight = 0;
        noMargin.verticalSpacing = 5;
        noMargin.horizontalSpacing = 10;
        return noMargin;
    }
}

