/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.utilities;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.dbfunc.command.Engine;
import com.ibm.cics.dbfunc.command.EngineShell;
import com.ibm.cics.dbfunc.command.RowProcessor;
import com.ibm.cics.dbfunc.model.ColumnReference;
import com.ibm.cics.dbfunc.model.Comparator;
import com.ibm.cics.dbfunc.model.Direction;
import com.ibm.cics.dbfunc.model.PresentationFactory;
import com.ibm.cics.dbfunc.model.QueryElement;
import com.ibm.cics.dbfunc.model.Selection;
import com.ibm.cics.dbfunc.model.SelectionObject;
import com.ibm.cics.eclipse.common.ViewHelper;
import com.ibm.cics.pa.model.AlertElement;
import com.ibm.cics.pa.model.ChartType;
import com.ibm.cics.pa.model.DateCaveat;
import com.ibm.cics.pa.model.IUniqueRecord;
import com.ibm.cics.pa.model.ManifestRecord;
import com.ibm.cics.pa.model.NullRangeDateCaveat;
import com.ibm.cics.pa.model.definitions.AbstractChartDefinition;
import com.ibm.cics.pa.model.definitions.ChartSpecification;
import com.ibm.cics.pa.model.definitions.ColumnDefinition;
import com.ibm.cics.pa.model.definitions.SheetViewDefinition;
import com.ibm.cics.pa.ui.Messages;
import com.ibm.cics.pa.ui.PAContextTracker;
import com.ibm.cics.pa.ui.handlers.CommonHandler;
import com.ibm.cics.pa.ui.utilities.DataTypeUtilities;
import com.ibm.cics.pa.ui.views.PerformanceListRecordFormsView;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public class ViewLinkingDBFunctions
extends CommonHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2013, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final Debug debug = new Debug(ViewLinkingDBFunctions.class);
    DateCaveat caveat1 = null;
    DateCaveat caveat2 = null;
    AlertElement element;
    IUniqueRecord plistRecord;
    IViewPart part;
    String tableRef = PAContextTracker.getInstance().getPerformanceTableReference();
    boolean completion1 = false;
    boolean completion2 = false;
    ColumnDefinition resourceColumn;
    Object resourceValue;

    private ViewLinkingDBFunctions(IViewPart workbenchPart, AlertElement element, String tableAlias) {
        if (StringUtil.hasContent((String)tableAlias)) {
            this.tableRef = tableAlias;
        }
        this.element = element;
        this.part = workbenchPart;
    }

    private ViewLinkingDBFunctions(IViewPart workbenchPart, IUniqueRecord record, String tableAlias) {
        if (StringUtil.hasContent((String)tableAlias)) {
            this.tableRef = tableAlias;
        }
        this.part = workbenchPart;
        this.plistRecord = record;
    }

    private void openSpreadsheet(final ColumnDefinition columnDefinition, final Object value) {
        ManifestRecord manRec = ManifestRecord.getAlias(this.tableRef);
        final String tableName = manRec.getName();
        this.resourceColumn = columnDefinition;
        this.resourceValue = value;
        Engine engine = new Engine("com.ibm.cics.pa.connection", new RowProcessor(){

            public Map<String, Object> getParameterMap() {
                return new HashMap<String, Object>();
            }

            public SelectionObject getSelectionObject() {
                Selection selection = PresentationFactory.getInstance().createSelectForTable(new String[]{tableName}, new String[]{":schema"});
                selection.getSelect().setDistinct(true);
                selection.getSelect().addSelectionColumn(ColumnDefinition.START_DATE.getDBColumnRef(), tableName, ColumnDefinition.START_DATE.getType(), ColumnReference.Function.NONE);
                selection.getSelect().addSelectionColumn(ColumnDefinition.START_TIME.getDBColumnRef(), tableName, ColumnDefinition.START_TIME.getType(), ColumnReference.Function.NONE);
                if (ViewLinkingDBFunctions.this.isPListSource()) {
                    Timestamp ts1 = (Timestamp)ViewLinkingDBFunctions.this.plistRecord.getCompleteMapping(false).get(ColumnDefinition.START);
                    selection.appendCondition(DateCaveat.createRangeDateCaveat(null, ts1).getConstraint(tableName, false), QueryElement.Predicate.AND);
                    selection.addOrderByCondition(ColumnDefinition.START_DATE.getDBColumnRef(), tableName, Direction.DESC);
                    selection.addOrderByCondition(ColumnDefinition.START_TIME.getDBColumnRef(), tableName, Direction.DESC);
                } else {
                    ViewLinkingDBFunctions.this.element.applyConstraint(selection, Direction.DESC);
                }
                if (ViewLinkingDBFunctions.this.resourceColumn != null) {
                    selection.appendCondition(ViewLinkingDBFunctions.this.resourceColumn.getDBColumnRef(), tableName, ViewLinkingDBFunctions.this.resourceColumn.getType(), Comparator.EQ, new Object[]{value}, QueryElement.Predicate.AND, false);
                }
                selection.firstRowOnly();
                return selection;
            }

            public Object processRow(ResultSet resultSet) {
                try {
                    return DateCaveat.createSpecificDateCaveat((Date)resultSet.getObject(1), (Time)resultSet.getObject(2));
                }
                catch (SQLException e) {
                    debug.error("processRow", (Throwable)e);
                    return null;
                }
            }
        });
        engine.addListener((EngineShell.EngineListener)new DedicatedEngineListener(1));
        engine.setPageSize(10);
        engine.start();
        if (this.isPerformanceSummary()) {
            engine = new Engine("com.ibm.cics.pa.connection", new RowProcessor(){

                public Map<String, Object> getParameterMap() {
                    return new HashMap<String, Object>();
                }

                public SelectionObject getSelectionObject() {
                    Selection selection = PresentationFactory.getInstance().createSelectForTable(new String[]{tableName}, new String[]{":schema"});
                    selection.getSelect().setDistinct(true);
                    selection.getSelect().addSelectionColumn(ColumnDefinition.START_DATE.getDBColumnRef(), tableName, ColumnDefinition.START_DATE.getType(), ColumnReference.Function.NONE);
                    selection.getSelect().addSelectionColumn(ColumnDefinition.START_TIME.getDBColumnRef(), tableName, ColumnDefinition.START_TIME.getType(), ColumnReference.Function.NONE);
                    if (ViewLinkingDBFunctions.this.isPListSource()) {
                        Timestamp ts2 = (Timestamp)ViewLinkingDBFunctions.this.plistRecord.getCompleteMapping(false).get(ColumnDefinition.STOP);
                        selection.appendCondition(DateCaveat.createRangeDateCaveat(ts2, null).getConstraint(tableName, false), QueryElement.Predicate.AND);
                        selection.addOrderByCondition(ColumnDefinition.START_DATE.getDBColumnRef(), tableName, Direction.ASC);
                        selection.addOrderByCondition(ColumnDefinition.START_TIME.getDBColumnRef(), tableName, Direction.ASC);
                        selection.appendCondition(ColumnDefinition.APPLID.getDBColumnRef(), tableName, ColumnDefinition.APPLID.getType(), Comparator.EQ, new Object[]{ViewLinkingDBFunctions.this.plistRecord.getCompleteMapping(false).get(ColumnDefinition.APPLID)}, QueryElement.Predicate.AND, false);
                    } else {
                        ViewLinkingDBFunctions.this.element.applyConstraint(selection, Direction.ASC);
                    }
                    if (columnDefinition != null) {
                        selection.appendCondition(columnDefinition.getDBColumnRef(), tableName, columnDefinition.getType(), Comparator.EQ, new Object[]{value}, QueryElement.Predicate.AND, false);
                    }
                    selection.firstRowOnly();
                    return selection;
                }

                public Object processRow(ResultSet resultSet) {
                    try {
                        Time time = (Time)resultSet.getObject(2);
                        time.setTime(time.getTime() - 60000L);
                        return DateCaveat.createSpecificDateCaveat((Date)resultSet.getObject(1), time);
                    }
                    catch (SQLException e) {
                        debug.error("processRow", (Throwable)e);
                        return null;
                    }
                }
            });
            engine.addListener((EngineShell.EngineListener)new DedicatedEngineListener(2));
            engine.setPageSize(10);
            engine.start();
        }
    }

    void goIntervalPlot() {
        ManifestRecord target = ManifestRecord.getAlias(this.tableRef);
        String tableName = target.getName();
        Selection selection = PresentationFactory.getInstance().createSelectAllForTable(tableName, ":schema");
        selection.applyTableMapping(ManifestRecord.getAliasMapping());
        if (this.caveat1 != null && !(this.caveat1 instanceof NullRangeDateCaveat)) {
            selection.appendCondition(this.caveat1.getConstraint(tableName, false), QueryElement.Predicate.AND);
        }
        HashMap<String, Object> mapping = new HashMap<String, Object>();
        Map<ColumnDefinition, Object> parameterMap = this.isPListSource() ? this.plistRecord.getCompleteMapping(false) : this.element.getDefinitionMapping();
        selection.appendCondition(ColumnDefinition.APPLID.getDBColumnRef(), tableName, ColumnReference.DataType.String, Comparator.EQ, new Object[]{parameterMap.get(ColumnDefinition.APPLID)}, QueryElement.Predicate.AND, false);
        mapping.put(ColumnDefinition.APPLID.getDBColumnRef(), parameterMap.get(ColumnDefinition.APPLID));
        if (target.isTransactions()) {
            mapping.put(ColumnDefinition.TRAN_ID.getDBColumnRef(), parameterMap.get(this.isPListSource() ? ColumnDefinition.TRAN : ColumnDefinition.TRAN_ID));
            selection.appendCondition(ColumnDefinition.TRAN_ID.getDBColumnRef(), tableName, ColumnReference.DataType.String, Comparator.EQ, new Object[]{parameterMap.get(this.isPListSource() ? ColumnDefinition.TRAN : ColumnDefinition.TRAN_ID)}, QueryElement.Predicate.AND, false);
        }
        if (target.isTransactionClassess()) {
            mapping.put(ColumnDefinition.TCLASS_NAME.getDBColumnRef(), parameterMap.get(this.isPListSource() ? ColumnDefinition.TCLASSNM : ColumnDefinition.TCLASS_NAME));
            selection.appendCondition(ColumnDefinition.TCLASS_NAME.getDBColumnRef(), tableName, ColumnReference.DataType.String, Comparator.EQ, new Object[]{parameterMap.get(this.isPListSource() ? ColumnDefinition.TCLASSNM : ColumnDefinition.TCLASS_NAME)}, QueryElement.Predicate.AND, false);
        }
        selection.addOrderByCondition(ColumnDefinition.START_DATE.getDBColumnRef(), tableName, Direction.ASC);
        selection.addOrderByCondition(ColumnDefinition.START_TIME.getDBColumnRef(), tableName, Direction.ASC);
        String tabLabel = "";
        ManifestRecord rec = ManifestRecord.getName(tableName);
        if (rec != null) {
            tabLabel = rec.getDescription();
        }
        selection.applyTableMapping(ManifestRecord.getAliasMapping());
        String contentDescription = MessageFormat.format(Messages.getString("ContentDescription.Applid.Resource"), parameterMap.get(ColumnDefinition.APPLID), parameterMap.get(this.isPListSource() ? ColumnDefinition.TRAN : ColumnDefinition.TRAN_ID));
        contentDescription = String.valueOf(contentDescription) + DataTypeUtilities.interpretStatsElement(mapping, this.caveat1, Collections.<String>emptyList());
        this.preCheckIntervalPlot(selection, contentDescription, mapping, tabLabel);
    }

    private void preCheckIntervalPlot(final Selection selection, String contentDescription, Map<String, Object> mapping, String tabLabel) {
        Engine engine = new Engine("com.ibm.cics.pa.connection", new RowProcessor(){

            public Map<String, Object> getParameterMap() {
                return new HashMap<String, Object>();
            }

            public SelectionObject getSelectionObject() {
                return selection;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object processRow(ResultSet resultSet) throws SQLException {
                ResultSet resultSet2 = resultSet;
                synchronized (resultSet2) {
                    try {
                        HashMap<ColumnDefinition, Object> valueMap = new HashMap<ColumnDefinition, Object>();
                        valueMap.put(ColumnDefinition.START_DATE, resultSet.getDate(ColumnDefinition.START_DATE.getDBColumnRef()));
                        valueMap.put(ColumnDefinition.START_TIME, resultSet.getTime(ColumnDefinition.START_TIME.getDBColumnRef()));
                        valueMap.put(ColumnDefinition.APPLID, resultSet.getString(ColumnDefinition.APPLID.getDBColumnRef()));
                        valueMap.put(ColumnDefinition.MVSID, resultSet.getString(ColumnDefinition.MVSID.getDBColumnRef()));
                        valueMap.put(ColumnDefinition.VRM, resultSet.getString(ColumnDefinition.VRM.getDBColumnRef()));
                        valueMap.put(ColumnDefinition.INTERVAL_TYPE, resultSet.getString(ColumnDefinition.INTERVAL_TYPE.getDBColumnRef()));
                        valueMap.put(ColumnDefinition.INTERVAL_NUMBER, resultSet.getString(ColumnDefinition.INTERVAL_NUMBER.getDBColumnRef()));
                        valueMap.put(ColumnDefinition.INTERVAL_DURATION, resultSet.getTime(ColumnDefinition.INTERVAL_DURATION.getDBColumnRef()));
                        AlertElement element = new AlertElement(valueMap, ViewLinkingDBFunctions.this.resourceColumn, (String)ViewLinkingDBFunctions.this.resourceValue, Comparator.EQ, ViewLinkingDBFunctions.this.tableRef);
                        return element;
                    }
                    catch (SQLException e) {
                        Debug.error((Logger)logger, (String)this.getClass().getName(), (String)"tableSelected ", (Throwable)e);
                    }
                }
                return null;
            }
        });
        engine.addListener(new EngineShell.EngineListener(){

            public void statusUpdate(EngineShell.EngineStatus es) {
            }

            public void dataAvailable(Collection<Object> items) {
                if (!items.isEmpty() && ViewLinkingDBFunctions.this.part instanceof PerformanceListRecordFormsView) {
                    ((PerformanceListRecordFormsView)ViewLinkingDBFunctions.this.part).setNextAlert((AlertElement)items.iterator().next());
                }
            }

            public void notifyResultCount(int count) {
            }
        });
        engine.setPageSize(10);
        engine.start();
    }

    void goPerformanceSummary() {
        DateCaveat dateCaveat = DateCaveat.createRangeDateCaveat(this.caveat1, this.caveat2);
        Selection selection = PresentationFactory.getInstance().createSelectAllForTable(this.tableRef, ":schema");
        selection.applyTableMapping(ManifestRecord.getAliasMapping());
        if (dateCaveat != null && !(dateCaveat instanceof NullRangeDateCaveat)) {
            selection.appendCondition(dateCaveat.getConstraint(this.tableRef, false), QueryElement.Predicate.AND);
        }
        HashMap<String, Object> mapping = new HashMap<String, Object>();
        Map<ColumnDefinition, Object> parameterMap = this.isPListSource() ? this.plistRecord.getCompleteMapping(false) : this.element.getDefinitionMapping();
        selection.appendCondition(ColumnDefinition.APPLID.getDBColumnRef(), this.tableRef, ColumnReference.DataType.String, Comparator.EQ, new Object[]{parameterMap.get(ColumnDefinition.APPLID)}, QueryElement.Predicate.AND, false);
        mapping.put(ColumnDefinition.APPLID.getDBColumnRef(), parameterMap.get(ColumnDefinition.APPLID));
        mapping.put(ColumnDefinition.TRAN.getDBColumnRef(), parameterMap.get(this.isPListSource() ? ColumnDefinition.TRAN : ColumnDefinition.TRAN_ID));
        selection.appendCondition(ColumnDefinition.TRAN.getDBColumnRef(), this.tableRef, ColumnReference.DataType.String, Comparator.EQ, new Object[]{parameterMap.get(this.isPListSource() ? ColumnDefinition.TRAN : ColumnDefinition.TRAN_ID)}, QueryElement.Predicate.AND, false);
        selection.addOrderByCondition(ColumnDefinition.START_DATE.getDBColumnRef(), this.tableRef, Direction.ASC);
        selection.addOrderByCondition(ColumnDefinition.START_TIME.getDBColumnRef(), this.tableRef, Direction.ASC);
        String tabLabel = "";
        ManifestRecord rec = ManifestRecord.getName(this.tableRef);
        if (rec != null) {
            tabLabel = rec.getDescription();
        }
        selection.applyTableMapping(ManifestRecord.getAliasMapping());
        String contentDescription = MessageFormat.format(Messages.getString("ContentDescription.Applid.Resource"), parameterMap.get(ColumnDefinition.APPLID), parameterMap.get(this.isPListSource() ? ColumnDefinition.TRAN : ColumnDefinition.TRAN_ID));
        contentDescription = String.valueOf(contentDescription) + DataTypeUtilities.interpretStatsElement(mapping, dateCaveat, Collections.<String>emptyList());
        this.preCheckPerformanceSummary(selection, contentDescription, mapping, tabLabel);
    }

    private void preCheckPerformanceSummary(final Selection selection, final String contentDescription, final Map<String, Object> mapping, final String tabLabel) {
        Engine engine = new Engine("com.ibm.cics.pa.connection", new RowProcessor(){

            public Map<String, Object> getParameterMap() {
                return new HashMap<String, Object>();
            }

            public SelectionObject getSelectionObject() {
                return selection;
            }

            public Object processRow(ResultSet resultSet) {
                return "";
            }
        });
        engine.addListener(new EngineShell.EngineListener(){

            public void statusUpdate(EngineShell.EngineStatus es) {
            }

            public void dataAvailable(Collection<Object> items) {
                ChartSpecification chartReference = items.size() == 1 ? AbstractChartDefinition.getByName("HST_RMI_pie") : SheetViewDefinition.createForType(ChartType.SHEET, null);
                ViewLinkingDBFunctions.this.dbQuery((IWorkbenchPart)ViewLinkingDBFunctions.this.part, selection, contentDescription, mapping, chartReference, tabLabel, ManifestRecord.getAlias("CMFPLST"));
            }

            public void notifyResultCount(int count) {
            }
        });
        engine.setPageSize(10);
        engine.start();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        return null;
    }

    boolean isPListSource() {
        return this.plistRecord != null;
    }

    boolean isPerformanceSummary() {
        return ManifestRecord.isPerformanceSummaryRecord(this.tableRef);
    }

    public static void openSpreadsheet(IViewPart viewPart, IUniqueRecord record, EngineShell.EngineListener engineListener) {
        new ViewLinkingDBFunctions(viewPart, record, "CMFPSUM").openSpreadsheet(null, null);
    }

    public static void openSpreadsheetXMR(IViewPart viewPart, AlertElement element, EngineShell.EngineListener engineListener) {
        new ViewLinkingDBFunctions(viewPart, element, "CMFPSUM").openSpreadsheet(ColumnDefinition.TRAN, element.getResourceValue());
    }

    public static void openSpreadsheet(IViewPart workbenchPart, IUniqueRecord record, String tableAlias, ColumnDefinition columnDefinition, Object value) {
        if (record != null) {
            ViewLinkingDBFunctions utilFunc = new ViewLinkingDBFunctions(workbenchPart, record, tableAlias);
            utilFunc.openSpreadsheet(columnDefinition, value);
        }
    }

    private class DedicatedEngineListener
    implements EngineShell.EngineListener {
        private int sequence;

        DedicatedEngineListener(int engineNumber) {
            this.sequence = engineNumber;
        }

        public void statusUpdate(EngineShell.EngineStatus es) {
        }

        public void dataAvailable(Collection<Object> items) {
            debug.enter("DedicatedEngineListenerdataAvailable", items);
            switch (this.sequence) {
                case 1: {
                    if (!items.isEmpty()) {
                        ViewLinkingDBFunctions.this.caveat1 = (DateCaveat)items.toArray()[0];
                    }
                    ViewLinkingDBFunctions.this.completion1 = true;
                    break;
                }
                default: {
                    if (!items.isEmpty()) {
                        ViewLinkingDBFunctions.this.caveat2 = (DateCaveat)items.toArray()[0];
                    }
                    ViewLinkingDBFunctions.this.completion2 = true;
                }
            }
            if (ViewLinkingDBFunctions.this.isPerformanceSummary()) {
                if (ViewLinkingDBFunctions.this.completion1 && ViewLinkingDBFunctions.this.completion2) {
                    if (ViewLinkingDBFunctions.this.caveat2 != null && ViewLinkingDBFunctions.this.caveat1 != null) {
                        ViewHelper.setStatusInformationMessage((IWorkbenchPart)ViewLinkingDBFunctions.this.part, (String)Messages.getString("Locating.records"));
                        ViewLinkingDBFunctions.this.goPerformanceSummary();
                    } else {
                        ViewHelper.setStatusInformationMessage((IWorkbenchPart)ViewLinkingDBFunctions.this.part, (String)Messages.getString("PAX0103I.Results.NoData"));
                    }
                } else {
                    ViewHelper.setStatusInformationMessage((IWorkbenchPart)ViewLinkingDBFunctions.this.part, (String)Messages.getString("Locating.records"));
                }
            } else if (ViewLinkingDBFunctions.this.completion1 && ViewLinkingDBFunctions.this.caveat1 != null) {
                ViewHelper.setStatusInformationMessage((IWorkbenchPart)ViewLinkingDBFunctions.this.part, (String)Messages.getString("Locating.records"));
                ViewLinkingDBFunctions.this.goIntervalPlot();
            } else {
                ViewHelper.setStatusInformationMessage((IWorkbenchPart)ViewLinkingDBFunctions.this.part, (String)Messages.getString("PAX0103I.Results.NoData"));
            }
            debug.exit("dataAvailable");
        }

        public void notifyResultCount(int count) {
        }
    }
}

