/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.pa.ui.utilities;

import com.ibm.cics.pa.model.definitions.ColumnDefinition;

public class FilterElement {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y23 (c) Copyright IBM Corp. 2008, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String[] operators = new String[]{" != ", " = ", " > ", " < "};
    private Object column;
    private String operator;
    private String value;
    private ColumnDefinition alternative_Value;
    private boolean isValid;
    private boolean isValueComplete = true;

    public boolean isComplete() {
        return this.column != null && this.operator != null && this.value != null && this.isValueComplete;
    }

    public FilterElement(String[] input, String nextCurrentTag) {
        String methodNextCurrentTag = nextCurrentTag.trim();
        int i = 0;
        while (i < input.length) {
            if (methodNextCurrentTag.toUpperCase().startsWith(input[i].toUpperCase()) && (this.column == null || input[i].length() > ((String)this.column).length())) {
                this.column = input[i];
            }
            ++i;
        }
        if (this.column != null) {
            String remnant = methodNextCurrentTag.substring(((String)this.column).length()).trim();
            String[] stringArray = operators;
            int n = operators.length;
            int n2 = 0;
            while (n2 < n) {
                String operator1 = stringArray[n2];
                int start = remnant.indexOf(operator1.trim());
                if (start == 0) {
                    this.operator = operator1;
                    this.value = remnant.substring(start + this.operator.trim().length()).trim();
                }
                ++n2;
            }
        }
    }

    public Object getColumn() {
        return this.column;
    }

    public void setColumn(Object column) {
        this.column = column;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
        this.alternative_Value = null;
    }

    public ColumnDefinition getAlternativeValue() {
        return this.alternative_Value;
    }

    public void setValue(ColumnDefinition value) {
        this.alternative_Value = value;
    }

    public String toString() {
        if (!this.isComplete()) {
            return String.valueOf(FilterElement.class.getName()) + " incomplete";
        }
        return String.valueOf(this.column.toString()) + " " + this.operator + " " + this.value;
    }

    public boolean isValid() {
        return this.isValid && this.isComplete();
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    public void setValueComplete(boolean isValueComplete) {
        this.isValueComplete = isValueComplete;
    }

    public boolean containsInvalidCharacters() {
        return this.value.indexOf(39) > -1;
    }
}

